/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcKMeans;
import com.insightful.cnkjava.CNKProcKMeansPredict;
import com.insightful.miner.ByColumnStatisticAccumulator;
import com.insightful.miner.DataCacheRowBuf;
import com.insightful.miner.EngineMessageHandler;
import com.insightful.miner.EngineNode;
import com.insightful.miner.MinerApp;
import com.insightful.miner.PredictEngineNode;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.util.Vector;

class ClusterEngineNode
extends EngineNode {
    public static String BIN_COUNT_CACHE = "bin.count";
    public static String DISPLAY_COLUMNS_ATTRIBUTE_TAG = "outgoingColumns";
    public static String NUM_CLUSTERS_ATTRIBUTE_TAG = "numClusters";
    public static String MAX_ITERATIONS_ATTRIBUTE_TAG = "maxIterations";
    public static String NUM_CLUSTERS_DEFAULT = "10";
    public static String MAX_ITERATIONS_DEFAULT = "10";
    public static String FIRST_K_DATA_POINTS_ATTRIBUTE_TAG = "FirstKDataPoints";
    public static String SAMPLING_FROM_FIRST_BLOCK_ATTRIBUTE_TAG = "SamplingFromFirstBlock";
    public static String HCLUST_FROM_FIRST_BLOCK_ATTRIBUTE_TAG = "HClustFromFirstBlock";
    public static String SAMPLING_FROM_ENTIRE_SET_ATTRIBUTE_TAG = "SamplingFromEntireDataSet";
    public static String NORMALIZE_INPUT_ATTRIBUTE_TAG = "normalizeInput";
    public static String ROWS_RETAINED_SET_ATTRIBUTE_TAG = "rowsRetainedSet";
    public static String MAX_TIMES_RETAIN_POINTS_ATTRIBUTE_TAG = "maxTimesRetainPoints";
    public static String INITIALIZING_CENTER_ATTRIBUTE_TAG = "initializingCenter";
    public static String MAX_TIMES_RETAIN_POINTS_DEFAULT = "5";
    public static String NO_SCALE_ATTRIBUTE_TAG = "noScale";
    public static String RANGE_SCALE_ATTRIBUTE_TAG = "rangeScale";
    public static String ST_DEV_SCALE_ATTRIBUTE_TAG = "stDevScale";
    public static String SCALE_ATTRIBUTE_TAG = "scale";
    public static String CHART_DISPLAY_ATTRIBUTE_TAG = "chartDisplay";
    public static String TABLE_VIEW_DISPLAY_ATTRIBUTE_TAG = "tableViewDisplay";
    public static boolean CHART_DISPLAY_DEFAULT = false;
    public static boolean TABLE_VIEW_DISPLAY_DEFAULT = true;
    public static String SCALE_METHOD_DEFAULT = ST_DEV_SCALE_ATTRIBUTE_TAG;
    public static int NO_SCALE_ATTRIBUTE = 0;
    public static int RANGE_SCALE_ATTRIBUTE = 1;
    public static int ST_DEV_SCALE_ATTRIBUTE = 2;
    public static int FIRST_K_DATA_POINTS_ATTRIBUTE = 0;
    public static int SAMPLING_FROM_FIRST_BLOCK_ATTRIBUTE = 1;
    public static int HCLUST_FROM_FIRST_BLOCK_ATTRIBUTE = 2;
    public static int SAMPLING_FROM_ENTIRE_SET_ATTRIBUTE = 3;
    public static final String MAXIMUM_ROWS_ATTRIBUTE_TAG = "max.rows";
    public static final int MAXIMUM_ROWS_DEFAULT = 10000;
    private int m_binCount = 10;
    private String m_modelString = null;

    public boolean hasCNKProc() {
        return false;
    }

    public boolean hasDataCacheProc() {
        return true;
    }

    public void procExtractResults(CNKProc proc) {
        if (proc instanceof CNKProcKMeans) {
            this.m_modelString = ((CNKProcKMeans)proc).getModel();
            XMLTree modelTree = XMLTree.readFromString(this.m_modelString);
            this.setNodeCache("model", modelTree);
        } else if (proc instanceof CNKProcKMeansPredict) {
            this.m_modelString = ((CNKProcKMeansPredict)proc).getStringProp("fitted.model.pmml", null);
            XMLTree modelTree = XMLTree.readFromString(this.m_modelString);
            this.setNodeCache("model", modelTree);
        }
    }

    public String getDataDictionaryAsString() throws Exception {
        XTProps props = this.getNodeProperties();
        XTMetaData md = this.getInputMetaData(0);
        Vector varNames = props.getSubProperties("outgoingColumns");
        if (varNames.size() <= 0) {
            throw new Exception("can't create k-means data dictionary: no variable(s)");
        }
        XTMetaData mdModel = md.selectiveClone(varNames);
        for (int i = 0; i < varNames.size(); ++i) {
            mdModel.setDataFieldRole((String)varNames.get(i), "independent");
        }
        return mdModel.writeToString();
    }

    public boolean executeDataCacheProc() throws Exception {
        XTProps props = this.getNodeProperties();
        Vector vars = props.getSubProperties("outgoingColumns");
        if (vars.size() <= 0) {
            throw new Exception("can't create k-means clustering: no variable(s)");
        }
        long k = props.getInt("numClusters", Integer.parseInt(NUM_CLUSTERS_DEFAULT));
        boolean ok = true;
        CNKProcKMeans proc1 = new CNKProcKMeans();
        proc1.setModel(this.getDataDictionaryAsString());
        long nRandomSeed = this.getRandomSeed();
        proc1.setProp("randomSeed", new Long(nRandomSeed));
        proc1.setNClusters(k);
        long nMaxIterations = props.getInt(MAX_ITERATIONS_ATTRIBUTE_TAG, Integer.parseInt(MAX_ITERATIONS_DEFAULT));
        proc1.setProp(MAX_ITERATIONS_ATTRIBUTE_TAG, new Long(nMaxIterations));
        long nRowsOfRetainedSet = props.getInt(ROWS_RETAINED_SET_ATTRIBUTE_TAG, Integer.parseInt("10000"));
        proc1.setProp(ROWS_RETAINED_SET_ATTRIBUTE_TAG, new Long(nRowsOfRetainedSet));
        long nTimesToRetainPoints = props.getInt(MAX_TIMES_RETAIN_POINTS_ATTRIBUTE_TAG, Integer.parseInt(MAX_TIMES_RETAIN_POINTS_DEFAULT));
        proc1.setProp(MAX_TIMES_RETAIN_POINTS_ATTRIBUTE_TAG, new Long(nTimesToRetainPoints));
        boolean bScaleRange = props.getValue(SCALE_ATTRIBUTE_TAG, SCALE_METHOD_DEFAULT).equals(RANGE_SCALE_ATTRIBUTE_TAG);
        boolean bScaleSTD = props.getValue(SCALE_ATTRIBUTE_TAG, SCALE_METHOD_DEFAULT).equals(ST_DEV_SCALE_ATTRIBUTE_TAG);
        if (bScaleRange) {
            proc1.setProp(SCALE_ATTRIBUTE_TAG, new Long(RANGE_SCALE_ATTRIBUTE));
        } else if (bScaleSTD) {
            proc1.setProp(SCALE_ATTRIBUTE_TAG, new Long(ST_DEV_SCALE_ATTRIBUTE));
        } else {
            proc1.setProp(SCALE_ATTRIBUTE_TAG, new Long(NO_SCALE_ATTRIBUTE));
        }
        String sInitCenters = props.getValue(INITIALIZING_CENTER_ATTRIBUTE_TAG, SAMPLING_FROM_FIRST_BLOCK_ATTRIBUTE_TAG);
        if (sInitCenters.equals(FIRST_K_DATA_POINTS_ATTRIBUTE_TAG)) {
            proc1.setProp(INITIALIZING_CENTER_ATTRIBUTE_TAG, new Long(FIRST_K_DATA_POINTS_ATTRIBUTE));
        } else if (sInitCenters.equals(SAMPLING_FROM_FIRST_BLOCK_ATTRIBUTE_TAG)) {
            proc1.setProp(INITIALIZING_CENTER_ATTRIBUTE_TAG, new Long(SAMPLING_FROM_FIRST_BLOCK_ATTRIBUTE));
        } else if (sInitCenters.equals(HCLUST_FROM_FIRST_BLOCK_ATTRIBUTE_TAG)) {
            proc1.setProp(INITIALIZING_CENTER_ATTRIBUTE_TAG, new Long(HCLUST_FROM_FIRST_BLOCK_ATTRIBUTE));
        } else if (sInitCenters.equals(SAMPLING_FROM_ENTIRE_SET_ATTRIBUTE_TAG)) {
            proc1.setProp(INITIALIZING_CENTER_ATTRIBUTE_TAG, new Long(SAMPLING_FROM_ENTIRE_SET_ATTRIBUTE));
        } else {
            proc1.setProp(INITIALIZING_CENTER_ATTRIBUTE_TAG, new Long(FIRST_K_DATA_POINTS_ATTRIBUTE));
        }
        XTMetaData md = this.getInputMetaData(0);
        long maxRows = md.getNumRows();
        proc1.setProp(MAXIMUM_ROWS_ATTRIBUTE_TAG, new Long(maxRows));
        if (sInitCenters.equals(SAMPLING_FROM_ENTIRE_SET_ATTRIBUTE_TAG)) {
            this.printlnVerbose("k-means clustering: sampling to initialize centers");
            if (!this.getNetworkManager().executeCNKProc(this.getNodeID(), proc1)) {
                this.procDelete(proc1);
                return false;
            }
        }
        this.printlnVerbose("k-means clustering: creating model");
        String origText = (String)EngineMessageHandler.sendMessageToApp("getStatusText", new Object[0]);
        String str = origText + ": Building model...";
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{str});
        ok = this.getNetworkManager().executeCNKProc(this.getNodeID(), proc1);
        this.procDelete(proc1);
        if (!ok || this.m_modelString == null) {
            return false;
        }
        Vector outputSpecs = this.getOutputSpecs();
        PredictEngineNode.isConflictingIO(outputSpecs, this);
        if (outputSpecs.size() < 1) {
            return ok;
        }
        this.printlnVerbose("k-means clustering: creating CNKProcKMeansPredict");
        CNKProcKMeansPredict proc2 = new CNKProcKMeansPredict();
        this.printlnVerbose("k-means clustering: CNKProcKMeansPredict.setModel");
        proc2.setModel(this.m_modelString);
        PredictEngineNode.defineOutputsFromSpecs(proc2, outputSpecs);
        this.printlnVerbose("k-means clustering: predicting from training data.");
        str = origText + ": Predicting...";
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{str});
        ok = this.getNetworkManager().executeCNKProc(this.getNodeID(), proc2);
        this.procDelete(proc2);
        this.m_modelString = null;
        if (!ok) {
            return false;
        }
        if (props.getBoolean(CHART_DISPLAY_ATTRIBUTE_TAG, CHART_DISPLAY_DEFAULT)) {
            ok = this.getChartData();
        }
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{origText});
        return ok;
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        if (outputNum == 0) {
            return PredictEngineNode.calculateOutputMetaDataFromOutputSpecs(this.getOutputSpecs());
        }
        try {
            return new XTMetaData();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Vector getOutputSpecs() {
        XTProps props = this.getNodeProperties();
        XTMetaData md = this.getInputMetaData(0);
        try {
            Vector outputSpecs = PredictEngineNode.getClusterOutputSpecs(md, props);
            return outputSpecs;
        }
        catch (Exception ex) {
            return new Vector();
        }
    }

    public int getBinCount() {
        return this.m_binCount;
    }

    private boolean getChartData() throws Exception {
        long curRow;
        XTProps props = this.getNodeProperties();
        if (!props.getBoolean(new String[]{"copyInputColumns", "clusterColumns"}, false) || !props.getBoolean(new String[]{"newColumns", "clusterMembership"}, false)) {
            this.printlnWarning("Cannot compute chart information unless output includes " + MinerApp.getText("PredictionPanel_clusterMembership") + " and " + MinerApp.getText("PredictionPanel_clusterColumns") + ".  \nChart will not be displayed on View.");
            this.setNodeCache(BIN_COUNT_CACHE, null);
            return true;
        }
        XTMetaData outputMD = this.getOutputMetaData(0);
        XTMetaData inputMD = this.getInputMetaData(0);
        Vector indepCols = props.getSubProperties(DISPLAY_COLUMNS_ATTRIBUTE_TAG);
        for (int i = indepCols.size() - 1; i >= 0; --i) {
            if (!inputMD.isStringColumn((String)indepCols.get(i))) continue;
            indepCols.remove(i);
        }
        Vector<String> groupBy = new Vector<String>();
        groupBy.add("PREDICT.membership");
        int numQuantiles = 4;
        int kValue = 100;
        boolean twoPass = false;
        ByColumnStatisticAccumulator bCS = new ByColumnStatisticAccumulator(groupBy, indepCols, numQuantiles, kValue, outputMD);
        bCS.setBinCount(this.getBinCount());
        bCS.calculateOnlyBinCounts();
        String filename = this.getOutputDataCacheFileName(0);
        FileInputStream dataStream = new FileInputStream(filename);
        BufferedInputStream dataBuffer = new BufferedInputStream(dataStream);
        DataInputStream dataInputStream = new DataInputStream(dataBuffer);
        int clusterColumnNum = outputMD.nameToOrdinal("PREDICT.membership");
        if (clusterColumnNum == -1) {
            this.printlnError("Prediction column for cluster membership is not found in output.");
            return false;
        }
        int numIndepCols = indepCols.size();
        int[] indepColumnNums = new int[numIndepCols];
        for (int i = 0; i < numIndepCols; ++i) {
            indepColumnNums[i] = outputMD.nameToOrdinal((String)indepCols.get(i));
            if (indepColumnNums[i] != -1) continue;
            this.printlnError("Independent column (" + (String)indepCols.get(i) + ") was not found in output.");
            return false;
        }
        DataCacheRowBuf rowBuf = new DataCacheRowBuf(outputMD);
        long rowCount = outputMD.getNumRows();
        boolean lastPercentage = false;
        int rowChunk = (int)Math.min((long)this.getMaxRowsPerBlock(), rowCount);
        double[][] actualInterestColumns = new double[numIndepCols][rowChunk];
        double[][] actualByColumns = new double[1][rowChunk];
        String origText = (String)EngineMessageHandler.sendMessageToApp("getStatusText", new Object[0]);
        String str = origText + ": Collecting chart info...";
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{str});
        for (curRow = 0L; curRow < rowCount; curRow += (long)rowChunk) {
            for (int row = 0; row < rowChunk; ++row) {
                rowBuf.readRow(dataInputStream);
                for (int column = 0; column < numIndepCols; ++column) {
                    if (rowBuf.isTimeDate(column)) {
                        double val = rowBuf.getTimeDate(indepColumnNums[column]);
                        actualInterestColumns[column][row] = val / 8.64E7;
                        continue;
                    }
                    actualInterestColumns[column][row] = rowBuf.getDouble(indepColumnNums[column]);
                }
                actualByColumns[0][row] = rowBuf.getDouble(clusterColumnNum);
            }
            bCS.updateStatistics(actualByColumns, actualInterestColumns, rowChunk);
            int percent = (int)((double)curRow / (double)rowCount * 100.0);
            if (this.updateProgressIndicator(percent)) continue;
            return false;
        }
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{origText});
        dataInputStream.close();
        if (twoPass) {
            dataStream = new FileInputStream(filename);
            dataBuffer = new BufferedInputStream(dataStream);
            dataInputStream = new DataInputStream(dataBuffer);
            String newStr = origText + ": Collecting quantile info...";
            EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{newStr});
            lastPercentage = false;
            for (curRow = 0L; curRow < rowCount; curRow += (long)rowChunk) {
                for (int row = 0; row < rowChunk; ++row) {
                    rowBuf.readRow(dataInputStream);
                    for (int column = 0; column < numIndepCols; ++column) {
                        actualInterestColumns[column][row] = rowBuf.getDouble(indepColumnNums[column]);
                    }
                    actualByColumns[0][row] = rowBuf.getDouble(clusterColumnNum);
                }
                bCS.updateStatisticsSecondPass(actualByColumns, actualInterestColumns, rowChunk);
                int percent = (int)((double)curRow / (double)rowCount * 100.0);
                if (this.updateProgressIndicator(percent)) continue;
                return false;
            }
            EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{origText});
        }
        XTProps binCounts = bCS.outputColumnStats();
        this.setNodeCache(BIN_COUNT_CACHE, binCounts);
        return true;
    }
}

