/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AppAction;
import com.insightful.miner.CompareEngineNode;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.XTProps;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class CompareDialog
extends NodeDialog {
    JRadioButton[] m_inputRadioButtons;
    JRadioButton[] m_numericRadioButtons;
    JTextField m_toleranceTextField;
    JCheckBox[] m_outputCheckBoxes;
    JRadioButton[] m_outputRadioButtons;
    private static CompareDialog instance = null;

    public static CompareDialog getInstance() {
        if (instance == null) {
            instance = new CompareDialog();
        }
        return instance;
    }

    private CompareDialog() {
        Dimension dim = new Dimension(400, 400);
        this.setMinimumSize(dim);
        this.setSize(dim);
    }

    public void restoreProperties() {
        super.restoreProperties();
        XTProps props = this.getNodeModel().getXTProps();
        this.m_inputRadioButtons[0].setSelected(props.getBoolean(CompareEngineNode.UNION_ATTRIBUTE_TAG, true));
        this.m_numericRadioButtons[0].setSelected(props.getBoolean(CompareEngineNode.LOGICAL_ATTRIBUTE_TAG, true));
        this.m_numericRadioButtons[1].setSelected(props.getBoolean(CompareEngineNode.ABSOLUTE_ATTRIBUTE_TAG, false));
        this.m_numericRadioButtons[2].setSelected(!this.m_numericRadioButtons[0].isSelected() && !this.m_numericRadioButtons[1].isSelected());
        this.m_toleranceTextField.setText(props.getValue(CompareEngineNode.TOLERANCE_ATTRIBUTE_TAG, "0.0"));
        this.m_outputCheckBoxes[0].setSelected(props.getBoolean(CompareEngineNode.FILTER_PASSING_ROWS_ATTRIBUTE_TAG, true));
        this.m_outputRadioButtons[0].setSelected(props.getBoolean(CompareEngineNode.SUMMARY_INPUTS_ATTRIBUTE_TAG, true));
        this.m_outputCheckBoxes[1].setSelected(props.getBoolean(CompareEngineNode.SUMMARY_INPUT_AND_ROW_ATTRIBUTE_TAG, true));
        this.m_outputCheckBoxes[2].setSelected(props.getBoolean(CompareEngineNode.SUMMARY_INPUT_AND_COLUMN_ATTRIBUTE_TAG, true));
        this.m_outputCheckBoxes[3].setSelected(props.getBoolean(CompareEngineNode.SUMMARY_INPUT_AND_ROW_NUM_ATTRIBUTE_TAG, true));
        this.m_outputRadioButtons[1].setSelected(props.getBoolean(CompareEngineNode.SUMMARY_ROW_ATTRIBUTE_TAG, true));
        this.m_outputRadioButtons[2].setSelected(props.getBoolean(CompareEngineNode.SUMMARY_COLUMN_ATTRIBUTE_TAG, false));
        this.m_outputCheckBoxes[4].setSelected(props.getBoolean(CompareEngineNode.ROW_NUM_COLUMN_ATTRIBUTE_TAG, true));
        this.m_outputCheckBoxes[5].setSelected(props.getBoolean(CompareEngineNode.MESSAGE_PANE_ATTRIBUTE_TAG, true));
        this.enableOutputButtons();
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        XTProps props = this.getNodeModel().getXTProps();
        props.set(CompareEngineNode.UNION_ATTRIBUTE_TAG, this.m_inputRadioButtons[0].isSelected());
        props.set(CompareEngineNode.LOGICAL_ATTRIBUTE_TAG, this.m_numericRadioButtons[0].isSelected());
        props.set(CompareEngineNode.ABSOLUTE_ATTRIBUTE_TAG, this.m_numericRadioButtons[1].isSelected());
        props.set(CompareEngineNode.TOLERANCE_ATTRIBUTE_TAG, this.m_toleranceTextField.getText());
        props.set(CompareEngineNode.FILTER_PASSING_ROWS_ATTRIBUTE_TAG, this.m_outputCheckBoxes[0].isSelected());
        props.set(CompareEngineNode.SUMMARY_INPUTS_ATTRIBUTE_TAG, this.m_outputRadioButtons[0].isSelected());
        props.set(CompareEngineNode.SUMMARY_INPUT_AND_ROW_ATTRIBUTE_TAG, this.m_outputCheckBoxes[1].isSelected());
        props.set(CompareEngineNode.SUMMARY_INPUT_AND_COLUMN_ATTRIBUTE_TAG, this.m_outputCheckBoxes[2].isSelected());
        props.set(CompareEngineNode.SUMMARY_INPUT_AND_ROW_NUM_ATTRIBUTE_TAG, this.m_outputCheckBoxes[3].isSelected());
        props.set(CompareEngineNode.SUMMARY_ROW_ATTRIBUTE_TAG, this.m_outputRadioButtons[1].isSelected());
        props.set(CompareEngineNode.ROW_NUM_COLUMN_ATTRIBUTE_TAG, this.m_outputCheckBoxes[4].isSelected());
        props.set(CompareEngineNode.SUMMARY_COLUMN_ATTRIBUTE_TAG, this.m_outputRadioButtons[2].isSelected());
        props.set(CompareEngineNode.MESSAGE_PANE_ATTRIBUTE_TAG, this.m_outputCheckBoxes[5].isSelected());
    }

    public Vector createOtherTabs() {
        Vector<JPanel> panels = new Vector<JPanel>();
        JPanel outputPanel = this.createOutputPanel();
        panels.add(outputPanel);
        return panels;
    }

    public JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        JPanel inputPanel = new JPanel(new GridBagLayout());
        inputPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("CompareDialog_inputs")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel numericPanel = new JPanel(new GridBagLayout());
        numericPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("CompareDialog_numeric")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        ButtonGroup bg = new ButtonGroup();
        this.m_inputRadioButtons = new JRadioButton[2];
        this.m_inputRadioButtons[0] = new JRadioButton(MinerApp.getText("CompareDialog_union"));
        this.m_inputRadioButtons[0].setMnemonic(MinerApp.getText("CompareDialog_unionHotkey").charAt(0));
        this.m_inputRadioButtons[1] = new JRadioButton(MinerApp.getText("CompareDialog_intersection"));
        this.m_inputRadioButtons[1].setMnemonic(MinerApp.getText("CompareDialog_intersectionHotkey").charAt(0));
        bg.add(this.m_inputRadioButtons[0]);
        bg.add(this.m_inputRadioButtons[1]);
        bg = new ButtonGroup();
        this.m_numericRadioButtons = new JRadioButton[3];
        this.m_numericRadioButtons[0] = new JRadioButton(MinerApp.getText("CompareDialog_logical"));
        this.m_numericRadioButtons[0].setMnemonic(MinerApp.getText("CompareDialog_logicalHotkey").charAt(0));
        this.m_numericRadioButtons[1] = new JRadioButton(MinerApp.getText("CompareDialog_absoluteDiff"));
        this.m_numericRadioButtons[1].setMnemonic(MinerApp.getText("CompareDialog_absoluteDiffHotkey").charAt(0));
        this.m_numericRadioButtons[2] = new JRadioButton(MinerApp.getText("CompareDialog_relativeDiff"));
        this.m_numericRadioButtons[2].setMnemonic(MinerApp.getText("CompareDialog_relativeDiffHotkey").charAt(0));
        bg.add(this.m_numericRadioButtons[0]);
        bg.add(this.m_numericRadioButtons[1]);
        bg.add(this.m_numericRadioButtons[2]);
        this.m_toleranceTextField = new JTextField(10);
        JLabel toleranceLabel = new JLabel(MinerApp.getText("CompareDialog_tolerance"));
        toleranceLabel.setDisplayedMnemonic(MinerApp.getText("CompareDialog_toleranceHotkey").charAt(0));
        toleranceLabel.setLabelFor(this.m_toleranceTextField);
        this.m_toleranceTextField.setDocument(new NodeDialog.InputDoubleDoc());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        inputPanel.add((Component)this.m_inputRadioButtons[0], gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        inputPanel.add((Component)this.m_inputRadioButtons[1], gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        numericPanel.add((Component)this.m_numericRadioButtons[0], gbc);
        ++gbc.gridy;
        numericPanel.add((Component)this.m_numericRadioButtons[1], gbc);
        ++gbc.gridy;
        numericPanel.add((Component)this.m_numericRadioButtons[2], gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        numericPanel.add((Component)toleranceLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        numericPanel.add((Component)this.m_toleranceTextField, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        optionsPanel.add((Component)inputPanel, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        optionsPanel.add((Component)numericPanel, gbc);
        return optionsPanel;
    }

    private void enableOutputButtons() {
        boolean inputEnabled = this.m_outputRadioButtons[0].isSelected();
        boolean rowsEnabled = this.m_outputRadioButtons[2].isSelected();
        this.m_outputCheckBoxes[1].setEnabled(inputEnabled);
        this.m_outputCheckBoxes[2].setEnabled(inputEnabled);
        this.m_outputCheckBoxes[3].setEnabled(inputEnabled);
        this.m_outputCheckBoxes[4].setEnabled(rowsEnabled);
    }

    protected JPanel createOutputPanel() {
        JPanel outputPanel = new JPanel(new GridBagLayout());
        outputPanel.setName(MinerApp.getText("PredictionPanel_prediction"));
        this.m_outputCheckBoxes = new JCheckBox[6];
        this.m_outputCheckBoxes[0] = new JCheckBox(MinerApp.getText("CompareDialog_filterPassingRows"));
        this.m_outputCheckBoxes[1] = new JCheckBox(MinerApp.getText("CompareDialog_summaryRow"));
        this.m_outputCheckBoxes[2] = new JCheckBox(MinerApp.getText("CompareDialog_summaryColumn"));
        this.m_outputCheckBoxes[3] = new JCheckBox(MinerApp.getText("CompareDialog_rowNumColumn"));
        this.m_outputCheckBoxes[4] = new JCheckBox(MinerApp.getText("CompareDialog_rowNumColumn"));
        this.m_outputCheckBoxes[5] = new JCheckBox(MinerApp.getText("CompareDialog_messagePane"));
        this.m_outputCheckBoxes[0].setMnemonic(MinerApp.getText("CompareDialog_filterPassingRowsHotkey").charAt(0));
        this.m_outputCheckBoxes[1].setMnemonic(MinerApp.getText("CompareDialog_summaryRowHotkey").charAt(0));
        this.m_outputCheckBoxes[2].setMnemonic(MinerApp.getText("CompareDialog_summaryColumnHotkey").charAt(0));
        this.m_outputCheckBoxes[3].setMnemonic(MinerApp.getText("CompareDialog_rowNumColumnHotkey").charAt(0));
        this.m_outputCheckBoxes[4].setMnemonic(MinerApp.getText("CompareDialog_rowNumColumnHotkey").charAt(1));
        this.m_outputCheckBoxes[5].setMnemonic(MinerApp.getText("CompareDialog_messagePaneHotkey").charAt(0));
        this.m_outputRadioButtons = new JRadioButton[3];
        this.m_outputRadioButtons[0] = new JRadioButton(new AppAction(MinerApp.getText("CompareDialog_summaryInput")){

            public void actionPerformed(ActionEvent e) {
                CompareDialog.this.enableOutputButtons();
            }
        });
        this.m_outputRadioButtons[1] = new JRadioButton(new AppAction(MinerApp.getText("CompareDialog_summaryRow")){

            public void actionPerformed(ActionEvent e) {
                CompareDialog.this.enableOutputButtons();
            }
        });
        this.m_outputRadioButtons[2] = new JRadioButton(new AppAction(MinerApp.getText("CompareDialog_summaryColumn")){

            public void actionPerformed(ActionEvent e) {
                CompareDialog.this.enableOutputButtons();
            }
        });
        this.m_outputRadioButtons[0].setMnemonic(MinerApp.getText("CompareDialog_summaryInputHotkey").charAt(0));
        this.m_outputRadioButtons[1].setMnemonic(MinerApp.getText("CompareDialog_summaryRowHotkey").charAt(1));
        this.m_outputRadioButtons[2].setMnemonic(MinerApp.getText("CompareDialog_summaryColumnHotkey").charAt(1));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_outputRadioButtons[0]);
        bg.add(this.m_outputRadioButtons[1]);
        bg.add(this.m_outputRadioButtons[2]);
        Insets none = new Insets(0, 0, 0, 0);
        Insets indnt = new Insets(0, 10, 0, 0);
        Insets ypaded = new Insets(10, 0, 10, 0);
        JPanel dataOutputPanel = new JPanel(new GridBagLayout());
        dataOutputPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("CompareDialog_dataOutput")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.insets = none;
        gbc.fill = 2;
        dataOutputPanel.add((Component)this.m_outputCheckBoxes[0], gbc);
        ++gbc.gridy;
        gbc.insets = ypaded;
        dataOutputPanel.add((Component)new JSeparator(), gbc);
        ++gbc.gridy;
        gbc.insets = none;
        dataOutputPanel.add((Component)this.m_outputRadioButtons[0], gbc);
        ++gbc.gridy;
        gbc.insets = indnt;
        dataOutputPanel.add((Component)this.m_outputCheckBoxes[1], gbc);
        ++gbc.gridy;
        dataOutputPanel.add((Component)this.m_outputCheckBoxes[2], gbc);
        ++gbc.gridy;
        dataOutputPanel.add((Component)this.m_outputCheckBoxes[3], gbc);
        ++gbc.gridy;
        gbc.insets = none;
        dataOutputPanel.add((Component)this.m_outputRadioButtons[1], gbc);
        ++gbc.gridy;
        gbc.insets = none;
        dataOutputPanel.add((Component)this.m_outputRadioButtons[2], gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.insets = indnt;
        dataOutputPanel.add((Component)this.m_outputCheckBoxes[4], gbc);
        JPanel textOutputPanel = new JPanel(new GridBagLayout());
        textOutputPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("CompareDialog_textOutput")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.insets = none;
        gbc.fill = 2;
        textOutputPanel.add((Component)this.m_outputCheckBoxes[5], gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weighty = 1.0;
        gbc.weightx = 0.5;
        gbc.insets = none;
        gbc.fill = 1;
        outputPanel.add((Component)dataOutputPanel, gbc);
        ++gbc.gridx;
        outputPanel.add((Component)textOutputPanel, gbc);
        return outputPanel;
    }
}

