/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.GridViewerModel;
import com.insightful.miner.GridViewerSorter;
import com.insightful.miner.GridViewerTransferHandler;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class GridViewerTable
extends JTable
implements ListSelectionListener {
    protected JTableHeader jSecondaryTableHeader = null;
    protected GridViewerListSelectionModel jGVListSelectionModel = null;
    private boolean jResetSelectionAllowed = true;

    public GridViewerTable(TableModel tm) {
        super(tm);
        JTableHeader primaryHeader = this.getPrimaryTableHeader();
        primaryHeader.setDefaultRenderer(new PrimaryTableHeaderRenderer(this));
        this.jSecondaryTableHeader = this.createSecondaryHeader();
        this.jSecondaryTableHeader.setTable(this);
        this.jSecondaryTableHeader.setDefaultRenderer(new SecondaryTableHeaderRenderer(this));
        this.jSecondaryTableHeader.setReorderingAllowed(false);
        primaryHeader.setReorderingAllowed(false);
        int last = this.getColumnCount() - 1;
        if (last != -1) {
            this.getColumnModel().getColumn(last).setResizable(false);
        } else {
            this.getColumnModel().getColumn(0).setResizable(false);
        }
        this.jSecondaryTableHeader.setResizingAllowed(false);
        this.setAutoResizeMode(3);
        int size = this.getFont().getSize();
        this.setFont(new Font("Courier", 0, size));
        if (tm instanceof GridViewerModel) {
            this.jGVListSelectionModel = new GridViewerListSelectionModel((GridViewerModel)tm);
            this.setSelectionModel(this.jGVListSelectionModel);
            this.jGVListSelectionModel.setAnchorSelectionIndex(0);
            this.setTransferHandler(new GridViewerTransferHandler(this.jGVListSelectionModel));
        }
    }

    public JTableHeader getPrimaryTableHeader() {
        return super.getTableHeader();
    }

    public JTableHeader getSecondaryTableHeader() {
        return this.jSecondaryTableHeader;
    }

    protected JTableHeader createSecondaryHeader() {
        return new MyTableHeader(this);
    }

    protected void paintComponent(Graphics g) {
        if (this.getParent() != null) {
            Rectangle clip = g.getClipBounds();
            g.setColor(this.getParent().getBackground());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
        }
        super.paintComponent(g);
    }

    public void createDefaultColumnsFromModel() {
        TableModel m = this.getModel();
        if (m != null) {
            TableColumnModel cm = this.getColumnModel();
            while (cm.getColumnCount() > 0) {
                cm.removeColumn(cm.getColumn(0));
            }
            int columnCount = m.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                TableColumn newColumn = null;
                int columnWidth = 0;
                columnWidth = m instanceof GridViewerSorter ? ((GridViewerSorter)m).getRelativeColumnWidth(i) : ((GridViewerModel)m).getRelativeColumnWidth(i);
                newColumn = new TableColumn(i, columnWidth);
                this.addColumn(newColumn);
            }
            int last = columnCount - 1;
            if (last >= 0 && this.jSecondaryTableHeader != null) {
                this.getColumnModel().getColumn(last).setResizable(false);
            }
        }
    }

    public boolean setResetSelectionAllowed(boolean newVal) {
        boolean ret = this.jResetSelectionAllowed;
        this.jResetSelectionAllowed = newVal;
        return ret;
    }

    protected class MyTableHeader
    extends JTableHeader {
        protected GridViewerTable gridViewerTable;

        public MyTableHeader(GridViewerTable table) {
            super(table.getColumnModel());
            this.gridViewerTable = null;
            this.gridViewerTable = table;
        }
    }

    protected class SecondaryTableHeaderRenderer
    implements TableCellRenderer {
        protected GridViewerModel gridViewerModel = null;
        protected TableCellRenderer dtcr = null;

        public SecondaryTableHeaderRenderer(GridViewerTable t) {
            this.gridViewerModel = (GridViewerModel)t.getModel();
            this.dtcr = t.getPrimaryTableHeader().getDefaultRenderer();
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.dtcr.getTableCellRendererComponent(table, this.gridViewerModel.getColumnDisplayType(column), isSelected, hasFocus, row, column);
        }
    }

    protected class PrimaryTableHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer renderer = null;

        public PrimaryTableHeaderRenderer(JTable table) {
            this.renderer = table.getTableHeader().getDefaultRenderer();
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ((JLabel)comp).setHorizontalAlignment(4);
            return comp;
        }
    }

    public class GridViewerListSelectionModel
    extends DefaultListSelectionModel {
        private Vector selectionIntervals = new Vector();
        private GridViewerModel model = null;
        private long anchorAbsPos = 0L;

        public GridViewerListSelectionModel(GridViewerModel model) {
            this.model = model;
        }

        public long getMinimum() {
            if (!this.selectionIntervals.isEmpty() && this.model != null) {
                Range first = (Range)this.selectionIntervals.firstElement();
                long longRetVal = first.start;
                return longRetVal;
            }
            return -1L;
        }

        public long getMaximum() {
            if (!this.selectionIntervals.isEmpty() && this.model != null) {
                Range first = (Range)this.selectionIntervals.lastElement();
                long longRetVal = first.end;
                return longRetVal;
            }
            return -1L;
        }

        public void selectAll() {
            int anchor = super.getAnchorSelectionIndex();
            this.clearSelection();
            if (this.model != null) {
                Range range = new Range(0L, this.model.getTotalRowCount() - 1L);
                this.selectionIntervals.removeAllElements();
                this.selectionIntervals.add(range);
            }
            super.setAnchorSelectionIndex(anchor);
        }

        public void setSelectionInterval(int index0, int index1) {
            int anchor = super.getAnchorSelectionIndex();
            super.setSelectionInterval(index0, index1);
            if (this.model != null) {
                long absRowPos = this.model.getAbsoluteRowPos();
                if (anchor != super.getAnchorSelectionIndex()) {
                    this.anchorAbsPos = absRowPos;
                }
                Range range = new Range(absRowPos + (long)Math.min(index0, index1), absRowPos + (long)Math.max(index0, index1));
                this.selectionIntervals.removeAllElements();
                this.selectionIntervals.add(range);
            }
        }

        public void addSelectionInterval(int index0, int index1) {
            int anchor = super.getAnchorSelectionIndex();
            super.addSelectionInterval(index0, index1);
            if (this.model != null) {
                long absRowPos = this.model.getAbsoluteRowPos();
                if (anchor != super.getAnchorSelectionIndex()) {
                    this.anchorAbsPos = absRowPos;
                }
                Range range = new Range(absRowPos + (long)Math.min(index0, index1), absRowPos + (long)Math.max(index0, index1));
                this.addRange(range);
            }
        }

        public void removeSelectionInterval(int index0, int index1) {
            int anchor = super.getAnchorSelectionIndex();
            super.removeSelectionInterval(index0, index1);
            if (this.model != null) {
                long absRowPos = this.model.getAbsoluteRowPos();
                if (anchor != super.getAnchorSelectionIndex()) {
                    this.anchorAbsPos = absRowPos;
                }
                Range range = new Range(absRowPos + (long)Math.min(index0, index1), absRowPos + (long)Math.max(index0, index1));
                this.removeRange(range);
            }
        }

        public int getMinSelectionIndex() {
            int ret = super.getMinSelectionIndex();
            if (!this.selectionIntervals.isEmpty() && this.model != null) {
                Range first = (Range)this.selectionIntervals.firstElement();
                long longRetVal = first.start;
                int n = (int)(longRetVal - this.model.getAbsoluteRowPos());
            }
            return ret;
        }

        public int getMaxSelectionIndex() {
            int ret = super.getMaxSelectionIndex();
            if (!this.selectionIntervals.isEmpty() && this.model != null) {
                Range first = (Range)this.selectionIntervals.firstElement();
                long longRetVal = first.start;
                int n = (int)(longRetVal - this.model.getAbsoluteRowPos());
            }
            return ret;
        }

        public int getAnchorSelectionIndex() {
            int iVal = super.getAnchorSelectionIndex();
            if (this.model != null || iVal == -1) {
                long absRowPos = this.model.getAbsoluteRowPos();
                long visNumRows = this.model.getRowCount();
                long curVal = (long)iVal + this.anchorAbsPos;
                if (curVal < absRowPos || curVal > absRowPos + visNumRows) {
                    return -1;
                }
                if (absRowPos != this.anchorAbsPos) {
                    return iVal + (int)(this.anchorAbsPos - absRowPos);
                }
            }
            return iVal;
        }

        public void setLeadSelectionIndex(int leadIndex) {
            int anchor = super.getAnchorSelectionIndex();
            super.setLeadSelectionIndex(leadIndex);
            if (this.model != null) {
                long absRowPos = this.model.getAbsoluteRowPos();
                int newAnchor = super.getAnchorSelectionIndex();
                if (anchor != newAnchor) {
                    this.anchorAbsPos = absRowPos;
                    anchor = newAnchor;
                }
                Range newRange = new Range(Math.min((long)anchor + this.anchorAbsPos, (long)leadIndex + absRowPos), Math.max((long)anchor + this.anchorAbsPos, (long)leadIndex + absRowPos));
                this.addRange(newRange);
            }
        }

        public void setAnchorSelectionIndex(int index) {
            super.setAnchorSelectionIndex(index);
            this.anchorAbsPos = this.model.getAbsoluteRowPos();
        }

        public boolean isSelectedIndex(int index) {
            if (!this.selectionIntervals.isEmpty() && this.model != null) {
                long longRowPos = this.model.getAbsoluteRowPos() + (long)index;
                for (Range range : this.selectionIntervals) {
                    if (!range.contains(longRowPos)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isSelectedIndex(long longRowPos) {
            if (!this.selectionIntervals.isEmpty() && this.model != null) {
                for (Range range : this.selectionIntervals) {
                    if (!range.contains(longRowPos)) continue;
                    return true;
                }
            }
            return false;
        }

        public void clearSelection() {
            if (GridViewerTable.this.jResetSelectionAllowed) {
                super.clearSelection();
                this.selectionIntervals.clear();
            }
        }

        public String toString() {
            StringBuffer ret = new StringBuffer("<");
            Iterator it = this.selectionIntervals.iterator();
            while (it.hasNext()) {
                Range r = (Range)it.next();
                ret.append("(" + r.start + "," + r.end + ")");
                if (!it.hasNext()) continue;
                ret.append(",");
            }
            ret.append(">  -  anchor=" + ((long)super.getAnchorSelectionIndex() + this.anchorAbsPos) + " lead=" + this.getLeadSelectionIndex());
            return ret.toString();
        }

        private void addRange(Range newRange) {
            int addPosition = -1;
            int i = 0;
            while (i < this.selectionIntervals.size()) {
                Range range = (Range)this.selectionIntervals.get(i);
                if (newRange.start > range.start && newRange.end < range.end) {
                    return;
                }
                if (newRange.start > range.end + 1L) {
                    ++i;
                    continue;
                }
                if (newRange.end < range.start - 1L) {
                    if (addPosition != -1) break;
                    addPosition = i;
                    break;
                }
                if (newRange.end <= range.end) {
                    newRange.end = range.end;
                }
                if (newRange.start >= range.start) {
                    newRange.start = range.start;
                }
                this.selectionIntervals.remove(i);
                if (addPosition != -1) continue;
                addPosition = i;
            }
            if (addPosition == -1) {
                this.selectionIntervals.add(newRange);
            } else {
                this.selectionIntervals.insertElementAt(newRange, addPosition);
            }
        }

        private void removeRange(Range newRange) {
            for (int i = 0; i < this.selectionIntervals.size(); ++i) {
                Range range = (Range)this.selectionIntervals.get(i);
                if (newRange.start == range.start) {
                    if (newRange.end == range.end) {
                        this.selectionIntervals.remove(i);
                        break;
                    }
                    range.start = newRange.end + 1L;
                    break;
                }
                if (newRange.end == range.end) {
                    range.end = newRange.start - 1L;
                    break;
                }
                if (newRange.start <= range.start || newRange.end >= range.end) continue;
                Range frontSide = new Range(range.start, newRange.end - 1L);
                this.selectionIntervals.insertElementAt(frontSide, i);
                range.start = newRange.end + 1L;
                break;
            }
        }

        private class Range {
            public long start;
            public long end;

            public Range(long start, long end) {
                this.start = start;
                this.end = end;
            }

            public boolean contains(long val) {
                return this.start <= val && this.end >= val;
            }
        }
    }
}

