/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcGLMFit;
import com.insightful.cnkjava.CNKProcILM;
import com.insightful.miner.BDLManager;
import com.insightful.miner.EngineMessageHandler;
import com.insightful.miner.EngineNode;
import com.insightful.miner.PredictEngineNode;
import com.insightful.miner.SetRolesPanelBase;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.util.StringTokenizer;
import java.util.Vector;

class LinearRegressionEngineNode
extends EngineNode {
    public static final String INCLUDE_INTERCEPT_ATTRIBUTE_TAG = "includeIntercept";
    public static final String WEIGHTED_COLUMN_ATTRIBUTE_TAG = "weightedColumn";
    public static final String MAX_ITERATIONS_ATTRIBUTE_TAG = "maxIterations";
    public static final String CONVERGENCE_TOLERANCE_ATTRIBUTE_TAG = "convergenceTolerance";
    public static final String PROBABILITY_FOR_ATTRIBUTE_TAG = "probabilityFor";
    public static final String SPECIFIED_CATEGORY_ATTRIBUTE_TAG = "specifiedCategory";
    public static final String LAST_CATEGORY_ATTRIBUTE_TAG = "lastCategory";
    public static final String IMPORTANCE_NODE_TAG = "Importance";
    public static final String IMPORTANCE_EFFECT_NODE_TAG = "Effect";
    private String m_modelString = null;
    public static String BEGIN_GENERALREGRESSIONMODEL = "<GeneralRegressionModel modelName=";
    public static String MODEL_TYPE_GENERALLINEAR = "generalLinear";
    public static String MODEL_TYPE = " modelType=";
    public static String BEGIN_LINEAR_MODEL = "   <LinearModel nterms=";
    public static String INTERCEPT_VALUE = "   <Intercept value=";
    public static String WEIGHTS_VALUE = "   <Weights value=";
    public static String BEGIN_TERM = "      <Term name=";
    public static String TERMVAR_VALUE = "         <TermVar value=";
    public static String END_TERM = "      </Term>\n";
    public static String END_LINEAR_MODEL = "   </LinearModel>\n";

    public boolean hasCNKProc() {
        return false;
    }

    public boolean hasDataCacheProc() {
        return true;
    }

    public void procExtractResults(CNKProc proc) {
        if (proc instanceof CNKProcILM) {
            this.m_modelString = ((CNKProcILM)proc).getModel();
            XMLTree modelTree = XMLTree.readFromString(this.m_modelString);
            this.setNodeCache("model", modelTree);
        }
    }

    public Vector getOutputSpecs() {
        XTProps props = this.getNodeProperties();
        XTMetaData md = this.getInputMetaData(0);
        String depVar = this.getDepVar(props, md);
        Vector indepVars = PredictEngineNode.getIndependentVars(props, md);
        Vector outputSpecs = PredictEngineNode.getOutputSpecs(md, props, depVar, indepVars);
        return outputSpecs;
    }

    public static String xmlQuote(String str) {
        String val = "\"";
        StringTokenizer st = new StringTokenizer(str, "\"<>&", true);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals("\"")) {
                val = val + "&quot;";
                continue;
            }
            if (tok.equals("<")) {
                val = val + "&lt;";
                continue;
            }
            if (tok.equals(">")) {
                val = val + "&gt;";
                continue;
            }
            if (tok.equals("&")) {
                val = val + "&amp;";
                continue;
            }
            if (tok.equals("'")) {
                val = val + "&apos;";
                continue;
            }
            val = val + tok;
        }
        val = val + "\"";
        return val;
    }

    public String getModelType() {
        return MODEL_TYPE_GENERALLINEAR;
    }

    public String getModelAsString() throws Exception {
        XTProps props = this.getNodeProperties();
        XTMetaData md = this.getInputMetaData(0);
        String depCol = this.getDepVar(props, md);
        String modelXML = this.getDataDictionaryAsString();
        int i = modelXML.indexOf("</IMML>", 0);
        if (i > 0) {
            modelXML = modelXML.substring(0, i - 1);
            modelXML = modelXML + "\n";
        }
        modelXML = modelXML + BEGIN_GENERALREGRESSIONMODEL;
        modelXML = depCol != null ? modelXML + LinearRegressionEngineNode.xmlQuote(depCol) : modelXML + "\"?????\"";
        modelXML = modelXML + MODEL_TYPE + "\"" + this.getModelType() + "\"/>\n";
        modelXML = modelXML + this.getTermsAsString();
        modelXML = modelXML + "</IMML>\n";
        return modelXML;
    }

    public String getDepVar(XTProps props, XTMetaData md) {
        return PredictEngineNode.getFirstDependentVar(props, md, XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG);
    }

    public XTMetaData getDataDictionayMetaData() throws Exception {
        int i;
        XTProps props = this.getNodeProperties();
        XTMetaData md = this.getInputMetaData(0);
        Vector varNames = PredictEngineNode.getIndependentVars(props, md);
        String depCol = this.getDepVar(props, md);
        Vector<String> allNames = new Vector<String>(varNames);
        allNames.add(depCol);
        String weights = props.getValue(WEIGHTED_COLUMN_ATTRIBUTE_TAG);
        if (weights.length() > 0 && weights.charAt(0) != ' ') {
            allNames.add(weights);
        }
        XTMetaData mdModel = md.selectiveClone(allNames);
        for (i = 0; i < varNames.size(); ++i) {
            mdModel.setDataFieldRole((String)varNames.get(i), "independent");
        }
        mdModel.setDataFieldRole(depCol, "dependent");
        if (weights.length() > 0 && weights.charAt(0) != ' ') {
            for (i = 0; i < varNames.size(); ++i) {
                if (!weights.equals((String)varNames.get(i))) continue;
                throw new Exception("Variable " + weights + " cannot have both the weights and independent variable roles");
            }
            if (weights.equals(depCol)) {
                throw new Exception("Variable " + weights + " cannot have both the weights and dependent variable roles");
            }
            mdModel.setDataFieldRole(weights, "weights");
        }
        return mdModel;
    }

    public String getDataDictionaryAsString() throws Exception {
        return this.getDataDictionayMetaData().writeToString();
    }

    public String getTermsAsString() throws Exception {
        int j;
        XTProps props = this.getNodeProperties();
        XTMetaData md = this.getInputMetaData(0);
        Vector varNames = PredictEngineNode.getIndependentVars(props, md);
        Vector terms = props.getSubProperties("interactions");
        Vector excludeVars = SetRolesPanelBase.getVarsWithSpecials(props, "exclude");
        int nterms = varNames.size() + terms.size() - excludeVars.size();
        String modelXML = BEGIN_LINEAR_MODEL + LinearRegressionEngineNode.xmlQuote(Integer.toString(nterms)) + ">\n";
        for (int i = 0; i < varNames.size(); ++i) {
            String vari = (String)varNames.get(i);
            for (j = 0; j < excludeVars.size() && vari.toString().compareTo(excludeVars.get(j).toString()) != 0; ++j) {
            }
            if (j < excludeVars.size()) continue;
            modelXML = modelXML + BEGIN_TERM + LinearRegressionEngineNode.xmlQuote((String)varNames.get(i)) + ">\n";
            modelXML = modelXML + TERMVAR_VALUE + LinearRegressionEngineNode.xmlQuote((String)varNames.get(i)) + "/>\n";
            modelXML = modelXML + END_TERM;
        }
        String[] path = new String[2];
        path[0] = "interactions";
        for (int i = 0; i < terms.size(); ++i) {
            path[1] = (String)terms.get(i);
            Vector vars = props.getSubProperties(path);
            if (vars.size() < 1) continue;
            Vector order = props.getSubPropertyValues(path);
            modelXML = modelXML + BEGIN_TERM + LinearRegressionEngineNode.xmlQuote((String)terms.get(i)) + ">\n";
            for (j = 0; j < vars.size(); ++j) {
                int ord = Integer.parseInt((String)order.get(j));
                for (int k = 0; k < ord; ++k) {
                    modelXML = modelXML + TERMVAR_VALUE + LinearRegressionEngineNode.xmlQuote((String)vars.get(j)) + "/>\n";
                }
            }
            modelXML = modelXML + END_TERM;
        }
        modelXML = modelXML + INTERCEPT_VALUE;
        modelXML = props.getBoolean(INCLUDE_INTERCEPT_ATTRIBUTE_TAG, true) ? modelXML + "\"1\"/>\n" : modelXML + "\"0\"/>\n";
        String weights = props.getValue(WEIGHTED_COLUMN_ATTRIBUTE_TAG);
        if (weights.length() > 0 && weights.charAt(0) != ' ') {
            modelXML = modelXML + WEIGHTS_VALUE + LinearRegressionEngineNode.xmlQuote(weights) + "/>\n";
        }
        modelXML = modelXML + END_LINEAR_MODEL;
        return modelXML;
    }

    public boolean isDataCacheProcOutputMetaDataComplete(int outputNum) {
        return true;
    }

    public void setCNKProcProps(CNKProcILM proc1, XTProps props) throws Exception {
        boolean isBDL = this.getNetworkManager() instanceof BDLManager;
        proc1.setThreshold(isBDL ? 0.0 : 0.5);
        proc1.setIncludeCorrelationsIntercept(isBDL);
        proc1.setModel(this.getModelAsString());
    }

    public boolean executeDataCacheProc() throws Exception {
        boolean ok = true;
        String origText = (String)EngineMessageHandler.sendMessageToApp("getStatusText", new Object[0]);
        String str = origText + ": Building model...";
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{str});
        CNKProcILM proc1 = new CNKProcILM();
        this.setCNKProcProps(proc1, null);
        this.printlnVerbose("linear regression: creating model");
        ok = this.getNetworkManager().executeCNKProc(this.getNodeID(), proc1);
        this.procDelete(proc1);
        if (!ok || this.m_modelString == null) {
            return false;
        }
        Vector outputSpecs = this.getOutputSpecs();
        PredictEngineNode.isConflictingIO(outputSpecs, this);
        if (outputSpecs.size() < 1) {
            return ok;
        }
        this.printlnVerbose("linear regression: creating CNKProcGLMFit");
        str = origText + ": Predicting...";
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{str});
        CNKProcGLMFit proc2 = new CNKProcGLMFit();
        this.printlnVerbose("linear regression: calling CNKProcGLMFit.setModel");
        proc2.setModel(this.m_modelString);
        PredictEngineNode.defineOutputsFromSpecs(proc2, outputSpecs);
        this.printlnVerbose("linear regression: predicting from training data.");
        ok = this.getNetworkManager().executeCNKProc(this.getNodeID(), proc2);
        this.procDelete(proc2);
        this.m_modelString = null;
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{origText});
        return ok;
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        if (outputNum == 0) {
            return PredictEngineNode.calculateOutputMetaDataFromOutputSpecs(this.getOutputSpecs());
        }
        return null;
    }

    protected Vector getLmVarNames() {
        XTProps props = this.getNodeProperties();
        XTMetaData md = this.getInputMetaData(0);
        String depVar = this.getDepVar(props, md);
        Vector indepVars = PredictEngineNode.getIndependentVars(props, md);
        Vector<String> allVars = new Vector<String>();
        allVars.add(depVar);
        allVars.addAll(indepVars);
        return allVars;
    }
}

