/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKBlobClassHandler;
import com.insightful.cnkjava.CNKObj;
import com.insightful.controls.SplusWin32Tools;
import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.AppAction;
import com.insightful.miner.BevelArrowIcon;
import com.insightful.miner.ChartBuilder;
import com.insightful.miner.GridDataSource;
import com.insightful.miner.GridViewerComposite;
import com.insightful.miner.GridViewerSorter;
import com.insightful.miner.GuiMessageHandler;
import com.insightful.miner.HtmlFrame;
import com.insightful.miner.InsChartPanel;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MinerFrame;
import com.insightful.miner.MinerPopupMenu;
import com.insightful.miner.ModifiableViewerFrame;
import com.insightful.miner.PrintPreview;
import com.insightful.miner.Retrievable;
import com.insightful.miner.Viewable;
import com.insightful.miner.WideFileChooser;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XMLTreeMetaData;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.graphdlg.GraphDialogSetupProvider;
import com.insightful.miner.graphdlg.GraphMenu;
import com.insightful.miner.tree.gui.ColorBroker;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.SplusWinSessionImpl;
import com.jrefinery.ui.JRefineryUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class NodeViewer
extends ModifiableViewerFrame
implements ActionListener,
Printable,
WindowListener,
GraphDialogSetupProvider {
    private Viewable viewableInterface;
    private JPanel backgroundPanel = new JPanel();
    private GridViewerComposite m_gridViewer;
    private GridDataSource gridData;
    private ContinuousSummaryDataSource contSource;
    private CategoricalSummaryDataSource catSource;
    private StringSummaryDataSource stringSource;
    private DateTimeSummaryDataSource dtSource;
    private BlobSummaryDataSource blobSource;
    private XTMetaData[] metaDataArray;
    private JTabbedPane mainTabPane = new JTabbedPane();
    private JPanel basicInfoPanel = new JPanel();
    private int decimalPlaces = 0;
    private int tableWidth = 390;
    private int tableHeight = 400;
    private int frameExtraWidth = 75;
    private int frameExtraHeight = 92;
    private int nodeId = 0;
    private String dataTabDefaultTitleString = null;
    private int titleStringLength = 0;
    private boolean isInput = false;
    public static Font levelFont = new Font("Courier", 0, 12);
    public int CELL_HEIGHT = GridViewerComposite.CELL_HEIGHT;
    private int lastSelectedIndex = 0;
    private JPopupMenu popup;
    public static final String SHOW_CHARTS_ACTION_COMMAND = "SHOWCHARTS";
    public static final String EXPORT_COUNTS_ACTION_COMMAND = "EXPORTCOUNTS";
    private String title;
    private int currentPort = 0;
    private TabSelectionListener tabListener;
    private JTable contTable;
    private JTable catTable;
    private JTable stringTable;
    private JTable dtTable;
    private JTable blobTable;
    private GridViewerSorter contSorter;
    private GridViewerSorter catSorter;
    private GridViewerSorter stringSorter;
    private GridViewerSorter dtSorter;
    private GridViewerSorter blobSorter;
    private String worksheetID = "";
    private String nodeID = "";
    private int viewerID = 0;
    private String levelText = "";
    private GridBagConstraints dataConstraints = null;
    private Vector displayColumns = null;
    private ChartBuilder chartBuilder = null;
    private String updateTitle = "";
    private Cursor oldCursor = null;
    private Thread updater = null;
    public DefaultTableCellRenderer rightJustifyCellRenderer = null;
    private boolean isStringLeftAligned = false;
    boolean myPrintBegun = false;
    Dimension myPrintDocSize = null;
    Point myPrintDocTopLeft = null;
    Rectangle2D.Double myPrintPageRect = null;
    int myPrintNumPagesAcross = 1;
    int myPrintNumPagesDown = 1;
    double myPrintHorizScale = 1.0;
    double myPrintVertScale = 1.0;
    private int m_hwnd = 0;
    private JMenuBar menuBar = new JMenuBar();
    private JMenu fileMenu = new JMenu();
    private JMenuItem fileMenuExit = new JMenuItem();
    private JMenuItem fileMenuSave = new JMenuItem();
    private JMenuItem fileMenuPrint = new JMenuItem();
    private JMenuItem fileMenuPrintPreview = new JMenuItem();
    private JMenuItem viewMenuOutputSummary = new JMenuItem();
    private JMenu helpMenu = new JMenu();
    private JMenuItem helpMenuUserGuide = new JMenuItem();
    private JMenu editMenu = new JMenu();
    private JMenu viewMenu = new JMenu();
    private JMenuItem viewChartsMenuItem = new JMenuItem();
    private JMenu roundingMenu = new JMenu();
    private JRadioButtonMenuItem menuItem = null;
    private JMenuItem exportCountsMenuItem = null;
    private JMenuItem showChartMenuItem = null;
    public static BevelArrowIcon downIcon = new BevelArrowIcon(1, false, true);
    public static BevelArrowIcon upIcon = new BevelArrowIcon(0, false, true);

    public NodeViewer(String title, int id, Viewable model, XTMetaData[] dataArray, boolean isInp, int initialPortNumber) {
        super(MinerApp.getText(MinerApp.isInBDL() ? "NodeViewer_title_bdl" : "NodeViewer_title") + " " + title);
        this.title = title;
        this.nodeId = id;
        this.metaDataArray = dataArray;
        this.viewableInterface = model;
        this.isInput = isInp;
        this.decimalPlaces = MinerApp.getWorksheetPropertiesManager().getNumDigitsInViewers();
        this.setIconImage(MinerApp.getResourceManager().getImage(MinerApp.isInBDL() ? "app.gif" : "minerapp.gif"));
        this.dataTabDefaultTitleString = MinerApp.getText("NodeViewer_data_tab");
        this.popup = this.createPopupMenu();
        if (this.rightJustifyCellRenderer == null) {
            this.rightJustifyCellRenderer = new DefaultTableCellRenderer();
            this.rightJustifyCellRenderer.setHorizontalAlignment(4);
        }
        this.viewerID = MinerApp.registerNodeViewer(this);
        try {
            this.worksheetID = MinerApp.getCurrentWorksheetID();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.nodeID = Integer.toString(id);
        try {
            this.jbInit();
            this.showPort(initialPortNumber, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setLocation(MinerApp.getNextWindowLocation());
        this.setSize(this.tableWidth + this.frameExtraWidth + 7 * downIcon.getIconWidth(), this.tableHeight + this.frameExtraHeight);
        ActionListener cancelListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NodeViewer.this.exit();
            }
        };
        this.getJMenuBar().registerKeyboardAction(cancelListener, KeyStroke.getKeyStroke("ESCAPE"), 2);
        this.addWindowListener(this);
    }

    private void setStringAlignment(boolean left) {
        this.isStringLeftAligned = left;
        this.m_gridViewer.gridViewerModel.setStringLeftAlignment(this.m_gridViewer.gridViewerTable, this.isStringLeftAligned);
    }

    private void jbInit() throws Exception {
        int numPorts = this.isInput ? this.viewableInterface.getNumInputLinks() : this.viewableInterface.getNumOutputs();
        String filemenu = MinerApp.getText("NodeViewer_fileMenu");
        this.fileMenu.setText(filemenu);
        this.fileMenu.setMnemonic(70);
        String fileexit = MinerApp.getText("NodeViewer_fileExitMenu");
        this.fileMenuExit.setText(fileexit);
        this.fileMenuExit.setMnemonic(88);
        this.fileMenuExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NodeViewer.this.setVisible(false);
                NodeViewer.this.exit();
            }
        });
        String filesave = MinerApp.getText("NodeViewer_fileSaveMenu");
        this.fileMenuSave.setText(filesave);
        this.fileMenuSave.setMnemonic(83);
        this.fileMenuSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.fileMenuSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NodeViewer.this.saveAs(null);
            }
        });
        String fileprint = MinerApp.getText("NodeViewer_filePrintMenu");
        this.fileMenuPrint.setText(fileprint);
        this.fileMenuPrint.setMnemonic(80);
        this.fileMenuPrint.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.fileMenuPrint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NodeViewer.this.print();
            }
        });
        String fileprintpreview = MinerApp.getText("NodeViewer_filePrintPreviewMenu");
        this.fileMenuPrintPreview.setText(fileprintpreview);
        this.fileMenuPrintPreview.setMnemonic(82);
        this.fileMenuPrintPreview.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.fileMenuPrintPreview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NodeViewer.this.printPreview();
            }
        });
        this.viewMenuOutputSummary.setText(MinerApp.getText("NodeViewer_viewOutputSummary"));
        this.viewMenuOutputSummary.setMnemonic(77);
        this.viewMenuOutputSummary.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int numOutputs = NodeViewer.this.metaDataArray.length;
                StringBuffer htmlBuf = new StringBuffer();
                String colInfo = MinerApp.getText("NodeViewer_columnInformation");
                htmlBuf.append("<HTML>\n<TITLE>" + colInfo + ": " + NodeViewer.this.title + " </TITLE>\n<BODY>\n<DIV>\n<H1>\n" + colInfo + ": " + NodeViewer.this.title + "\n</H1>\n</DIV>\n");
                htmlBuf.append("<style type=\"text/css\">" + XMLTree.getCSSText() + "</style>");
                if (numOutputs == 1) {
                    htmlBuf.append(NodeViewer.this.metaDataArray[0].getHtmlString(XMLTree.META_DATA_XSL_FILE));
                } else {
                    String io = (NodeViewer.this.isInput ? MinerApp.getText("NodeViewer_inputText") : MinerApp.getText("NodeViewer_outputText")) + " ";
                    for (int i = 0; i < numOutputs; ++i) {
                        htmlBuf.append("<DIV>\n<H2>\n" + io + (i + 1) + " of " + numOutputs + "\n</H2>\n</DIV>\n");
                        htmlBuf.append(NodeViewer.this.metaDataArray[i].getHtmlString(XMLTree.META_DATA_XSL_FILE));
                    }
                }
                htmlBuf.append("\n</BODY>\n</HTML>");
                new HtmlFrame(htmlBuf.toString());
            }
        });
        this.editMenu.setText(MinerApp.getText("NodeViewer_editMenu"));
        this.editMenu.setMnemonic(69);
        this.editMenu.setEnabled(false);
        String help = MinerApp.getText("NodeViewer_helpMenu");
        this.helpMenu.setText(help);
        this.helpMenu.setMnemonic(72);
        String helpsystem = MinerApp.getText("NodeViewer_helpSystemMenu");
        this.helpMenuUserGuide.setText(helpsystem);
        this.helpMenuUserGuide.setMnemonic(67);
        this.helpMenuUserGuide.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.helpMenuUserGuide.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!MinerApp.isWindowsOS() && MinerApp.isInBDL() && SplusSystem.getEngineQueryHandler() != null) {
                    SplusSystem.getEngineQueryHandler().processDataQuery("help(bd.data.viewer)");
                } else {
                    MinerApp.getHelpManager().showContents();
                    MinerApp.getHelpManager().showTopic("Node_Viewer");
                }
            }
        });
        String viewmenu = MinerApp.getText("NodeViewer_viewMenu");
        this.viewMenu.setText(viewmenu);
        this.viewMenu.setMnemonic(86);
        ButtonGroup group = new ButtonGroup();
        AppAction action = null;
        this.roundingMenu.setText(MinerApp.getText("NodeViewer_roundingMenu"));
        this.roundingMenu.setMnemonic('o');
        action = new AppAction(MinerApp.getText("NodeViewer_no_rounding")){

            public void actionPerformed(ActionEvent e) {
                NodeViewer.this.setRounding(true, -1);
            }
        };
        this.menuItem = new JRadioButtonMenuItem(action);
        this.roundingMenu.add(this.menuItem);
        if (this.decimalPlaces < 0) {
            this.menuItem.setSelected(true);
        }
        group.add(this.menuItem);
        action = new AppAction(MinerApp.getText("NodeViewer_1_decimal_place")){

            public void actionPerformed(ActionEvent e) {
                NodeViewer.this.setRounding(true, 1);
            }
        };
        this.menuItem = new JRadioButtonMenuItem(action);
        this.roundingMenu.add(this.menuItem);
        if (this.decimalPlaces == 1) {
            this.menuItem.setSelected(true);
        }
        group.add(this.menuItem);
        action = new AppAction(MinerApp.getText("NodeViewer_2_decimal_places")){

            public void actionPerformed(ActionEvent e) {
                NodeViewer.this.setRounding(true, 2);
            }
        };
        this.menuItem = new JRadioButtonMenuItem(action);
        if (this.decimalPlaces == 2) {
            this.menuItem.setSelected(true);
        }
        this.roundingMenu.add(this.menuItem);
        group.add(this.menuItem);
        action = new AppAction(MinerApp.getText("NodeViewer_3_decimal_places")){

            public void actionPerformed(ActionEvent e) {
                NodeViewer.this.setRounding(true, 3);
            }
        };
        this.menuItem = new JRadioButtonMenuItem(action);
        this.roundingMenu.add(this.menuItem);
        if (this.decimalPlaces == 3) {
            this.menuItem.setSelected(true);
        }
        group.add(this.menuItem);
        action = new AppAction(MinerApp.getText("NodeViewer_4_decimal_places")){

            public void actionPerformed(ActionEvent e) {
                NodeViewer.this.setRounding(true, 4);
            }
        };
        this.menuItem = new JRadioButtonMenuItem(action);
        this.roundingMenu.add(this.menuItem);
        if (this.decimalPlaces == 4) {
            this.menuItem.setSelected(true);
        }
        group.add(this.menuItem);
        action = new AppAction(MinerApp.getText("NodeViewer_5_decimal_places")){

            public void actionPerformed(ActionEvent e) {
                NodeViewer.this.setRounding(true, 5);
            }
        };
        this.menuItem = new JRadioButtonMenuItem(action);
        this.roundingMenu.add(this.menuItem);
        if (this.decimalPlaces == 5) {
            this.menuItem.setSelected(true);
        }
        group.add(this.menuItem);
        action = new AppAction(MinerApp.getText("NodeViewer_6_decimal_places")){

            public void actionPerformed(ActionEvent e) {
                NodeViewer.this.setRounding(true, 6);
            }
        };
        this.menuItem = new JRadioButtonMenuItem(action);
        this.roundingMenu.add(this.menuItem);
        if (this.decimalPlaces == 6) {
            this.menuItem.setSelected(true);
        }
        group.add(this.menuItem);
        this.roundingMenu.addSeparator();
        ButtonGroup leftRightGroup = new ButtonGroup();
        action = new AppAction(MinerApp.getText("NodeViewer_left_align_text")){

            public void actionPerformed(ActionEvent e) {
                NodeViewer.this.setStringAlignment(true);
            }
        };
        this.menuItem = new JRadioButtonMenuItem(action);
        leftRightGroup.add(this.menuItem);
        this.roundingMenu.add(this.menuItem);
        boolean isleft = MinerApp.getWorksheetPropertiesManager().getStringLeftAlignment();
        if (isleft) {
            this.menuItem.setSelected(true);
        }
        action = new AppAction(MinerApp.getText("NodeViewer_right_align_text")){

            public void actionPerformed(ActionEvent e) {
                NodeViewer.this.setStringAlignment(false);
            }
        };
        this.menuItem = new JRadioButtonMenuItem(action);
        leftRightGroup.add(this.menuItem);
        this.roundingMenu.add(this.menuItem);
        if (!isleft) {
            this.menuItem.setSelected(true);
        }
        ButtonGroup bg = new ButtonGroup();
        for (int i = 0; i < numPorts; ++i) {
            String str = this.viewableInterface.getPortToolTip(this.isInput, i);
            JRadioButtonMenuItem port = new JRadioButtonMenuItem(str, i == 0);
            bg.add(port);
            port.setActionCommand(Integer.toString(i));
            port.addActionListener(new PortListener());
            this.viewMenu.add(port);
        }
        this.fileMenu.add(this.fileMenuSave);
        this.fileMenu.add(this.viewMenuOutputSummary);
        this.fileMenu.add(this.fileMenuPrintPreview);
        this.fileMenu.add(this.fileMenuPrint);
        this.fileMenu.add(this.fileMenuExit);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.viewMenuOutputSummary);
        this.helpMenu.add(this.helpMenuUserGuide);
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.editMenu);
        if (!MinerApp.isInBDL()) {
            this.menuBar.add(this.viewMenu);
        }
        this.menuBar.add(this.roundingMenu);
        GraphMenu graphMenu = new GraphMenu(this);
        String viewcharts = MinerApp.getText("NodeViewer_viewChartsMenu");
        this.viewChartsMenuItem.setText(viewcharts);
        this.viewChartsMenuItem.setEnabled(false);
        this.viewChartsMenuItem.setMnemonic(67);
        this.viewChartsMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.viewChartsMenuItem.setActionCommand(SHOW_CHARTS_ACTION_COMMAND);
        this.viewChartsMenuItem.addActionListener(this);
        graphMenu.insert(this.viewChartsMenuItem, 0);
        graphMenu.insertSeparator(1);
        if (!MinerApp.isInBDL()) {
            this.menuBar.add(graphMenu);
        }
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.getContentPane().add((Component)this.backgroundPanel, "Center");
        this.backgroundPanel.setLayout(new GridBagLayout());
        this.backgroundPanel.setBackground(ColorBroker.getColor("chartLabelBackgroundColor"));
        this.assemblePanels();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        if (MinerApp.isInBDL()) {
            this.exit();
        }
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void show() {
        super.show();
        String title = this.getTitle();
        try {
            if (MinerApp.isInBDL() && MinerApp.isWindowsOS()) {
                this.m_hwnd = SplusWin32Tools.getHwnd((Frame)this);
                SplusWinSessionImpl.setDialogRegister((int)this.m_hwnd, (boolean)true);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setTitle(title);
    }

    public void showPort(int portNum, boolean changeMenuItem) {
        if (changeMenuItem) {
            JMenuItem mi = this.viewMenu.getItem(portNum);
            mi.setSelected(true);
        }
        this.currentPort = portNum;
        this.mainTabPane.removeAll();
        this.mainTabPane.removeChangeListener(this.getTabListener());
        this.backgroundPanel.remove(this.mainTabPane);
        this.backgroundPanel.remove(this.basicInfoPanel);
        this.assemblePanels();
        this.getTabListener().stateChanged(null);
        this.viewChartsMenuItem.setEnabled(false);
        this.showChartMenuItem.setEnabled(false);
        this.repaintViewer();
    }

    private void assemblePanels() {
        this.mainTabPane = this.createTabPane();
        this.basicInfoPanel = this.createBasicInfoPanel(this.currentPort);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(10, 5, 10, 5);
        c.fill = 1;
        c.anchor = 17;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 2;
        this.backgroundPanel.add((Component)this.mainTabPane, c);
        c.gridy = 2;
        c.gridheight = 1;
        c.weighty = 0.0;
        this.backgroundPanel.add((Component)this.basicInfoPanel, c);
    }

    private void setRounding(boolean b, int i) {
        if (this.contSource != null) {
            this.contSource.setRounding(b, i);
        }
        if (this.catSource != null) {
            this.contSource.setRounding(b, i);
        }
        if (this.stringSource != null) {
            this.stringSource.setRounding(b, i);
        }
        if (this.dtSource != null) {
            this.dtSource.setRounding(b, i);
        }
        if (this.gridData != null) {
            this.gridData.setRounding(b, i);
        }
        if (this.m_gridViewer != null) {
            this.m_gridViewer.forceRefresh();
        }
        this.repaint();
    }

    private void setEditMenuItems(GridViewerComposite gvc) {
        if (this.editMenu.getItemCount() > 0) {
            this.editMenu.removeAll();
        }
        JMenuItem item1 = new JMenuItem(gvc.getScrollToCellAction(this));
        item1.setMnemonic('S');
        this.editMenu.add(item1);
        JMenuItem item2 = new JMenuItem(this.m_gridViewer.getSelectAllAction());
        item2.setMnemonic('A');
        this.editMenu.add(item2);
        JMenuItem item3 = new JMenuItem(this.m_gridViewer.getCopyAction());
        item3.setMnemonic('C');
        this.editMenu.add(item3);
        this.editMenu.setEnabled(true);
    }

    private void removeEditMenuItems() {
        this.editMenu.removeAll();
        this.editMenu.setEnabled(false);
    }

    private void setSaveMenuItems(boolean enable) {
        this.fileMenuSave.setEnabled(enable);
    }

    public JTabbedPane createTabPane() {
        JTabbedPane pane = new JTabbedPane();
        JPanel panel = new JPanel();
        panel.setBackground(ColorBroker.getColor("chartLabelBackgroundColor"));
        pane.addTab(MinerApp.getText("NodeViewer_data_tab"), panel);
        JPanel continuousPanel = this.getContinuousPanel();
        pane.addTab(MinerApp.getText(MinerApp.isInBDL() ? "NodeViewer_cont_summary_stats_bdl" : "NodeViewer_cont_summary_stats"), continuousPanel);
        JPanel categoricalPanel = this.getCategoricalPanel();
        pane.addTab(MinerApp.getText(MinerApp.isInBDL() ? "NodeViewer_cat_summary_stats_bdl" : "NodeViewer_cat_summary_stats"), categoricalPanel);
        JPanel stringPanel = this.getStringPanel();
        pane.addTab(MinerApp.getText("NodeViewer_string_summary_stats"), stringPanel);
        JPanel dtPanel = this.getDateTimePanel();
        pane.addTab(MinerApp.getText("NodeViewer_datetime_summary_stats"), dtPanel);
        if (!MinerApp.isInBDL()) {
            JPanel blobPanel = this.getBlobPanel();
            pane.addTab(MinerApp.getText("NodeViewer_other_summary_stats"), blobPanel);
        }
        pane.setSelectedIndex(this.lastSelectedIndex);
        this.tabListener = new TabSelectionListener(pane);
        pane.addChangeListener(this.tabListener);
        return pane;
    }

    private JPanel getContinuousPanel() {
        JPanel continuousPanel = new JPanel();
        continuousPanel.setBackground(ColorBroker.getColor("chartLabelBackgroundColor"));
        continuousPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 0, 0, 0);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.contSource = new ContinuousSummaryDataSource(this.metaDataArray[this.currentPort]);
        if (this.decimalPlaces > 0) {
            this.contSource.setRounding(true, this.decimalPlaces);
        } else {
            this.contSource.setRounding(false);
        }
        this.contSorter = new GridViewerSorter((int)this.contSource.getTotalRows(), this.contSource.getTotalColumns(), this.contSource);
        this.contTable = new JTable(this.contSorter);
        this.contTable.setRowHeight(this.CELL_HEIGHT);
        this.contTable.getTableHeader().setReorderingAllowed(false);
        int columnCount = this.contSorter.getColumnCount();
        block4: for (int i = 0; i < columnCount; ++i) {
            TableColumn column = this.contTable.getColumn(this.contTable.getColumnName(i));
            switch (i) {
                case 0: {
                    column.setPreferredWidth(30 + downIcon.getIconWidth());
                    continue block4;
                }
                case 1: {
                    column.setPreferredWidth(90 + downIcon.getIconWidth());
                    continue block4;
                }
                default: {
                    column.setPreferredWidth(60 + downIcon.getIconWidth());
                    column.setCellRenderer(this.rightJustifyCellRenderer);
                }
            }
        }
        this.contTable.setAutoResizeMode(0);
        this.addMouseListenerToHeaderInTable(this.contTable, this.contSorter);
        this.contTable.setPreferredScrollableViewportSize(new Dimension(300, 300));
        JScrollPane scrollPane = new JScrollPane(this.contTable);
        scrollPane.setViewportBorder(null);
        scrollPane.getViewport().setBackground(ColorBroker.getColor("chartLabelBackgroundColor"));
        continuousPanel.add((Component)scrollPane, c);
        this.contTable.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                NodeViewer.this.updateChartMenuState(NodeViewer.this.contTable, e, false, true);
            }

            public void mouseReleased(MouseEvent e) {
                NodeViewer.this.updateChartMenuState(NodeViewer.this.contTable, e, false, false);
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }
        });
        return continuousPanel;
    }

    public void updateChartMenuState(JTable table, MouseEvent e, boolean categorical, boolean menu) {
        int[] rows = table.getSelectedRows();
        boolean enable = rows != null && rows.length > 0;
        boolean isRunning = this.updater == null ? false : this.updater.isAlive();
        this.viewChartsMenuItem.setEnabled(enable && !isRunning);
        this.showChartMenuItem.setEnabled(enable && !isRunning);
        this.exportCountsMenuItem.setEnabled(categorical && enable);
        if (menu && e.getButton() != 1 && this.popup != null) {
            this.popup.show(table, e.getX(), e.getY());
        }
    }

    private JPanel getCategoricalPanel() {
        JPanel categoricalPanel = new JPanel();
        categoricalPanel.setBackground(ColorBroker.getColor("chartLabelBackgroundColor"));
        categoricalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        JPanel levelPanel = new JPanel(new BorderLayout());
        levelPanel.setBackground(ColorBroker.getColor("chartLabelBackgroundColor"));
        JTextArea levelTextArea = new JTextArea();
        levelTextArea.setEditable(false);
        levelTextArea.setFont(levelFont);
        JScrollPane levelTextScrollPane = new JScrollPane(levelTextArea);
        levelTextScrollPane.setPreferredSize(new Dimension(200, 50));
        levelTextScrollPane.setMaximumSize(new Dimension(200, 50));
        levelTextScrollPane.setMinimumSize(new Dimension(200, 50));
        levelTextScrollPane.setViewportBorder(null);
        JLabel levelLabel = new JLabel(MinerApp.getText("NodeViewer_level_text"));
        levelLabel.setBackground(ColorBroker.getColor("chartLabelBackgroundColor"));
        levelPanel.add((Component)levelLabel, "North");
        levelPanel.add((Component)levelTextScrollPane, "Center");
        categoricalPanel.add((Component)levelPanel, c);
        this.catSource = new CategoricalSummaryDataSource(this.metaDataArray[this.currentPort]);
        if (this.decimalPlaces > 0) {
            this.catSource.setRounding(true, this.decimalPlaces);
        } else {
            this.catSource.setRounding(false);
        }
        this.catSorter = new GridViewerSorter((int)this.catSource.getTotalRows(), this.catSource.getTotalColumns(), this.catSource);
        this.catTable = new JTable(this.catSorter);
        this.catTable.setRowHeight(this.CELL_HEIGHT);
        this.catTable.getTableHeader().setReorderingAllowed(false);
        int columnCount = this.catSorter.getColumnCount();
        block6: for (int i = 0; i < columnCount; ++i) {
            TableColumn column = this.catTable.getColumn(this.catTable.getColumnName(i));
            switch (i) {
                case 0: {
                    column.setPreferredWidth(30 + downIcon.getIconWidth());
                    continue block6;
                }
                case 1: {
                    column.setPreferredWidth(120 + downIcon.getIconWidth());
                    continue block6;
                }
                case 2: {
                    column.setPreferredWidth(80 + downIcon.getIconWidth());
                    column.setCellRenderer(this.rightJustifyCellRenderer);
                    continue block6;
                }
                case 3: {
                    column.setPreferredWidth(120 + downIcon.getIconWidth());
                    column.setCellRenderer(this.rightJustifyCellRenderer);
                    continue block6;
                }
                default: {
                    column.setPreferredWidth(60 + downIcon.getIconWidth());
                    column.setCellRenderer(this.rightJustifyCellRenderer);
                }
            }
        }
        this.catTable.setAutoResizeMode(0);
        this.addMouseListenerToHeaderInTable(this.catTable, this.catSorter);
        ListSelectionModel rowSM = this.catTable.getSelectionModel();
        rowSM.addListSelectionListener(new SummaryListSelectionListener(this.catTable, levelTextArea, this.metaDataArray[this.currentPort]));
        this.catTable.setPreferredScrollableViewportSize(new Dimension(300, 300));
        JScrollPane scrollPane2 = new JScrollPane(this.catTable);
        scrollPane2.getViewport().setBackground(ColorBroker.getColor("chartLabelBackgroundColor"));
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weighty = 1.0;
        c.weightx = 1.0;
        categoricalPanel.add((Component)scrollPane2, c);
        this.catTable.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                NodeViewer.this.updateChartMenuState(NodeViewer.this.catTable, e, true, true);
            }

            public void mouseReleased(MouseEvent e) {
                NodeViewer.this.updateChartMenuState(NodeViewer.this.catTable, e, true, false);
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }
        });
        return categoricalPanel;
    }

    private JPanel getStringPanel() {
        JPanel stringPanel = new JPanel();
        stringPanel.setBackground(ColorBroker.getColor("chartLabelBackgroundColor"));
        stringPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 0, 0, 0);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.stringSource = new StringSummaryDataSource(this.metaDataArray[this.currentPort]);
        if (this.decimalPlaces > 0) {
            this.stringSource.setRounding(true, this.decimalPlaces);
        } else {
            this.stringSource.setRounding(false);
        }
        this.stringSorter = new GridViewerSorter((int)this.stringSource.getTotalRows(), this.stringSource.getTotalColumns(), this.stringSource);
        this.stringTable = new JTable(this.stringSorter);
        this.stringTable.setRowHeight(this.CELL_HEIGHT);
        this.stringTable.getTableHeader().setReorderingAllowed(false);
        int columnCount = this.stringSorter.getColumnCount();
        block4: for (int i = 0; i < columnCount; ++i) {
            TableColumn column = this.stringTable.getColumn(this.stringTable.getColumnName(i));
            switch (i) {
                case 0: {
                    column.setPreferredWidth(30 + downIcon.getIconWidth());
                    continue block4;
                }
                case 1: {
                    column.setPreferredWidth(160 + downIcon.getIconWidth());
                    continue block4;
                }
                default: {
                    column.setPreferredWidth(60 + downIcon.getIconWidth());
                    column.setCellRenderer(this.rightJustifyCellRenderer);
                }
            }
        }
        this.stringTable.setAutoResizeMode(0);
        this.addMouseListenerToHeaderInTable(this.stringTable, this.stringSorter);
        this.stringTable.setPreferredScrollableViewportSize(new Dimension(300, 300));
        JScrollPane stringScrollPane = new JScrollPane(this.stringTable);
        stringScrollPane.setBorder(BorderFactory.createLineBorder(Color.black));
        stringScrollPane.getViewport().setBackground(ColorBroker.getColor("chartLabelBackgroundColor"));
        stringScrollPane.setViewportBorder(null);
        stringPanel.add((Component)stringScrollPane, c);
        return stringPanel;
    }

    private JPanel getDateTimePanel() {
        JPanel dtPanel = new JPanel();
        dtPanel.setBackground(ColorBroker.getColor("chartLabelBackgroundColor"));
        dtPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 0, 0, 0);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.dtSource = new DateTimeSummaryDataSource(this.metaDataArray[this.currentPort]);
        if (this.decimalPlaces > 0) {
            this.dtSource.setRounding(true, this.decimalPlaces);
        } else {
            this.dtSource.setRounding(false);
        }
        this.dtSorter = new GridViewerSorter((int)this.dtSource.getTotalRows(), this.dtSource.getTotalColumns(), this.dtSource);
        this.dtTable = new JTable(this.dtSorter);
        this.dtTable.setRowHeight(this.CELL_HEIGHT);
        this.dtTable.getTableHeader().setReorderingAllowed(false);
        int columnCount = this.dtSorter.getColumnCount();
        block6: for (int i = 0; i < columnCount; ++i) {
            TableColumn column = this.dtTable.getColumn(this.dtTable.getColumnName(i));
            switch (i) {
                case 0: {
                    column.setPreferredWidth(30 + downIcon.getIconWidth());
                    continue block6;
                }
                case 1: {
                    column.setPreferredWidth(110 + downIcon.getIconWidth());
                    continue block6;
                }
                case 2: {
                    column.setPreferredWidth(110 + downIcon.getIconWidth());
                    continue block6;
                }
                case 3: {
                    column.setPreferredWidth(110 + downIcon.getIconWidth());
                    continue block6;
                }
                default: {
                    column.setPreferredWidth(60 + downIcon.getIconWidth());
                    column.setCellRenderer(this.rightJustifyCellRenderer);
                }
            }
        }
        this.dtTable.setAutoResizeMode(0);
        this.addMouseListenerToHeaderInTable(this.dtTable, this.dtSorter);
        this.dtTable.setPreferredScrollableViewportSize(new Dimension(300, 300));
        JScrollPane dtScrollPane = new JScrollPane(this.dtTable);
        dtScrollPane.setBorder(BorderFactory.createLineBorder(Color.black));
        dtScrollPane.getViewport().setBackground(ColorBroker.getColor("chartLabelBackgroundColor"));
        dtScrollPane.setViewportBorder(null);
        dtPanel.add((Component)dtScrollPane, c);
        return dtPanel;
    }

    private JPanel getBlobPanel() {
        JPanel blobPanel = new JPanel();
        blobPanel.setBackground(ColorBroker.getColor("chartLabelBackgroundColor"));
        blobPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 0, 0, 0);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.blobSource = new BlobSummaryDataSource(this.metaDataArray[this.currentPort]);
        if (this.decimalPlaces > 0) {
            this.blobSource.setRounding(true, this.decimalPlaces);
        } else {
            this.blobSource.setRounding(false);
        }
        this.blobSorter = new GridViewerSorter((int)this.blobSource.getTotalRows(), this.blobSource.getTotalColumns(), this.blobSource);
        this.blobTable = new JTable(this.blobSorter);
        this.blobTable.setRowHeight(this.CELL_HEIGHT);
        this.blobTable.getTableHeader().setReorderingAllowed(false);
        int columnCount = this.blobSorter.getColumnCount();
        block6: for (int i = 0; i < columnCount; ++i) {
            TableColumn column = this.blobTable.getColumn(this.blobTable.getColumnName(i));
            switch (i) {
                case 0: {
                    column.setPreferredWidth(30 + downIcon.getIconWidth());
                    continue block6;
                }
                case 1: {
                    column.setPreferredWidth(110 + downIcon.getIconWidth());
                    continue block6;
                }
                case 2: {
                    column.setPreferredWidth(110 + downIcon.getIconWidth());
                    continue block6;
                }
                case 3: {
                    column.setPreferredWidth(110 + downIcon.getIconWidth());
                    continue block6;
                }
                default: {
                    column.setPreferredWidth(60 + downIcon.getIconWidth());
                    column.setCellRenderer(this.rightJustifyCellRenderer);
                }
            }
        }
        this.blobTable.setAutoResizeMode(0);
        this.addMouseListenerToHeaderInTable(this.blobTable, this.blobSorter);
        this.blobTable.setPreferredScrollableViewportSize(new Dimension(300, 300));
        JScrollPane blobScrollPane = new JScrollPane(this.blobTable);
        blobScrollPane.setBorder(BorderFactory.createLineBorder(Color.black));
        blobScrollPane.getViewport().setBackground(ColorBroker.getColor("chartLabelBackgroundColor"));
        blobScrollPane.setViewportBorder(null);
        blobPanel.add((Component)blobScrollPane, c);
        return blobPanel;
    }

    private JPanel createBasicInfoPanel(int portIndex) {
        JPanel basicInfoPanel = new JPanel();
        basicInfoPanel.setBackground(ColorBroker.getColor("chartLabelBackgroundColor"));
        basicInfoPanel.setLayout(new GridLayout(5, 2));
        JLabel outputLabel = new JLabel((this.isInput ? MinerApp.getText("NodeViewer_inputText") + " " : MinerApp.getText("NodeViewer_outputText") + " ") + Integer.toString(this.currentPort + 1));
        JLabel countLabel = new JLabel(MinerApp.getText("NodeViewer_totalNumberRows") + " " + Long.toString(this.metaDataArray[portIndex].getNumRows()));
        JLabel colsLabel = new JLabel(MinerApp.getText("NodeViewer_totalNumberColumns") + " " + Integer.toString(this.metaDataArray[portIndex].getNumColumns()));
        JLabel contLabel = new JLabel((MinerApp.isInBDL() ? MinerApp.getText("NodeViewer_numericColumns") + " " : MinerApp.getText("NodeViewer_continuousColumns") + " ") + Integer.toString(this.metaDataArray[portIndex].getDataFieldsWithType(XMLTreeMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG).size()));
        JLabel catLabel = new JLabel((MinerApp.isInBDL() ? MinerApp.getText("NodeViewer_factorColumns") + " " : MinerApp.getText("NodeViewer_categoricalColumns") + " ") + Integer.toString(this.metaDataArray[portIndex].getDataFieldsWithType(XMLTreeMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG).size()));
        JLabel stringLabel = new JLabel(MinerApp.getText("NodeViewer_stringColumns") + " " + Integer.toString(this.metaDataArray[portIndex].getDataFieldsWithType(XMLTreeMetaData.STRING_TYPE_ATTRIBUTE_TAG).size()));
        JLabel dtLabel = new JLabel(MinerApp.getText("NodeViewer_dateColumns") + " " + Integer.toString(this.metaDataArray[portIndex].getDataFieldsWithType(XMLTreeMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG).size()));
        JLabel blobLabel = new JLabel(MinerApp.getText("NodeViewer_otherColumns") + " " + Integer.toString(this.metaDataArray[portIndex].getDataFieldsWithType(XMLTreeMetaData.BLOB_TYPE_ATTRIBUTE_TAG).size()));
        if (MinerApp.isInBDL()) {
            basicInfoPanel.add(colsLabel);
            basicInfoPanel.add(contLabel);
            basicInfoPanel.add(countLabel);
            basicInfoPanel.add(catLabel);
            basicInfoPanel.add(new JLabel(""));
            basicInfoPanel.add(stringLabel);
            basicInfoPanel.add(new JLabel(""));
            basicInfoPanel.add(dtLabel);
            basicInfoPanel.add(new JLabel(""));
            basicInfoPanel.add(new JLabel(""));
        } else {
            basicInfoPanel.add(outputLabel);
            basicInfoPanel.add(contLabel);
            basicInfoPanel.add(new JLabel(""));
            basicInfoPanel.add(catLabel);
            basicInfoPanel.add(new JLabel(""));
            basicInfoPanel.add(stringLabel);
            basicInfoPanel.add(colsLabel);
            basicInfoPanel.add(dtLabel);
            basicInfoPanel.add(countLabel);
            basicInfoPanel.add(blobLabel);
        }
        JPanel wrapperPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        wrapperPanel.setBackground(ColorBroker.getColor("chartLabelBackgroundColor"));
        wrapperPanel.setBorder(BorderFactory.createEtchedBorder());
        wrapperPanel.add((Component)basicInfoPanel, c);
        return wrapperPanel;
    }

    public void addMouseListenerToHeaderInTable(JTable table, GridViewerSorter tsorter) {
        table.setColumnSelectionAllowed(false);
        ButtonHeaderRenderer renderer = new ButtonHeaderRenderer();
        JTableHeader header = table.getTableHeader();
        header.setDefaultRenderer(renderer);
        header.addMouseListener(new HeaderListener(header, renderer, tsorter));
    }

    private GridViewerComposite getTableData(int portIndex, boolean isInput) {
        if (isInput && this.viewableInterface.getNumInputLinks() <= 0) {
            return null;
        }
        if (!isInput && this.viewableInterface.getNumOutputs() <= 0) {
            return null;
        }
        this.gridData = this.viewableInterface.getDataSource(portIndex, isInput);
        if (this.gridData == null) {
            return null;
        }
        if (this.decimalPlaces > 0) {
            this.gridData.setRounding(true, this.decimalPlaces);
        } else {
            this.gridData.setRounding(false);
        }
        return new GridViewerComposite(this.gridData, this.tableWidth, this.tableHeight);
    }

    private void exit() {
        try {
            MinerApp.removeNodeViewer(this);
            String desiredNodeID = this.viewableInterface.getNodeID(this.isInput, this.currentPort);
            this.sendMessageToEngine(null, "nodeCloseDataViewerFiles", new Object[]{desiredNodeID});
            if (MinerApp.isInBDL() && MinerApp.isWindowsOS()) {
                SplusWinSessionImpl.setDialogRegister((int)this.m_hwnd, (boolean)false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.dispose();
    }

    private Object sendMessageToEngine(String msg, Object[] args) {
        String desiredNodeID = this.viewableInterface.getNodeID(this.isInput, this.currentPort);
        return this.sendMessageToEngine(desiredNodeID, msg, args);
    }

    private Object sendMessageToEngine(String nodeID, String msg, Object[] args) {
        try {
            return GuiMessageHandler.sendMessageToEngine(MinerApp.getCurrentWorksheetID(this.viewableInterface.getWorksheetDocument()), nodeID, msg, args);
        }
        catch (Exception e) {
            AcceleratorOptionPane.showOKDialog(null, e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    protected JPopupMenu createPopupMenu() {
        MinerPopupMenu result = new MinerPopupMenu();
        this.showChartMenuItem = new JMenuItem(MinerApp.getText("NodeViewer_viewChartsMenu"));
        this.showChartMenuItem.setActionCommand(SHOW_CHARTS_ACTION_COMMAND);
        this.showChartMenuItem.setEnabled(false);
        this.showChartMenuItem.addActionListener(this);
        result.add(this.showChartMenuItem);
        this.exportCountsMenuItem = new JMenuItem(MinerApp.getText("NodeViewer_exportFrequencyMenu"));
        this.exportCountsMenuItem.setActionCommand(EXPORT_COUNTS_ACTION_COMMAND);
        this.exportCountsMenuItem.addActionListener(this);
        this.exportCountsMenuItem.setEnabled(false);
        result.add(this.exportCountsMenuItem);
        return result;
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals(EXPORT_COUNTS_ACTION_COMMAND)) {
            this.saveAs(this.levelText);
        } else if (command.equals(SHOW_CHARTS_ACTION_COMMAND)) {
            int tab = this.mainTabPane.getSelectedIndex();
            GridViewerSorter sorter = null;
            int[] rows = null;
            if (this.displayColumns == null) {
                this.displayColumns = new Vector();
            } else {
                this.displayColumns.removeAllElements();
            }
            switch (tab) {
                case 1: {
                    rows = this.contTable.getSelectedRows();
                    sorter = this.contSorter;
                    break;
                }
                case 2: {
                    rows = this.catTable.getSelectedRows();
                    sorter = this.catSorter;
                    break;
                }
                case 3: {
                    rows = this.stringTable.getSelectedRows();
                    sorter = this.stringSorter;
                    break;
                }
                case 4: {
                    rows = this.dtTable.getSelectedRows();
                    sorter = this.dtSorter;
                    break;
                }
            }
            if (rows == null || rows.length == 0) {
                return;
            }
            for (int i = 0; i < rows.length; ++i) {
                this.displayColumns.add(sorter.getValueAt(rows[i], 1));
            }
            this.oldCursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.updater = new Thread(){

                public void run() {
                    NodeViewer.this.chartBuilder = new ChartBuilder(NodeViewer.this.metaDataArray[NodeViewer.this.currentPort], null);
                    String desiredNodeID = NodeViewer.this.viewableInterface.getNodeID(NodeViewer.this.isInput, NodeViewer.this.currentPort);
                    Object[] args = new Object[]{desiredNodeID, NodeViewer.this.displayColumns, new Integer(NodeViewer.this.currentPort), new Boolean(NodeViewer.this.isInput), new Integer(NodeViewer.this.viewerID), new Long(100L), NodeViewer.this.title, NodeViewer.this.chartBuilder};
                    GuiMessageHandler.sendMessageToEngine(NodeViewer.this.worksheetID, null, "getNodeDataViewerChartStats", args);
                }
            };
            this.updater.start();
        }
    }

    public void resetCursor() {
        this.setCursor(this.oldCursor);
    }

    private void showChart(InsChartPanel chartPanel) {
        ModifiableViewerFrame chartFrame = new ModifiableViewerFrame();
        chartFrame.setTitle(MinerApp.getText("NodeViewer_dist_charts"));
        chartFrame.setIconImage(MinerApp.getResourceManager().getImage("minerapp.gif"));
        chartFrame.getContentPane().add((Component)((Object)chartPanel));
        chartFrame.setSize(200, 200);
        JRefineryUtilities.positionFrameRandomly((JFrame)chartFrame);
        chartFrame.show();
    }

    private void setLastSelectedIndex(int i) {
        this.lastSelectedIndex = i;
    }

    public TabSelectionListener getTabListener() {
        return this.tabListener;
    }

    private void enableMenuItems(int i) {
        JTable table = this.getTable(i);
        if (table == null) {
            return;
        }
        if (table.getSelectedRows() == null || table.getSelectedRows().length == 0) {
            this.viewChartsMenuItem.setEnabled(false);
            this.showChartMenuItem.setEnabled(false);
        } else {
            this.viewChartsMenuItem.setEnabled(true);
            this.showChartMenuItem.setEnabled(true);
        }
        this.exportCountsMenuItem.setEnabled(false);
    }

    public JTable getTable(int i) {
        JTable table = null;
        switch (i) {
            case 1: {
                table = this.contTable;
                break;
            }
            case 2: {
                table = this.catTable;
                break;
            }
            case 3: {
                table = this.stringTable;
                break;
            }
            case 4: {
                table = this.dtTable;
                break;
            }
        }
        return table;
    }

    public void repaintViewer() {
        this.mainTabPane.invalidate();
        this.mainTabPane.repaint();
        this.repaint();
    }

    private void saveAs(String text) {
        File file = null;
        WideFileChooser fc = new WideFileChooser(MinerApp.getSprimeHome());
        fc.setDialogTitle(MinerApp.getText("NodeViewer_saveAsDialogTitle"));
        fc.addChoosableFileFilter(new AsciFileFilter());
        int fcresult = fc.showSaveDialog(this);
        if (fcresult == 1) {
            return;
        }
        file = fc.getSelectedFile();
        String name = file.getName();
        if (name == null || name.length() <= 4 || !".txt".equals(name.substring(name.length() - 4, name.length()))) {
            file = new File(file.getAbsolutePath() + ".txt");
        }
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw, 4096);
            PrintWriter pw = new PrintWriter((Writer)bw, true);
            if (text == null) {
                String output = "";
                JTable table = this.getTable(this.mainTabPane.getSelectedIndex());
                for (int i = 0; i < table.getModel().getRowCount(); ++i) {
                    for (int j = 0; j < table.getModel().getColumnCount(); ++j) {
                        output = output + (String)table.getValueAt(i, j);
                        if (j >= table.getModel().getColumnCount() - 1) continue;
                        output = output + ", ";
                    }
                    output = output + "\n";
                }
                pw.write(output);
            } else {
                pw.write(text);
            }
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public NodeViewer getNodeViewer() {
        return this;
    }

    private void printPreview() {
        Thread runner = new Thread(){

            public void run() {
                MinerFrame frame = MinerApp.getMainFrame();
                if (frame == null) {
                    new PrintPreview(NodeViewer.this.getNodeViewer(), NodeViewer.this.getNodeViewer().mainTabPane);
                } else {
                    Component comp = frame.getGlassPane();
                    Cursor oldCursor = comp.getCursor();
                    comp.setCursor(Cursor.getPredefinedCursor(3));
                    comp.setVisible(true);
                    new PrintPreview(NodeViewer.this.getNodeViewer(), NodeViewer.this.getNodeViewer().mainTabPane);
                    comp.setCursor(oldCursor);
                    comp.setVisible(false);
                }
            }
        };
        runner.start();
    }

    public void print() {
        PrintThread thrd = new PrintThread(this);
        thrd.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int print(Graphics g, PageFormat pf, int pnum) {
        Point myOrigin = new Point();
        Graphics2D g2 = (Graphics2D)g;
        if (!this.myPrintBegun) {
            this.myPrintBegun = true;
            this.myPrintDocTopLeft = new Point((int)this.getAlignmentX(), (int)this.getAlignmentY());
            this.myPrintDocSize = this.getSize();
            int docWidth = this.myPrintDocSize.width;
            int docHeight = this.myPrintDocSize.height;
            this.myPrintPageRect = new Rectangle2D.Double(pf.getImageableX(), pf.getImageableY(), pf.getImageableWidth(), pf.getImageableHeight());
            double pageWidth = this.myPrintPageRect.width;
            double pageHeight = this.myPrintPageRect.height;
            this.myPrintVertScale = this.myPrintHorizScale = this.myPrintPageRect.width / (double)this.myPrintDocSize.width;
            this.myPrintNumPagesAcross = (int)Math.ceil((double)docWidth * this.myPrintHorizScale / pageWidth);
            this.myPrintNumPagesDown = (int)Math.ceil((double)docHeight * this.myPrintVertScale / pageHeight);
        }
        double pageX = this.myPrintPageRect.x;
        double pageY = this.myPrintPageRect.y;
        double pageWidth = this.myPrintPageRect.width;
        double pageHeight = this.myPrintPageRect.height;
        if (pnum >= this.myPrintNumPagesAcross * this.myPrintNumPagesDown) {
            this.myPrintBegun = false;
            return 1;
        }
        int hpnum = pnum % this.myPrintNumPagesAcross;
        int vpnum = pnum / this.myPrintNumPagesAcross;
        myOrigin = new Point((int)(((double)this.myPrintDocTopLeft.x + (double)hpnum * pageWidth) / this.myPrintHorizScale), (int)(((double)this.myPrintDocTopLeft.y + (double)vpnum * pageHeight) / this.myPrintVertScale));
        g2.clip(this.myPrintPageRect);
        Rectangle clipRect = new Rectangle();
        g2.getClipBounds(clipRect);
        clipRect.x -= (int)pageX;
        clipRect.y -= (int)pageY;
        clipRect.x = (int)((double)clipRect.x / this.myPrintHorizScale) + myOrigin.x;
        clipRect.y = (int)((double)clipRect.y / this.myPrintVertScale) + myOrigin.y;
        clipRect.width = (int)Math.ceil((double)clipRect.width / this.myPrintHorizScale);
        clipRect.height = (int)Math.ceil((double)clipRect.height / this.myPrintVertScale);
        g2.translate(pageX, pageY);
        g2.translate(-myOrigin.x, -myOrigin.y);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.paint(g2);
        return 0;
    }

    public Frame getParentFrame() {
        return this;
    }

    public Viewable getNodeModel() {
        return this.viewableInterface;
    }

    public int getPortNumber() {
        return this.currentPort;
    }

    public boolean isInputPort() {
        return this.isInput;
    }

    public class AsciFileFilter
    extends FileFilter {
        public static final String FILTER_DESCRIPTION = "ASCII Text (*.txt)";
        public static final String FILTER_EXTENSION = ".txt";

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(FILTER_EXTENSION);
        }

        public String getDescription() {
            return FILTER_DESCRIPTION;
        }
    }

    public class BlobSummaryDataSource
    extends ContinuousSummaryDataSource {
        public BlobSummaryDataSource(XTMetaData metaData) {
            super(metaData);
        }

        protected String[] getColumns() {
            return new String[]{"#", MinerApp.getText("NodeViewer_variable"), MinerApp.getText("NodeViewer_type"), MinerApp.getText("NodeViewer_missing")};
        }

        protected boolean isInteger(int i) {
            boolean[] s = new boolean[]{true, false, false, true};
            if (i >= s.length) {
                return false;
            }
            return s[i];
        }

        protected Vector getSelectedVars() {
            return this.metaData.getDataFieldsWithType(XMLTreeMetaData.BLOB_TYPE_ATTRIBUTE_TAG);
        }

        protected void setData(XTMetaData metaData, Vector cols) {
            for (int i = 0; i < this.m_rowCount; ++i) {
                String s = (String)cols.elementAt(i);
                this.data[i * this.m_colCount + 0] = Integer.toString(metaData.nameToOrdinal(s) + 1);
                this.data[i * this.m_colCount + 1] = s;
                this.data[i * this.m_colCount + 2] = CNKBlobClassHandler.getDisplayClassName(metaData.getBlobDataFieldClassName(s));
                this.data[i * this.m_colCount + 3] = Integer.toString((int)metaData.getColumnMissingCount(s));
            }
        }
    }

    public class DateTimeSummaryDataSource
    extends ContinuousSummaryDataSource {
        public DateTimeSummaryDataSource(XTMetaData metaData) {
            super(metaData);
        }

        protected String[] getColumns() {
            return new String[]{"#", MinerApp.getText("NodeViewer_variable"), MinerApp.getText("NodeViewer_min"), MinerApp.getText("NodeViewer_max"), MinerApp.getText("NodeViewer_missing")};
        }

        protected boolean isInteger(int i) {
            boolean[] s = new boolean[]{true, false, false, false, true};
            if (i >= s.length) {
                return false;
            }
            return s[i];
        }

        protected Vector getSelectedVars() {
            return this.metaData.getDataFieldsWithType(XMLTreeMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG);
        }

        protected void setData(XTMetaData metaData, Vector cols) {
            double julianEpoch = (double)CNKObj.getDoubleDateEpoch() / 8.64E7;
            for (int i = 0; i < this.m_rowCount; ++i) {
                String s = (String)cols.elementAt(i);
                this.data[i * this.m_colCount + 0] = Integer.toString(metaData.nameToOrdinal(s) + 1);
                this.data[i * this.m_colCount + 1] = s;
                double minDate = metaData.getColumnMin(s);
                double maxDate = metaData.getColumnMax(s);
                if (!CNKObj.isDoubleNA(minDate)) {
                    minDate += julianEpoch;
                }
                if (!CNKObj.isDoubleNA(maxDate)) {
                    maxDate += julianEpoch;
                }
                this.data[i * this.m_colCount + 2] = MinerApp.getWorksheetPropertiesManager().getDateFormatter().convertJulianDateToString(minDate);
                this.data[i * this.m_colCount + 3] = MinerApp.getWorksheetPropertiesManager().getDateFormatter().convertJulianDateToString(maxDate);
                this.data[i * this.m_colCount + 4] = Integer.toString((int)metaData.getColumnMissingCount(s));
            }
        }
    }

    public class StringSummaryDataSource
    extends ContinuousSummaryDataSource {
        public StringSummaryDataSource(XTMetaData metaData) {
            super(metaData);
        }

        protected String[] getColumns() {
            return new String[]{"#", MinerApp.getText("NodeViewer_variable"), MinerApp.getText("NodeViewer_length"), MinerApp.getText("NodeViewer_missing")};
        }

        protected boolean isInteger(int i) {
            boolean[] s = new boolean[]{true, false, true, true};
            if (i >= s.length) {
                return false;
            }
            return s[i];
        }

        protected Vector getSelectedVars() {
            return this.metaData.getDataFieldsWithType(XMLTreeMetaData.STRING_TYPE_ATTRIBUTE_TAG);
        }

        protected void setData(XTMetaData metaData, Vector cols) {
            for (int i = 0; i < this.m_rowCount; ++i) {
                String s = (String)cols.elementAt(i);
                int width = metaData.getStringDataFieldWidth(s) - 1;
                this.data[i * this.m_colCount + 0] = Integer.toString(metaData.nameToOrdinal(s) + 1);
                this.data[i * this.m_colCount + 1] = s;
                this.data[i * this.m_colCount + 2] = Integer.toString(width);
                this.data[i * this.m_colCount + 3] = Integer.toString((int)metaData.getColumnMissingCount(s));
            }
        }
    }

    public class CategoricalSummaryDataSource
    extends ContinuousSummaryDataSource {
        public CategoricalSummaryDataSource(XTMetaData metaData) {
            super(metaData);
        }

        protected String[] getColumns() {
            return new String[]{"#", MinerApp.getText("NodeViewer_variable"), MinerApp.getText("NodeViewer_numberLevels"), MinerApp.getText("NodeViewer_mostFreqLevel"), MinerApp.getText("NodeViewer_missing")};
        }

        protected boolean isInteger(int i) {
            boolean[] s = new boolean[]{true, false, true, false, true};
            if (i >= s.length) {
                return false;
            }
            return s[i];
        }

        protected Vector getSelectedVars() {
            return this.metaData.getDataFieldsWithType(XMLTreeMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG);
        }

        protected void setData(XTMetaData metaData, Vector cols) {
            for (int i = 0; i < this.m_rowCount; ++i) {
                String s = (String)cols.elementAt(i);
                Vector v = metaData.getCategoricalDataFieldLevels(s);
                String biggestLevel = "";
                int levelMax = 0;
                for (int j = 0; j < v.size(); ++j) {
                    int levelcount = Integer.parseInt(metaData.getLevelCount(s, (String)v.elementAt(j)));
                    if (levelMax >= levelcount) continue;
                    levelMax = levelcount;
                    int percent = (int)Math.floor((double)levelMax / (double)metaData.getNumRows() * 100.0);
                    biggestLevel = (String)v.elementAt(j) + "  (" + Integer.toString(percent) + " %)";
                }
                this.data[i * this.m_colCount + 0] = Integer.toString(metaData.nameToOrdinal(s) + 1);
                this.data[i * this.m_colCount + 1] = s;
                this.data[i * this.m_colCount + 2] = v.size() == 0 ? "" : Integer.toString(v.size());
                this.data[i * this.m_colCount + 3] = biggestLevel;
                this.data[i * this.m_colCount + 4] = Integer.toString((int)metaData.getColumnMissingCount(s));
            }
        }
    }

    public class ContinuousSummaryDataSource
    implements Retrievable {
        protected int m_rowCount;
        protected int m_colCount;
        protected Vector m_varNames = null;
        protected XTMetaData metaData;
        protected String[] columnNames;
        protected String[] data;
        private boolean m_rounding = true;
        private DecimalFormat m_decimalFormat = new DecimalFormat();
        private DecimalFormat m_scientificFormat = new DecimalFormat();
        private int m_formatDecimalPlaces = -1;
        private double m_scientificMaxBound = 9.99999999E8;
        private double m_scientificMinBound = 1.0E-4;

        public ContinuousSummaryDataSource(XTMetaData xmetaData) {
            this.metaData = xmetaData;
            this.columnNames = this.getColumns();
            this.m_colCount = this.columnNames.length;
            this.m_varNames = this.getSelectedVars();
            this.m_rowCount = this.m_varNames.size();
            this.data = new String[this.m_colCount * this.m_rowCount];
            this.setData(this.metaData, this.m_varNames);
        }

        protected String[] getColumns() {
            return new String[]{"#", MinerApp.getText("NodeViewer_variable"), MinerApp.getText("NodeViewer_mean"), MinerApp.getText("NodeViewer_min"), MinerApp.getText("NodeViewer_max"), MinerApp.getText("NodeViewer_stDev"), MinerApp.getText("NodeViewer_missing")};
        }

        protected boolean isInteger(int i) {
            boolean[] s = new boolean[]{true, false, false, false, false, false, true};
            if (i >= s.length) {
                return false;
            }
            return s[i];
        }

        protected Vector getSelectedVars() {
            return this.metaData.getDataFieldsWithType(XMLTreeMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG);
        }

        protected void setData(XTMetaData metaData, Vector cols) {
            for (int i = 0; i < this.m_rowCount; ++i) {
                String s = (String)cols.elementAt(i);
                this.data[i * this.m_colCount + 0] = Integer.toString(metaData.nameToOrdinal(s) + 1);
                this.data[i * this.m_colCount + 1] = s;
                this.data[i * this.m_colCount + 2] = Double.isNaN(metaData.getColumnMean(s)) ? "" : Double.toString(metaData.getColumnMean(s));
                this.data[i * this.m_colCount + 3] = Double.isNaN(metaData.getColumnMin(s)) ? "" : Double.toString(metaData.getColumnMin(s));
                this.data[i * this.m_colCount + 4] = Double.isNaN(metaData.getColumnMax(s)) ? "" : Double.toString(metaData.getColumnMax(s));
                this.data[i * this.m_colCount + 5] = Double.isNaN(metaData.getColumnStandardDeviation(s)) ? "" : Double.toString(metaData.getColumnStandardDeviation(s));
                this.data[i * this.m_colCount + 6] = Integer.toString((int)metaData.getColumnMissingCount(s));
            }
        }

        public void setRounding(boolean rounding) {
            this.m_rounding = rounding;
        }

        public boolean isRounding() {
            return this.m_rounding;
        }

        public void setRounding(boolean rounding, int decimalPlaces) {
            this.m_rounding = rounding;
            if (this.m_rounding) {
                this.m_formatDecimalPlaces = decimalPlaces;
                MinerApp.getWorksheetPropertiesManager().initViewerRoundingObject(this.m_decimalFormat, decimalPlaces);
                if (decimalPlaces < 0) {
                    this.m_scientificFormat.setDecimalFormatSymbols(MinerApp.getWorksheetPropertiesManager().getDecimalFormatSymbols());
                    this.m_scientificFormat.applyPattern("0.0##################E0");
                    this.m_scientificMinBound = 1.0E-4;
                } else {
                    MinerApp.getWorksheetPropertiesManager().initViewerScientificRoundingObject(this.m_scientificFormat, decimalPlaces);
                    this.m_scientificMinBound = Math.pow(10.0, -this.m_formatDecimalPlaces);
                }
            }
        }

        public Object getData(long row, int column) {
            if (this.data.length == 0) {
                return "";
            }
            String ret = this.data[column + (int)row * this.m_colCount];
            if (column == 0) {
                return ret;
            }
            if (this.m_rounding && !this.isInteger(column)) {
                try {
                    double full = Double.parseDouble(ret);
                    double absFull = Math.abs(full);
                    ret = absFull > this.m_scientificMaxBound || absFull > 0.0 && absFull < this.m_scientificMinBound ? this.m_scientificFormat.format(full) : this.m_decimalFormat.format(full);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            return ret;
        }

        public String getRowLabel(long rowNum) {
            return (String)this.m_varNames.get((int)rowNum);
        }

        public int getRowLabelWidth() {
            int maxSize = 0;
            int tmp = 0;
            for (int i = this.m_varNames.size() - 1; i >= 0; --i) {
                tmp = ((String)this.m_varNames.get(i)).length();
                if (tmp <= maxSize) continue;
                maxSize = tmp;
            }
            return maxSize > 5 ? maxSize * 9 : 50;
        }

        public void updateWindowPosition(long neededRowOrigin, int neededNumRows, int neededColOrigin, int neededNumCols) {
        }

        public long getTotalRows() {
            return this.m_rowCount;
        }

        public int getTotalColumns() {
            return this.m_colCount;
        }

        public String getColumnType(int colNum) {
            return "continuous";
        }

        public String getColumnDisplayType(int numCol) {
            return "continuous";
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        public boolean isSortable() {
            return true;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public int getColumnWidth(int colNum) {
            return 100;
        }
    }

    class ButtonHeaderRenderer
    extends JButton
    implements TableCellRenderer {
        private boolean ascending;
        private int ascendingColumn = -1;
        private int pushedColumn = -1;

        public ButtonHeaderRenderer() {
            this.setMargin(new Insets(0, 0, 0, 0));
            this.ascending = true;
        }

        public void toggleAscending(int column) {
            if (column == this.ascendingColumn) {
                this.ascending = !this.ascending;
            } else {
                this.ascendingColumn = column;
                this.ascending = false;
            }
        }

        public boolean getAscending() {
            return this.ascending;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setHorizontalAlignment(4);
            String valueStr = value == null ? "" : value.toString();
            this.setText(valueStr);
            boolean isPressed = column == this.pushedColumn;
            this.getModel().setPressed(isPressed);
            this.getModel().setArmed(isPressed);
            if (this.ascendingColumn == column) {
                if (this.ascending) {
                    this.setIcon(upIcon);
                } else {
                    this.setIcon(downIcon);
                }
            } else {
                this.setIcon(null);
            }
            return this;
        }

        public void setPressedColumn(int col) {
            this.pushedColumn = col;
        }
    }

    class HeaderListener
    extends MouseAdapter {
        private JTableHeader header;
        private ButtonHeaderRenderer renderer;
        private GridViewerSorter sorter;

        HeaderListener(JTableHeader header, ButtonHeaderRenderer renderer, GridViewerSorter sorter) {
            this.header = header;
            this.renderer = renderer;
            this.sorter = sorter;
        }

        public void mousePressed(MouseEvent e) {
            if (this.header.getResizingColumn() != null) {
                return;
            }
            int col = this.header.columnAtPoint(e.getPoint());
            this.renderer.setPressedColumn(col);
            this.header.repaint();
            int column = this.header.getTable().convertColumnIndexToModel(col);
            if (column != -1) {
                this.renderer.toggleAscending(column);
                this.sorter.sortByColumn(column, this.renderer.getAscending());
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.renderer.setPressedColumn(-1);
            this.header.repaint();
        }
    }

    public class DataViewPanel
    extends JPanel {
        public DataViewPanel(JPanel panel) {
            this.setBackground(ColorBroker.getColor("chartLabelBackgroundColor"));
            this.setLayout(new BorderLayout());
            JPanel gridViewPanel = panel != null ? panel : new JPanel();
            gridViewPanel.setBackground(ColorBroker.getColor("chartLabelBackgroundColor"));
            this.add((Component)gridViewPanel, "Center");
        }
    }

    public class PortListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            NodeViewer.this.showPort(Integer.parseInt(e.getActionCommand()), false);
        }
    }

    public class SummaryListSelectionListener
    implements ListSelectionListener {
        JTable table;
        JTextArea textArea;
        XTMetaData metaData;

        public SummaryListSelectionListener(JTable t, JTextArea ta, XTMetaData xtm) {
            this.table = t;
            this.textArea = ta;
            this.metaData = xtm;
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                if (lsm.getMaxSelectionIndex() != lsm.getMinSelectionIndex()) {
                    this.textArea.setText("");
                } else {
                    int selectedRow = lsm.getMinSelectionIndex();
                    String col = (String)this.table.getModel().getValueAt(selectedRow, 1);
                    NodeViewer.this.levelText = this.getLevelText(col);
                    this.textArea.setText(NodeViewer.this.levelText);
                    this.textArea.setCaretPosition(0);
                }
            }
        }

        public String getLevelText(String col) {
            Vector v = this.metaData.getCategoricalDataFieldLevels(col);
            String text = "";
            for (int i = 0; i < v.size(); ++i) {
                String numRows = this.metaData.getLevelCount(col, (String)v.elementAt(i));
                text = text + (String)v.elementAt(i) + ": " + numRows + "\n";
            }
            return text;
        }
    }

    public class TabSelectionListener
    implements ChangeListener {
        private JTabbedPane mainTabPane;

        public TabSelectionListener(JTabbedPane pane) {
            this.mainTabPane = pane;
        }

        public void stateChanged(ChangeEvent e) {
            int i = this.mainTabPane.getSelectedIndex();
            NodeViewer.this.enableMenuItems(i);
            if (i < 0) {
                return;
            }
            String title = this.mainTabPane.getTitleAt(i);
            if (NodeViewer.this.dataTabDefaultTitleString.equals(title)) {
                NodeViewer.this.m_gridViewer = NodeViewer.this.getTableData(NodeViewer.this.currentPort, NodeViewer.this.isInput);
                if (NodeViewer.this.m_gridViewer != null) {
                    boolean isleft = MinerApp.getWorksheetPropertiesManager().getStringLeftAlignment();
                    NodeViewer.this.setStringAlignment(isleft);
                    JPanel panel = (JPanel)this.mainTabPane.getSelectedComponent();
                    panel.setLayout(new GridBagLayout());
                    NodeViewer.this.dataConstraints = new GridBagConstraints();
                    ((NodeViewer)NodeViewer.this).dataConstraints.insets = new Insets(5, 0, 0, 0);
                    ((NodeViewer)NodeViewer.this).dataConstraints.fill = 1;
                    ((NodeViewer)NodeViewer.this).dataConstraints.weightx = 1.0;
                    ((NodeViewer)NodeViewer.this).dataConstraints.weighty = 1.0;
                    panel.add((Component)new DataViewPanel(NodeViewer.this.m_gridViewer), NodeViewer.this.dataConstraints);
                    NodeViewer.this.setEditMenuItems(NodeViewer.this.m_gridViewer);
                } else {
                    JPanel panel = (JPanel)this.mainTabPane.getSelectedComponent();
                    panel.setLayout(new BorderLayout());
                    panel.setSize(NodeViewer.this.tableWidth - 10, NodeViewer.this.tableHeight - 1);
                    String port = (NodeViewer.this.isInput ? "Input " : "Output ") + Integer.toString(NodeViewer.this.currentPort + 1) + ": ";
                    JLabel label = new JLabel(port + MinerApp.getText("NodeViewer_noOutputMessage"));
                    label.setForeground(Color.red);
                    panel.add((Component)label, "North");
                }
                NodeViewer.this.setSaveMenuItems(false);
            } else {
                NodeViewer.this.removeEditMenuItems();
                NodeViewer.this.setSaveMenuItems(true);
            }
            NodeViewer.this.setLastSelectedIndex(this.mainTabPane.getSelectedIndex());
        }
    }

    protected class PrintThread
    extends Thread {
        private NodeViewer m_ui;

        public PrintThread(NodeViewer ui) {
            this.m_ui = ui;
        }

        public void run() {
            PrinterJob pj = PrinterJob.getPrinterJob();
            if (pj.printDialog(MinerApp.getPrintAttributeSet())) {
                PageFormat pf = pj.validatePage(MinerApp.getDefaultPageFormat());
                Paper paper = pf.getPaper();
                double margin = 36.0;
                paper.setImageableArea(margin, margin, paper.getWidth() - margin * 2.0, paper.getHeight() - margin * 2.0);
                pf.setPaper(paper);
                pj.setPrintable(this.m_ui, pf);
                new MinerApp.GenericPrintThread(pj).start();
            }
            if (MinerApp.getMainFrame() != null) {
                MinerApp.getMainFrame().requestFocus();
            }
            this.m_ui.requestFocus();
        }
    }
}

