/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.HtmlFrame;
import com.insightful.miner.PredictableNodeModel;
import com.insightful.miner.PrincipalComponentDialog;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.Frame;
import java.util.Vector;

public class PrincipalComponentNodeModel
extends PredictableNodeModel {
    public void showPropertiesDialog(boolean modality) {
        PrincipalComponentDialog dialog = PrincipalComponentDialog.getInstance();
        dialog.setModal(modality);
        dialog.show(this);
    }

    public String getModelOutputType() {
        return "dimensionReduction";
    }

    public String getModelAlgorithm() {
        return "principleComponent";
    }

    public boolean isPropertiesValid() {
        XTProps props = this.getXTProps();
        Vector display = props.getSubProperties("featureVariables");
        try {
            if (this.isInputValid()) {
                XTMetaData md = this.getInputMetaData(0);
                for (int i = display.size() - 1; i >= 0; --i) {
                    if (md.nameToOrdinal((String)display.get(i)) != -1) continue;
                    return false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return display.size() != 0;
    }

    public void showView(Frame frame) {
        try {
            XMLTree xt = this.getFittedModel();
            if (xt != null) {
                String htmlString = xt.getHtmlString(XMLTree.PRINCIPLE_COMPONENTS_XSL_FILE, this.getLabelText());
                new HtmlFrame(htmlString);
            } else {
                super.showView(frame);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

