/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcFile;
import com.insightful.miner.FixedFormatDictionary;
import com.insightful.miner.ReadTextFileEngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Vector;

public class ReadFixedFormatFileEngineNode
extends ReadTextFileEngineNode {
    public void procSetProperties(CNKProc proc, XTProps props) throws Exception {
        CNKProcFile fProc = (CNKProcFile)proc;
        String absPath = this.getNetworkManager().getAbsolutePath(props.getValue("filePath", ""));
        if (absPath == null || absPath.length() == 0) {
            throw new Exception("empty filename");
        }
        if (!new File(absPath).exists()) {
            throw new Exception("file not found");
        }
        fProc.setFileName(absPath);
        fProc.setFileType("FASCII");
        fProc.setVnames(0);
        FixedFormatDictionary ffd = null;
        if (this.hasBDLProps(props)) {
            String format = props.getValue("format", "");
            if (format.length() < 1) {
                throw new Exception("empty format");
            }
            ffd = FixedFormatDictionary.createFixedFormatDictionaryFromSplusFormatString(format);
        } else {
            ffd = this.getDataDictionary(props);
        }
        int maxColumnUsed = this.storeFixedFormatDict(fProc, ffd) + 10;
        if (maxColumnUsed < 32768) {
            maxColumnUsed = 32768;
        }
        fProc.setTxtMaxLineWidth(maxColumnUsed);
        this.setFileProcColumns(fProc, props);
        this.setFileRange(fProc, props);
        this.setTextFormats(fProc, props, true);
    }

    protected int storeFixedFormatDict(CNKProcFile fProc, FixedFormatDictionary ffd) throws Exception {
        List colNames = ffd.getNames();
        int numColumns = colNames.size();
        int maxColumnUsed = 0;
        int offset = 0;
        fProc.clearFixedColumnInfo();
        for (int colNum = 0; colNum < numColumns; ++colNum) {
            int width;
            int startCol;
            String name = (String)colNames.get(colNum);
            String type = ffd.getType(colNum);
            String procType = "string";
            if (type != null) {
                if (type.equals(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG)) {
                    procType = "double";
                } else if (type.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG)) {
                    procType = "factor";
                } else if (type.equals(XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG)) {
                    procType = "timeDate";
                }
            }
            if ((startCol = ffd.getStart(colNum) - 1) < 0) {
                startCol = offset;
            }
            if ((width = ffd.getWidth(colNum)) < 0) {
                if (colNum + 1 < numColumns && ffd.getStart(colNum + 1) >= startCol) {
                    width = ffd.getStart(colNum + 1) - startCol;
                } else {
                    throw new Exception("can't determine width for column " + name);
                }
            }
            fProc.addFixedColumnInfo(name, procType);
            int decimals = ffd.getDecimals(colNum);
            if (decimals > width) {
                decimals = width;
            }
            fProc.setFixedColumnPosition(startCol, width, decimals);
            maxColumnUsed = Math.max(maxColumnUsed, startCol + width);
            offset = startCol + width;
        }
        return maxColumnUsed;
    }

    protected void modifyMetaData(XTMetaData md, XTProps props) {
        try {
            Vector columns = md.getColumnNames();
            FixedFormatDictionary ffd = this.getDataDictionary(props);
            for (int i = 0; i < md.getNumColumns(); ++i) {
                String name = (String)columns.get(i);
                String role = ffd.getRole(name);
                if (role == null) continue;
                md.setDataFieldRole(name, role);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected FixedFormatDictionary getDataDictionary(XTProps props) throws Exception {
        String ddictFile = this.getNetworkManager().getAbsolutePath(props.getValue("dictionaryFile", ""));
        if (ddictFile.equals("")) {
            throw new Exception("no data dictionary file specified");
        }
        File file = new File(ddictFile);
        if (!file.exists()) {
            throw new Exception("data dictionary file not found");
        }
        FixedFormatDictionary ffd_text = new FixedFormatDictionary(file);
        return ffd_text;
    }

    public void updateDataSourceInfoWarnings(XTProps currentProps, XTProps info) {
    }

    public long procGetEstimatedNumRows(CNKProc proc) {
        long estimatedLines = -1L;
        try {
            String filename = this.getNodeProperties().getValue("filePath", "");
            if (filename == null || filename.equals("")) {
                return -1L;
            }
            filename = this.getNetworkManager().getAbsolutePath(filename);
            File fl = new File(filename);
            if (!fl.isFile()) {
                return -1L;
            }
            long totalBytes = fl.length();
            if (totalBytes == 0L) {
                return -1L;
            }
            char delimChar = ',';
            boolean isUTF8 = false;
            int maxLineWidth = 32768;
            int lookLines = 32;
            long maxBytes = (long)lookLines * (long)maxLineWidth;
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(filename));
            ReadTextFileEngineNode.Scanner scan = new ReadTextFileEngineNode.Scanner();
            scan.scanFile(in, lookLines, maxBytes, delimChar, isUTF8, maxLineWidth);
            ((InputStream)in).close();
            double avgLineWidth = scan.getAvgLineWidth();
            estimatedLines = avgLineWidth > 0.0 ? (long)((double)totalBytes / avgLineWidth) : -1L;
            this.printlnDebug("text file scan of " + filename + ":" + " read " + scan.m_totalLines + " lines, " + scan.m_totalBytes + " bytes" + ", file len=" + totalBytes + ", avg line width=" + (int)avgLineWidth + ", est rows=" + estimatedLines + ", good:bad utf8 bytes=" + scan.m_utf8GoodBytes + ":" + scan.m_utf8BadBytes);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return estimatedLines;
    }
}

