/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKObj;
import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcFile;
import com.insightful.miner.EngineNode;
import com.insightful.miner.MinerApp;
import com.insightful.miner.ModifyColumnsEngineNode;
import com.insightful.miner.ReadTextFileEngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.io.File;
import java.util.HashSet;
import java.util.Vector;

public class ReadOtherFileEngineNode
extends EngineNode {
    public static final String FILEPATH_TAG = "filePath";
    public static final String FILETYPE_TAG = "fileType";
    public static final String WORKSHEET_TAG = "worksheet";
    public static final String DICTIONARY_TAG = "dictionaryFile";
    public static final String DELIMITER_TAG = "delimiter";
    public static final String USER_DELIMITER_TAG = "userDelimiter";
    public static final String USE_COLUMN_NAMES_TAG = "useColumnNames";
    public static final String COLUMNS_TAG = "columns";
    public static final String IS_SELECTED_TAG = "isSelected";
    public static final String NEW_NAME_TAG = "newName";
    public static final String ROLE_TAG = "role";
    public static final String DATATYPE_TAG = "datatype";
    public static final String STRING_WIDTH_TAG = "stringSize";
    public static final String ROWS_TO_PREVIEW_TAG = "rowsToPreview";
    public static final String PREVIEW_DATA_TAG = "previewRows";
    public static final String MAX_COLUMNS_TO_PREVIEW_TAG = "maxColumnsToPreview";
    public static final String DATA_SOURCE_INFO_ERROR_TAG = "error";
    public static final String DATA_SOURCE_INFO_WARNING_TAG = "warning";
    public static final String DATA_SOURCE_INFO_ESTIMATED_ROWS_TAG = "estimatedRows";
    public static final String START_ROW_TAG = "startRow";
    public static final String END_ROW_TAG = "endRow";
    public static final String START_COLUMN_TAG = "startCol";
    public static final String END_COLUMN_TAG = "endCol";
    public static final String NA_STRING_TAG = "NAString";
    public static final String MAX_LINE_WIDTH_TAG = "maxLineWidth";
    public static final String LOOK_MAX_LINES_TAG = "lookMaxLines";
    public static final String TIME_DATE_FORMAT_TAG = "timeDateFormat";
    public static final String TIME_DATE_CENTURY_CUTOFF_TAG = "timeDateCenturyCutoff";
    public static final String TIME_DATE_ZONE_TAG = "timeDateZone";
    public static final String DEFAULT_STRING_COLUMN_TYPE_TAG = "defaultStringColumnType";
    public static final String IS_SAMPLE_FRACTION_TAG = "isSampleFraction";
    public static final String IS_SAMPLE_EACH_N_TAG = "isSampleEachN";
    public static final String SAMPLE_FRACTION_TAG = "sampleFraction";
    public static final String SAMPLE_EACH_N_TAG = "sampleEachN";
    public static final String DB_USER_TAG = "dbUser";
    public static final String DB_PASSWORD_TAG = "dbPassword";
    public static final String DB_DATABASE_TAG = "dbDatabase";
    public static final String DB_SERVER_TAG = "dbServer";
    public static final String DB_CONNECTION_TAG = "dbConnection";
    public static final String DB_TABLE_TAG = "dbTable";
    public static final String DB_SQL_TAG = "dbSql";
    public static final String DB_APPEND_TAG = "dbAppend";
    public static final String DB_WRITE_OPTION_TAG = "dbWriteOption";
    public static final String DB_WRITE_OPTION_CREATE = "create";
    public static final String DB_WRITE_OPTION_OVERWRITE = "overwrite";
    public static final String DB_WRITE_OPTION_APPEND = "append";
    public static final String DATA_SOURCE_META_DATA_CACHE_NAME = "datasourceMD";
    public static final String DATA_SOURCE_PROPS_CACHE_NAME = "datasourceProps";
    public static final String DATA_SOURCE_PREVIEW_CACHE_NAME = "datasourcePreview";
    public static final String DATA_SOURCE_INFO_CACHE_NAME = "datasourceInfo";
    public static final String TABLE_NAMES_COUNT_TAG = "tableNameCount";
    public static final String TABLE_NAMES_ERROR_TAG = "tableNameErrors";
    public static final String TABLE_NAMES_LIST_TAG = "tableNames";
    public static final String TEXT_ENCODING_TAG = "textEncoding";
    public static final String DEFAULT_TEXT_ENCODING = "ASCII";
    public static final String KEEP_DROP_TAG = "keepDrop";
    public static final String KEEP_DROP_KEEP_TAG = "keep";
    public static final String KEEP_DROP_COLUMNS_TAG = "columns";
    public static final String COL_NAMES_UPPER_CASE_TAG = "colNamesUpperCase";
    public static final String COL_NAMES_TAG = "colNames";
    public static final String COL_TYPES_TAG = "colTypes";
    public static final String COL_STRING_WIDTHS_TAG = "colStringWidths";
    public static final String FORMAT_TAG = "format";
    public static final String FILTER_TAG = "filter";
    public static final String PAGE_NUMBER_TAG = "pageNumber";
    public static final String VALUE_LABEL_AS_NUMBER_TAG = "valueLabelAsNumber";
    public static final String SAS_FORMAT_FILE_TAG = "sasFormatFile";
    public static final String ODBC_CONNECTION_TAG = "odbcConnection";
    public static final String COL_NAME_ROW_TAG = "colNameRow";
    public static final String CENTURY_CUTOFF_TAG = "centuryCutoff";
    public static final String SEPARATE_DELIMITERS_TAG = "separateDelimiters";
    public static final String DECIMAL_POINT_TAG = "decimal.point";
    public static final String THOUSANDS_SEPARATOR_TAG = "thousands.separator";
    public static final String WRITE_QUOTE_TAG = "writeQuote";
    public static final String ASCII_START_ROW_TAG = "asciiStartRow";
    public static final String ASCII_END_ROW_TAG = "asciiEndRow";
    public static final String READ_TRIM_STRING_TAG = "readTrimString";
    public static final String READ_STRING_NA = "readStringNA";
    private static String m_jetVersionString = null;
    private static boolean m_hasAccess2KDrivers = false;
    private boolean m_dataSourceInProgress = false;
    private static final String[] m_fileTypesToLowerCaseColNames = new String[]{"sasv6", "sas1", "sas4", "sas_tpt", "spssp", "spss_por"};

    public CNKProc procCreate() throws Exception {
        XTProps info = this.getDataSourceInfo();
        if (info != null) {
            String errors = info.getValue(DATA_SOURCE_INFO_ERROR_TAG, "");
            String warnings = info.getValue(DATA_SOURCE_INFO_WARNING_TAG, "");
            if (!errors.equals("")) {
                if (!warnings.equals("")) {
                    errors = errors + "\n" + warnings;
                }
                throw new Exception(errors);
            }
            if (!warnings.equals("")) {
                int idx = 0;
                while (idx < warnings.length()) {
                    String oneWarning;
                    int endIdx = warnings.indexOf("\n", idx);
                    if (endIdx < 0) {
                        oneWarning = warnings.substring(idx);
                        idx = warnings.length();
                    } else {
                        oneWarning = warnings.substring(idx, endIdx);
                        idx = endIdx + 1;
                    }
                    this.printlnWarning(this.getNodeName() + ": " + oneWarning);
                }
            }
        }
        CNKProcFile proc = new CNKProcFile();
        return proc;
    }

    public void procSetProperties(CNKProc proc) throws Exception {
        XTProps props = this.getNodeProperties();
        this.procSetProperties(proc, props);
    }

    public void procSetProperties(CNKProc proc, XTProps props) throws Exception {
        CNKProcFile fProc = (CNKProcFile)proc;
        String fileType = props.getValue(FILETYPE_TAG, "");
        fProc.setRead(true);
        fProc.setFileName(this.getNetworkManager().getAbsolutePath(props.getValue(FILEPATH_TAG, "")));
        fProc.setFileType(fileType);
        fProc.setDBTable(props.getValue(DB_TABLE_TAG, ""));
        this.setFileProcColumns(fProc, props);
        this.setFileRange(fProc, props);
        if (this.isWorksheetFileType(fileType) || fileType.equals("SAS_TPT") || fileType.equals("CPORT")) {
            int worksheetNum;
            String worksheetName = props.getValue(WORKSHEET_TAG, "");
            if (worksheetName.length() > 0) {
                fProc.setExcelPageName(worksheetName);
            }
            if ((worksheetNum = props.getInt(PAGE_NUMBER_TAG, -1)) >= 0) {
                fProc.setExcelPageNum(worksheetNum - 1);
            }
        }
        ReadOtherFileEngineNode.setAccessFileType(fProc, fileType);
    }

    public static void setAccessFileType(CNKProcFile fProc, String fileType) throws Exception {
        if (fileType.startsWith("ACCESS")) {
            if (!MinerApp.isWindowsOS()) {
                throw new Exception("Cannot execute node on this platform.  Microsoft Access is only available on Windows.");
            }
            if (fileType.equals("ACCESS97") || fileType.equals("ACCESS")) {
                fProc.setFileType("ACCESS");
                fProc.setAccessVersion(1997);
            } else if (fileType.equals("ACCESS2K")) {
                if (!ReadOtherFileEngineNode.isAccess2KSupported(fProc)) {
                    throw new Exception("Access 2000 not available on this machine: install Jet 4.x drivers and MDAC 2.5 or higher (see www.microsoft.com/data)");
                }
                fProc.setFileType("ACCESS");
                fProc.setAccessVersion(2000);
            }
        }
    }

    public static boolean isAccess2KSupported(CNKProcFile fProc) {
        if (m_jetVersionString == null && fProc != null) {
            try {
                String ver = fProc.getJetVersion();
                if (ver == null) {
                    ver = "0.0";
                }
                m_jetVersionString = ver;
                int verNum = Integer.parseInt(ver.substring(0, ver.indexOf(".")));
                m_hasAccess2KDrivers = verNum >= 4;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            System.out.println("jet version string=" + m_jetVersionString + ", has Access2K=" + m_hasAccess2KDrivers);
        }
        return m_hasAccess2KDrivers;
    }

    protected void setFileProcColumns(CNKProcFile proc, XTProps props) {
        proc.clearSelectedColumns();
        XTMetaData fileMD = this.getDataSourceMetaData();
        if (fileMD == null) {
            return;
        }
        int[] outputColumnToInputColumnMap = null;
        outputColumnToInputColumnMap = this.hasBDLProps(props) ? this.getBDLReadOutputToInputColumnArray(props, fileMD) : ModifyColumnsEngineNode.getOutputColumnToInputColumnArray(props, fileMD);
        for (int outCol = 0; outCol < outputColumnToInputColumnMap.length; ++outCol) {
            int inCol = outputColumnToInputColumnMap[outCol];
            if (inCol >= 0) {
                proc.addSelectedColumn(inCol);
                continue;
            }
            this.printlnDebug("setFileProcColumns: bad column map outCol=" + outCol + ", inCol=" + inCol);
        }
        proc.setReadSelectAll(this.hasBDLProps(props) && !this.hasKeepDropColumns(props));
    }

    protected void setFileRange(CNKProcFile proc, XTProps props) {
        long startRow = this.getPropAsLong(props, START_ROW_TAG, -1L);
        long endRow = this.getPropAsLong(props, END_ROW_TAG, -1L);
        proc.setStartRow(startRow < 0L ? -1L : startRow - 1L);
        proc.setEndRow(endRow < 0L ? -1L : endRow - 1L);
        int randomSeed = (int)(this.getRandomSeedFromProps(props) & 0xFFFFL);
        proc.setSeed(randomSeed);
        double sampleFraction = props.getDouble(SAMPLE_FRACTION_TAG, -1.0);
        int sampleEachN = props.getInt(SAMPLE_EACH_N_TAG, -1);
        if (!props.getBoolean(IS_SAMPLE_FRACTION_TAG)) {
            sampleFraction = -1.0;
        }
        if (!props.getBoolean(IS_SAMPLE_EACH_N_TAG)) {
            sampleEachN = -1;
        }
        proc.setSampleFraction(sampleFraction);
        proc.setSampleEachN(sampleEachN);
        proc.setValueLabelAsNumber(props.getBoolean(VALUE_LABEL_AS_NUMBER_TAG, false));
        proc.setSASFormatFile(props.getValue(SAS_FORMAT_FILE_TAG, ""));
        this.setFilter(proc, props);
        if (this.hasBDLProps(props)) {
            proc.setVnames(props.getInt(COL_NAME_ROW_TAG, -1));
        } else {
            int vnames = -1;
            if (props.getValue(USE_COLUMN_NAMES_TAG, null) != null) {
                vnames = props.getBoolean(USE_COLUMN_NAMES_TAG, true) ? 1 : 0;
            }
            proc.setVnames(vnames);
        }
        proc.setReadTrimString(props.getBoolean(READ_TRIM_STRING_TAG, true));
        proc.setReadStringNA(props.getBoolean(READ_STRING_NA, true));
    }

    private long getPropAsLong(XTProps props, String tag, long defaultValue) {
        try {
            String val = props.getValue(tag, null);
            return Long.parseLong(val);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public long procGetEstimatedNumRows(CNKProc proc) {
        CNKProcFile fProc = (CNKProcFile)proc;
        return fProc.getNumCases();
    }

    public void invalidateNodeState() {
        this.setNodeCache(DATA_SOURCE_META_DATA_CACHE_NAME, null);
        this.setNodeCache(DATA_SOURCE_PROPS_CACHE_NAME, null);
        this.setNodeCache(DATA_SOURCE_PREVIEW_CACHE_NAME, null);
        this.setNodeCache(DATA_SOURCE_INFO_CACHE_NAME, null);
    }

    public XTProps getDataSourceInfo() {
        return this.getDataSourceInfo(this.getNodeProperties());
    }

    public XTProps getDataSourcePreview() {
        return this.getDataSourcePreview(this.getNodeProperties());
    }

    public XTMetaData getDataSourceMetaData() {
        return this.getDataSourceMetaData(this.getNodeProperties());
    }

    public XTProps getDataSourceInfo(XTProps props) {
        this.updateDataSourceInfo(props, false);
        XTProps info = this.getNodeCacheXTProps(DATA_SOURCE_INFO_CACHE_NAME);
        return info;
    }

    public XTProps getDataSourcePreview(XTProps props) {
        this.updateDataSourceInfo(props, true);
        XTProps preview = this.getNodeCacheXTProps(DATA_SOURCE_PREVIEW_CACHE_NAME);
        return preview;
    }

    public XTMetaData getDataSourceMetaData(XTProps props) {
        this.updateDataSourceInfo(props, false);
        XTMetaData md = this.getNodeCacheXTMetaData(DATA_SOURCE_META_DATA_CACHE_NAME);
        return md;
    }

    private boolean hasPreviewCache() {
        return this.getNodeCacheNames().contains(DATA_SOURCE_PREVIEW_CACHE_NAME);
    }

    private boolean getDefaultStringColumnTypeIsCategorical(XTProps props) {
        String defaultStringColumnType = props.getValue(DEFAULT_STRING_COLUMN_TYPE_TAG, XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG);
        return defaultStringColumnType.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG);
    }

    protected void modifyMetaData(XTMetaData md, XTProps props) {
    }

    public synchronized void updateDataSourceInfo(XTProps currentProps, boolean getPreview) {
        block54: {
            if (this.m_dataSourceInProgress) {
                return;
            }
            this.m_dataSourceInProgress = true;
            try {
                XTProps mdProps;
                XTProps params = this.getNetworkManager().getWorksheetParameters();
                if (params != null) {
                    currentProps.paramaterize(params.getSubProperties(new String[0]), params.getSubPropertyValues(new String[0]));
                }
                if ((mdProps = this.getNodeCacheXTProps(DATA_SOURCE_PROPS_CACHE_NAME)) != null && mdProps.equals(currentProps) && !getPreview) break block54;
                this.setNodeCache(DATA_SOURCE_META_DATA_CACHE_NAME, null);
                this.setNodeCache(DATA_SOURCE_PREVIEW_CACHE_NAME, null);
                this.setNodeCache(DATA_SOURCE_INFO_CACHE_NAME, null);
                this.setNodeCache(DATA_SOURCE_PROPS_CACHE_NAME, null);
                XTProps info = new XTProps();
                XTMetaData md = new XTMetaData();
                XTProps preview = null;
                String errorString = "";
                String filepath = currentProps.getValue(FILEPATH_TAG, "");
                if (filepath != null && !filepath.equals("")) {
                    filepath = this.getNetworkManager().getAbsolutePath(filepath);
                    File fl = new File(filepath);
                    if (!fl.exists()) {
                        errorString = MinerApp.getText("ReadOtherFileEngineNode_msg_fileDoesNotExist");
                    } else if (fl.isDirectory()) {
                        errorString = MinerApp.getText("ReadOtherFileEngineNode_msg_fileIsDirectory");
                    } else if (!fl.canRead()) {
                        errorString = MinerApp.getText("ReadOtherFileEngineNode_msg_fileCannotBeRead");
                    } else if (fl.length() == 0L) {
                        errorString = MinerApp.getText("ReadOtherFileEngineNode_msg_fileIsEmpty");
                    }
                }
                if (!errorString.equals("")) {
                    errorString = errorString + " " + filepath;
                }
                CNKObj rdr = null;
                int numColumns = -1;
                Vector<String> asciiColumnNames = null;
                boolean isAsciiReader = this instanceof ReadTextFileEngineNode;
                if (isAsciiReader && !this.hasBDLProps(currentProps) && (currentProps.getInt(START_ROW_TAG, -1) >= 0 || currentProps.getInt(END_ROW_TAG, -1) >= 0) && currentProps.getValue(USE_COLUMN_NAMES_TAG, null) != null && currentProps.getBoolean(USE_COLUMN_NAMES_TAG, true)) {
                    try {
                        this.printlnDebug("opening data source to find ascii column names: " + filepath);
                        rdr = new CNKProcFile();
                        rdr.createCheck();
                        ((CNKProc)rdr).setNumRows(1);
                        this.procSetProperties((CNKProc)rdr, currentProps);
                        ((CNKProcFile)rdr).setAsciiStartRow(0L);
                        ((CNKProcFile)rdr).setAsciiEndRow(0L);
                        ((CNKProcFile)rdr).setVnames(0);
                        ((CNKProcFile)rdr).setRead(true);
                        ((CNKProcFile)rdr).setPreviewFlag(true);
                        rdr.init();
                        numColumns = ((CNKProcFile)rdr).getNumInputColumns();
                        boolean ok = ((CNKProcFile)rdr).getPreviewReadRow();
                        asciiColumnNames = new Vector<String>();
                        for (int col = 0; col < numColumns; ++col) {
                            String val = ((CNKProcFile)rdr).getPreviewReadString(col);
                            if (CNKObj.isStringNA(val)) {
                                val = null;
                            }
                            asciiColumnNames.add(val);
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    this.printlnDebug("found " + (asciiColumnNames == null ? 0 : asciiColumnNames.size()) + " ascii column names");
                    try {
                        if (rdr != null) {
                            rdr.destroyCNKObj();
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    rdr = null;
                    numColumns = -1;
                }
                if (errorString.equals("")) {
                    try {
                        this.printlnDebug("opening data source to get meta-data: " + filepath);
                        rdr = new CNKProcFile();
                        rdr.createCheck();
                        ((CNKProc)rdr).setNumRows(1);
                        this.procSetProperties((CNKProc)rdr, currentProps);
                        ((CNKProcFile)rdr).setRead(true);
                        ((CNKProcFile)rdr).setPreviewFlag(true);
                        rdr.init();
                        numColumns = ((CNKProcFile)rdr).getNumInputColumns();
                        this.printlnDebug("data source has " + numColumns + " columns");
                        int numMessages = rdr.getNumMessages();
                        for (int i = 0; i < numMessages; ++i) {
                            String msg = rdr.getMessage(i);
                            int severity = rdr.getMessageSeverity(i);
                            this.printlnDebug("rdr msg " + i + ": (" + severity + ") " + msg);
                            if (severity != 4) continue;
                            if (!errorString.equals("")) {
                                errorString = errorString + "\n";
                            }
                            errorString = errorString + msg;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (!errorString.equals("")) {
                            errorString = errorString + "\n";
                        }
                        errorString = errorString + ex.getMessage();
                    }
                }
                info.set(DATA_SOURCE_INFO_ERROR_TAG, errorString);
                if (errorString.equals("") && numColumns >= 0) {
                    boolean[] isDoubleType = new boolean[numColumns];
                    boolean[] isTimeDateType = new boolean[numColumns];
                    boolean defaultStringColumnTypeIsCategorical = this.getDefaultStringColumnTypeIsCategorical(currentProps);
                    HashSet<String> knownColumns = new HashSet<String>();
                    int minStringWidth = this.getWorksheetPropertiesManager().getDefaultStringSize();
                    for (int col = 0; col < numColumns; ++col) {
                        String asciiName;
                        String name = ((CNKProcFile)rdr).getInputColumnName(col);
                        if (asciiColumnNames != null && col < asciiColumnNames.size() && (asciiName = (String)asciiColumnNames.get(col)) != null && asciiName.length() > 0) {
                            name = asciiName;
                        }
                        if (knownColumns.contains(name)) {
                            int suffixNum = 1;
                            while (true) {
                                if (!knownColumns.contains(name + suffixNum)) {
                                    name = name + suffixNum;
                                    break;
                                }
                                ++suffixNum;
                            }
                        }
                        knownColumns.add(name);
                        String rdrType = ((CNKProcFile)rdr).getInputColumnType(col);
                        isDoubleType[col] = false;
                        isTimeDateType[col] = false;
                        if ("factor".equals(rdrType)) {
                            md.appendCategoricalDataField(name, new String[0]);
                            continue;
                        }
                        if ("string".equals(rdrType)) {
                            if (defaultStringColumnTypeIsCategorical) {
                                md.appendCategoricalDataField(name, new String[0]);
                                continue;
                            }
                            int stringWidth = ((CNKProcFile)rdr).getInputColumnPrintWidth(col) + 1;
                            if (stringWidth < minStringWidth) {
                                stringWidth = minStringWidth;
                            }
                            md.appendStringDataField(name, stringWidth);
                            continue;
                        }
                        if ("timeDate".equals(rdrType)) {
                            md.appendDateTimeDataField(name);
                            isTimeDateType[col] = true;
                            continue;
                        }
                        md.appendContinousDataField(name);
                        isDoubleType[col] = true;
                    }
                    this.modifyMetaData(md, currentProps);
                    if (getPreview) {
                        preview = new XTProps();
                        int numRowsToPreview = currentProps.getInt(ROWS_TO_PREVIEW_TAG, 10);
                        int maxColumns = currentProps.getInt(MAX_COLUMNS_TO_PREVIEW_TAG, -1);
                        int numColumnsToPreview = numColumns;
                        if (maxColumns > 0 && numColumns > maxColumns) {
                            numColumnsToPreview = maxColumns;
                        }
                        int startRow = currentProps.getInt(START_ROW_TAG, -1);
                        int endRow = currentProps.getInt(END_ROW_TAG, -1);
                        if (endRow < startRow) {
                            endRow = -1;
                        }
                        if (this.isWorksheetFileType(currentProps.getValue(FILETYPE_TAG, ""))) {
                            endRow = -1;
                            startRow = -1;
                        }
                        if (isAsciiReader) {
                            endRow = -1;
                            startRow = -1;
                        }
                        int skipRows = startRow < 1 ? 0 : startRow - 1;
                        int numRowsToRead = endRow < 0 ? -1 : endRow - skipRows;
                        for (int skip = 0; skip < skipRows; ++skip) {
                            boolean ok = ((CNKProcFile)rdr).getPreviewReadRow();
                            if (ok) continue;
                            this.printlnDebug("preview read failed w skipRow=" + skip + "/" + skipRows);
                            numRowsToRead = 0;
                            break;
                        }
                        int rowsRead = 0;
                        int rowsSaved = 0;
                        double sampleFraction = ((CNKProcFile)rdr).getSampleFraction();
                        boolean useSampleFraction = sampleFraction >= 0.0;
                        int sampleEachN = ((CNKProcFile)rdr).getSampleEachN();
                        boolean useSampleEachN = sampleEachN > 1;
                        String[] path = new String[]{PREVIEW_DATA_TAG, "row", "col"};
                        while (rowsSaved < numRowsToPreview && (numRowsToRead < 0 || rowsRead < numRowsToRead)) {
                            boolean ok = ((CNKProcFile)rdr).getPreviewReadRow();
                            ++rowsRead;
                            if (!ok) break;
                            if (useSampleFraction ? ((CNKProcFile)rdr).getNextRandom() > sampleFraction : useSampleEachN && (rowsRead - 1) % sampleEachN != 0) continue;
                            path[1] = Integer.toString(rowsSaved++);
                            for (int col = 0; col < numColumnsToPreview; ++col) {
                                path[2] = Integer.toString(col);
                                String val = "";
                                if (isDoubleType[col]) {
                                    double dVal = ((CNKProcFile)rdr).getPreviewReadDouble(col);
                                    if (!CNKObj.isDoubleNA(dVal)) {
                                        val = this.getNetworkManager().getWorksheetPropertiesManager().formatFreeDouble(dVal);
                                    }
                                } else if (isTimeDateType[col]) {
                                    long td = ((CNKProcFile)rdr).getPreviewReadTimeDate(col);
                                    if (!CNKObj.isTimeDateNA(td)) {
                                        val = this.getNetworkManager().getWorksheetPropertiesManager().getDateFormatter().convertTimeDateToString(td);
                                    }
                                } else {
                                    val = ((CNKProcFile)rdr).getPreviewReadString(col);
                                }
                                if (CNKObj.isStringNA(val)) {
                                    val = "";
                                }
                                preview.set(path, val);
                            }
                        }
                    }
                }
                if (rdr != null) {
                    rdr.destroyCNKObj();
                }
                this.updateDataSourceInfoWarnings(currentProps, info);
                this.setNodeCache(DATA_SOURCE_PROPS_CACHE_NAME, currentProps);
                this.setNodeCache(DATA_SOURCE_META_DATA_CACHE_NAME, md);
                this.setNodeCache(DATA_SOURCE_INFO_CACHE_NAME, info);
                this.setNodeCache(DATA_SOURCE_PREVIEW_CACHE_NAME, preview);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.setNodeCache(DATA_SOURCE_PROPS_CACHE_NAME, null);
            }
        }
        this.m_dataSourceInProgress = false;
    }

    private boolean isWorksheetFileType(String fileType) {
        return fileType != null && (fileType.equals("EXCEL") || fileType.equals("LOTUS") || fileType.equals("QUATTRO"));
    }

    public void updateDataSourceInfoWarnings(XTProps currentProps, XTProps info) {
    }

    public XTProps getAllTableNames(XTProps currentProps, int maxTableNames) {
        XTProps tnprops = null;
        CNKProcFile rdr = null;
        if (this.m_dataSourceInProgress) {
            return null;
        }
        this.m_dataSourceInProgress = true;
        try {
            tnprops = new XTProps();
            this.printlnDebug("opening data source to get table names");
            rdr = new CNKProcFile();
            rdr.setNumRows(1);
            this.procSetProperties(rdr, currentProps);
            rdr.setRead(true);
            rdr.setDBTable("tndummy");
            rdr.setDBSql("");
            rdr.setTableNameFlag(true);
            rdr.init();
            int numTables = rdr.getTableNameCount();
            this.printlnDebug("data source has " + numTables + " table names");
            tnprops.set(TABLE_NAMES_COUNT_TAG, numTables);
            String errorString = "";
            if (numTables < 1) {
                int numMessages = rdr.getNumMessages();
                for (int i = 0; i < numMessages; ++i) {
                    String msg = rdr.getMessage(i);
                    int severity = rdr.getMessageSeverity(i);
                    this.printlnDebug("rdr msg " + i + ": (" + severity + ") " + msg);
                    if (severity != 4) continue;
                    if (!errorString.equals("")) {
                        errorString = errorString + "\n";
                    }
                    errorString = errorString + msg;
                }
                tnprops.set(TABLE_NAMES_ERROR_TAG, errorString);
            } else {
                HashSet<String> tableNameSet = new HashSet<String>();
                int propsIndex = 0;
                for (int i = 0; i < numTables && propsIndex < maxTableNames; ++i) {
                    String tableName = rdr.getTableNameString(i);
                    if (tableNameSet.contains(tableName)) continue;
                    tnprops.set(TABLE_NAMES_LIST_TAG, Integer.toString(propsIndex++), tableName);
                    tableNameSet.add(tableName);
                }
                tnprops.set(TABLE_NAMES_COUNT_TAG, propsIndex);
                this.printlnDebug("retrieved " + propsIndex + " distinct table names");
            }
        }
        catch (Exception ex) {
            return null;
        }
        if (rdr != null) {
            rdr.destroyCNKObj();
        }
        this.m_dataSourceInProgress = false;
        return tnprops;
    }

    public String[] getExcelPageList(XTProps props) {
        CNKProcFile rdr = null;
        String errorString = "";
        try {
            String filepath = this.getNetworkManager().getAbsolutePath(props.getValue(FILEPATH_TAG, ""));
            this.printlnDebug("opening data source to get excel page list: " + filepath);
            rdr = new CNKProcFile();
            rdr.createCheck();
            rdr.setNumRows(1);
            this.procSetProperties(rdr, props);
            rdr.setPreviewFlag(true);
            rdr.init();
            int numMessages = rdr.getNumMessages();
            for (int i = 0; i < numMessages; ++i) {
                String msg = rdr.getMessage(i);
                int severity = rdr.getMessageSeverity(i);
                this.printlnDebug("rdr msg " + i + ": (" + severity + ") " + msg);
                if (severity != 4) continue;
                if (!errorString.equals("")) {
                    errorString = errorString + "\n";
                }
                errorString = errorString + msg;
            }
            XTProps info = new XTProps();
            info.set(DATA_SOURCE_INFO_ERROR_TAG, errorString);
            this.setNodeCache(DATA_SOURCE_INFO_CACHE_NAME, info);
            if (errorString.length() == 0) {
                int num = rdr.getNumExcelPages();
                String[] pageList = new String[num];
                for (int i = 0; i < num; ++i) {
                    pageList[i] = rdr.getExcelPageName(i);
                }
                return pageList;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (!errorString.equals("")) {
                errorString = errorString + "\n";
            }
            errorString = errorString + ex.getMessage();
        }
        return new String[0];
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        XTProps props = this.getNodeProperties();
        XTMetaData inputMD = this.getDataSourceMetaData();
        XTMetaData md = null;
        md = this.hasBDLProps(props) ? this.getBDLOutputMetaData(props, inputMD) : ModifyColumnsEngineNode.calculateOutputMetaData(props, inputMD, this.getWorksheetPropertiesManager().getDefaultStringSize());
        return md;
    }

    public boolean hasBDLProps(XTProps props) {
        return props.getValue(DECIMAL_POINT_TAG, null) != null;
    }

    public XTMetaData getBDLOutputMetaData(XTProps props, XTMetaData fileMD) {
        XTMetaData md = null;
        try {
            md = new XTMetaData();
            String fileType = props.getValue(FILETYPE_TAG, "");
            boolean lowerCaseColNames = false;
            for (int i = 0; i < m_fileTypesToLowerCaseColNames.length; ++i) {
                if (!fileType.equalsIgnoreCase(m_fileTypesToLowerCaseColNames[i])) continue;
                lowerCaseColNames = true;
                break;
            }
            int[] outputColumnToInputColumns = this.getBDLReadOutputToInputColumnArray(props, fileMD);
            boolean colNamesUpperCase = props.getBoolean(COL_NAMES_UPPER_CASE_TAG, false);
            Vector newColumnNames = props.getSubPropertyValues(COL_NAMES_TAG);
            Vector newColumnTypes = props.getSubPropertyValues(COL_TYPES_TAG);
            Vector newColumnStringWidths = props.getSubPropertyValues(COL_STRING_WIDTHS_TAG);
            int minStringWidth = this.getWorksheetPropertiesManager().getDefaultStringSize();
            if (newColumnNames.size() > 0 && newColumnNames.size() != outputColumnToInputColumns.length) {
                this.printlnWarning("importData colNames argument is the wrong length, is " + newColumnNames.size() + ", should be " + outputColumnToInputColumns.length);
            }
            for (int i = 0; i < outputColumnToInputColumns.length; ++i) {
                int mdStringWidth;
                String newOutputType;
                String newOutputName;
                int inputCol = outputColumnToInputColumns[i];
                String outputName = fileMD.ordinalToName(inputCol);
                if (i < newColumnNames.size() && (newOutputName = (String)newColumnNames.get(i)) != null && newOutputName.length() > 0) {
                    outputName = newOutputName;
                }
                if (lowerCaseColNames) {
                    outputName = outputName.toLowerCase();
                }
                if (colNamesUpperCase) {
                    outputName = outputName.toUpperCase();
                }
                String outputType = fileMD.getColumnType(inputCol);
                if (i < newColumnTypes.size() && (newOutputType = (String)newColumnTypes.get(i)) != null) {
                    if (newOutputType.equals("numeric") || newOutputType.equals(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG)) {
                        outputType = XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG;
                    } else if (newOutputType.equals("factor") || newOutputType.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG)) {
                        outputType = XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG;
                    } else if (newOutputType.equals("character") || newOutputType.equals(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG)) {
                        outputType = XTMetaData.STRING_TYPE_ATTRIBUTE_TAG;
                    } else if (newOutputType.equals("timeDate") || newOutputType.equals(XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG)) {
                        outputType = XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG;
                    }
                }
                int stringWidth = minStringWidth;
                if (fileMD.isStringColumn(inputCol) && stringWidth < (mdStringWidth = fileMD.getStringDataFieldWidth(inputCol))) {
                    stringWidth = mdStringWidth;
                }
                if (i < newColumnStringWidths.size()) {
                    try {
                        String newColumnStringWidth = (String)newColumnStringWidths.get(i);
                        stringWidth = Integer.parseInt(newColumnStringWidth) + 1;
                        if (stringWidth < 4) {
                            stringWidth = 4;
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                md.appendCopyDataField(fileMD, inputCol, outputName, null, outputType, stringWidth);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return md;
    }

    public int[] getBDLReadOutputToInputColumnArray(XTProps props, XTMetaData fileMD) {
        int i;
        int inputColumns = fileMD.getNumColumns();
        int startCol = props.getInt(START_COLUMN_TAG, 1);
        int endCol = props.getInt(END_COLUMN_TAG, -1);
        int n = startCol = startCol < 1 ? 1 : startCol;
        endCol = endCol < 1 ? inputColumns : (endCol > inputColumns ? inputColumns : endCol);
        int startIdx = startCol - 1;
        int endIdx = endCol - 1;
        boolean keep = props.getBoolean(new String[]{KEEP_DROP_TAG, KEEP_DROP_KEEP_TAG}, true);
        Vector columns = props.getSubPropertyValues(new String[]{KEEP_DROP_TAG, "columns"});
        boolean[] selectedColumns = new boolean[inputColumns];
        if (columns.size() < 1 || !keep) {
            for (i = startIdx; i < inputColumns && i <= endIdx; ++i) {
                selectedColumns[i] = true;
            }
        }
        for (i = 0; i < columns.size(); ++i) {
            int colIndex = this.getColIndexFromKeepDropSpec((String)columns.get(i), fileMD);
            if (colIndex < startIdx || colIndex > endIdx) continue;
            selectedColumns[colIndex] = keep;
        }
        return this.getSelectedColumnIndices(selectedColumns);
    }

    protected void setFileProcWriteCommon(CNKProcFile proc, XTProps props) {
        proc.clearSelectedColumns();
        XTMetaData inMD = this.getInputMetaData(0);
        int[] outputColumnToInputColumnMap = this.getBDLWriteOutputToInputColumnArray(props, inMD);
        for (int outCol = 0; outCol < outputColumnToInputColumnMap.length; ++outCol) {
            int inCol = outputColumnToInputColumnMap[outCol];
            if (inCol >= 0) {
                proc.addSelectedColumn(inCol);
                continue;
            }
            this.printlnDebug("setFileProcWriteCommon: bad column map outCol=" + outCol + ", inCol=" + inCol);
        }
        int randomSeed = (int)(this.getRandomSeedFromProps(props) & 0xFFFFL);
        proc.setSeed(randomSeed);
        this.setFilter(proc, props);
    }

    public int[] getBDLWriteOutputToInputColumnArray(XTProps props, XTMetaData inMD) {
        int inputColumns = inMD.getNumColumns();
        boolean keep = props.getBoolean(new String[]{KEEP_DROP_TAG, KEEP_DROP_KEEP_TAG}, true);
        Vector columns = props.getSubPropertyValues(new String[]{KEEP_DROP_TAG, "columns"});
        if (columns.size() < 1 || !keep) {
            int i;
            boolean[] selectedColumns = new boolean[inputColumns];
            for (i = 0; i < inputColumns; ++i) {
                selectedColumns[i] = true;
            }
            if (columns.size() > 0) {
                for (i = 0; i < columns.size(); ++i) {
                    int colIndex = this.getColIndexFromKeepDropSpec((String)columns.get(i), inMD);
                    if (colIndex < 0) continue;
                    selectedColumns[colIndex] = false;
                }
            }
            return this.getSelectedColumnIndices(selectedColumns);
        }
        Vector<Integer> colIndexVec = new Vector<Integer>();
        for (int i = 0; i < columns.size(); ++i) {
            int colIndex = this.getColIndexFromKeepDropSpec((String)columns.get(i), inMD);
            if (colIndex < 0) continue;
            colIndexVec.add(new Integer(colIndex));
        }
        return this.getSelectedColumnIndices(colIndexVec);
    }

    private boolean hasKeepDropColumns(XTProps props) {
        Vector columns = props.getSubPropertyValues(new String[]{KEEP_DROP_TAG, "columns"});
        return columns.size() > 0;
    }

    private int getColIndexFromKeepDropSpec(String keepDropSpec, XTMetaData md) {
        int colIndex = -1;
        try {
            colIndex = Integer.parseInt(keepDropSpec) - 1;
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (colIndex < 0) {
            colIndex = md.nameToOrdinal(keepDropSpec);
        }
        return colIndex;
    }

    private int[] getSelectedColumnIndices(boolean[] selectedColumns) {
        int outputColumns = 0;
        for (int i = 0; i < selectedColumns.length; ++i) {
            if (!selectedColumns[i]) continue;
            ++outputColumns;
        }
        int[] ret = new int[outputColumns];
        int retIndex = 0;
        for (int i = 0; i < selectedColumns.length; ++i) {
            if (!selectedColumns[i]) continue;
            ret[retIndex++] = i;
        }
        return ret;
    }

    private int[] getSelectedColumnIndices(Vector selectedColumns) {
        int outputColumns = selectedColumns.size();
        int[] ret = new int[outputColumns];
        for (int i = 0; i < outputColumns; ++i) {
            ret[i] = (Integer)selectedColumns.get(i);
        }
        return ret;
    }

    public void setFilter(CNKProcFile fProc, XTProps props) {
        String origFilter = props.getValue(FILTER_TAG, "");
        StringBuffer buf = new StringBuffer(origFilter);
        String ucFilter = origFilter.toUpperCase();
        String[] sampfns = new String[]{"SAMP.RAND", "SAMP.FIXED", "SAMP.SYST"};
        for (int i = 0; i < sampfns.length; ++i) {
            String sampfn = sampfns[i];
            int index = 0;
            while ((index = ucFilter.indexOf(sampfn, index)) >= 0) {
                buf.setCharAt(index + 4, '_');
                ++index;
            }
        }
        String filter = buf.toString();
        fProc.setFilter(filter);
        fProc.setSeed((int)this.getRandomSeedFromProps(props));
    }

    public void setTextFormats(CNKProcFile fProc, XTProps props, boolean read) {
        fProc.setNAString(props.getValue(NA_STRING_TAG, ""));
        String dateString = props.getValue(TIME_DATE_FORMAT_TAG, "");
        if (dateString.trim().length() < 1) {
            dateString = read ? this.getWorksheetPropertiesManager().getDateParseString() : this.getWorksheetPropertiesManager().getDateFormatString();
        }
        fProc.setTimeDateFormat(dateString);
        String centuryCutoffString = props.getValue(CENTURY_CUTOFF_TAG, null);
        fProc.setTimeDateCenturyCutoff(centuryCutoffString != null ? props.getInt(CENTURY_CUTOFF_TAG, -1) : this.getWorksheetPropertiesManager().getCenturyCutoff());
        fProc.setConverter(this.getNetworkManager().getEngineStringConverter(read ? dateString : null, read ? null : dateString));
        String decimalString = props.getValue(DECIMAL_POINT_TAG, null);
        int decimalInt = decimalString == null || decimalString.length() < 1 ? -1 : (int)decimalString.charAt(0);
        fProc.setDecimalSeparator(decimalInt >= 0 ? decimalInt : (int)this.getNetworkManager().getWorksheetPropertiesManager().getDecimalSeparator());
        String groupingString = props.getValue(THOUSANDS_SEPARATOR_TAG, null);
        int groupingInt = groupingString == null || groupingString.length() < 1 ? -1 : (int)groupingString.charAt(0);
        fProc.setGroupingSeparator(groupingInt >= 0 ? groupingInt : (int)this.getNetworkManager().getWorksheetPropertiesManager().getThousandsSeparator());
    }
}

