/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.ActivityNodeCreated;
import com.insightful.miner.ActivityNodeLinked;
import com.insightful.miner.ActivityNodeState;
import com.insightful.miner.MinerApp;
import com.insightful.miner.SplusGraphEngineNode;
import com.insightful.miner.SplusGraphNodeDialog;
import com.insightful.miner.SplusScriptNodeModel;
import com.insightful.miner.XTNetwork;
import com.insightful.miner.XTProps;
import org.w3c.dom.Element;

public class SplusGraphNodeModel
extends SplusScriptNodeModel {
    public static final String DIALOG_CLASS_TAG = "dialogClass";

    public SplusGraphNodeModel(Element elt) {
        super(elt);
    }

    public SplusGraphNodeModel(XTNetwork.NodeInfo elt) {
        super(elt);
    }

    public void initializeNodeModel() {
        XTProps props = this.getXTProps();
        props.set("showOutputDuringRun", false);
        props.set("storeOutputForView", true);
        boolean mustSample = false;
        for (int i = 0; i < SplusGraphEngineNode.NODES_REQUIRE_SAMPLING.length; ++i) {
            if (!props.getValue(DIALOG_CLASS_TAG).endsWith(SplusGraphEngineNode.NODES_REQUIRE_SAMPLING[i])) continue;
            mustSample = true;
            break;
        }
        if (!mustSample) {
            // empty if block
        }
        props.set("doSample", props.getBoolean("doSample", true));
        props.set("sampleSize", props.getValue("sampleSize", Long.toString(10000L)));
    }

    public boolean isInputValid() {
        if (this.m_inputs == null) {
            return false;
        }
        int total = this.getNumInputs();
        int actual = this.m_inputs.size();
        if (total == -1 && actual > 0) {
            return true;
        }
        return actual == total;
    }

    public boolean isPropertiesValid() {
        if (!MinerApp.isSplusLicensed()) {
            return false;
        }
        boolean ok = true;
        XTProps props = this.getXTProps();
        String dialogClass = props.getValue(DIALOG_CLASS_TAG);
        String[] propPath = new String[]{"minerFunctionInfo", "controlList", ""};
        if (dialogClass.endsWith("ScatterPlotDialog")) {
            propPath[2] = "xColumn";
            boolean hasX = props.getValue(propPath, "").trim().length() > 0;
            propPath[2] = "yColumn";
            boolean hasY = props.getValue(propPath, "").trim().length() > 0;
            ok = hasX || hasY;
        } else if (dialogClass.endsWith("TimeHighLowPlotDialog")) {
            String[] colNames = new String[]{"dateColumn", "high", "low", "open", "close", "volume"};
            boolean[] colRequired = new boolean[]{true, true, true, false, false, false};
            propPath[2] = "style";
            boolean isCandlestick = props.getValue(propPath, "").equals("Candlestick");
            if (isCandlestick) {
                colRequired[3] = true;
                colRequired[4] = true;
            }
            propPath[2] = "plotVolume";
            if (props.getValue(propPath, "").equals("T")) {
                colRequired[5] = true;
            }
            String propValue = null;
            for (int i = 0; ok && i < colNames.length; ++i) {
                if (!colRequired[i]) continue;
                propPath[2] = colNames[i];
                propValue = props.getValue(propPath, null);
                if (propValue == null || propValue.trim().length() != 0) continue;
                ok = false;
            }
        } else {
            String[] propsToCheck = new String[]{"xColumn", "yColumn", "zColumn", "variables", "dateColumn"};
            String propValue = null;
            int i = 0;
            while (ok && i < propsToCheck.length) {
                propPath[2] = propsToCheck[i++];
                propValue = props.getValue(propPath, null);
                if (propValue == null || propValue.trim().length() != 0) continue;
                ok = false;
            }
        }
        return ok;
    }

    public void showPropertiesDialog(boolean modality) {
        this.showPropertiesDialog(modality, false);
    }

    public void showPropertiesDialog(boolean modality, boolean launchedFromTableView) {
        if (MinerApp.isSplusLicensed()) {
            SplusGraphNodeDialog dlg = SplusGraphNodeDialog.getInstance(this.getXTProps().getValue(DIALOG_CLASS_TAG));
            if (launchedFromTableView) {
                dlg.getAddButton().setVisible(true);
                dlg.getOKButton().setVisible(false);
                dlg.getCancelButton().setText(MinerApp.getText("NodeDialog_close"));
                dlg.setDeleteOnClose(this);
                dlg.getRootPane().setDefaultButton(dlg.getApplyButton());
            } else {
                dlg.getAddButton().setVisible(false);
                dlg.getOKButton().setVisible(true);
                dlg.getCancelButton().setText(MinerApp.getText("NodeDialog_cancel"));
                dlg.getRootPane().setDefaultButton(dlg.getOKButton());
            }
            dlg.setModal(modality);
            dlg.show(this);
        } else {
            AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), "S-PLUS is not available.  Cannot display Properties dialog.", "S-PLUS Not Available", 0);
        }
    }

    protected void setState(ActivityNodeState state) {
        if (!MinerApp.isSplusLicensed() && !state.equals(ActivityNodeCreated.instance())) {
            state = ActivityNodeLinked.instance();
        }
        super.setState(state);
    }
}

