/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.miner.SplusScriptEngineNode;
import com.insightful.miner.XTProps;
import java.io.File;
import java.io.FileInputStream;

public class SplusPredictableEngineNode
extends SplusScriptEngineNode {
    private String m_dataDumpTempFileName = null;
    public static final String SPLUS_MODEL_ATTRIBUTE_TAG = "splusModelDataDump";
    public static final String SPLUS_MODEL_CACHE_NAME = "splusModel";
    public static final String PREDICT_SCRIPT_ATTRIBUTE_TAG = "predictScript";

    public String getTransformFunctionBody() {
        if (this.m_dataDumpTempFileName == null) {
            this.m_dataDumpTempFileName = "D:/Temp/splusDataDump-" + this.getNodeID() + ".sdd";
        }
        String expr = "tempFunc <- " + super.getTransformFunctionBody() + "; out <- tempFunc(IM); " + "if (!is.null(out$model)) { " + "assign('tempPredictableObj', out$model, where=1, immediate=T); " + "data.dump('tempPredictableObj', file='" + this.m_dataDumpTempFileName + "'); remove('tempPredictableObj', where=1); out$model <- NULL}; return(out)";
        expr = this.getSafeTransformFunction(expr);
        return expr;
    }

    public void procExtractResults(CNKProc proc) {
        super.procExtractResults(proc);
        if (this.m_dataDumpTempFileName != null) {
            File tempFile = new File(this.m_dataDumpTempFileName);
            String dataDumpText = null;
            if (tempFile.exists() && tempFile.length() > 0L) {
                long len = tempFile.length();
                if (len > Integer.MAX_VALUE) {
                    this.printlnError("S-PLUS model data.dump longer than 2147483647 bytes.  Cannot recover the model information.");
                    return;
                }
                byte[] buf = new byte[(int)len];
                try {
                    FileInputStream stream = new FileInputStream(tempFile);
                    stream.read(buf);
                    stream.close();
                    dataDumpText = new String(buf);
                    tempFile.delete();
                }
                catch (Exception e) {
                    this.printlnError("Error reading text output:  " + e.getMessage());
                }
                try {
                    XTProps splusModelCache = new XTProps();
                    splusModelCache.set(SPLUS_MODEL_ATTRIBUTE_TAG, dataDumpText);
                    this.setNodeCache(SPLUS_MODEL_CACHE_NAME, splusModelCache);
                }
                catch (Exception e) {
                    this.printlnError("Error creating model cache: " + e.getMessage());
                }
            }
        }
    }
}

