/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.StackEngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class StackDialog
extends NodeDialog {
    private NodeDialog.SortingScrollPane availableScrollPane;
    private NodeDialog.SortingScrollPane stackScrollPane;
    private NodeDialog.SortingScrollPane replicateScrollPane;
    private NodeDialog.DNDList availableList;
    private NodeDialog.DNDListModel availableListModel;
    private NodeDialog.DNDList stackList;
    private NodeDialog.DNDListModel stackListModel;
    private NodeDialog.DNDList replicateList;
    private NodeDialog.DNDListModel replicateListModel;
    private HashMap inStackList;
    private HashMap inReplicateList;
    private JCheckBox includeGroupCheckBox;
    private JTextField stackColumnTextField;
    private JTextField groupColumnTextField;
    private AbstractAction addStackAction;
    private AbstractAction removeStackAction;
    private AbstractAction addReplicateAction;
    private AbstractAction removeReplicateAction;
    private static StackDialog instance = null;

    public static StackDialog getInstance() {
        if (instance == null) {
            instance = new StackDialog();
        }
        return instance;
    }

    private StackDialog() {
        this.setResizable(true);
        this.setMinimumSize(new Dimension(400, 475));
    }

    public void restoreProperties() {
        XTMetaData metaData;
        super.restoreProperties();
        this.availableListModel.removeAllElements();
        this.stackListModel.removeAllElements();
        this.replicateListModel.removeAllElements();
        XTProps props = this.getNodeModel().getXTProps();
        try {
            metaData = this.getNodeModel().getInputMetaData(0);
        }
        catch (Exception e) {
            AcceleratorOptionPane.showOKDialog(this, MinerApp.getText("NodeDialog_cannotRestoreProperties"), MinerApp.getText("NodeDialog_propertiesNotRestored"), 0);
            e.printStackTrace();
            return;
        }
        Vector names = metaData.getColumnNames();
        Vector types = metaData.getColumnTypes();
        Vector roles = metaData.getColumnRoles();
        Vector propStack = props.getSubProperties(StackEngineNode.STACK_COLUMN_ATTRIBUTE_TAG);
        Vector propReplicate = props.getSubProperties(StackEngineNode.REPLICATE_COLUMN_ATTRIBUTE_TAG);
        String groupColumn = props.getValue(StackEngineNode.GROUP_COLUMN_ATTRIBUTE_TAG, "");
        String valueColumn = props.getValue(StackEngineNode.STACK_COLUMN_ATTRIBUTE_TAG, "");
        boolean keepGroup = props.getBoolean(StackEngineNode.KEEP_GROUP_ATTRIBUTE_TAG, false);
        this.includeGroupCheckBox.setSelected(keepGroup);
        this.stackColumnTextField.setText(valueColumn);
        this.groupColumnTextField.setText(groupColumn);
        this.groupColumnTextField.setEnabled(keepGroup);
        this.inStackList = new HashMap();
        this.inReplicateList = new HashMap();
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            String role = (String)roles.get(i);
            String type = (String)types.get(i);
            NodeDialog.ColumnInformationObject info = new NodeDialog.ColumnInformationObject(name, type, role, false, i);
            if (propStack.contains(name)) {
                this.stackListModel.addElement(info);
                this.inStackList.put(name, name);
            }
            if (propReplicate.contains(name)) {
                this.replicateListModel.addElement(info);
                this.inReplicateList.put(name, name);
            }
            this.availableListModel.addElement(info);
        }
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        XTProps props = this.getNodeModel().getXTProps();
        boolean keepGroup = this.includeGroupCheckBox.isSelected();
        String groupCol = this.groupColumnTextField.getText();
        String valueCol = this.stackColumnTextField.getText();
        NodeDialog.ColumnInformationObject GCinfo = new NodeDialog.ColumnInformationObject(groupCol, "", "", false, 0);
        NodeDialog.ColumnInformationObject VCinfo = new NodeDialog.ColumnInformationObject(valueCol, "", "", false, 0);
        if (keepGroup && this.replicateListModel.contains(GCinfo)) {
            throw new NodeDialog.DialogException("The Group Column Name must be unique.  \"" + groupCol + "\" already exists.");
        }
        if (this.replicateListModel.contains(VCinfo)) {
            throw new NodeDialog.DialogException("The Stack Column Name must be unique.  \"" + valueCol + "\" already exists.");
        }
        if (keepGroup && groupCol.equals("")) {
            throw new NodeDialog.DialogException("The Group Column Name must not be empty.");
        }
        if (valueCol.equals("")) {
            throw new NodeDialog.DialogException("The Stack Column Name must not be empty.");
        }
        if (keepGroup && valueCol.equals(groupCol)) {
            throw new NodeDialog.DialogException("The Stack Column Name and Group Column Name must be unique.");
        }
        props.removeProperty(new String[]{StackEngineNode.STACK_COLUMN_ATTRIBUTE_TAG});
        props.removeProperty(new String[]{StackEngineNode.REPLICATE_COLUMN_ATTRIBUTE_TAG});
        NodeDialog.ColumnInformationObject object = null;
        Enumeration stackColumns = this.stackListModel.elements();
        while (stackColumns.hasMoreElements()) {
            object = (NodeDialog.ColumnInformationObject)stackColumns.nextElement();
            props.set(StackEngineNode.STACK_COLUMN_ATTRIBUTE_TAG, object.getText(), "");
        }
        stackColumns = null;
        Enumeration replicateColumns = this.replicateListModel.elements();
        while (replicateColumns.hasMoreElements()) {
            object = (NodeDialog.ColumnInformationObject)replicateColumns.nextElement();
            String colName = object.getText();
            props.set(StackEngineNode.REPLICATE_COLUMN_ATTRIBUTE_TAG, colName, "");
        }
        replicateColumns = null;
        props.set(StackEngineNode.GROUP_COLUMN_ATTRIBUTE_TAG, groupCol);
        props.set(StackEngineNode.STACK_COLUMN_ATTRIBUTE_TAG, valueCol);
        props.set(StackEngineNode.KEEP_GROUP_ATTRIBUTE_TAG, keepGroup);
    }

    public void createActions() {
        super.createActions();
        this.addStackAction = new AbstractAction(">>"){

            public void actionPerformed(ActionEvent e) {
                if (!StackDialog.this.availableList.isSelectionEmpty()) {
                    Object[] values = StackDialog.this.availableList.getSelectedValues();
                    StackDialog.this.stackListModel.removeListDataListeners();
                    for (int i = 0; i < values.length; ++i) {
                        String type;
                        String name = ((NodeDialog.ColumnInformationObject)values[i]).getText();
                        if (StackDialog.this.stackListModel.isEmpty()) {
                            StackDialog.this.stackListModel.addElement(values[i]);
                            StackDialog.this.inStackList.put(name, values[i]);
                            continue;
                        }
                        String compareType = ((NodeDialog.ColumnInformationObject)StackDialog.this.stackListModel.get(0)).getType();
                        if (!compareType.equals(type = ((NodeDialog.ColumnInformationObject)values[i]).getType()) || StackDialog.this.inStackList.get(name) != null) continue;
                        StackDialog.this.stackListModel.addElement(values[i]);
                        StackDialog.this.inStackList.put(name, values[i]);
                    }
                    StackDialog.this.stackListModel.undoRemoveListDataListeners();
                    StackDialog.this.stackScrollPane.sort();
                    StackDialog.this.stackListModel.listContentsChanged();
                    Object var2_2 = null;
                }
            }
        };
        this.removeStackAction = new AbstractAction("<<"){

            public void actionPerformed(ActionEvent e) {
                if (!StackDialog.this.stackList.isSelectionEmpty()) {
                    Object[] values = StackDialog.this.stackList.getSelectedValues();
                    int[] indices = StackDialog.this.stackList.getSelectedIndices();
                    StackDialog.this.stackList.getSelectionModel().clearSelection();
                    StackDialog.this.stackListModel.removeListDataListeners();
                    for (int i = 0; i < indices.length; ++i) {
                        String name = ((NodeDialog.ColumnInformationObject)values[i]).getText();
                        StackDialog.this.inStackList.remove(name);
                        StackDialog.this.stackListModel.removeElementAt(indices[i] - i);
                    }
                    StackDialog.this.stackListModel.undoRemoveListDataListeners();
                    StackDialog.this.stackListModel.listContentsChanged();
                    indices = null;
                    Object var2_2 = null;
                }
            }
        };
        this.addReplicateAction = new AbstractAction(">>"){

            public void actionPerformed(ActionEvent e) {
                if (!StackDialog.this.availableList.isSelectionEmpty()) {
                    Object[] values = StackDialog.this.availableList.getSelectedValues();
                    StackDialog.this.replicateListModel.removeListDataListeners();
                    for (int i = 0; i < values.length; ++i) {
                        String name = ((NodeDialog.ColumnInformationObject)values[i]).getText();
                        if (StackDialog.this.inReplicateList.get(name) != null) continue;
                        StackDialog.this.replicateListModel.addElement(values[i]);
                        StackDialog.this.inReplicateList.put(name, values[i]);
                    }
                    StackDialog.this.replicateListModel.undoRemoveListDataListeners();
                    StackDialog.this.replicateScrollPane.sort();
                    StackDialog.this.replicateListModel.listContentsChanged();
                    Object var2_2 = null;
                }
            }
        };
        this.removeReplicateAction = new AbstractAction("<<"){

            public void actionPerformed(ActionEvent e) {
                if (!StackDialog.this.replicateList.isSelectionEmpty()) {
                    Object[] values = StackDialog.this.replicateList.getSelectedValues();
                    int[] indices = StackDialog.this.replicateList.getSelectedIndices();
                    StackDialog.this.replicateList.getSelectionModel().clearSelection();
                    StackDialog.this.replicateListModel.removeListDataListeners();
                    for (int i = 0; i < indices.length; ++i) {
                        String name = ((NodeDialog.ColumnInformationObject)values[i]).getText();
                        StackDialog.this.inReplicateList.remove(name);
                        StackDialog.this.replicateListModel.removeElementAt(indices[i] - i);
                    }
                    StackDialog.this.replicateListModel.undoRemoveListDataListeners();
                    StackDialog.this.replicateListModel.listContentsChanged();
                    indices = null;
                    Object var2_2 = null;
                }
            }
        };
    }

    public JPanel createOptionsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.getSelectColumnsPanel(), "Center");
        panel.add((Component)this.getOptionsPanel(), "South");
        return panel;
    }

    private JPanel getSelectColumnsPanel() {
        JPanel selectColumnsPanel = new JPanel(new GridBagLayout());
        selectColumnsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("StackDialog_selectColumns")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel availableLabel = new JLabel(MinerApp.getText("StackDialog_availableColumns"));
        availableLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.availableListModel = new NodeDialog.DNDListModel();
        this.availableList = new NodeDialog.DNDList(this.availableListModel);
        NodeDialog.ColumnInformationRenderer renderer = new NodeDialog.ColumnInformationRenderer();
        this.availableList.setCellRenderer(renderer);
        this.availableList.setSelectionMode(2);
        this.availableScrollPane = new NodeDialog.SortingScrollPane(this.availableList);
        this.availableScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        constraints.gridheight = 1;
        constraints.gridwidth = 5;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        constraints.anchor = 17;
        selectColumnsPanel.add((Component)availableLabel, constraints);
        constraints.gridy = 1;
        constraints.gridheight = 17;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        selectColumnsPanel.add((Component)this.availableScrollPane, constraints);
        JButton addStackButton = new JButton(this.addStackAction);
        JButton removeStackButton = new JButton(this.removeStackAction);
        JButton addReplicateButton = new JButton(this.addReplicateAction);
        JButton removeReplicateButton = new JButton(this.removeReplicateAction);
        constraints.gridx = 5;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(3, 10, 3, 10);
        constraints.fill = 0;
        selectColumnsPanel.add((Component)addStackButton, constraints);
        constraints.gridy = 2;
        selectColumnsPanel.add((Component)removeStackButton, constraints);
        constraints.gridy = 7;
        selectColumnsPanel.add((Component)addReplicateButton, constraints);
        constraints.gridy = 8;
        selectColumnsPanel.add((Component)removeReplicateButton, constraints);
        JLabel stackLabel = new JLabel(MinerApp.getText("StackDialog_stackColumns"));
        stackLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.stackListModel = new NodeDialog.DNDListModel();
        this.stackList = new NodeDialog.DNDList(this.stackListModel);
        this.stackList.setCellRenderer(renderer);
        this.stackScrollPane = new NodeDialog.SortingScrollPane(this.stackList);
        this.stackScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        JLabel replicateLabel = new JLabel(MinerApp.getText("StackDialog_replicateColumns"));
        replicateLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.replicateListModel = new NodeDialog.DNDListModel();
        this.replicateList = new NodeDialog.DNDList(this.replicateListModel);
        this.replicateList.setCellRenderer(renderer);
        this.replicateScrollPane = new NodeDialog.SortingScrollPane(this.replicateList);
        this.replicateScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        constraints.gridx = 6;
        constraints.gridy = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 5;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.anchor = 17;
        constraints.fill = 1;
        selectColumnsPanel.add((Component)stackLabel, constraints);
        constraints.gridy = 1;
        constraints.gridheight = 4;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        selectColumnsPanel.add((Component)this.stackScrollPane, constraints);
        constraints.gridy = 6;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        selectColumnsPanel.add((Component)replicateLabel, constraints);
        constraints.gridy = 7;
        constraints.gridheight = 4;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        selectColumnsPanel.add((Component)this.replicateScrollPane, constraints);
        return selectColumnsPanel;
    }

    private JPanel getOptionsPanel() {
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        optionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("StackDialog_options")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.includeGroupCheckBox = new JCheckBox(MinerApp.getText("StackDialog_includeGroupColumn"));
        this.includeGroupCheckBox.setMnemonic(MinerApp.getText("StackDialog_includeGroupHotkey").charAt(0));
        JLabel stackColumnLabel = new JLabel(MinerApp.getText("StackDialog_stackColumnName"));
        this.stackColumnTextField = new JTextField(10);
        stackColumnLabel.setDisplayedMnemonic(MinerApp.getText("StackDialog_stackColumnHotkey").charAt(0));
        stackColumnLabel.setLabelFor(this.stackColumnTextField);
        JLabel groupColumnLabel = new JLabel(MinerApp.getText("StackDialog_groupColumnName"));
        this.groupColumnTextField = new JTextField(10);
        groupColumnLabel.setDisplayedMnemonic(MinerApp.getText("StackDialog_groupColumnHotkey").charAt(0));
        groupColumnLabel.setLabelFor(this.groupColumnTextField);
        this.includeGroupCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StackDialog.this.groupColumnTextField.setEnabled(StackDialog.this.includeGroupCheckBox.isSelected());
            }
        });
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        optionsPanel.add((Component)stackColumnLabel, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 15, 0, 0);
        optionsPanel.add((Component)this.stackColumnTextField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 0.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        optionsPanel.add((Component)this.includeGroupCheckBox, constraints);
        constraints.gridy = 2;
        constraints.insets = new Insets(0, 15, 5, 0);
        optionsPanel.add((Component)new JLabel(MinerApp.getText("StackDialog_groupColumnName")), constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        optionsPanel.add((Component)this.groupColumnTextField, constraints);
        return optionsPanel;
    }
}

