/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.SetRolesPanelBase;
import com.insightful.miner.TransposeEngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class TransposeDialog
extends NodeDialog {
    private TransposeSetRolesPanel setRolesPanel;
    private JTextField maxRowsTextField;
    private static TransposeDialog instance = null;

    public static TransposeDialog getInstance() {
        if (instance == null) {
            instance = new TransposeDialog();
        }
        return instance;
    }

    private TransposeDialog() {
        Dimension dim = new Dimension(510, 500);
        this.setMinimumSize(dim);
        this.setSize(dim);
        this.setResizable(true);
    }

    public void restoreProperties() {
        super.restoreProperties();
        this.setRolesPanel.restoreProperties(this.getNodeModel());
        int mrows = this.getNodeModel().getXTProps().getInt(TransposeEngineNode.MAX_ROWS_ATTRIBUTE_TAG, TransposeEngineNode.DEFAULT_MAX_ROWS);
        this.maxRowsTextField.setText(Integer.toString(mrows));
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        this.setRolesPanel.saveProperties(this.getNodeModel());
        String str = this.maxRowsTextField.getText();
        if (str.length() > 0) {
            this.getNodeModel().getXTProps().set(TransposeEngineNode.MAX_ROWS_ATTRIBUTE_TAG, str);
        }
    }

    public JPanel createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.setRolesPanel = new TransposeSetRolesPanel(this.okAction);
        this.maxRowsTextField = new JTextField(10);
        JLabel maxRowsLabel = new JLabel(MinerApp.getText("TransposeDialog_maxRows"));
        maxRowsLabel.setDisplayedMnemonic(MinerApp.getText("TransposeDialog_maxRowsHotkey").charAt(0));
        maxRowsLabel.setLabelFor(this.maxRowsTextField);
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        optionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("TransposeDialog_overflow")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.gridy = 0;
        gbc.gridx = 0;
        optionsPanel.add((Component)maxRowsLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        optionsPanel.add((Component)this.maxRowsTextField, gbc);
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridy = 0;
        gbc.gridx = 0;
        panel.add((Component)this.setRolesPanel, gbc);
        gbc.weighty = 0.0;
        ++gbc.gridy;
        panel.add((Component)optionsPanel, gbc);
        return panel;
    }

    private class TransposeSetRolesPanel
    extends SetRolesPanelBase {
        private NodeDialog.DNDListModel dependentListModel;
        private JList dependentList;
        private static final String tIndependentString = "TransposeDialog_transposeColumns";
        private static final String dependentString = "TransposeDialog_columnNames";
        private static final String addDependentString = ">>";
        private static final String removeDependentString = "<<";
        protected AbstractAction addDependentAction;
        protected AbstractAction removeDependentAction;

        public TransposeSetRolesPanel(AbstractAction okAction) {
            super(false);
            this.createLayout();
        }

        public void restoreProperties(ActivityNodeModel model) {
            this.independentListModel.removeAllElements();
            this.dependentListModel.removeAllElements();
            this.availableListModel.removeAllElements();
            XTProps props = model.getXTProps();
            XTMetaData metaData = null;
            try {
                metaData = model.getInputMetaData(0);
            }
            catch (Exception e) {
                AcceleratorOptionPane.showOKDialog(this, MinerApp.getText("NodeDialog_cannotRestoreProperties"), MinerApp.getText("NodeDialog_propertiesNotRestored"), 0);
                e.printStackTrace();
                return;
            }
            Vector names = metaData.getColumnNames();
            Vector types = metaData.getColumnTypes();
            Vector roles = metaData.getColumnRoles();
            Vector propNames = props.getSubProperties("columnRoles");
            Vector propRoles = props.getSubPropertyValues("columnRoles");
            int size = names.size();
            for (int i = 0; i < size; ++i) {
                String type = (String)types.get(i);
                String name = (String)names.get(i);
                NodeDialog.ModelTerm term = new NodeDialog.ModelTerm(name, type, (String)roles.get(i), i);
                int index = propNames.indexOf(name);
                if (index == -1) {
                    this.availableListModel.addElement(term);
                    continue;
                }
                String propRole = (String)propRoles.get(index);
                if (propRole.equals(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG)) {
                    if (this.dependentListModel.isEmpty() && (type.equals(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG) || type.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG))) {
                        this.dependentListModel.addElement(term);
                        continue;
                    }
                    this.availableListModel.addElement(term);
                    continue;
                }
                if (propRole.equals(XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG)) {
                    this.independentListModel.addElement(term);
                    continue;
                }
                this.availableListModel.addElement(term);
            }
        }

        public void saveProperties(ActivityNodeModel model) {
            this.availableListModel.removeAllElements();
            super.saveProperties(model);
            XTProps props = model.getXTProps();
            NodeDialog.ColumnInformationObject object = null;
            if (!this.dependentListModel.isEmpty()) {
                object = (NodeDialog.ColumnInformationObject)this.dependentListModel.firstElement();
                props.set("columnRoles", object.getText(), XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG);
            }
        }

        public void createActions() {
            this.addIndependentAction = new AbstractAction(addDependentString){

                public void actionPerformed(ActionEvent e) {
                    if (!TransposeSetRolesPanel.this.availableList.isSelectionEmpty()) {
                        int i;
                        TransposeSetRolesPanel.this.availableListModel.removeListDataListeners();
                        TransposeSetRolesPanel.this.independentListModel.removeListDataListeners();
                        Object[] vals = TransposeSetRolesPanel.this.availableList.getSelectedValues();
                        int[] ind = TransposeSetRolesPanel.this.availableList.getSelectedIndices();
                        TransposeSetRolesPanel.this.availableList.getSelectionModel().clearSelection();
                        String acceptableType = ((NodeDialog.ColumnInformationObject)vals[0]).getType();
                        if (!TransposeSetRolesPanel.this.independentListModel.isEmpty()) {
                            acceptableType = ((NodeDialog.ColumnInformationObject)TransposeSetRolesPanel.this.independentListModel.get(0)).getType();
                        }
                        for (i = 0; i < vals.length; ++i) {
                            NodeDialog.ColumnInformationObject obj = (NodeDialog.ColumnInformationObject)vals[i];
                            if (obj.getType().equals(acceptableType)) {
                                TransposeSetRolesPanel.this.independentListModel.addElement(obj);
                                continue;
                            }
                            ind[i] = -1;
                        }
                        vals = null;
                        for (i = ind.length - 1; i >= 0; --i) {
                            if (ind[i] <= -1) continue;
                            TransposeSetRolesPanel.this.availableListModel.removeElementAt(ind[i]);
                        }
                        ind = null;
                        TransposeSetRolesPanel.this.availableListModel.undoRemoveListDataListeners();
                        TransposeSetRolesPanel.this.independentListModel.undoRemoveListDataListeners();
                        TransposeSetRolesPanel.this.repaint();
                        TransposeSetRolesPanel.this.availableListModel.listContentsChanged();
                        TransposeSetRolesPanel.this.independentListModel.listContentsChanged();
                    }
                }
            };
            this.removeIndependentAction = new AbstractAction(removeDependentString){

                public void actionPerformed(ActionEvent e) {
                    if (!TransposeSetRolesPanel.this.independentList.isSelectionEmpty()) {
                        Object[] values = TransposeSetRolesPanel.this.independentList.getSelectedValues();
                        int[] indices = TransposeSetRolesPanel.this.independentList.getSelectedIndices();
                        TransposeSetRolesPanel.this.independentList.getSelectionModel().clearSelection();
                        TransposeSetRolesPanel.this.independentListModel.removeListDataListeners();
                        TransposeSetRolesPanel.this.availableListModel.removeListDataListeners();
                        for (int i = 0; i < values.length; ++i) {
                            TransposeSetRolesPanel.this.independentListModel.removeElementAt(indices[i] - i);
                            TransposeSetRolesPanel.this.availableListModel.addElement(values[i]);
                        }
                        TransposeSetRolesPanel.this.independentListModel.undoRemoveListDataListeners();
                        TransposeSetRolesPanel.this.availableListModel.undoRemoveListDataListeners();
                        TransposeSetRolesPanel.this.availableScrollPane.sort();
                        TransposeSetRolesPanel.this.repaint();
                        TransposeSetRolesPanel.this.independentListModel.listContentsChanged();
                        TransposeSetRolesPanel.this.availableListModel.listContentsChanged();
                        indices = null;
                        Object var2_2 = null;
                    }
                }
            };
            this.addDependentAction = new AbstractAction(addDependentString){

                public void actionPerformed(ActionEvent e) {
                    if (!TransposeSetRolesPanel.this.availableList.isSelectionEmpty()) {
                        Object[] vals = TransposeSetRolesPanel.this.availableList.getSelectedValues();
                        int[] ind = TransposeSetRolesPanel.this.availableList.getSelectedIndices();
                        TransposeSetRolesPanel.this.availableList.getSelectionModel().clearSelection();
                        for (int i = 0; i < vals.length; ++i) {
                            NodeDialog.ColumnInformationObject obj = (NodeDialog.ColumnInformationObject)vals[i];
                            String type = obj.getType();
                            if (!type.equals(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG) && !type.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG)) continue;
                            TransposeSetRolesPanel.this.dependentListModel.addElement(obj);
                            TransposeSetRolesPanel.this.availableListModel.removeElementAt(ind[i]);
                            break;
                        }
                        TransposeSetRolesPanel.this.repaint();
                        TransposeSetRolesPanel.this.availableListModel.listContentsChanged();
                        TransposeSetRolesPanel.this.dependentListModel.listContentsChanged();
                    }
                }
            };
            this.removeDependentAction = new AbstractAction(removeDependentString){

                public void actionPerformed(ActionEvent e) {
                    int selectedIndex;
                    if (TransposeSetRolesPanel.this.dependentListModel.getSize() > 0 && (selectedIndex = TransposeSetRolesPanel.this.dependentList.getSelectedIndex()) >= 0) {
                        TransposeSetRolesPanel.this.dependentList.getSelectionModel().clearSelection();
                        NodeDialog.ColumnInformationObject selectedObject = (NodeDialog.ColumnInformationObject)TransposeSetRolesPanel.this.dependentListModel.getElementAt(selectedIndex);
                        TransposeSetRolesPanel.this.dependentListModel.removeElementAt(selectedIndex);
                        TransposeSetRolesPanel.this.availableListModel.addElement(selectedObject);
                        TransposeSetRolesPanel.this.availableScrollPane.sort();
                        TransposeSetRolesPanel.this.repaint();
                    }
                }
            };
            this.autoFillAction = new AbstractAction("Auto >>"){

                public void actionPerformed(ActionEvent e) {
                    NodeDialog.ColumnInformationObject object;
                    int i;
                    Object[] values = TransposeSetRolesPanel.this.availableListModel.toArray();
                    TransposeSetRolesPanel.this.availableListModel.removeAllElements();
                    TransposeSetRolesPanel.this.availableListModel.removeListDataListeners();
                    TransposeSetRolesPanel.this.independentListModel.removeListDataListeners();
                    boolean anyMoved = false;
                    for (i = 0; i < values.length; ++i) {
                        object = (NodeDialog.ColumnInformationObject)values[i];
                        String role = object.getRole();
                        String type = object.getType();
                        if (role.equals(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG)) {
                            if (TransposeSetRolesPanel.this.dependentListModel.getSize() == 0 && (type.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG) || type.equals(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG))) {
                                anyMoved = true;
                                TransposeSetRolesPanel.this.dependentListModel.addElement(object);
                                continue;
                            }
                            TransposeSetRolesPanel.this.availableListModel.addElement(object);
                            continue;
                        }
                        if (role.equals(XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG)) {
                            anyMoved = true;
                            TransposeSetRolesPanel.this.independentListModel.addElement(object);
                            continue;
                        }
                        TransposeSetRolesPanel.this.availableListModel.addElement(object);
                    }
                    if (!anyMoved) {
                        TransposeSetRolesPanel.this.availableListModel.removeAllElements();
                        for (i = 0; i < values.length; ++i) {
                            object = (NodeDialog.ColumnInformationObject)values[i];
                            String type = object.getType();
                            if (type.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG) || type.equals(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG)) {
                                if (TransposeSetRolesPanel.this.dependentListModel.getSize() == 0) {
                                    TransposeSetRolesPanel.this.dependentListModel.addElement(object);
                                    continue;
                                }
                                TransposeSetRolesPanel.this.availableListModel.addElement(object);
                                continue;
                            }
                            if (type.equals(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG)) {
                                TransposeSetRolesPanel.this.independentListModel.addElement(object);
                                continue;
                            }
                            TransposeSetRolesPanel.this.availableListModel.addElement(object);
                        }
                    }
                    TransposeSetRolesPanel.this.availableListModel.undoRemoveListDataListeners();
                    TransposeSetRolesPanel.this.independentListModel.undoRemoveListDataListeners();
                    TransposeSetRolesPanel.this.availableListModel.listContentsChanged();
                    TransposeSetRolesPanel.this.independentListModel.listContentsChanged();
                }
            };
        }

        private void createLayout() {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("SetRolesPanel_variables")), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
            NodeDialog.ColumnInformationRenderer renderer = new NodeDialog.ColumnInformationRenderer();
            this.addAvailableScrollPane(this, renderer, 0, 0);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 6;
            constraints.gridy = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.fill = 0;
            constraints.insets = new Insets(0, 5, 0, 5);
            this.add((Component)new JButton(this.removeDependentAction), constraints);
            constraints.gridx = 8;
            this.add((Component)new JButton(this.addDependentAction), constraints);
            JLabel dependentLabel = new JLabel(MinerApp.getText(dependentString) + ":");
            dependentLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            this.dependentListModel = new NodeDialog.DNDListModel();
            this.dependentList = new NodeDialog.DNDList(this.dependentListModel);
            this.dependentList.setCellRenderer(renderer);
            this.dependentList.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 8 && TransposeSetRolesPanel.this.removeDependentAction.isEnabled()) {
                        TransposeSetRolesPanel.this.removeDependentAction.actionPerformed(new ActionEvent(TransposeSetRolesPanel.this, 0, "Remove"));
                    }
                }
            });
            JScrollPane dependentScrollPane = new JScrollPane(this.dependentList);
            dependentScrollPane.setPreferredSize(new Dimension(125, 20));
            dependentScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
            dependentScrollPane.setHorizontalScrollBarPolicy(31);
            dependentScrollPane.setVerticalScrollBarPolicy(21);
            constraints.gridx = 10;
            constraints.gridy = 0;
            constraints.gridwidth = 5;
            constraints.anchor = 11;
            constraints.insets = new Insets(0, 0, 0, 0);
            constraints.fill = 1;
            this.add((Component)dependentLabel, constraints);
            constraints.gridy = 1;
            this.add((Component)dependentScrollPane, constraints);
            this.addIndependentScrollPane(this, renderer, 6, 2, MinerApp.getText(tIndependentString));
        }
    }
}

