/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.dndtree;

import com.insightful.miner.dndtree.Copyable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.tree.DefaultMutableTreeNode;

public class SubTreeNode
implements Serializable {
    protected Object m_contents;
    protected SubTreeNode[] m_arrChildren;

    public Object getContents() {
        return this.m_contents;
    }

    void setContents(Object ob) {
        this.m_contents = ob;
    }

    public SubTreeNode(DefaultMutableTreeNode node, boolean include_subtree) {
        this.m_contents = node.getUserObject();
        if (include_subtree) {
            this.m_arrChildren = new SubTreeNode[node.getChildCount()];
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.m_arrChildren[i] = new SubTreeNode((DefaultMutableTreeNode)node.getChildAt(i), true);
            }
        }
    }

    public DefaultMutableTreeNode createNode() {
        Object new_contents = this.getContents() instanceof Copyable ? ((Copyable)this.getContents()).copy() : this.getContents();
        DefaultMutableTreeNode retval = new DefaultMutableTreeNode(new_contents);
        if (this.m_arrChildren != null) {
            for (int i = 0; i < this.m_arrChildren.length; ++i) {
                retval.insert(this.m_arrChildren[i].createNode(), i);
            }
        }
        return retval;
    }

    public File toFile(File parent) throws IOException {
        File f = new File(parent, this.getContents().toString());
        f.createNewFile();
        if (this.m_arrChildren.length > 0) {
            f.mkdir();
            for (int i = 0; i < this.m_arrChildren.length; ++i) {
                this.m_arrChildren[i].toFile(f);
            }
        }
        return f;
    }

    public String toString() {
        if (this.m_contents != null) {
            return this.m_contents.toString();
        }
        return super.toString();
    }

    void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }
}

