/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.graphdlg.controls;

import com.insightful.miner.graphdlg.controls.MinerControlMethods;
import com.insightful.miner.graphdlg.controls.MinerLabelBox;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;

public class MinerComboBox
extends MinerLabelBox
implements MinerControlMethods {
    JComboBox comboBox;
    private InnerComboBoxModel dataModel;
    private String[] prependString = null;
    private String[] appendString = null;

    public MinerComboBox() {
        this("", new String[]{""});
    }

    public MinerComboBox(String text) {
        this(text, new String[]{""});
    }

    public MinerComboBox(String text, char mnemonic) {
        this(text, new String[]{""});
        this.setMnemonic(mnemonic);
    }

    public MinerComboBox(String text, int mnemonic) {
        this(text, new String[]{""});
        this.setMnemonic(mnemonic);
    }

    public MinerComboBox(String text, char mnemonic, String[] listData) {
        this(text, listData);
        this.setMnemonic(mnemonic);
    }

    public MinerComboBox(String text, int mnemonic, String[] listData) {
        this(text, listData);
        this.setMnemonic(mnemonic);
    }

    public MinerComboBox(String text, String[] listData) {
        super(text);
        this.dataModel = new InnerComboBoxModel(listData);
        this.comboBox = new JComboBox(this.dataModel);
        this.comboBox.setPreferredSize(labelDimension);
        this.comboBox.setMinimumSize(labelDimension);
        this.comboBox.setEditable(true);
        this.comboBox.setMaximumRowCount(7);
        this.setActionControl(this.comboBox);
    }

    public synchronized String getValue() {
        String value = "";
        Object currentItem = this.comboBox.getSelectedItem();
        if (currentItem != null) {
            value = currentItem.toString();
        }
        if (value.endsWith("\\") && !value.endsWith("\\\\")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    public synchronized void setValue(String value) {
        this.comboBox.setSelectedItem(value);
    }

    public synchronized int getSelectedIndex() {
        return this.comboBox.getSelectedIndex();
    }

    public synchronized void setSelectedIndex(int anIndex) {
        this.comboBox.setSelectedIndex(anIndex);
    }

    public synchronized String[] getOptionList() {
        ComboBoxModel listModel = this.comboBox.getModel();
        int listSize = listModel.getSize();
        String[] stringArray = new String[listSize];
        for (int i = 0; i < listSize; ++i) {
            stringArray[i] = (String)listModel.getElementAt(i);
        }
        return stringArray;
    }

    public synchronized void setOptionList(String[] listData) {
        int i;
        Vector<String> listVector = new Vector<String>();
        if (this.prependString != null) {
            for (i = 0; i < this.prependString.length; ++i) {
                listVector.add(this.prependString[i]);
            }
        }
        if (listData != null) {
            for (i = 0; i < listData.length; ++i) {
                listVector.add(listData[i]);
            }
        }
        if (this.appendString != null) {
            for (i = 0; i < this.appendString.length; ++i) {
                listVector.add(this.appendString[i]);
            }
        }
        this.dataModel.setListData(listVector);
    }

    public boolean isEnabled() {
        return this.comboBox.isEnabled();
    }

    public void setEnabled(boolean b) {
        this.comboBox.setEnabled(b);
        this.setLabelEnabled(b);
    }

    public void addActionListener(ActionListener listener) {
        this.comboBox.addActionListener(listener);
    }

    public void addItemListener(ItemListener listener) {
        this.comboBox.addItemListener(listener);
    }

    public String getActionCommand() {
        return this.comboBox.getActionCommand();
    }

    public void setActionCommand(String aCommand) {
        this.comboBox.setActionCommand(aCommand);
    }

    public void setPrepend(String[] str) {
        this.prependString = str;
        this.setOptionList(this.getOptionList());
    }

    public String[] getPrepend() {
        return this.prependString;
    }

    public void setAppend(String[] str) {
        this.appendString = str;
        this.setOptionList(this.getOptionList());
    }

    public String[] getAppend() {
        return this.appendString;
    }

    public boolean isEditable() {
        return this.comboBox.isEditable();
    }

    public void setEditable(boolean aFlag) {
        this.comboBox.setEditable(aFlag);
    }

    private class InnerComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private Vector objects;
        private Object selectedObject;

        InnerComboBoxModel() {
            this.objects = new Vector();
        }

        InnerComboBoxModel(Object[] items) {
            this.objects = new Vector();
            this.objects.ensureCapacity(items.length);
            int c = items.length;
            for (int i = 0; i < c; ++i) {
                this.objects.addElement(items[i]);
            }
            if (this.getSize() > 0) {
                this.selectedObject = this.getElementAt(0);
            }
        }

        InnerComboBoxModel(Vector v) {
            this.objects = v;
            if (this.getSize() > 0) {
                this.selectedObject = this.getElementAt(0);
            }
        }

        public void setSelectedItem(Object anObject) {
            if (this.selectedObject != null && !this.selectedObject.equals(anObject) || this.selectedObject == null && anObject != null) {
                this.selectedObject = anObject;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            return this.selectedObject;
        }

        public int getSize() {
            return this.objects.size();
        }

        public Object getElementAt(int index) {
            if (index >= 0 && index < this.objects.size()) {
                return this.objects.elementAt(index);
            }
            return null;
        }

        public void setListData(Vector v) {
            this.objects = v;
            if (!this.objects.contains(this.selectedObject)) {
                this.selectedObject = null;
            }
            this.fireContentsChanged(this, -1, -1);
        }
    }
}

