/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.graphdlg.controls;

import com.insightful.miner.graphdlg.controls.MinerComboBox;
import com.insightful.miner.graphdlg.controls.MinerControlMethods;
import com.insightful.miner.graphdlg.controls.MinerDataColumnListProvider;
import com.insightful.miner.graphdlg.controls.MinerObjectComboBox;
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.SplusSystem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class MinerDataSetComboBox
extends MinerComboBox
implements MinerDataColumnListProvider {
    static String[] dataSetList = null;
    Vector registeredColumnControls = new Vector();
    String[] columnList = new String[]{""};

    public MinerDataSetComboBox() {
        this("Data Set:");
        this.setMnemonic('D');
    }

    public MinerDataSetComboBox(String text, char mnemonic) {
        this(text);
        this.setMnemonic(mnemonic);
    }

    public MinerDataSetComboBox(String text, int mnemonic) {
        this(text);
        this.setMnemonic(mnemonic);
    }

    public MinerDataSetComboBox(String text) {
        super(text);
        if (dataSetList == null) {
            MinerDataSetComboBox.updateDataSetList();
        }
        this.setOptionList(dataSetList);
        this.setValue(MinerDataSetComboBox.getCurrentDataSet());
        this.updateColumnList();
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MinerDataSetComboBox.this.updateColumnList();
                MinerDataSetComboBox.this.updateRegisteredColumnControls();
            }
        });
    }

    public static final String getCurrentDataSet() {
        return "";
    }

    public static final String[] getDataSetList() {
        if (dataSetList == null) {
            MinerDataSetComboBox.updateDataSetList();
        }
        return dataSetList;
    }

    public static final void updateDataSetList() {
        dataSetList = MinerObjectComboBox.getObjectsOfClass("data.frame", true);
    }

    public String[] getColumnList() {
        return this.columnList;
    }

    private void updateColumnList() {
        String currentValue = this.getValue();
        if (currentValue != null && currentValue != "") {
            String expression = "if (exists(\"" + currentValue + "\") && inherits(" + currentValue + ",\"data.frame\")){ names(" + currentValue + ")} else { \"\"}";
            try {
                SplusDataResult answer = SplusSystem.getEngineQueryHandler().processDataQuery(expression);
                this.columnList = answer.getStringData();
            }
            catch (Exception e) {}
        } else {
            this.columnList = new String[]{""};
        }
    }

    public void registerColumnControl(MinerControlMethods control) {
        this.registeredColumnControls.add(control);
    }

    private void updateRegisteredColumnControls() {
        for (int i = 0; i < this.registeredColumnControls.size(); ++i) {
            MinerControlMethods control = (MinerControlMethods)this.registeredColumnControls.elementAt(i);
            control.setOptionList(this.columnList);
            control.setValue("");
        }
    }
}

