/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.sql;

import com.insightful.miner.sql.Binary;
import com.insightful.miner.sql.Column;
import com.insightful.miner.sql.Expression;
import com.insightful.miner.sql.HsqlException;
import com.insightful.miner.sql.JavaObject;
import com.insightful.miner.sql.Library;
import com.insightful.miner.sql.Result;
import com.insightful.miner.sql.TableFilter;
import com.insightful.miner.sql.Trace;
import com.insightful.miner.sql.Types;
import com.insightful.miner.sql.lib.HashMap;
import com.insightful.miner.sql.lib.HsqlArrayList;
import com.insightful.miner.sql.lib.StringConverter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;

class Function {
    private String sFunction;
    Method mMethod;
    private Class cReturnClass;
    private Class[] aArgClasses;
    private int iReturnType;
    private int iArgCount;
    private int iSqlArgCount;
    private int iSqlArgStart;
    private int[] iArgType;
    private boolean[] bArgNullable;
    Expression[] eArg;
    private boolean bConnection;
    private static HashMap methodCache = new HashMap();
    private int fID;
    String name;
    boolean isSimple;
    boolean hasAggregate;

    Function(String name, String fqn, boolean isSimple) throws HsqlException {
        this.name = name;
        this.isSimple = isSimple;
        this.sFunction = fqn;
        this.fID = Library.functionID(fqn);
        int i = fqn.lastIndexOf(46);
        Trace.check(i != -1, 11, fqn);
        String classname = fqn.substring(0, i);
        this.mMethod = (Method)methodCache.get(fqn);
        if (this.mMethod == null) {
            String methodname = fqn.substring(i + 1);
            Class<?> classinstance = null;
            try {
                classinstance = Class.forName(classname);
            }
            catch (Exception e) {
                throw Trace.error(42, 115, new Object[]{classname, e});
            }
            Method[] methods = classinstance.getMethods();
            for (i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                if (!m.getName().equals(methodname) || !Modifier.isStatic(m.getModifiers())) continue;
                this.mMethod = m;
                break;
            }
            Trace.check(this.mMethod != null, 13, methodname);
            methodCache.put(fqn, this.mMethod);
        }
        this.cReturnClass = this.mMethod.getReturnType();
        this.iReturnType = this.cReturnClass.equals(Result.class) ? 1111 : Types.getParameterTypeNr(this.cReturnClass);
        this.aArgClasses = this.mMethod.getParameterTypes();
        this.iArgCount = this.aArgClasses.length;
        this.iArgType = new int[this.iArgCount];
        this.bArgNullable = new boolean[this.iArgCount];
        for (i = 0; i < this.aArgClasses.length; ++i) {
            Class a = this.aArgClasses[i];
            String type = a.getName();
            if (i == 0 && a.equals(Connection.class)) {
                this.bConnection = true;
                continue;
            }
            this.iArgType[i] = Types.getParameterTypeNr(a);
            this.bArgNullable[i] = !a.isPrimitive();
        }
        this.iSqlArgCount = this.iArgCount;
        if (this.bConnection) {
            --this.iSqlArgCount;
            this.iSqlArgStart = 1;
        } else {
            this.iSqlArgStart = 0;
        }
        this.eArg = new Expression[this.iArgCount];
    }

    Object getValue() throws HsqlException {
        Object[] oArg = this.getArguments();
        if (oArg == null) {
            return null;
        }
        return this.getValue(oArg);
    }

    Object getValue(Object[] arguments) throws HsqlException {
        if (this.bConnection) {
            // empty if block
        }
        try {
            Object ret = this.fID >= 0 ? Library.invoke(this.fID, arguments) : this.mMethod.invoke(null, arguments);
            return Column.convertObject(ret, this.iReturnType);
        }
        catch (InvocationTargetException e1) {
            Throwable t = e1.getTargetException();
            String s = this.sFunction + " : " + t.toString();
            throw Trace.error(198, s);
        }
        catch (IllegalAccessException e3) {
            throw Trace.error(198);
        }
    }

    private Object[] getArguments() throws HsqlException {
        Object[] oArg = new Object[this.iArgCount];
        for (int i = this.bConnection ? 1 : 0; i < this.iArgCount; ++i) {
            Expression e = this.eArg[i];
            Object o = null;
            if (e != null) {
                o = e.getValue(this.iArgType[i]);
            }
            if (o == null && !this.bArgNullable[i]) {
                return null;
            }
            if (o instanceof JavaObject) {
                o = ((JavaObject)o).getObject();
            } else if (o instanceof Binary) {
                o = ((Binary)o).getBytes();
            }
            oArg[i] = o;
        }
        return oArg;
    }

    private Object[] getNotNull(Object[] values) throws HsqlException {
        int i;
        int n = i = this.bConnection ? 1 : 0;
        while (i < this.iArgCount) {
            Object o = values[i];
            if (o == null && !this.bArgNullable[i]) {
                return null;
            }
            ++i;
        }
        return values;
    }

    Object getAggregatedValue(Object currValue) throws HsqlException {
        Object[] valueArray = (Object[])currValue;
        if (valueArray == null) {
            valueArray = new Object[this.iArgCount];
        }
        for (int i = 0; i < this.iArgCount; ++i) {
            Expression e = this.eArg[i];
            if (this.eArg[i] == null) continue;
            valueArray[i] = this.eArg[i].isAggregate() ? e.getAggregatedValue(valueArray[i]) : e.getValue();
        }
        if ((valueArray = this.getNotNull(valueArray)) == null) {
            return null;
        }
        return this.getValue(valueArray);
    }

    Object updateAggregatingValue(Object currValue) throws HsqlException {
        Object[] valueArray = (Object[])currValue;
        if (valueArray == null) {
            valueArray = new Object[this.iArgCount];
        }
        for (int i = 0; i < this.iArgCount; ++i) {
            Expression e = this.eArg[i];
            if (this.eArg[i] == null) continue;
            valueArray[i] = e.updateAggregatingValue(valueArray[i]);
        }
        return valueArray;
    }

    int getArgCount() {
        return this.iSqlArgCount;
    }

    void checkTables(HsqlArrayList fa) throws HsqlException {
        for (int i = this.iSqlArgStart; i < this.iArgCount; ++i) {
            Expression e = this.eArg[i];
            if (e == null) continue;
            e.checkTables(fa);
        }
    }

    void resolveTables(TableFilter f) throws HsqlException {
        for (int i = this.iSqlArgStart; i < this.iArgCount; ++i) {
            Expression e = this.eArg[i];
            if (e == null) continue;
            e.resolveTables(f);
        }
    }

    void resolveType() throws HsqlException {
        for (int i = this.iSqlArgStart; i < this.iArgCount; ++i) {
            Expression e = this.eArg[i];
            if (e == null) continue;
            if (e.isParam()) {
                e.setDataType(this.iArgType[i]);
                e.nullability = this.getArgNullability(i);
                e.valueClassName = this.getArgClass(i).getName();
                continue;
            }
            e.resolveTypes();
        }
    }

    boolean checkResolved(boolean check) throws HsqlException {
        boolean result = true;
        for (int i = this.iSqlArgStart; i < this.iArgCount; ++i) {
            if (this.eArg[i] == null) continue;
            result = result && this.eArg[i].checkResolved(check);
        }
        return result;
    }

    int getArgType(int i) {
        return this.iArgType[i];
    }

    int getReturnType() {
        return this.iReturnType;
    }

    void setArgument(int i, Expression e) {
        if (this.bConnection) {
            ++i;
        }
        this.eArg[i] = e;
        this.hasAggregate = this.hasAggregate || e != null && e.isAggregate();
    }

    String getDLL() throws HsqlException {
        StringBuffer sb = new StringBuffer();
        String ddlName = this.name;
        if (this.isSimple) {
            return this.name;
        }
        if ("TRIM".equals(this.name)) {
            sb.append(this.name).append('(');
            boolean leading = this.eArg[2].test();
            boolean trailing = this.eArg[3].test();
            if (leading && trailing) {
                sb.append("BOTH");
            } else {
                sb.append(leading ? "LEADING" : "TRAILING");
            }
            sb.append(' ');
            String charval = (String)this.eArg[1].getValue();
            sb.append(Column.createSQLString(charval)).append(' ');
            sb.append("FROM").append(' ');
            sb.append(this.eArg[0].getDDL()).append(')');
            return sb.toString();
        }
        if (this.sFunction.equals(this.name)) {
            ddlName = StringConverter.toQuotedString(this.name, '\"', true);
        }
        sb.append(ddlName).append('(');
        for (int i = this.iSqlArgStart; i < this.eArg.length; ++i) {
            sb.append(this.eArg[i].getDDL());
            if (i >= this.eArg.length - 1) continue;
            sb.append(',');
        }
        sb.append(')');
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString()).append("=[\n");
        sb.append(this.sFunction).append("(");
        for (int i = this.iSqlArgStart; i < this.eArg.length; ++i) {
            sb.append("[").append(this.eArg[i]).append("]");
        }
        sb.append(") returns ").append(Types.getTypeString(this.getReturnType()));
        sb.append("]\n");
        return sb.toString();
    }

    Class getReturnClass() {
        return this.cReturnClass;
    }

    Class getArgClass(int i) {
        return this.aArgClasses[i];
    }

    int getArgNullability(int i) {
        return this.bArgNullable[i] ? 1 : 0;
    }
}

