/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.sql;

import com.insightful.miner.sql.Column;
import com.insightful.miner.sql.HsqlException;
import com.insightful.miner.sql.Trace;
import com.insightful.miner.sql.lib.HashSet;
import java.math.BigDecimal;
import java.math.BigInteger;

public class SetFunction {
    private HashSet distinctValues;
    private boolean isDistinct;
    private int setType;
    private int type;
    private int count;
    private long currentLong;
    private double currentDouble;
    private BigDecimal currentBigDecimal;
    private Object currentValue;
    private LongSum longSum;

    SetFunction(int setType, int type, boolean isDistinct) {
        this.setType = setType;
        this.type = type;
        if (isDistinct) {
            this.isDistinct = true;
            this.distinctValues = new HashSet();
        }
        if (type == -5 && (setType == 41 || setType == 44)) {
            this.longSum = new LongSum();
        }
    }

    void add(Object item) throws HsqlException {
        if (item == null) {
            return;
        }
        if (this.isDistinct && !this.distinctValues.add(item)) {
            return;
        }
        ++this.count;
        switch (this.setType) {
            case 40: {
                return;
            }
            case 41: 
            case 44: {
                switch (this.type) {
                    case -6: 
                    case 4: 
                    case 5: {
                        this.currentLong += (long)((Number)item).intValue();
                        return;
                    }
                    case -5: {
                        this.longSum.add(((Number)item).longValue());
                        return;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        this.currentDouble += ((Number)item).doubleValue();
                        return;
                    }
                    case 2: 
                    case 3: {
                        this.currentBigDecimal = this.currentBigDecimal == null ? (BigDecimal)item : this.currentBigDecimal.add((BigDecimal)item);
                        return;
                    }
                }
                throw Trace.error(15);
            }
            case 42: {
                if (this.currentValue == null) {
                    this.currentValue = item;
                    return;
                }
                if (Column.compare(this.currentValue, item, this.type) > 0) {
                    this.currentValue = item;
                }
                return;
            }
            case 43: {
                if (this.currentValue == null) {
                    this.currentValue = item;
                    return;
                }
                if (Column.compare(this.currentValue, item, this.type) < 0) {
                    this.currentValue = item;
                }
                return;
            }
        }
    }

    Object getValue() throws HsqlException {
        if (this.setType == 40) {
            return new Integer(this.count);
        }
        if (this.count == 0) {
            return null;
        }
        switch (this.setType) {
            case 44: {
                switch (this.type) {
                    case -6: 
                    case 4: 
                    case 5: {
                        return new Long(this.currentLong / (long)this.count);
                    }
                    case -5: {
                        long value = this.longSum.getValue().divide(BigInteger.valueOf(this.count)).longValue();
                        return new Long(value);
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return new Double(this.currentDouble / (double)this.count);
                    }
                    case 2: 
                    case 3: {
                        return this.currentBigDecimal.divide(new BigDecimal(this.count), 5);
                    }
                }
                throw Trace.error(15);
            }
            case 41: {
                switch (this.type) {
                    case -6: 
                    case 4: 
                    case 5: {
                        return new Long(this.currentLong);
                    }
                    case -5: {
                        return new BigDecimal(this.longSum.getValue());
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return new Double(this.currentDouble);
                    }
                    case 2: 
                    case 3: {
                        return this.currentBigDecimal;
                    }
                }
                throw Trace.error(15);
            }
            case 42: 
            case 43: {
                return this.currentValue;
            }
        }
        throw Trace.error(95);
    }

    static int getType(int setType, int type) throws HsqlException {
        switch (setType) {
            case 40: {
                return 4;
            }
            case 44: {
                switch (type) {
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        return -5;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return 8;
                    }
                    case 2: 
                    case 3: {
                        return 3;
                    }
                }
                return 0;
            }
            case 41: {
                switch (type) {
                    case -6: 
                    case 4: 
                    case 5: {
                        return -5;
                    }
                    case -5: {
                        return 3;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return 8;
                    }
                    case 2: 
                    case 3: {
                        return 3;
                    }
                }
                return 0;
            }
            case 42: 
            case 43: {
                return type;
            }
            case 45: 
            case 46: {
                return 8;
            }
        }
        throw Trace.error(95);
    }

    static class LongSum {
        static BigInteger multiplier = BigInteger.valueOf(0x100000000L);
        long hi;
        long lo;

        LongSum() {
        }

        void add(long value) {
            if (value != 0L) {
                if (value > 0L) {
                    this.hi += value >> 32;
                    this.lo += value & 0xFFFFFFFFL;
                } else if (value == Long.MIN_VALUE) {
                    this.hi -= 0x80000000L;
                } else {
                    long temp = (value ^ 0xFFFFFFFFFFFFFFFFL) + 1L;
                    this.hi -= temp >> 32;
                    this.lo -= temp & 0xFFFFFFFFL;
                }
            }
        }

        BigInteger getValue() throws HsqlException {
            BigInteger biglo = BigInteger.valueOf(this.lo);
            BigInteger bighi = BigInteger.valueOf(this.hi);
            BigInteger result = bighi.multiply(multiplier).add(biglo);
            return result;
        }
    }
}

