/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.preferences;

import org.eclipse.help.internal.base.remote.RemoteIC;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.preferences.AddICDialog;
import org.eclipse.help.ui.internal.preferences.EditICDialog;
import org.eclipse.help.ui.internal.preferences.IHelpContentBlockContainer;
import org.eclipse.help.ui.internal.preferences.RemoteICViewer;
import org.eclipse.help.ui.internal.preferences.RemoveICDialog;
import org.eclipse.help.ui.internal.preferences.TestConnectionDialog;
import org.eclipse.help.ui.internal.preferences.TestConnectionUtility;
import org.eclipse.help.ui.internal.preferences.ViewICPropsDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class HelpContentBlock {
    private TableViewer tableViewer;
    private Button addNewICButton;
    private Button editICButton;
    private Button removeICButton;
    private Button viewPropertiesButton;
    private Button testICConnectionButton;
    private Button enableDisableICButton;
    private IHelpContentBlockContainer container;
    private RemoteICViewer remoteICviewer = null;
    private int validated = 2;
    private int indexSelected;
    private SelectionListener selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == HelpContentBlock.this.addNewICButton) {
                HelpContentBlock.this.addNewIC();
            } else if (source == HelpContentBlock.this.editICButton) {
                HelpContentBlock.this.editICInfo();
            } else if (source == HelpContentBlock.this.removeICButton) {
                HelpContentBlock.this.removeIC();
            } else if (HelpContentBlock.this.viewPropertiesButton == source) {
                HelpContentBlock.this.viewICProperties();
            } else if (HelpContentBlock.this.testICConnectionButton == source) {
                HelpContentBlock.this.testICConnection();
            } else if (HelpContentBlock.this.enableDisableICButton == source) {
                HelpContentBlock.this.enableDisableIC();
            }
        }
    };

    public void setContainer(IHelpContentBlockContainer container) {
        this.container = container;
    }

    private void addButtonsToButtonGroup(Composite parent) {
        this.addNewICButton = this.container.createPushButton(parent, Messages.HelpContentBlock_addICTitle);
        this.addNewICButton.addSelectionListener(this.selectionListener);
        this.editICButton = this.container.createPushButton(parent, Messages.HelpContentBlock_editICTitle);
        this.editICButton.addSelectionListener(this.selectionListener);
        this.removeICButton = this.container.createPushButton(parent, Messages.HelpContentBlock_removeICTitle);
        this.removeICButton.addSelectionListener(this.selectionListener);
        this.viewPropertiesButton = this.container.createPushButton(parent, Messages.HelpContentBlock_viewICTitle);
        this.viewPropertiesButton.addSelectionListener(this.selectionListener);
        this.testICConnectionButton = this.container.createPushButton(parent, Messages.HelpContentBlock_testConnectionTitle);
        this.testICConnectionButton.addSelectionListener(this.selectionListener);
        this.enableDisableICButton = this.container.createPushButton(parent, Messages.HelpContentBlock_0);
        this.enableDisableICButton.addSelectionListener(this.selectionListener);
    }

    private void viewICProperties() {
        RemoteIC remoteic = (RemoteIC)((IStructuredSelection)this.remoteICviewer.getSelection()).getFirstElement();
        if (remoteic != null) {
            ViewICPropsDialog dialog = new ViewICPropsDialog(this.remoteICviewer.getControl().getShell(), remoteic.getName());
            dialog.setTextValues(remoteic.getName(), remoteic.getHost(), remoteic.getPort(), remoteic.getPath(), true);
            this.remoteICviewer.getTable().setSelection(this.indexSelected);
            dialog.open();
        }
    }

    private void removeIC() {
        RemoveICDialog dialog;
        RemoteIC remoteic = (RemoteIC)((IStructuredSelection)this.remoteICviewer.getSelection()).getFirstElement();
        if (remoteic != null && (dialog = new RemoveICDialog(this.remoteICviewer.getControl().getShell(), remoteic.getName())).open() == 0) {
            this.remoteICviewer.getRemoteICList().removeRemoteIC(remoteic);
        }
    }

    private void editICInfo() {
        RemoteIC remoteic = (RemoteIC)((IStructuredSelection)this.remoteICviewer.getSelection()).getFirstElement();
        if (remoteic != null) {
            EditICDialog dialog = new EditICDialog(this.remoteICviewer.getControl().getShell(), remoteic.getName());
            dialog.setTextValues(remoteic.getName(), remoteic.getHost(), remoteic.getPort(), remoteic.getPath());
            this.remoteICviewer.getTable().setSelection(this.indexSelected);
            if (dialog.open() == 0) {
                remoteic.setName(dialog.getEnteredName());
                remoteic.setHost(dialog.getEnteredHost());
                remoteic.setPath(dialog.getEnteredPath());
                remoteic.setPort(dialog.getEnteredPort());
                this.remoteICviewer.getRemoteICList().updateRemoteIC(remoteic);
            }
        }
    }

    private void addNewIC() {
        AddICDialog dialog = new AddICDialog(this.remoteICviewer.getControl().getShell());
        if (dialog.open() == 0) {
            RemoteIC remoteic = new RemoteIC(true, dialog.getEnteredName(), dialog.getEnteredHost(), dialog.getEnteredPath(), dialog.getEnteredPort());
            this.remoteICviewer.getRemoteICList().addRemoteIC(remoteic);
            int rowCount = this.remoteICviewer.getTable().getItemCount();
            this.remoteICviewer.getTable().setSelection(rowCount - 1);
            this.indexSelected = rowCount - 1;
            this.addNewICButton.setEnabled(true);
            this.removeICButton.setEnabled(true);
            this.editICButton.setEnabled(true);
            this.viewPropertiesButton.setEnabled(true);
            this.testICConnectionButton.setEnabled(true);
            this.enableDisableICButton.setText(Messages.HelpContentBlock_1);
            this.enableDisableICButton.setEnabled(true);
        }
    }

    public void testICConnection() {
        RemoteIC remoteic = (RemoteIC)((IStructuredSelection)this.remoteICviewer.getSelection()).getFirstElement();
        if (remoteic != null) {
            boolean isConnected = TestConnectionUtility.testConnection(remoteic.getHost(), remoteic.getPort(), remoteic.getPath());
            TestConnectionDialog dialog = new TestConnectionDialog(this.remoteICviewer.getControl().getShell());
            dialog.setValues(remoteic.getName(), remoteic.getHost(), remoteic.getPort(), remoteic.getPath());
            dialog.setConnectionStatus(isConnected);
            dialog.open();
        }
        this.remoteICviewer.getTable().setSelection(this.indexSelected);
    }

    public void enableDisableIC() {
        RemoteIC selectedIC = this.remoteICviewer.getRemoteICList().getRemoteICAtIndex(this.indexSelected);
        boolean isEnabled = selectedIC.isEnabled();
        if (isEnabled) {
            selectedIC.setEnabled(false);
        } else {
            selectedIC.setEnabled(true);
        }
        this.remoteICviewer.getTable().setSelection(this.indexSelected);
        this.tableSelectionChanged((IStructuredSelection)this.remoteICviewer.getTableViewer().getSelection());
        this.remoteICviewer.getRemoteICList().refreshRemoteIC(selectedIC, this.indexSelected);
    }

    private void createButtonGroup(Composite top) {
        Composite buttonGroup = new Composite(top, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonGroup.setLayout((Layout)layout);
        buttonGroup.setLayoutData((Object)new GridData(1040));
        buttonGroup.setFont(top.getFont());
        this.addButtonsToButtonGroup(buttonGroup);
    }

    private void createRemoteICTable(Composite parent) {
        this.remoteICviewer = new RemoteICViewer(parent);
    }

    public void createContents(Composite parent) {
        this.createRemoteICTable(parent);
        this.createButtonGroup(parent);
        this.tableSelectionChanged((IStructuredSelection)this.remoteICviewer.getTableViewer().getSelection());
        this.remoteICviewer.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                HelpContentBlock.this.tableSelectionChanged((IStructuredSelection)event.getSelection());
            }
        });
    }

    private void tableSelectionChanged(IStructuredSelection selection) {
        this.indexSelected = this.remoteICviewer.getTable().getSelectionIndex();
        RemoteIC selectedEntry = (RemoteIC)selection.getFirstElement();
        if (selectedEntry != null) {
            this.addNewICButton.setEnabled(true);
            this.removeICButton.setEnabled(true);
            this.editICButton.setEnabled(true);
            this.viewPropertiesButton.setEnabled(true);
            this.testICConnectionButton.setEnabled(true);
            boolean currentEnabledStatus = selectedEntry.isEnabled();
            if (this.indexSelected == -1) {
                this.enableDisableICButton.setText(Messages.HelpContentBlock_2);
                this.enableDisableICButton.setEnabled(false);
            } else if (currentEnabledStatus) {
                this.enableDisableICButton.setText(Messages.HelpContentBlock_3);
                this.enableDisableICButton.setEnabled(true);
                selectedEntry.setEnabled(true);
            } else {
                this.enableDisableICButton.setText(Messages.HelpContentBlock_4);
                this.enableDisableICButton.setEnabled(true);
                selectedEntry.setEnabled(false);
            }
        } else {
            this.restoreDefaultButtons();
        }
    }

    public void updateContainer() {
        this.validated = 0;
        this.container.update();
    }

    public boolean isValidated() {
        return this.validated >= 2;
    }

    public void setValidated() {
        this.validated = 2;
    }

    public TableViewer getHelpBlockTableViewer() {
        return this.tableViewer;
    }

    public void restoreDefaultButtons() {
        this.addNewICButton.setEnabled(true);
        this.editICButton.setEnabled(false);
        this.removeICButton.setEnabled(false);
        this.viewPropertiesButton.setEnabled(false);
        this.testICConnectionButton.setEnabled(false);
        this.enableDisableICButton.setEnabled(false);
        this.enableDisableICButton.setText(Messages.HelpContentBlock_5);
        this.indexSelected = -1;
    }

    public void disableAllButtons() {
        this.addNewICButton.setEnabled(false);
        this.editICButton.setEnabled(false);
        this.removeICButton.setEnabled(false);
        this.viewPropertiesButton.setEnabled(false);
        this.testICConnectionButton.setEnabled(false);
        this.enableDisableICButton.setEnabled(false);
        this.enableDisableICButton.setText(Messages.HelpContentBlock_6);
    }

    public RemoteICViewer getRemoteICviewer() {
        return this.remoteICviewer;
    }

    public RemoteIC[] getRemoteICList() {
        return this.remoteICviewer.getRemoteICList().getRemoteICArray();
    }
}

