/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.frameworkadmin.equinox;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import org.eclipse.core.runtime.internal.adaptor.EclipseEnvironmentInfo;
import org.eclipse.equinox.internal.frameworkadmin.equinox.Activator;
import org.eclipse.equinox.internal.frameworkadmin.equinox.EquinoxFwAdminImpl;
import org.eclipse.equinox.internal.frameworkadmin.equinox.EquinoxManipulatorImpl;
import org.eclipse.equinox.internal.frameworkadmin.equinox.Log;
import org.eclipse.equinox.internal.frameworkadmin.equinox.utils.FileUtils;
import org.eclipse.equinox.internal.frameworkadmin.utils.SimpleBundlesState;
import org.eclipse.equinox.internal.frameworkadmin.utils.Utils;
import org.eclipse.equinox.internal.provisional.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.provisional.frameworkadmin.BundlesState;
import org.eclipse.equinox.internal.provisional.frameworkadmin.ConfigData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdminRuntimeException;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class EquinoxBundlesState
implements BundlesState {
    static final long DEFAULT_TIMESTAMP = 0L;
    private static final boolean DEBUG = false;
    private static final String INTERNAL_AMD64 = "amd64";
    private static final String INTERNAL_ARCH_I386 = "i386";
    public static final String[] PROPS = new String[]{"osgi.os", "osgi.ws", "osgi.nl", "osgi.arch", "org.osgi.framework.system.packages", "osgi.resolverMode", "org.osgi.framework.executionenvironment", "osgi.resolveOptional", "osgi.genericAliases"};
    EquinoxFwAdminImpl fwAdmin = null;
    BundleContext context;
    Manipulator manipulator = null;
    Properties platfromProperties = new Properties();
    long maxId = 0L;
    StateObjectFactory soFactory = null;
    State state = null;
    static /* synthetic */ Class class$0;

    static boolean checkFullySupported() {
        return true;
    }

    static File getFwJar(LauncherData launcherData, ConfigData configData) {
        return EquinoxBundlesState.getFwJar(launcherData, configData, true);
    }

    private static File getFwJar(LauncherData launcherData, ConfigData configData, boolean checkBundleInfos) {
        File ret;
        if (launcherData.getFwJar() != null) {
            return launcherData.getFwJar();
        }
        String[] jvmArgs = launcherData.getJvmArgs();
        String location = null;
        int i = 0;
        while (i < jvmArgs.length) {
            if (jvmArgs[i].endsWith("-Dosgi.framework=")) {
                location = jvmArgs[i].substring("-Dosgi.framework=".length());
            }
            ++i;
        }
        if (location != null) {
            return new File(location);
        }
        if (checkBundleInfos && (ret = EquinoxBundlesState.getSystemBundleFromBundleInfos(configData)) != null) {
            return ret;
        }
        return null;
    }

    private static long getMaxId(State state) {
        BundleDescription[] bundleDescriptions = state.getBundles();
        long maxId = 0L;
        int i = 0;
        while (i < bundleDescriptions.length) {
            if (maxId < bundleDescriptions[i].getBundleId()) {
                maxId = bundleDescriptions[i].getBundleId();
            }
            ++i;
        }
        return maxId;
    }

    private static File getSystemBundleFromBundleInfos(BundleInfo[] bundleInfos) {
        int i = 0;
        while (i < bundleInfos.length) {
            File match = EquinoxBundlesState.isSystemBundle(bundleInfos[i]);
            if (match != null) {
                return match;
            }
            ++i;
        }
        return null;
    }

    private static File getSystemBundleFromBundleInfos(ConfigData configData) {
        BundleInfo[] bundleInfos = configData.getBundles();
        return EquinoxBundlesState.getSystemBundleFromBundleInfos(bundleInfos);
    }

    static long getTimeStamp(File fwPersistentDataLocation) {
        if (fwPersistentDataLocation == null) {
            return 0L;
        }
        File file = new File(fwPersistentDataLocation, "org.eclipse.osgi");
        if (!file.exists() || !file.isDirectory()) {
            return 0L;
        }
        long ret = file.lastModified();
        File[] lists = file.listFiles();
        if (lists == null) {
            return ret;
        }
        int i = 0;
        while (i < lists.length) {
            if (ret < lists[i].lastModified()) {
                ret = lists[i].lastModified();
            }
            ++i;
        }
        return ret;
    }

    public static File isSystemBundle(BundleInfo bundleInfo) {
        if (bundleInfo == null || bundleInfo.getLocation() == null) {
            return null;
        }
        String bundleLocation = bundleInfo.getLocation();
        if (bundleLocation.startsWith("reference:")) {
            bundleLocation = bundleLocation.substring("reference:".length());
        }
        if (bundleLocation.startsWith("file:")) {
            try {
                String[] clauses = Utils.getClausesManifestMainAttributes((String)bundleLocation, (String)"Bundle-SymbolicName");
                if (bundleLocation.indexOf("org.eclipse.osgi") > 0 && "org.eclipse.osgi".equals(Utils.getPathFromClause((String)clauses[0]))) {
                    return new File(bundleLocation.substring("file:".length()));
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    static Properties setDefaultPlatformProperties() {
        Properties platformProperties = new Properties();
        String nl = Locale.getDefault().toString();
        platformProperties.setProperty("osgi.nl", nl);
        String os = EclipseEnvironmentInfo.guessOS((String)System.getProperty("os.name"));
        platformProperties.setProperty("osgi.os", os);
        String ws = EclipseEnvironmentInfo.guessWS((String)os);
        platformProperties.setProperty("osgi.ws", ws);
        String arch = null;
        String name = FrameworkProperties.getProperty((String)"os.arch");
        arch = name.equalsIgnoreCase(INTERNAL_ARCH_I386) ? "x86" : (name.equalsIgnoreCase(INTERNAL_AMD64) ? "x86_64" : name);
        platformProperties.setProperty("osgi.arch", arch);
        platformProperties.setProperty("org.osgi.framework.system.packages", FrameworkProperties.getProperty((String)"org.osgi.framework.system.packages"));
        platformProperties.setProperty("org.osgi.framework.executionenvironment", FrameworkProperties.getProperty((String)"org.osgi.framework.executionenvironment"));
        platformProperties.setProperty("osgi.resolveOptional", "" + "true".equals(FrameworkProperties.getProperty((String)"osgi.resolveOptional")));
        return platformProperties;
    }

    EquinoxBundlesState(BundleContext context, EquinoxFwAdminImpl fwAdmin, Manipulator manipulator, boolean useFwPersistentData) {
        this.context = context;
        this.fwAdmin = fwAdmin;
        this.manipulator = fwAdmin.getManipulator();
        this.manipulator.setConfigData(manipulator.getConfigData());
        this.manipulator.setLauncherData(manipulator.getLauncherData());
        this.initialize(useFwPersistentData);
    }

    EquinoxBundlesState(BundleContext context, EquinoxFwAdminImpl fwAdmin, Manipulator manipulator, Properties platformProperties) {
        this.context = context;
        this.fwAdmin = fwAdmin;
        this.manipulator = fwAdmin.getManipulator();
        this.manipulator.setConfigData(manipulator.getConfigData());
        this.manipulator.setLauncherData(manipulator.getLauncherData());
        LauncherData launcherData = manipulator.getLauncherData();
        ConfigData configData = manipulator.getConfigData();
        BundleInfo[] bInfos = configData.getBundles();
        this.composeNewState(launcherData, configData, platformProperties, bInfos);
    }

    private void composeNewState(LauncherData launcherData, ConfigData configData, BundleInfo[] bInfos) {
        this.composeNewState(launcherData, configData, configData.getFwDependentProps(), bInfos);
    }

    private void composeNewState(LauncherData launcherData, ConfigData configData, Properties properties, BundleInfo[] bInfos) {
        File fwJar = EquinoxBundlesState.getSystemBundleFromBundleInfos(configData);
        launcherData.setFwJar(fwJar);
        this.setFwJar(fwJar);
        this.composeState(configData.getBundles(), properties, null);
        this.resolve(true);
    }

    private boolean composeState(BundleInfo[] bInfos, Dictionary props, File fwPersistentDataLocation) throws IllegalArgumentException, FrameworkAdminRuntimeException {
        BundleInfo[] infos = this.manipulator.getConfigData().getBundles();
        this.manipulator.getConfigData().setBundles(null);
        SimpleBundlesState.checkAvailability((FrameworkAdmin)this.fwAdmin);
        this.setStateObjectFactory();
        BundleDescription[] cachedInstalledBundles = null;
        this.state = null;
        boolean flagNewState = false;
        if (fwPersistentDataLocation != null) {
            this.manipulator.getConfigData().setBundles(infos);
            return false;
        }
        this.state = this.soFactory.createState(true);
        flagNewState = true;
        cachedInstalledBundles = new BundleDescription[]{};
        if (props == null) {
            this.manipulator.getConfigData().setBundles(infos);
            return false;
        }
        this.setPlatformPropertiesToState(props);
        this.setPlatformProperties(this.state);
        int i = 0;
        while (i < cachedInstalledBundles.length) {
            if (cachedInstalledBundles[i].getLocation().startsWith("initial@")) {
                String location = FileUtils.getRealLocation(this.manipulator, cachedInstalledBundles[i].getLocation(), true);
                boolean found = false;
                int j = 0;
                while (j < bInfos.length) {
                    if (bInfos[j].getLocation().equals(location)) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    this.state.removeBundle(cachedInstalledBundles[i].getBundleId());
                }
            }
            ++i;
        }
        try {
            this.maxId = this.state.getHighestBundleId();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.maxId = EquinoxBundlesState.getMaxId(this.state);
        }
        if (flagNewState) {
            int indexSystemBundle = -1;
            int j = 0;
            while (j < bInfos.length) {
                if (EquinoxBundlesState.isSystemBundle(bInfos[j]) != null) {
                    indexSystemBundle = j;
                    break;
                }
                ++j;
            }
            if (indexSystemBundle > 0) {
                BundleInfo[] newBundleInfos = new BundleInfo[bInfos.length];
                newBundleInfos[0] = bInfos[indexSystemBundle];
                System.arraycopy(bInfos, 0, newBundleInfos, 1, indexSystemBundle);
                if (indexSystemBundle < bInfos.length - 1) {
                    System.arraycopy(bInfos, indexSystemBundle + 1, newBundleInfos, indexSystemBundle + 1, bInfos.length - indexSystemBundle - 1);
                }
                bInfos = newBundleInfos;
            }
        }
        int j = 0;
        while (j < bInfos.length) {
            try {
                this.installBundle(bInfos[j]);
            }
            catch (RuntimeException e) {
                Log.log(1, this, "composeExpectedState()", "BundleInfo:" + bInfos[j], e);
            }
            ++j;
        }
        return true;
    }

    public BundleInfo convert(BundleDescription toConvert) {
        String location;
        int sl;
        boolean markedAsStarted;
        block9: {
            markedAsStarted = false;
            sl = -1;
            location = null;
            if (toConvert.getBundleId() == 0L && "org.eclipse.osgi".equals(toConvert.getSymbolicName())) {
                String symbolicNameTarget = toConvert.getSymbolicName();
                Version versionTarget = toConvert.getVersion();
                try {
                    File fwJar = this.manipulator.getLauncherData().getFwJar();
                    if (fwJar == null) break block9;
                    String fwJarLocation = fwJar.toURL().toExternalForm();
                    String[] clauses = Utils.getClausesManifestMainAttributes((String)fwJarLocation, (String)"Bundle-SymbolicName");
                    String fwJarSymbolicName = Utils.getPathFromClause((String)clauses[0]);
                    String fwJarVersionSt = Utils.getManifestMainAttributes((String)fwJarLocation, (String)"Bundle-Version");
                    if (fwJarSymbolicName.equals(symbolicNameTarget) && fwJarVersionSt.equals(versionTarget.toString())) {
                        location = fwJarLocation;
                        markedAsStarted = true;
                    }
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
                catch (FrameworkAdminRuntimeException e1) {
                    e1.printStackTrace();
                }
            } else {
                location = FileUtils.getEclipseRealLocation(this.manipulator, toConvert.getLocation());
                BundleInfo[] originalBInfos = this.manipulator.getConfigData().getBundles();
                boolean found = false;
                int i = 0;
                while (i < originalBInfos.length) {
                    if (originalBInfos[i].getLocation().equals(location)) {
                        markedAsStarted = originalBInfos[i].isMarkedAsStarted();
                        sl = this.getStartLevel(originalBInfos[i].getStartLevel());
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    markedAsStarted = false;
                    sl = -1;
                }
            }
        }
        BundleInfo result = new BundleInfo();
        result.setSymbolicName(toConvert.getSymbolicName());
        result.setVersion(toConvert.getVersion().toString());
        result.setLocation(location);
        result.setResolved(toConvert.isResolved());
        result.setMarkedAsStarted(markedAsStarted);
        result.setStartLevel(sl);
        result.setBundleId(toConvert.getBundleId());
        return result;
    }

    public BundleInfo[] convertState(BundleDescription[] bundles) {
        BundleInfo[] result = new BundleInfo[bundles.length];
        int i = 0;
        while (i < bundles.length) {
            result[i] = this.convert(bundles[i]);
            ++i;
        }
        return result;
    }

    public BundleInfo[] getExpectedState() throws FrameworkAdminRuntimeException {
        SimpleBundlesState.checkAvailability((FrameworkAdmin)this.fwAdmin);
        return this.convertState(this.state.getBundles());
    }

    Properties getPlatformProperties() {
        return this.platfromProperties;
    }

    public BundleInfo[] getPrerequisteBundles(BundleInfo bInfo) {
        HashSet<BundleDescription> set = new HashSet<BundleDescription>();
        BundleDescription bundle = this.state.getBundleByLocation(bInfo.getLocation());
        ImportPackageSpecification[] imports = bundle.getImportPackages();
        int i = 0;
        while (i < imports.length) {
            BaseDescription supplier = imports[i].getSupplier();
            if (supplier == null) {
                if (!imports[i].getDirective("resolution").equals("optional")) {
                    throw new IllegalStateException("Internal error: import supplier should not be null");
                }
            } else {
                set.add(supplier.getSupplier());
            }
            ++i;
        }
        BundleDescription[] requires = bundle.getResolvedRequires();
        int i2 = 0;
        while (i2 < requires.length) {
            set.add(requires[i2]);
            ++i2;
        }
        BundleDescription[] bundles = new BundleDescription[set.size()];
        set.toArray(bundles);
        return this.convertState(bundles);
    }

    private int getStartLevel(int startLevel) {
        return startLevel == -1 ? this.manipulator.getConfigData().getInitialBundleStartLevel() : startLevel;
    }

    public BundleInfo getSystemBundle() {
        BundleDescription bundle = this.getSystemBundleDescription();
        return bundle != null ? this.convert(bundle) : null;
    }

    private BundleDescription getSystemBundleDescription() {
        BundleDescription bundle = this.state.getBundle(0L);
        if (bundle == null || bundle.getHost() != null) {
            return null;
        }
        return "org.eclipse.osgi".equals(bundle.getSymbolicName()) ? bundle : null;
    }

    public BundleInfo[] getSystemFragmentedBundles() {
        BundleDescription bundle = this.getSystemBundleDescription();
        if (bundle == null) {
            return null;
        }
        return this.convertState(bundle.getFragments());
    }

    public String[] getUnsatisfiedConstraints(BundleInfo bInfo) {
        BundleDescription description = this.state.getBundleByLocation(bInfo.getLocation());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformAdmin platformAdmin = (PlatformAdmin)Activator.acquireService(clazz.getName());
        StateHelper helper = platformAdmin.getStateHelper();
        VersionConstraint[] constraints = helper.getUnsatisfiedConstraints(description);
        String[] ret = new String[constraints.length];
        int i = 0;
        while (i < constraints.length) {
            ret[i] = constraints[i].toString();
            ++i;
        }
        return ret;
    }

    private void initialize(boolean useFwPersistentData) {
        LauncherData launcherData = this.manipulator.getLauncherData();
        ConfigData configData = this.manipulator.getConfigData();
        BundleInfo[] bInfos = configData.getBundles();
        if (!useFwPersistentData) {
            this.composeNewState(launcherData, configData, bInfos);
            return;
        }
        EquinoxManipulatorImpl.checkConsistencyOfFwConfigLocAndFwPersistentDataLoc(launcherData);
        if (launcherData.isClean()) {
            this.composeNewState(launcherData, configData, bInfos);
        } else {
            if (this.manipulator.getLauncherData().getFwPersistentDataLocation() == null) {
                File installArea = null;
                String installAreaSt = configData.getFwDependentProp("osgi.install");
                if (installAreaSt == null) {
                    if (this.manipulator.getLauncherData().getLauncher() != null) {
                        installArea = this.manipulator.getLauncherData().getLauncher().getParentFile();
                    }
                } else if (installAreaSt.startsWith("file:")) {
                    installArea = new File(installAreaSt.substring("file:".length()));
                } else {
                    throw new IllegalStateException("Current implementation assume that property value keyed by osgi.install must start with \"file:\". But it was not:" + installAreaSt);
                }
                File fwPersistentDataLocation = new File(installArea, "configuration");
                this.manipulator.getLauncherData().setFwPersistentDataLocation(fwPersistentDataLocation, false);
            }
            if (!this.composeState(bInfos, null, this.manipulator.getLauncherData().getFwPersistentDataLocation())) {
                this.composeNewState(launcherData, configData, bInfos);
            }
            this.resolve(true);
        }
    }

    public void installBundle(BundleInfo bInfo) throws FrameworkAdminRuntimeException {
        SimpleBundlesState.checkAvailability((FrameworkAdmin)this.fwAdmin);
        boolean found = false;
        BundleDescription[] currentInstalledBundles = this.state.getBundles();
        String newLocation = FileUtils.getRealLocation(this.manipulator, bInfo.getLocation(), true);
        Dictionary manifest = Utils.getOSGiManifest((String)newLocation);
        if (manifest == null) {
            return;
        }
        String newSymbolicName = (String)manifest.get("Bundle-SymbolicName");
        int position = newSymbolicName.indexOf(";");
        if (position >= 0) {
            newSymbolicName = newSymbolicName.substring(0, position).trim();
        }
        String newVersion = (String)manifest.get("Bundle-Version");
        int i = 0;
        while (i < currentInstalledBundles.length) {
            String version;
            String location = FileUtils.getRealLocation(this.manipulator, currentInstalledBundles[i].getLocation(), true);
            if (newLocation.equals(location)) {
                found = true;
                break;
            }
            String symbolicName = currentInstalledBundles[i].getSymbolicName();
            if (newSymbolicName.equals(symbolicName) && newVersion.equals(version = currentInstalledBundles[i].getVersion().toString())) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            BundleDescription newBundleDescription = null;
            try {
                bInfo.setBundleId(++this.maxId);
                newBundleDescription = this.soFactory.createBundleDescription(this.state, manifest, newLocation, bInfo.getBundleId());
                this.state.addBundle(newBundleDescription);
                this.manipulator.getConfigData().addBundle(bInfo);
            }
            catch (BundleException e) {
                Log.log(2, (Object)this, "installBundle(BundleInfo)", e);
            }
        }
    }

    public boolean isFullySupported() {
        return true;
    }

    public boolean isResolved() {
        return this.state.isResolved();
    }

    public boolean isResolved(BundleInfo bInfo) {
        BundleDescription description = this.state.getBundleByLocation(bInfo.getLocation());
        if (description == null) {
            return false;
        }
        return description.isResolved();
    }

    public void resolve(boolean increment) {
        this.state.resolve(increment);
    }

    void setFwJar(File fwJar) {
        this.manipulator.getLauncherData().setFwJar(fwJar);
    }

    private void setPlatformProperties(State state) {
        Dictionary platformProperties = state.getPlatformProperties()[0];
        ((Hashtable)this.platfromProperties).clear();
        if (platformProperties != null) {
            Enumeration enumeration = platformProperties.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                Object value = platformProperties.get(key);
                this.platfromProperties.setProperty(key, (String)value);
            }
        }
    }

    private void setPlatformPropertiesToState(Dictionary props) {
        Properties platformProperties = EquinoxBundlesState.setDefaultPlatformProperties();
        Enumeration enumeration = props.keys();
        block0: while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            int i = 0;
            while (i < PROPS.length) {
                if (key.equals(PROPS[i])) {
                    ((Hashtable)platformProperties).put(key, props.get(key));
                    continue block0;
                }
                ++i;
            }
        }
        this.state.setPlatformProperties((Dictionary)platformProperties);
    }

    private void setStateObjectFactory() {
        if (this.soFactory != null) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformAdmin platformAdmin = (PlatformAdmin)Activator.acquireService(clazz.getName());
        this.soFactory = platformAdmin.getFactory();
    }

    public String toString() {
        if (this.state == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        BundleDescription[] bundleDescriptions = this.state.getBundles();
        int i = 0;
        while (i < bundleDescriptions.length) {
            sb.append(String.valueOf(bundleDescriptions[i].getBundleId()) + ":");
            sb.append(String.valueOf(bundleDescriptions[i].toString()) + "(");
            sb.append(String.valueOf(bundleDescriptions[i].isResolved()) + ")");
            String[] ees = bundleDescriptions[i].getExecutionEnvironments();
            int j = 0;
            while (j < ees.length) {
                sb.append(String.valueOf(ees[j]) + " ");
                ++j;
            }
            sb.append("\n");
            ++i;
        }
        sb.append("PlatformProperties:\n");
        Dictionary[] dics = this.state.getPlatformProperties();
        int i2 = 0;
        while (i2 < dics.length) {
            Enumeration enumeration = dics[i2].keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = (String)dics[i2].get(key);
                sb.append(" (" + key + "," + value + ")\n");
            }
            ++i2;
        }
        sb.append("\n");
        return sb.toString();
    }

    public void uninstallBundle(BundleInfo bInfo) throws FrameworkAdminRuntimeException {
        SimpleBundlesState.checkAvailability((FrameworkAdmin)this.fwAdmin);
        long id = 0L;
        String targetLocation = bInfo.getLocation();
        BundleDescription[] currentInstalledBundles = this.state.getBundles();
        int i = 0;
        while (i < currentInstalledBundles.length) {
            String location = currentInstalledBundles[i].getLocation();
            if (targetLocation.equals(location)) {
                id = currentInstalledBundles[i].getBundleId();
                break;
            }
            ++i;
        }
        if (id != 0L) {
            try {
                Dictionary manifest = Utils.getOSGiManifest((String)bInfo.getLocation());
                if (manifest == null) {
                    Log.log(2, (Object)this, "uninstallBundle(BundleInfo)", "Unable to get bundle manifest for: " + bInfo.getLocation());
                    return;
                }
                BundleDescription bundleDescription = this.soFactory.createBundleDescription(this.state, manifest, bInfo.getLocation(), id);
                this.state.removeBundle(bundleDescription);
                this.manipulator.getConfigData().removeBundle(bInfo);
            }
            catch (BundleException e) {
                Log.log(2, (Object)this, "uninstallBundle(BundleInfo)", e);
            }
        }
    }
}

