/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.cnkjava;

import com.insightful.cnkjava.CNKObj;
import com.insightful.cnkjava.CNKProc;

public class CNKBuf
extends CNKObj {
    public void createPeerObject() {
        this.createCNKObject("cnkbase", new String[]{"CNKMemoryBuf", "CNKBuf", "CNKObj"});
    }

    public CNKBuf() {
    }

    CNKBuf(long tag) {
        super(tag);
    }

    public CNKBuf(int numRows, int numColumns) {
        this();
        this.setNumRows(numRows);
        this.setNumColumns(numColumns);
    }

    public String getStatus() {
        String status = super.getStatus();
        if (status.length() > 0) {
            status = status + ",";
        }
        if (this.getBooleanProp("eof", null)) {
            status = status + "eof,";
        }
        long totRows = this.getLongProp("output.rows.released", null);
        int rows = this.getNumRows();
        int cols = this.getNumColumns();
        int bytesPerRow = this.calcBytesPerRow();
        long totalBytes = (long)rows * (long)bytesPerRow;
        status = status + "tot=" + totRows + ",rows=" + rows + ",cols=" + cols + ",bytesPerRow=" + bytesPerRow + ",totalBytes=" + totalBytes;
        return status;
    }

    public boolean getEOF() {
        return this.getBooleanProp("eof", null);
    }

    public int getNumRows() {
        return this.getIntProp("num.rows", null);
    }

    public void setNumRows(int val) {
        this.setProp("num.rows", new Integer(val));
    }

    public int getNumColumns() {
        return this.getIntProp("num.columns", null);
    }

    public void setNumColumns(int val) {
        this.setProp("num.columns", new Integer(val));
    }

    public String[] getColumnNames() {
        int numColumns = this.getNumColumns();
        String[] val = new String[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            val[i] = this.getColumnName(i);
        }
        return val;
    }

    public void setColumnNames(String[] val) {
        int numColumns = this.getNumColumns();
        if (val == null || val.length != numColumns) {
            throw new RuntimeException("column names wrong size");
        }
        for (int i = 0; i < numColumns; ++i) {
            this.setColumnName(i, val[i]);
        }
    }

    public void setColumnName(int colNum, String val) {
        this.setProp("column.name", new Object[]{new Integer(colNum), val});
    }

    public String getColumnName(int colNum) {
        return this.getStringProp("column.name", new Integer(colNum));
    }

    public void setColumnType(int colNum, String val) {
        this.setProp("column.type", new Object[]{new Integer(colNum), val});
    }

    public String getColumnType(int colNum) {
        return this.getStringProp("column.type", new Integer(colNum));
    }

    public void setColumnLevelStrings(int colNum, String[] levelStrings) {
        int numLevels = levelStrings.length;
        this.setProp("column.num.levels", new Object[]{new Integer(colNum), new Integer(numLevels)});
        for (int i = 0; i < numLevels; ++i) {
            this.setProp("column.level.name", new Object[]{new Integer(colNum), new Integer(i), levelStrings[i]});
        }
    }

    public String[] getColumnLevelStrings(int colNum) {
        int numLevels = this.getIntProp("column.num.levels", new Integer(colNum));
        String[] val = new String[numLevels];
        for (int i = 0; i < numLevels; ++i) {
            val[i] = this.getStringProp("column.level.name", new Object[]{new Integer(colNum), new Integer(i)});
        }
        return val;
    }

    public void setColumnMaxAutoLevels(int colNum, int val) {
        this.setProp("column.max.auto.levels", new Object[]{new Integer(colNum), new Integer(val)});
    }

    public int getColumnMaxAutoLevels(int colNum) {
        int val = this.getIntProp("column.max.auto.levels", new Integer(colNum));
        return val;
    }

    public void setDefaultMaxAutoLevels(int val) {
        this.setProp("default.max.auto.levels", new Integer(val));
    }

    public int getDefaultMaxAutoLevels() {
        int val = this.getIntProp("default.max.auto.levels", null);
        return val;
    }

    public void setColumnOverflowLevel(int colNum, String val) {
        this.setProp("column.overflow.level", new Object[]{new Integer(colNum), val});
    }

    public String getColumnOverflowLevel(int colNum) {
        String val = this.getStringProp("column.overflow.level", new Integer(colNum));
        return val;
    }

    public void setColumnStringBytes(int colNum, int val) {
        this.setProp("column.string.bytes", new Object[]{new Integer(colNum), new Integer(val)});
    }

    public int getColumnStringBytes(int colNum) {
        int val = this.getIntProp("column.string.bytes", new Integer(colNum));
        return val;
    }

    public void setColumnBlobClassName(int colNum, String val) {
        this.setProp("column.blob.class.name", new Object[]{new Integer(colNum), val});
    }

    public String getColumnBlobClassName(int colNum) {
        String val = this.getStringProp("column.blob.class.name", new Integer(colNum));
        return val;
    }

    public int getNumWriters() {
        int val = this.getIntProp("num.writers", null);
        return val;
    }

    public CNKProc getWriter(int num) {
        CNKProc val = this.getCNKProcProp("writer.proc", new Integer(num));
        return val;
    }

    public int getNumReaders() {
        int val = this.getIntProp("num.readers", null);
        return val;
    }

    public CNKProc getReader(int num) {
        CNKProc val = this.getCNKProcProp("reader.proc", new Integer(num));
        return val;
    }

    public boolean isDeadlockPossible() {
        boolean val = this.getBooleanProp("is.deadlock.possible", null);
        return val;
    }

    public int getMinRowsToAvoidDeadlock() {
        int val = this.getIntProp("min.rows.to.avoid.deadlock", null);
        return val;
    }

    public long getTotalNumRows() {
        long val = this.getLongProp("total.num.rows", null);
        return val;
    }

    public double mapLevelToDouble(int colNum, String level) {
        double val = this.getDoubleProp("map.level.to.double", new Object[]{new Integer(colNum), level});
        return val;
    }

    public String mapDoubleToLevel(int colNum, double level) {
        String val = this.getStringProp("map.double.to.level", new Object[]{new Integer(colNum), new Double(level)});
        return val;
    }

    public int mapLevelToInt(int colNum, String level) {
        int val = this.getIntProp("map.level.to.int", new Object[]{new Integer(colNum), level});
        return val;
    }

    public String mapIntToLevel(int colNum, int level) {
        String val = this.getStringProp("map.int.to.level", new Object[]{new Integer(colNum), new Integer(level)});
        return val;
    }

    public boolean anyOverflowCounts() {
        return this.getBooleanProp("any.overflow.counts", null);
    }

    public void initOverflowCounts() {
        this.setProp("init.overflow.counts", null);
    }

    public long getOverflowCount(int colNum) {
        return this.getLongProp("overflow.count", new Integer(colNum));
    }

    public void setOverflowCount(int colNum, long val) {
        this.setProp("overflow.count", new Object[]{new Integer(colNum), new Long(val)});
    }

    public int getOverflowStringBytes(int colNum) {
        return this.getIntProp("overflow.string.bytes", new Integer(colNum));
    }

    public void setOverflowStringBytes(int colNum, int val) {
        this.setProp("overflow.string.bytes", new Object[]{new Integer(colNum), new Integer(val)});
    }

    public int calcBytesPerRow() {
        int val = this.getIntProp("calc.bytes.per.row", null);
        return val;
    }
}

