/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.cnkjava;

import com.insightful.cnkjava.CNKBuf;
import com.insightful.cnkjava.CNKPipeline;
import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcCount;
import com.insightful.cnkjava.CNKProcFile;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcJavaTransformExec;
import com.insightful.cnkjava.CNKProcLm;
import com.insightful.cnkjava.CNKProcNullWriter;
import com.insightful.cnkjava.CNKProcPrintf;
import com.insightful.cnkjava.CNKProcRandomReader;
import com.insightful.cnkjava.CNKProcSplusTransform;

public class CNKExamples {
    static Example[] m_examples = new Example[]{new Example(){

        public String getDescription() {
            return "example.null.reader.pipeline";
        }

        public void run() {
            int numRows = 1000;
            int numColumns = 2;
            long totalRows = 1000000L;
            CNKBuf buf = new CNKBuf(numRows * 2, numColumns);
            CNKProcRandomReader rdr = new CNKProcRandomReader(buf, numRows, totalRows);
            CNKProcNullWriter wtr = new CNKProcNullWriter(buf, numRows);
            CNKPipeline pip = new CNKPipeline();
            pip.add(buf);
            pip.add(rdr);
            pip.add(wtr);
            pip.init();
            pip.run();
            pip.destroyPipeline(true);
        }
    }, new Example(){

        public String getDescription() {
            return "example.lm.pipeline";
        }

        public void run() {
            int numRows = 1000;
            int numColumns = 2;
            long totalRows = 1000000L;
            CNKBuf buf = new CNKBuf(numRows * 2, numColumns);
            CNKProcRandomReader rdr = new CNKProcRandomReader(buf, numRows, totalRows);
            CNKProcLm lm = new CNKProcLm(buf, numRows);
            lm.setName("lm");
            CNKPipeline pip = new CNKPipeline();
            pip.add(buf);
            pip.add(rdr);
            pip.add(lm);
            pip.setStatusFn(new CNKPipeline.StatusFn(){

                public void run(CNKPipeline pip) {
                    CNKExamples.printLmStat(pip, "lm");
                }
            });
            pip.init();
            pip.run();
            pip.destroyPipeline(true);
        }
    }, new Example(){

        public String getDescription() {
            return "example.count.pipeline";
        }

        public void run() {
            int numRows = 1000;
            int numColumns = 3;
            long totalRows = 5000L;
            CNKBuf buf = new CNKBuf(numRows * 2, numColumns);
            buf.setColumnType(1, "factor");
            buf.setColumnType(2, "factor");
            CNKProcRandomReader rdr = new CNKProcRandomReader(buf, numRows, totalRows);
            CNKProcCount cnt = new CNKProcCount(buf, numRows);
            CNKPipeline pip = new CNKPipeline();
            pip.add(buf);
            pip.add(rdr);
            pip.add(cnt);
            pip.init();
            pip.run();
            for (int colNum = 1; colNum < 3; ++colNum) {
                System.out.println("col=" + colNum + " numLevels=" + cnt.getColumnNumLevels(colNum));
                for (int levelNum = 0; levelNum < cnt.getColumnNumLevels(colNum); ++levelNum) {
                    System.out.println("col=" + colNum + " levelNum=" + levelNum + " levelName=" + cnt.getColumnLevelName(colNum, levelNum) + " levelCount=" + cnt.getColumnLevelCount(colNum, levelNum));
                }
            }
            pip.destroyPipeline(true);
        }
    }, new Example(){

        public String getDescription() {
            return "example.lm.multi.pipeline";
        }

        public void run() {
            int numRows = 1000;
            int numColumns = 2;
            long totalRows = 1000000L;
            CNKBuf buf = new CNKBuf(numRows * 2, numColumns);
            CNKProcRandomReader rdr = new CNKProcRandomReader(buf, numRows, totalRows);
            CNKProcLm lm1 = new CNKProcLm(buf, numRows);
            lm1.setName("lm1");
            CNKProcLm lm2 = new CNKProcLm(buf, (int)Math.round((double)numRows * 0.8));
            lm2.setName("lm2");
            CNKPipeline pip = new CNKPipeline();
            pip.add(buf);
            pip.add(rdr);
            pip.add(lm1);
            pip.add(lm2);
            pip.setStatusFn(new CNKPipeline.StatusFn(){

                public void run(CNKPipeline pip) {
                    CNKExamples.printLmStat(pip, "lm1");
                    CNKExamples.printLmStat(pip, "lm2");
                }
            });
            pip.init();
            pip.run();
            pip.destroyPipeline(true);
        }
    }, new Example(){

        public String getDescription() {
            return "example.transform.lm.pipeline";
        }

        public void run() {
            int numRows = 1000;
            int numColumns = 2;
            long totalRows = 1000000L;
            String transform = "function(x) cbind(2*x[,1]+0.05*x[,2],x[,2:ncol(x)])";
            CNKBuf buf1 = new CNKBuf(numRows * 2, numColumns);
            CNKBuf buf2 = new CNKBuf(numRows * 2, numColumns);
            CNKProcRandomReader rdr = new CNKProcRandomReader(buf1, numRows, totalRows);
            CNKProcSplusTransform xform = new CNKProcSplusTransform(buf1, buf2, numRows, transform);
            CNKProcLm lm = new CNKProcLm(buf2, numRows);
            lm.setName("lm");
            CNKPipeline pip = new CNKPipeline();
            pip.add(buf1);
            pip.add(buf2);
            pip.add(rdr);
            pip.add(xform);
            pip.add(lm);
            pip.setStatusFn(new CNKPipeline.StatusFn(){

                public void run(CNKPipeline pip) {
                    CNKExamples.printLmStat(pip, "lm");
                }
            });
            pip.init();
            pip.run();
            pip.destroyPipeline(true);
        }
    }, new Example(){

        public String getDescription() {
            return "example.read.var.pipeline";
        }

        public void run() {
            int numRows = 5;
            int numColumns = 5;
            String varName = "fuel.frame";
            String transform = "function(x) {print(x)}";
            CNKBuf buf = new CNKBuf(numRows * 2, numColumns);
            CNKProcSplusTransform rdr = CNKProcSplusTransform.createSplusVarReader(buf, numRows, varName);
            CNKProcSplusTransform xform = new CNKProcSplusTransform(buf, null, numRows, transform);
            CNKPipeline pip = new CNKPipeline();
            pip.add(buf);
            pip.add(rdr);
            pip.add(xform);
            pip.init();
            pip.run();
            pip.destroyPipeline(true);
        }
    }, new Example(){

        public String getDescription() {
            return "example.write.var.pipeline";
        }

        public void run() {
            int numRows = 5;
            int numColumns = 5;
            String inVarName = "fuel.frame";
            String outVarName = "fuel.frame2";
            String transform = "function(x) {print(x);x}";
            CNKBuf buf1 = new CNKBuf(numRows * 2, numColumns);
            CNKBuf buf2 = new CNKBuf(numRows * 2, numColumns);
            CNKProcSplusTransform rdr = CNKProcSplusTransform.createSplusVarReader(buf1, numRows, inVarName);
            CNKProcSplusTransform xform = new CNKProcSplusTransform(buf1, buf2, numRows, transform);
            CNKProcSplusTransform wtr = CNKProcSplusTransform.createSplusVarWriter(buf2, numRows, outVarName);
            CNKPipeline pip = new CNKPipeline();
            pip.add(buf1);
            pip.add(buf2);
            pip.add(rdr);
            pip.add(xform);
            pip.add(wtr);
            pip.init();
            pip.run();
            pip.destroyPipeline(true);
        }
    }, new Example(){

        public String getDescription() {
            return "example.random.write.file.pipeline";
        }

        public void run() {
            int i;
            int numRows = 5;
            int numColumns = 3;
            String[] columnNames = new String[]{"foo", "bar", "baz"};
            int[] factorColumns = new int[]{1, 2};
            long totalRows = 200L;
            String fileName = "e:/temp.txt";
            String fileType = "ASCII";
            CNKBuf buf = new CNKBuf(numRows * 2, numColumns);
            for (i = 0; i < columnNames.length; ++i) {
                buf.setColumnName(i, columnNames[i]);
            }
            for (i = 0; i < factorColumns.length; ++i) {
                buf.setColumnType(factorColumns[i], "factor");
            }
            CNKProcRandomReader rdr = new CNKProcRandomReader(buf, numRows, totalRows);
            CNKProcFile wtr = CNKProcFile.createFileWriter(buf, numRows, fileName, fileType);
            CNKPipeline pip = new CNKPipeline();
            pip.add(buf);
            pip.add(rdr);
            pip.add(wtr);
            pip.init();
            pip.run();
            pip.destroyPipeline(true);
        }
    }, new Example(){

        public String getDescription() {
            return "example.read.file.transform.pipeline";
        }

        public void run() {
            int numRows = 5;
            int numColumns = 5;
            String fileName = "e:/temp.txt";
            String fileType = "ASCII";
            String transform = "function(x) {print(x);x}";
            CNKBuf buf = new CNKBuf(numRows * 2, numColumns);
            CNKProcFile rdr = CNKProcFile.createFileReader(buf, numRows, fileName, fileType);
            rdr.setMaxRows(100);
            CNKProcSplusTransform xform = new CNKProcSplusTransform(buf, null, numRows, transform);
            CNKPipeline pip = new CNKPipeline();
            pip.add(buf);
            pip.add(rdr);
            pip.add(xform);
            pip.init();
            pip.run();
            pip.destroyPipeline(true);
        }
    }, new Example(){

        public String getDescription() {
            return "example.java.transform.pipeline";
        }

        public void run() {
            int numRows = 5;
            int numColumns = 5;
            long totalRows = 17L;
            String varName = "fuel.frame";
            String transform = "function(x) {print(x)}";
            CNKBuf buf1 = new CNKBuf(numRows * 2, numColumns);
            CNKBuf buf2 = new CNKBuf(numRows * 2, numColumns);
            CNKProcRandomReader rdr = new CNKProcRandomReader(buf1, numRows, totalRows);
            CNKProcPrintf printf1 = new CNKProcPrintf(buf1, numRows);
            CNKProcPrintf printf2 = new CNKProcPrintf(buf2, numRows);
            CNKProcJavaTransformExec exec = new CNKProcJavaTransformExec(){

                public void execute(CNKProcJavaTransform proc) {
                    int inputRows = proc.getChunkInputRows(0);
                    double[] inputData = proc.getChunkInputColumnData(0, 0);
                    double[] outputData = proc.getChunkOutputColumnData(0, 0);
                    double[] inputData2 = proc.getChunkInputColumnData(0, 1);
                    double[] outputData2 = proc.getChunkOutputColumnData(0, 1);
                    for (int i = 0; i < inputRows; ++i) {
                        outputData[i] = 100.0 + inputData[i];
                        outputData2[i] = 1000.0 + inputData2[i];
                    }
                }
            };
            CNKProcJavaTransform xform = new CNKProcJavaTransform(buf1, buf2, numRows, exec);
            CNKPipeline pip = new CNKPipeline();
            pip.add(buf1);
            pip.add(buf2);
            pip.add(rdr);
            pip.add(xform);
            pip.add(printf1);
            pip.add(printf2);
            pip.init();
            pip.run();
            pip.destroyPipeline(true);
        }
    }, new Example(){

        public String getDescription() {
            return "example.java.transform.pipeline w releasing less than all rows";
        }

        public void run() {
            int numRows = 5;
            int numColumns = 5;
            long totalRows = 17L;
            CNKBuf buf1 = new CNKBuf(numRows * 2, numColumns);
            CNKBuf buf2 = new CNKBuf(numRows * 2, numColumns);
            CNKProcRandomReader rdr = new CNKProcRandomReader(buf1, numRows, totalRows);
            CNKProcPrintf printf2 = new CNKProcPrintf(buf2, numRows);
            CNKProcJavaTransformExec exec = new CNKProcJavaTransformExec(){
                int myVal = 0;

                public void execute(CNKProcJavaTransform proc) {
                    System.out.println("executing input pos=" + proc.getChunkInputPosition(0) + " input num rows=" + proc.getChunkInputRows(0) + " output pos=" + proc.getChunkOutputPosition(0) + " output num rows=" + proc.getChunkOutputRows(0));
                    int inputRows = proc.getChunkInputRows(0);
                    double[] inputData = proc.getChunkInputColumnData(0, 0);
                    double[] outputData = proc.getChunkOutputColumnData(0, 0);
                    for (int i = 0; i < 3; ++i) {
                        System.out.println("out[" + i + "]=" + this.myVal);
                        outputData[i] = this.myVal++;
                    }
                    proc.setChunkOutputReleaseRows(0, 3);
                }
            };
            CNKProcJavaTransform xform = new CNKProcJavaTransform(buf1, buf2, numRows, exec);
            printf2.setProp("num.to.print", new Integer(9999));
            CNKPipeline pip = new CNKPipeline();
            pip.add(buf1);
            pip.add(buf2);
            pip.add(rdr);
            pip.add(xform);
            pip.add(printf2);
            pip.init();
            pip.run();
            pip.destroyPipeline(true);
        }
    }};

    static void printLmStat(CNKPipeline pip, String name) {
        CNKProc lm = pip.getProc(name);
        if (lm == null || !(lm instanceof CNKProcLm)) {
            return;
        }
        double[] coef = ((CNKProcLm)lm).getCoefficients();
        String str = name + " coef:";
        for (int i = 0; i < coef.length; ++i) {
            str = str + " " + coef[i];
        }
        System.out.println(str);
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        block12: {
            try {
                while (true) {
                    block11: {
                        for (i = 0; i < CNKExamples.m_examples.length; ++i) {
                            System.out.println("" + i + " : " + CNKExamples.m_examples[i].getDescription());
                        }
                        System.out.println("all : do all");
                        System.out.println("q : quit");
                        System.out.print("  select example: ");
                        System.out.flush();
                        str = "";
                        while ((c = (char)System.in.read()) != '\n') {
                            if (c == '\r') continue;
                            str = str + c;
                        }
                        sel = -99;
                        try {
                            if (str.equals("all")) {
                                sel = -1;
                                break block11;
                            }
                            if (str.equals("q")) break block12;
                            i = Integer.parseInt(str);
                            if (i >= 0 && i < CNKExamples.m_examples.length) {
                                sel = i;
                            }
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    i = 0;
                    while (true) {
                        if (i >= CNKExamples.m_examples.length) ** continue;
                        if (sel == i || sel == -1) {
                            System.out.println("starting example " + i + " : " + CNKExamples.m_examples[i].getDescription());
                            CNKExamples.m_examples[i].run();
                            System.out.println("finished example " + i + " : " + CNKExamples.m_examples[i].getDescription() + "\n");
                        }
                        ++i;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static interface Example {
        public String getDescription();

        public void run();
    }
}

