/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.cnkjava;

import com.insightful.cnkjava.CNKBuf;
import com.insightful.cnkjava.CNKProc;
import java.io.File;
import java.util.Hashtable;

public abstract class CNKObj {
    public static final int DEBUG_MESSAGE_SEVERITY = 0;
    public static final int VERBOSE_MESSAGE_SEVERITY = 1;
    public static final int INFORMATION_MESSAGE_SEVERITY = 2;
    public static final int WARNING_MESSAGE_SEVERITY = 3;
    public static final int ERROR_MESSAGE_SEVERITY = 4;
    private static final String m_stringNA;
    private long m_tag = -1L;
    private String m_createError = "";
    private static boolean g_isWindowsOS;
    private static Hashtable m_registeredLibraries;
    private static boolean g_initialLibrariesLoaded;
    private static String g_initialLibrariesStatus;
    private static boolean m_errorOnLevelOverflowNeedsToBeSentToCNKObj;
    private static boolean m_errorOnLevelOverflow;
    private static boolean m_errorOnStringTruncationNeedsToBeSentToCNKObj;
    private static boolean m_errorOnStringTruncation;
    private static boolean m_useWindowsStringEncodingNeedsToBeSentToCNKObj;
    private static boolean m_useWindowsStringEncoding;
    private static boolean m_doubleDateEpochNeedsToBeSentToCNKObj;
    private static long m_doubleDateEpoch;

    protected CNKObj() {
        this.createPeerObject();
    }

    CNKObj(long tag) {
        this.m_tag = tag;
    }

    public abstract void createPeerObject();

    public static int getINT32(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        if (obj instanceof String) {
            try {
                return Integer.parseInt((String)obj);
            }
            catch (Exception exception) {
            }
        } else if (obj instanceof Boolean) {
            return (Boolean)obj != false ? 1 : 0;
        }
        return 0;
    }

    public static Object setINT32(int val) {
        return new Integer(val);
    }

    public static long getINT64(Object obj) {
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof String) {
            try {
                return Long.parseLong((String)obj);
            }
            catch (Exception exception) {
            }
        } else if (obj instanceof Boolean) {
            return (Boolean)obj != false ? 1L : 0L;
        }
        return 0L;
    }

    public static Object setINT64(long val) {
        return new Long(val);
    }

    public static double getDouble(Object obj) {
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        if (obj instanceof String) {
            try {
                return Double.parseDouble((String)obj);
            }
            catch (Exception exception) {
            }
        } else if (obj instanceof Boolean) {
            return (Boolean)obj != false ? 1.0 : 0.0;
        }
        return 0.0;
    }

    public static Object setDouble(double val) {
        return new Double(val);
    }

    public static boolean getBoolean(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue() != 0.0;
        }
        if (obj instanceof String) {
            return ((String)obj).equals("true");
        }
        return false;
    }

    public static Object setBoolean(boolean val) {
        return new Boolean(val);
    }

    public static String getString(Object obj) {
        return obj != null ? obj.toString() : null;
    }

    public static Object setString(String val) {
        return val;
    }

    public static long getCNKObj(Object obj) {
        return obj != null && obj instanceof CNKObj ? ((CNKObj)obj).m_tag : -1L;
    }

    public static Object setCNKObj(long tag, String firstClass) {
        CNKObj val;
        block5: {
            val = null;
            if (tag >= 0L && firstClass != null) {
                try {
                    if (firstClass.equals("CNKBuf")) {
                        val = new CNKBuf(tag);
                        break block5;
                    }
                    if (firstClass.equals("CNKProc")) {
                        val = new CNKProc(tag);
                        break block5;
                    }
                    throw new Exception("only CNKBuf and CNKProc supported");
                }
                catch (Exception ex) {
                    System.out.println("CNKObj.setCNKObj error while creating " + firstClass + ": " + ex);
                    return null;
                }
            }
        }
        return val;
    }

    public void destroyCNKObj() {
        this.destroy_CNKObj(this.m_tag);
    }

    public void setProp(String propName, Object args) {
        this.handleObjectProp(true, propName, args);
    }

    public Object getObjectProp(String propName, Object args) {
        return this.handleObjectProp(false, propName, args);
    }

    public int getIntProp(String propName, Object args) {
        return CNKObj.getINT32(this.getObjectProp(propName, args));
    }

    public long getLongProp(String propName, Object args) {
        return CNKObj.getINT64(this.getObjectProp(propName, args));
    }

    public double getDoubleProp(String propName, Object args) {
        return CNKObj.getDouble(this.getObjectProp(propName, args));
    }

    public boolean getBooleanProp(String propName, Object args) {
        return CNKObj.getBoolean(this.getObjectProp(propName, args));
    }

    public String getStringProp(String propName, Object args) {
        return CNKObj.getString(this.getObjectProp(propName, args));
    }

    public CNKBuf getCNKBufProp(String propName, Object args) {
        Object val = this.getObjectProp(propName, args);
        return val instanceof CNKBuf ? (CNKBuf)val : null;
    }

    public CNKProc getCNKProcProp(String propName, Object args) {
        Object val = this.getObjectProp(propName, args);
        return val instanceof CNKProc ? (CNKProc)val : null;
    }

    public String toString() {
        String className = this.getClass().getName();
        if (this.m_tag < 0L || !this.isValid()) {
            return className + "[invalid]";
        }
        String name = this.getName();
        if (!(name != null && name.length() != 0 || (name = this.get_first_class_from_tag(this.m_tag)) != null && name.length() != 0)) {
            name = className;
        }
        String status = this.getStatus();
        return name + "[" + status + "]";
    }

    public String getStatus() {
        if (!this.hasError()) {
            return "";
        }
        String err = this.getError();
        return "error:" + err;
    }

    public void init() {
        this.setProp("init", null);
    }

    public boolean isValid() {
        return this.m_tag >= 0L && this.is_tag_valid(this.m_tag);
    }

    public void setName(String val) {
        this.setProp("name", val);
    }

    public String getName() {
        String val = this.getStringProp("name", null);
        return val;
    }

    public String getError() {
        String val = this.getStringProp("error", null);
        return val;
    }

    public void setError(String val) {
        this.setProp("error", val == null ? "" : val);
    }

    public boolean hasError() {
        boolean val = this.getBooleanProp("has.error", null);
        return val;
    }

    public void addError(String val) {
        this.setProp("error", val == null ? "" : val);
    }

    public void addWarning(String val) {
        this.setProp("warning", val == null ? "" : val);
    }

    public void addInformation(String val) {
        this.setProp("information", val == null ? "" : val);
    }

    public void addVerbose(String val) {
        this.setProp("verbose", val == null ? "" : val);
    }

    public void addDebug(String val) {
        this.setProp("debug", val == null ? "" : val);
    }

    public void setMaxMessages(int val) {
        this.setProp("max.messages", new Integer(val));
    }

    public void setMaxErrors(int val) {
        this.setProp("max.errors", new Integer(val));
    }

    public void setMaxMessageLength(int val) {
        this.setProp("max.message.length", new Integer(val));
    }

    public void clearMessages() {
        this.setProp("clear.messages", null);
    }

    public int getMaxMessages() {
        int val = this.getIntProp("max.messages", null);
        return val;
    }

    public int getMaxErrors() {
        int val = this.getIntProp("max.errors", null);
        return val;
    }

    public int getMaxMessageLength() {
        int val = this.getIntProp("max.message.length", null);
        return val;
    }

    public int getNumMessages() {
        int val = this.getIntProp("num.messages", null);
        return val;
    }

    public int getNumMessagesAdded() {
        int val = this.getIntProp("num.messages.added", null);
        return val;
    }

    public String getMessage(int i) {
        String val = this.getStringProp("message", new Integer(i));
        return val;
    }

    public int getNumMessagesAtLevel(String severityString) {
        int val = this.getIntProp("num.messages.at.level", severityString);
        return val;
    }

    public String getMessageSeverityString(int i) {
        String val = this.getStringProp("severity", new Integer(i));
        return val;
    }

    public int getMessageSeverity(int i) {
        String severityString = this.getMessageSeverityString(i);
        if (severityString.equals("error")) {
            return 4;
        }
        if (severityString.equals("warning")) {
            return 3;
        }
        if (severityString.equals("information")) {
            return 2;
        }
        if (severityString.equals("verbose")) {
            return 1;
        }
        return 0;
    }

    public static int convertDoubleToLevelNum(double val) {
        if (CNKObj.isDoubleNA(val)) {
            return CNKObj.getLevelNumNA();
        }
        if (val < 0.0 || val >= 65535.0) {
            return 0;
        }
        return (int)val;
    }

    public static double convertLevelNumToDouble(int val) {
        if (CNKObj.isLevelNumNA(val)) {
            return CNKObj.getDoubleNA();
        }
        return val;
    }

    public static boolean isLevelNumNA(int val) {
        return val < 0;
    }

    public static int getLevelNumNA() {
        return -1;
    }

    public static boolean isDoubleNA(double val) {
        return Double.isNaN(val);
    }

    public static double getDoubleNA() {
        return Double.NaN;
    }

    public static boolean isStringNA(String val) {
        return val == null || val.equals(m_stringNA);
    }

    public static String getStringNA() {
        return m_stringNA;
    }

    public static long getTimeDateNA() {
        return Long.MAX_VALUE;
    }

    public static boolean isTimeDateNA(long val) {
        return val > 0x7FFFFFFFFFFFFFF0L;
    }

    public void createCNKObject(String[] classNames) {
        this.createCNKObject(null, classNames);
    }

    public void createCNKObject(String libraryName, String[] classNames) {
        String mainClassName = classNames != null && classNames.length > 0 ? classNames[0] : "no-class";
        this.m_tag = -1L;
        this.m_createError = "";
        if (!CNKObj.getInitialLibrariesLoaded()) {
            this.m_createError = "can't create " + mainClassName + " object: " + CNKObj.getInitialLibrariesStatus();
            return;
        }
        String libraryRegisterError = null;
        if (libraryName != null && !libraryName.equals("")) {
            CNKObj.registerLibrary(libraryName);
            if (!CNKObj.getRegisterLibraryOK(libraryName)) {
                libraryRegisterError = "can't create " + mainClassName + " object: " + CNKObj.getRegisterLibraryStatus(libraryName);
            }
        }
        this.m_tag = this.create_cnk_object(classNames);
        if (this.m_tag < 0L) {
            this.m_createError = libraryRegisterError != null ? libraryRegisterError : "can't create " + mainClassName + " object: unknown error";
        }
        if (this.m_tag >= 0L) {
            if (m_doubleDateEpochNeedsToBeSentToCNKObj) {
                this.setProp("double.date.epoch", new Long(m_doubleDateEpoch));
                m_doubleDateEpochNeedsToBeSentToCNKObj = false;
            }
            if (m_errorOnLevelOverflowNeedsToBeSentToCNKObj) {
                this.setProp("error.on.level.overflow", new Boolean(m_errorOnLevelOverflow));
                m_errorOnLevelOverflowNeedsToBeSentToCNKObj = false;
            }
            if (m_errorOnStringTruncationNeedsToBeSentToCNKObj) {
                this.setProp("error.on.string.truncation", new Boolean(m_errorOnStringTruncation));
                m_errorOnStringTruncationNeedsToBeSentToCNKObj = false;
            }
            if (m_useWindowsStringEncodingNeedsToBeSentToCNKObj) {
                this.setProp("use.windows.string.encoding", new Boolean(m_useWindowsStringEncoding));
                m_useWindowsStringEncodingNeedsToBeSentToCNKObj = false;
            }
        }
    }

    public boolean getCreateOK() {
        return this.m_tag >= 0L;
    }

    public String getCreateError() {
        String err = this.m_createError == null || this.m_createError.equals("") ? "unknown error" : this.m_createError;
        return err;
    }

    public void createCheck() throws Exception {
        if (!this.getCreateOK()) {
            throw new Exception(this.getCreateError());
        }
    }

    private Object handleObjectProp(boolean setIt, String propName, Object args) {
        if (this.m_tag < 0L) {
            String err = "object error in " + (setIt ? "set/" : "get/") + propName + " : " + this.m_createError;
            throw new RuntimeException(err);
        }
        Object prop1 = null;
        Object prop2 = null;
        Object prop3 = null;
        if (args instanceof Object[]) {
            Object[] argArray = (Object[])args;
            if (argArray.length > 0) {
                prop1 = argArray[0];
            }
            if (argArray.length > 1) {
                prop2 = argArray[1];
            }
            if (argArray.length > 2) {
                prop3 = argArray[2];
            }
        } else {
            prop1 = args;
        }
        Object val = null;
        val = setIt ? this.set_property(this.m_tag, propName, prop1, prop2, prop3) : this.get_property(this.m_tag, propName, prop1, prop2, prop3);
        if (val != null && val instanceof String) {
            String msg = (String)val;
            if (msg.equals("unknown.property.error.flag")) {
                String err = "can't " + (setIt ? "set" : "get") + " " + propName + " for " + this.getClass().getName() + " object : unknown property";
                throw new RuntimeException(err);
            }
            if (msg.equals("unknown.object.error.flag")) {
                String err = "can't " + (setIt ? "set" : "get") + " " + propName + " for " + this.getClass().getName() + " object : unknown object " + this;
                throw new RuntimeException(err);
            }
        }
        return val;
    }

    private static void setDebugDLLFlag(boolean val) {
        CNKObj.set_global_property("debug.dll.flag", new Boolean(val), null, null);
    }

    public void setConverter(Object obj) {
        this.setProp("converter", obj);
    }

    public static void setDefaultConverter(Object obj) {
        CNKObj.set_global_property("converter", obj, null, null);
    }

    private native long create_cnk_object(String[] var1);

    private native Object get_property(long var1, String var3, Object var4, Object var5, Object var6);

    private native Object set_property(long var1, String var3, Object var4, Object var5, Object var6);

    private static native Object get_global_property(String var0, Object var1, Object var2, Object var3);

    private static native Object set_global_property(String var0, Object var1, Object var2, Object var3);

    private native boolean is_tag_valid(long var1);

    private native void destroy_CNKObj(long var1);

    private static native long get_data_storage();

    public static long getDataStorage() {
        return CNKObj.get_data_storage();
    }

    private native String get_first_class_from_tag(long var1);

    private static native String set_up_library_path(String var0);

    private static native void register_library_file(String var0);

    private static native String register_library_file_get_status(String var0);

    public static String getLibraryFileName(String libraryName) {
        try {
            if (libraryName == null) {
                libraryName = "null";
            }
            File libraryNameFile = new File(libraryName);
            String fileName = libraryName;
            if (!libraryNameFile.isAbsolute()) {
                fileName = System.mapLibraryName(fileName);
                if ("aix".equals(System.getProperty("os.name", "unknown").toLowerCase())) {
                    fileName = CNKObj.getAIXDependentLibraryName(fileName);
                }
                String sphome = System.getProperty("sprime.home", null);
                String cnkDir = System.getProperty("cnk.library.dir", null);
                String binDir = null;
                if (cnkDir != null && cnkDir.length() > 0) {
                    binDir = cnkDir + File.separator;
                } else if (sphome != null) {
                    binDir = sphome + (g_isWindowsOS ? "/splus/cmd/" : "/splus/newfun/lib/");
                }
                fileName = new File(binDir, fileName).getAbsolutePath();
            }
            return fileName;
        }
        catch (Exception ex) {
            System.out.println("error in getLibraryFileName(" + libraryName + ")");
            ex.printStackTrace();
            return null;
        }
    }

    public static void registerLibrary(String libraryName) {
        if (libraryName == null || libraryName.equals("")) {
            return;
        }
        if (m_registeredLibraries.containsKey(libraryName)) {
            return;
        }
        String fileName = CNKObj.getLibraryFileName(libraryName);
        String status = null;
        if (fileName == null) {
            status = "library " + libraryName + " file name is null";
        } else if (!new File(fileName).exists()) {
            status = "library " + libraryName + ", file name does not exist: " + fileName;
        } else {
            String registerStatus = "";
            try {
                registerStatus = CNKObj.register_library_file_get_status(fileName);
            }
            catch (Exception ex) {
                registerStatus = ex.toString();
            }
            status = registerStatus != null && registerStatus.equals("") ? registerStatus : "problem registering library " + libraryName + ", file name " + fileName + ": " + registerStatus;
        }
        if (status == null) {
            status = "";
        }
        m_registeredLibraries.put(libraryName, new String[]{fileName, status});
        if (status != null && status.length() > 0) {
            System.out.println("registered library=" + libraryName + ", file=" + fileName + ", status=" + status);
        }
    }

    private static String[] getRegisterLibraryInfo(String libraryName) {
        String[] vals = null;
        if (libraryName != null && !libraryName.equals("")) {
            vals = (String[])m_registeredLibraries.get(libraryName);
        }
        if (vals == null || vals.length < 2) {
            vals = new String[]{"unknownLibraryFileName", "unknown library: " + libraryName};
        }
        return vals;
    }

    public static String getRegisterLibraryFileName(String libraryName) {
        return CNKObj.getRegisterLibraryInfo(libraryName)[0];
    }

    public static String getRegisterLibraryStatus(String libraryName) {
        return CNKObj.getRegisterLibraryInfo(libraryName)[1];
    }

    public static boolean getRegisterLibraryOK(String libraryName) {
        String status = CNKObj.getRegisterLibraryStatus(libraryName);
        return status != null && status.equals("");
    }

    public static boolean getRegisterLibraryDone(String libraryName) {
        return libraryName != null && m_registeredLibraries.containsKey(libraryName);
    }

    public static String javaLoadLibrary(String libraryName) {
        if (libraryName == null || libraryName.equals("")) {
            return "";
        }
        String fileName = CNKObj.getLibraryFileName(libraryName);
        String status = "unknown error";
        if (fileName == null) {
            status = "library " + libraryName + " file name is null";
        } else {
            try {
                System.load(fileName);
                status = "";
            }
            catch (UnsatisfiedLinkError err) {
                status = "UnsatisfiedLinkError loading JNI library " + libraryName + ", file: " + fileName + ", err: " + err.getMessage();
            }
            catch (Exception ex) {
                status = "Exception loading JNI library " + libraryName + ", file: " + fileName + ", err: " + ex;
            }
        }
        if (status != null && !status.equals("")) {
            System.out.println("JNI library load: " + status);
        }
        return status;
    }

    public static boolean getInitialLibrariesLoaded() {
        return g_initialLibrariesLoaded;
    }

    public static String getInitialLibrariesStatus() {
        return g_initialLibrariesStatus;
    }

    public static void setDoubleDateEpoch(long val) {
        if (val != m_doubleDateEpoch) {
            m_doubleDateEpoch = val;
            m_doubleDateEpochNeedsToBeSentToCNKObj = true;
        }
    }

    public static long getDoubleDateEpoch() {
        return m_doubleDateEpoch;
    }

    public static void setErrorOnLevelOverflow(boolean val) {
        if (val != m_errorOnLevelOverflow) {
            m_errorOnLevelOverflow = val;
            m_errorOnLevelOverflowNeedsToBeSentToCNKObj = true;
        }
    }

    public static boolean getErrorOnLevelOverflow() {
        return m_errorOnLevelOverflow;
    }

    public static void setErrorOnStringTruncation(boolean val) {
        if (val != m_errorOnStringTruncation) {
            m_errorOnStringTruncation = val;
            m_errorOnStringTruncationNeedsToBeSentToCNKObj = true;
        }
    }

    public static boolean getErrorOnStringTruncation() {
        return m_errorOnStringTruncation;
    }

    public static void setUseWindowsStringEncoding(boolean val) {
        if (val != m_useWindowsStringEncoding) {
            m_useWindowsStringEncoding = val;
            m_useWindowsStringEncodingNeedsToBeSentToCNKObj = true;
        }
    }

    public static boolean getUseWindowsStringEncoding() {
        return m_useWindowsStringEncoding;
    }

    public static String getAIXDependentLibraryName(String libName) {
        if (libName != null && libName.length() > 0 && libName.lastIndexOf(".") != -1 && libName.substring(libName.lastIndexOf(".")).equals(".a")) {
            return libName.substring(0, libName.lastIndexOf(".")) + ".so";
        }
        return libName;
    }

    static {
        String status;
        m_stringNA = new String(new char[]{'\uffff'});
        g_isWindowsOS = System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0;
        m_registeredLibraries = new Hashtable();
        g_initialLibrariesLoaded = false;
        g_initialLibrariesStatus = "unknown error";
        m_errorOnLevelOverflowNeedsToBeSentToCNKObj = true;
        m_errorOnLevelOverflow = false;
        m_errorOnStringTruncationNeedsToBeSentToCNKObj = true;
        m_errorOnStringTruncation = false;
        m_useWindowsStringEncodingNeedsToBeSentToCNKObj = true;
        m_useWindowsStringEncoding = false;
        g_initialLibrariesLoaded = false;
        g_initialLibrariesStatus = "unknown error";
        m_errorOnLevelOverflowNeedsToBeSentToCNKObj = true;
        m_errorOnLevelOverflow = false;
        m_errorOnStringTruncationNeedsToBeSentToCNKObj = true;
        m_errorOnStringTruncation = false;
        m_useWindowsStringEncodingNeedsToBeSentToCNKObj = true;
        m_useWindowsStringEncoding = false;
        boolean ok = true;
        if (ok) {
            status = CNKObj.javaLoadLibrary("cnkbase");
            if (!status.equals("")) {
                g_initialLibrariesStatus = status;
                ok = false;
            }
            boolean useWindowsEncodingFlag = System.getProperty("iminer.use.windows.string.encoding", "").toLowerCase().equals("true");
            CNKObj.setUseWindowsStringEncoding(useWindowsEncodingFlag);
        }
        if (ok && !(status = CNKObj.javaLoadLibrary("cnkjava")).equals("")) {
            g_initialLibrariesStatus = status;
            ok = false;
        }
        if (ok) {
            boolean debugDLL = System.getProperty("iminer.debug.register.library", "").toLowerCase().equals("true");
            CNKObj.setDebugDLLFlag(debugDLL);
            String libPathStatus = CNKObj.set_up_library_path(CNKObj.getLibraryFileName("cnkjava"));
            if (libPathStatus == null || !libPathStatus.equals("")) {
                // empty if block
            }
            CNKObj.registerLibrary("cnkjava");
            CNKObj.registerLibrary("cnkbase");
            CNKObj.registerLibrary("cnkmisc");
            g_initialLibrariesLoaded = true;
        }
        m_doubleDateEpochNeedsToBeSentToCNKObj = true;
        m_doubleDateEpoch = 0L;
    }
}

