/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.cnkjava;

import com.insightful.cnkjava.CNKBuf;
import com.insightful.cnkjava.CNKObj;
import com.insightful.cnkjava.CNKProc;

public class CNKPipeline
extends CNKObj {
    StatusFn m_fn = null;

    public void createPeerObject() {
        this.createCNKObject("cnkbase", new String[]{"CNKPipeline", "CNKObj"});
    }

    public String getStatus() {
        String status = super.getStatus();
        if (status.length() > 0) {
            status = status + ",";
        }
        status = status + "any.ready=" + this.anyProcReady();
        status = status + ",cnt=" + this.getTotalExecutionCount();
        status = status + ",nproc=" + this.getNumProcs();
        status = status + ",nbuf=" + this.getNumBufs();
        return status;
    }

    public void add(CNKBuf buf) {
        this.setProp("add.buf", buf);
    }

    public void add(CNKProc proc) {
        this.setProp("add.proc", proc);
    }

    public void remove(CNKBuf buf) {
        this.setProp("remove.buf", buf);
    }

    public void remove(CNKProc proc) {
        this.setProp("remove.proc", proc);
    }

    public CNKBuf getBuf(int i) {
        CNKBuf buf = this.getCNKBufProp("get.buf.by.number", new Integer(i));
        return buf;
    }

    public CNKBuf getBuf(String str) {
        CNKBuf buf = this.getCNKBufProp("get.buf.by.name", str);
        return buf;
    }

    public CNKProc getProc(int i) {
        CNKProc proc = this.getCNKProcProp("get.proc.by.number", new Integer(i));
        return proc;
    }

    public CNKProc getProc(String str) {
        CNKProc proc = this.getCNKProcProp("get.proc.by.name", str);
        return proc;
    }

    public int getNumBufs() {
        int val = this.getIntProp("get.num.bufs", null);
        return val;
    }

    public int getNumProcs() {
        int val = this.getIntProp("get.num.procs", null);
        return val;
    }

    public CNKBuf[] getBufs() {
        int num = this.getNumBufs();
        CNKBuf[] val = new CNKBuf[num];
        for (int i = 0; i < num; ++i) {
            val[i] = this.getBuf(i);
        }
        return val;
    }

    public CNKProc[] getProcs() {
        int num = this.getNumProcs();
        CNKProc[] val = new CNKProc[num];
        for (int i = 0; i < num; ++i) {
            val[i] = this.getProc(i);
        }
        return val;
    }

    public void destroyPipeline(boolean all) {
        if (all) {
            CNKProc[] procs = this.getProcs();
            for (int i = 0; i < procs.length; ++i) {
                if (procs[i] == null) continue;
                procs[i].destroyCNKObj();
            }
            CNKBuf[] bufs = this.getBufs();
            for (int i = 0; i < bufs.length; ++i) {
                if (bufs[i] == null) continue;
                bufs[i].destroyCNKObj();
            }
        }
        this.destroyCNKObj();
    }

    public void execute(long count) {
        this.setProp("execute", new Long(count));
    }

    public boolean anyProcReady() {
        boolean val = this.getBooleanProp("any.proc.ready", null);
        return val;
    }

    public long getLastExecutionCount() {
        long val = this.getLongProp("last.execution.count", null);
        return val;
    }

    public long getTotalExecutionCount() {
        long val = this.getLongProp("total.execution.count", null);
        return val;
    }

    private void printStatus(long iter) {
        System.out.println("status iter=" + iter);
        if (this.m_fn != null) {
            this.m_fn.run(this);
        }
        CNKProc[] procs = this.getProcs();
        for (int i = 0; i < procs.length; ++i) {
            System.out.println("p" + i + ": " + String.valueOf(procs[i]));
        }
        CNKBuf[] bufs = this.getBufs();
        for (int i = 0; i < bufs.length; ++i) {
            System.out.println("b" + i + ": " + String.valueOf(bufs[i]));
        }
    }

    public void run() {
        this.run(0L, true, 100L);
    }

    public void run(long count, boolean status, long statusCount) {
        if (status) {
            this.printStatus(0L);
        }
        long iter = 0L;
        long iterStatus = 0L;
        long cIter = count;
        if (status && statusCount > 0L && (count <= 0L || count > statusCount)) {
            cIter = statusCount;
        }
        while (true) {
            if (count > 0L && iter + cIter > count) {
                cIter = count - iter;
            }
            this.execute(cIter);
            long cIterDone = this.getLastExecutionCount();
            if (!this.anyProcReady() || count > 0L && (iter += cIterDone) >= count) break;
            if (!status || statusCount <= 0L || (iterStatus += cIterDone) < statusCount) continue;
            iterStatus = 0L;
            this.printStatus(iter);
        }
        if (status) {
            this.printStatus(iter);
        }
    }

    public void setStatusFn(StatusFn fn) {
        this.m_fn = fn;
    }

    public static interface StatusFn {
        public void run(CNKPipeline var1);
    }
}

