/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKObj;
import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcAssocRules;
import com.insightful.miner.EngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.util.Vector;

public class AssocRulesEngineNode
extends EngineNode {
    public static String INPUT_FORMAT_ITEM_LIST = "item.list";
    public static String INPUT_FORMAT_COLUMN_VALUE = "column.value";
    public static String INPUT_FORMAT_COLUMN_FLAG = "column.flag";
    public static String INPUT_FORMAT_TRANSACTION_ID = "transaction.id";
    public static String INPUT_FORMAT_TAG = "inputFormat";
    public static String ITEM_COLUMNS_TAG = "itemColumns";
    public static String ID_COLUMNS_TAG = "idColumns";
    public static String MIN_SUPPORT_TAG = "minSupport";
    public static String MIN_CONFIDENCE_TAG = "minConfidence";
    public static String MAX_RULE_ITEMS_TAG = "maxRuleItems";
    public static String MIN_RULE_ITEMS_TAG = "minRuleItems";
    public static String OUTPUT_RULE_STRINGS_TAG = "outputRuleStrings";
    public static String OUTPUT_RULE_ITEMS_TAG = "outputRuleItems";
    public static String OUTPUT_RULE_SIZES_TAG = "outputRuleSizes";
    public static String OUTPUT_MEASURES_TAG = "outputMeasures";
    public static String OUTPUT_COUNTS_TAG = "outputCounts";
    public static String DEBUG_TAG = "debug";
    public static String USE_INIT_ITEMS_TAG = "useInitItems";
    public static String INIT_ITEMS_TAG = "initItems";
    public static String EXTRACT_ITEMS_TAG = "extractItems";
    public static String RULE_SUPPORT_BOTH_TAG = "ruleSupportBoth";

    public boolean hasCNKProc() {
        return true;
    }

    public boolean hasDataCacheProc() {
        return false;
    }

    public CNKProc procCreate() {
        CNKProcAssocRules proc = new CNKProcAssocRules();
        return proc;
    }

    public void procSetProperties(CNKProc proc) throws Exception {
        int i;
        XTMetaData inputMD = this.getInputMetaData(0);
        XTProps props = this.getNodeProperties();
        String inputFormat = props.getValue(INPUT_FORMAT_TAG, INPUT_FORMAT_ITEM_LIST);
        Vector itemColumns = props.getSubProperties(ITEM_COLUMNS_TAG);
        Vector idColumns = props.getSubProperties(ID_COLUMNS_TAG);
        double minSupport = props.getDouble(MIN_SUPPORT_TAG, 0.1);
        double minConfidence = props.getDouble(MIN_CONFIDENCE_TAG, 0.8);
        int maxRuleItems = props.getInt(MAX_RULE_ITEMS_TAG, 5);
        int minRuleItems = props.getInt(MIN_RULE_ITEMS_TAG, 1);
        boolean outputRuleStrings = props.getBoolean(OUTPUT_RULE_STRINGS_TAG, true);
        boolean outputRuleItems = props.getBoolean(OUTPUT_RULE_ITEMS_TAG, false);
        boolean outputRuleSizes = props.getBoolean(OUTPUT_RULE_SIZES_TAG, false);
        boolean outputMeasures = props.getBoolean(OUTPUT_MEASURES_TAG, true);
        boolean outputCounts = props.getBoolean(OUTPUT_COUNTS_TAG, false);
        boolean debug = props.getBoolean(DEBUG_TAG, false);
        boolean ruleSupportBoth = props.getBoolean(RULE_SUPPORT_BOTH_TAG, true);
        CNKProcAssocRules p = (CNKProcAssocRules)proc;
        p.setDebug(debug);
        p.setInputFormat(inputFormat);
        p.clearColumns();
        for (i = 0; i < itemColumns.size(); ++i) {
            p.addItemColumn(inputMD.nameToOrdinal((String)itemColumns.get(i)));
        }
        for (i = 0; i < idColumns.size(); ++i) {
            p.addIdColumn(inputMD.nameToOrdinal((String)idColumns.get(i)));
        }
        boolean extractItems = props.getBoolean(EXTRACT_ITEMS_TAG, false);
        p.setExtractItems(extractItems);
        if (!extractItems) {
            p.setMinSupport(minSupport);
            p.setMinConfidence(minConfidence);
            p.setMaxRuleItems(maxRuleItems);
            p.setMinRuleItems(minRuleItems);
            p.setOutputRuleStrings(outputRuleStrings);
            p.setOutputRuleItems(outputRuleItems);
            p.setOutputRuleSizes(outputRuleSizes);
            p.setOutputMeasures(outputMeasures);
            p.setOutputCounts(outputCounts);
            p.setRuleSupportBoth(ruleSupportBoth);
            boolean useInitItems = props.getBoolean(USE_INIT_ITEMS_TAG, false);
            p.setUseInitItems(useInitItems);
            if (useInitItems) {
                Vector initItems = props.getSubProperties(INIT_ITEMS_TAG);
                p.clearInitItems();
                for (int i2 = 0; i2 < initItems.size(); ++i2) {
                    p.addInitItem((String)initItems.get(i2));
                }
            }
        }
    }

    private static int getStringUTF8Length(String val) {
        int ret = 0;
        if (val != null) {
            try {
                ret = val.length();
                ret = val.getBytes("UTF-8").length;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    public static int getColWidth(XTMetaData md, int colNum, int defaultStringSize) {
        if (md.isStringColumn(colNum)) {
            double maxCharsInData = md.getColumnMax(colNum) + 1.0;
            int columnWidth = md.getStringDataFieldWidth(colNum) + 1;
            if (!CNKObj.isDoubleNA(maxCharsInData) && maxCharsInData > 0.0 && maxCharsInData < (double)columnWidth) {
                return (int)maxCharsInData;
            }
            return columnWidth;
        }
        if (md.isCategoricalColumn(colNum)) {
            Vector levels = md.getCategoricalDataFieldLevels(md.ordinalToName(colNum));
            int numLevels = levels.size();
            int maxLen = 0;
            for (int i = 0; i < numLevels; ++i) {
                String levelString = (String)levels.get(i);
                maxLen = Math.max(maxLen, AssocRulesEngineNode.getStringUTF8Length(levelString));
            }
            return maxLen;
        }
        return defaultStringSize;
    }

    public static int getMaxItemWidth(XTMetaData inputMD, Vector itemColumns, String inputFormat, int defaultStringSize) {
        int maxItemWidth = 32;
        for (int i = 0; i < itemColumns.size(); ++i) {
            String columnName = (String)itemColumns.get(i);
            int colNum = inputMD.nameToOrdinal(columnName);
            if (colNum < 0) continue;
            int itemWidth = 0;
            itemWidth = inputFormat.equals(INPUT_FORMAT_COLUMN_VALUE) ? AssocRulesEngineNode.getStringUTF8Length(columnName) + 1 + AssocRulesEngineNode.getColWidth(inputMD, colNum, defaultStringSize) : (inputFormat.equals(INPUT_FORMAT_COLUMN_FLAG) ? AssocRulesEngineNode.getStringUTF8Length(columnName) : AssocRulesEngineNode.getColWidth(inputMD, colNum, defaultStringSize));
            maxItemWidth = Math.max(maxItemWidth, itemWidth);
        }
        return maxItemWidth;
    }

    public static XTMetaData calculateAssocRulesOutputMD(XTMetaData inputMD, XTProps props, int defaultStringSize) {
        XTMetaData md = null;
        try {
            md = new XTMetaData();
            boolean extractItems = props.getBoolean(EXTRACT_ITEMS_TAG, false);
            String inputFormat = props.getValue(INPUT_FORMAT_TAG, INPUT_FORMAT_ITEM_LIST);
            Vector itemColumns = props.getSubProperties(ITEM_COLUMNS_TAG);
            int maxItemWidth = AssocRulesEngineNode.getMaxItemWidth(inputMD, itemColumns, inputFormat, defaultStringSize);
            if (extractItems) {
                md.appendStringDataField("item", maxItemWidth + 2);
                md.appendContinousDataField("transaction");
            } else {
                int maxRuleItems = props.getInt(MAX_RULE_ITEMS_TAG, 5);
                int maxRuleBytes = (maxItemWidth + 1) * maxRuleItems + 10;
                boolean outputRuleStrings = props.getBoolean(OUTPUT_RULE_STRINGS_TAG, true);
                boolean outputRuleItems = props.getBoolean(OUTPUT_RULE_ITEMS_TAG, false);
                boolean outputRuleSizes = props.getBoolean(OUTPUT_RULE_SIZES_TAG, false);
                boolean outputMeasures = props.getBoolean(OUTPUT_MEASURES_TAG, true);
                boolean outputCounts = props.getBoolean(OUTPUT_COUNTS_TAG, false);
                if (outputRuleStrings) {
                    md.appendStringDataField("rule", maxRuleBytes);
                }
                if (outputRuleItems) {
                    for (int i = 0; i < maxRuleItems; ++i) {
                        String nm = i < 1 ? "con1" : "ant" + i;
                        md.appendStringDataField(nm, maxItemWidth);
                    }
                }
                if (outputRuleSizes) {
                    md.appendContinousDataField("conSize");
                    md.appendContinousDataField("antSize");
                    md.appendContinousDataField("ruleSize");
                }
                if (outputMeasures) {
                    md.appendContinousDataField("support");
                    md.appendContinousDataField("confidence");
                    md.appendContinousDataField("lift");
                }
                if (outputCounts) {
                    md.appendContinousDataField("conCount");
                    md.appendContinousDataField("antCount");
                    md.appendContinousDataField("ruleCount");
                    md.appendContinousDataField("transCount");
                    md.appendContinousDataField("itemCount");
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return md;
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        XTMetaData inputMD = this.getInputMetaData(0);
        XTProps props = this.getNodeProperties();
        int defaultStringSize = this.getNetworkManager().getDefaultStringSize();
        XTMetaData md = AssocRulesEngineNode.calculateAssocRulesOutputMD(inputMD, props, defaultStringSize);
        return md;
    }

    public long procGetEstimatedNumRows(CNKProc proc) {
        XTMetaData inputMD = this.getInputMetaData(0);
        XTProps props = this.getNodeProperties();
        long inputRows = inputMD.getNumRows();
        int maxRuleItems = props.getInt(MAX_RULE_ITEMS_TAG, 5);
        return inputRows * (long)maxRuleItems;
    }
}

