/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ColumnFilterSpecificationDialog;
import com.insightful.miner.FilterColumnsNodeModel;
import com.insightful.miner.MinerApp;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTNetwork;
import com.insightful.miner.XTProps;
import java.awt.Frame;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ColumnFilterTools {
    private static final Element DEFAULT_XML_ELEMENT = ColumnFilterTools.buildDefaultElement();
    public static final String SELECT_NUMBER_METHOD_CODE = "number";
    public static final String SELECT_RANGE_METHOD_CODE = "range";
    public static final String DIALOG_EXIT_STATUS_PROPERTY = "dialogExitStatus";
    public static final String LABEL_PROPERTY = "label";
    public static final String SELECTION_METHOD_PROPERTY = "method";
    public static final String NUM_TO_KEEP_PROPERTY = "numKeep";
    public static final String MIN_VALUE_PROPERTY = "minValue";
    public static final String MAX_VALUE_PROPERTY = "maxValue";

    private ColumnFilterTools() {
    }

    public static FilterColumnsNodeModel createNodeModel(String[] colNames, XTMetaData metaData) {
        if (colNames == null) {
            return null;
        }
        FilterColumnsNodeModel model = new FilterColumnsNodeModel((Element)DEFAULT_XML_ELEMENT.cloneNode(true));
        XTProps props = model.getXTProps();
        props.set("useGlobal", true);
        props.set("useCache", "global");
        props.set("specifiedRowsToChunk", 0);
        String chunksize = String.valueOf(MinerApp.getWorksheetPropertiesManager().getMaxRowsPerBlock());
        props.set("rowsToChunk", chunksize);
        String[] typePath = new String[]{"excludeColumns", ""};
        String[] rolePath = new String[]{"excludeColumns", "", XTMetaData.ROLE_ATTRIBUTE_TAG};
        for (int i = 0; i < colNames.length; ++i) {
            typePath[1] = colNames[i];
            rolePath[1] = colNames[i];
            props.set(typePath, metaData.getColumnType(colNames[i]));
            props.set(rolePath, metaData.getColumnRole(colNames[i]));
        }
        return model;
    }

    public static String[] showDefaultFilterSpecificationDialog(String[] colNames, double[] statValues, String statName) {
        return ColumnFilterTools.showDefaultFilterSpecificationDialog(MinerApp.getMainFrame(), colNames, statValues, statName);
    }

    public static String[] showDefaultFilterSpecificationDialog(Frame parent, String[] colNames, double[] statValues, String statName) {
        if (colNames == null || statValues == null) {
            throw new IllegalArgumentException("Col names and stat values cannot be null.");
        }
        if (colNames.length != statValues.length) {
            throw new IllegalArgumentException("Length of col names and stat values do not match.");
        }
        if (statName == null || statName.length() == 0) {
            throw new IllegalArgumentException("Stat name cannot be null or length zero.");
        }
        if (colNames.length == 0) {
            return new String[0];
        }
        XTProps props = null;
        try {
            props = new XTProps();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        props.set(LABEL_PROPERTY, "Statistic: " + statName);
        ColumnFilterSpecificationDialog dialog = new ColumnFilterSpecificationDialog(parent);
        return dialog.show(props, colNames, statValues);
    }

    public static String[] getExcludeColumnsFromFilterSpecification(String[] colNames, double[] statValues, boolean bSpecifyNumber, int numToKeep, double minValue, double maxValue) {
        String[] dropNames;
        block7: {
            int dropCount;
            boolean[] dropFlag;
            block6: {
                dropNames = new String[]{};
                dropFlag = new boolean[colNames.length];
                dropCount = 0;
                if (!bSpecifyNumber) break block6;
                double[] sortedArray = (double[])statValues.clone();
                Arrays.sort(sortedArray);
                dropCount = colNames.length - numToKeep;
                dropNames = new String[dropCount];
                int i = 0;
                for (int j = 0; j < statValues.length && i < dropCount; ++j) {
                    if (!Double.isNaN(statValues[j])) continue;
                    dropNames[i] = colNames[j];
                    dropFlag[j] = true;
                    ++i;
                }
                int k = 0;
                while (i < dropCount) {
                    for (int j = 0; j < statValues.length; ++j) {
                        if (sortedArray[k] != statValues[j] || dropFlag[j]) continue;
                        dropNames[i] = colNames[j];
                        dropFlag[j] = true;
                        j = statValues.length;
                    }
                    ++i;
                    ++k;
                }
                break block7;
            }
            for (int i = 0; i < colNames.length; ++i) {
                if (Double.isNaN(statValues[i])) {
                    dropFlag[i] = true;
                    ++dropCount;
                    continue;
                }
                boolean bl = dropFlag[i] = statValues[i] < minValue || statValues[i] > maxValue;
                if (!dropFlag[i]) continue;
                ++dropCount;
            }
            if (dropCount <= 0) break block7;
            dropNames = new String[dropCount];
            int curIndex = 0;
            for (int i = 0; i < colNames.length; ++i) {
                if (!dropFlag[i]) continue;
                dropNames[curIndex++] = colNames[i];
            }
        }
        return dropNames;
    }

    private static final Element buildDefaultElement() {
        Element activityNode = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document doc = factory.newDocumentBuilder().newDocument();
            activityNode = doc.createElement(XTNetwork.ACTIVITY_NODE_NODE_TAG);
            activityNode.setAttribute(XTNetwork.GUI_CLASS_ATTRIBUTE_TAG, "com.insightful.miner.FilterColumnsNodeModel");
            activityNode.setAttribute(XTNetwork.ENGINE_CLASS_ATTRIBUTE_TAG, "com.insightful.miner.FilterColumnsEngineNode");
            activityNode.setAttribute(XTNetwork.NUM_INPUTS_ATTRIBUTE_TAG, "1");
            activityNode.setAttribute(XTNetwork.NUM_OUTPUTS_ATTRIBUTE_TAG, "1");
            Element displayInfo = doc.createElement(XTNetwork.DISPLAY_INFO_NODE_TAG);
            activityNode.appendChild(displayInfo);
            displayInfo.setAttribute(XTNetwork.DEFAULT_LABEL_TEXT_ATTRIBUTE_TAG, "Filter Columns");
            displayInfo.setAttribute(XTNetwork.LABEL_TEXT_ATTRIBUTE_TAG, "Filter Columns");
            displayInfo.setAttribute(XTNetwork.SMALL_ICON_ATTRIBUTE_TAG, "filter_cols_small.gif");
            displayInfo.setAttribute(XTNetwork.LARGE_ICON_ATTRIBUTE_TAG, "filter_cols_large.gif");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return activityNode;
    }
}

