/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcJavaTransformExec;
import com.insightful.miner.ByColumnStatisticAccumulator;
import com.insightful.miner.EngineMessageHandler;
import com.insightful.miner.EngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Vector;

public class CreateBinsEngineNode
extends EngineNode
implements CNKProcJavaTransformExec {
    public static String COLUMNS_ATTRIBUTE_TAG = "outgoingColumns";
    public static String NUM_BINS_ATTRIBUTE_TAG = "numBins";
    public static String REPLACE_ATTRIBUTE_TAG = "replace";
    public static String SUFFIX_ATTRIBUTE_TAG = "binSuffix";
    public static String EQUAL_COUNTS_ATTRIBUTE_TAG = "equalCounts";
    public static String EQUAL_RANGE_ATTRIBUTE_TAG = "equalRange";
    public static String K_VALUE_ATTRIBUTE_TAG = "kValue";
    public static String USER_DEFINED_ATTRIBUTE_TAG = "userDef";
    public static String IS_USER_DEFINED_ATTRIBUTE_TAG = "isUserDef";
    public static String RANGE_SPECS_ATTRIBUTE_TAG = "range";
    public static String STURGES_ATTRIBUTE_TAG = "sturges";
    public static String FREEDMAN_ATTRIBUTE_TAG = "freedman";
    public static String SCOTT_ATTRIBUTE_TAG = "scott";
    public static int DEFAULT_K_VALUE = 5000;
    private boolean[] m_columnsToBin = null;
    private int[] m_numBins = null;
    private int[] m_mapping = null;
    private int m_numColumns = 0;
    protected double[][] m_binMaxVals = null;
    protected double[][] m_binRanges = null;
    private XTMetaData m_metaData = null;
    private boolean m_replace = false;
    private Vector m_binColumns = null;
    private boolean m_calculateHistogramRun = true;
    private boolean m_calculateFreedmanNumBinsRun = true;
    private ByColumnStatisticAccumulator.ByContinuousColumnStats[] m_freedmanBCS = null;
    private boolean m_allSturges = false;
    private boolean m_allFreedman = false;
    private boolean m_allScott = false;
    private boolean m_anySturges = false;
    private boolean m_anyFreedman = false;
    private boolean m_anyScott = false;
    private boolean[] m_userDefinedSturges = null;
    private boolean[] m_userDefinedFreedman = null;
    private boolean[] m_userDefinedScott = null;
    private boolean m_equalCounts = true;
    private ByColumnStatisticAccumulator.ByContinuousColumnStats[] m_bCS = null;
    private int m_kValue = DEFAULT_K_VALUE;
    private String[][] m_newLevels = null;
    private int[][] m_orderNewLevels = null;
    private int[] m_lastLevel = null;
    private DecimalFormat m_format = new DecimalFormat();
    private String m_statusBarText = null;

    public boolean hasCNKProc() {
        return true;
    }

    public boolean hasDataCacheProc() {
        return false;
    }

    public CNKProc procCreate() {
        CNKProcJavaTransform proc = new CNKProcJavaTransform();
        proc.setExecObject(this);
        return proc;
    }

    public void procSetProperties(CNKProc proc) {
        int existColumns;
        boolean userDefined;
        XTProps dialogProps = this.getNodeProperties();
        this.m_metaData = this.getInputMetaData(0);
        this.m_statusBarText = null;
        this.m_binColumns = dialogProps.getSubProperties(COLUMNS_ATTRIBUTE_TAG);
        this.m_replace = dialogProps.getBoolean(REPLACE_ATTRIBUTE_TAG, true);
        this.m_equalCounts = dialogProps.getBoolean(EQUAL_COUNTS_ATTRIBUTE_TAG, false);
        this.m_kValue = dialogProps.getInt(K_VALUE_ATTRIBUTE_TAG, DEFAULT_K_VALUE);
        this.m_allSturges = dialogProps.getBoolean(STURGES_ATTRIBUTE_TAG, false);
        this.m_allFreedman = dialogProps.getBoolean(FREEDMAN_ATTRIBUTE_TAG, false);
        this.m_allScott = dialogProps.getBoolean(SCOTT_ATTRIBUTE_TAG, false);
        boolean bl = userDefined = dialogProps.getBoolean(USER_DEFINED_ATTRIBUTE_TAG, false) || dialogProps.getBoolean(IS_USER_DEFINED_ATTRIBUTE_TAG, false);
        if (userDefined) {
            this.m_equalCounts = false;
        }
        int binCount = dialogProps.getInt(NUM_BINS_ATTRIBUTE_TAG, 0);
        int digitCount = (int)(Math.log(binCount) / Math.log(10.0) + 1.0E-4) + 1;
        this.m_format = new DecimalFormat();
        this.m_format.setMinimumIntegerDigits(digitCount);
        this.m_format.setMaximumFractionDigits(0);
        this.m_format.setGroupingUsed(false);
        int totalColumns = existColumns = this.m_metaData.getNumColumns();
        this.m_numColumns = this.m_binColumns.size();
        if (!this.m_replace) {
            totalColumns += this.m_numColumns;
        }
        this.m_bCS = new ByColumnStatisticAccumulator.ByContinuousColumnStats[totalColumns];
        this.m_columnsToBin = new boolean[totalColumns];
        this.m_numBins = new int[totalColumns];
        this.m_binMaxVals = new double[totalColumns][];
        this.m_binRanges = new double[totalColumns][];
        this.m_mapping = new int[totalColumns];
        this.m_lastLevel = new int[totalColumns];
        this.m_newLevels = new String[totalColumns][];
        this.m_orderNewLevels = new int[totalColumns][];
        this.m_freedmanBCS = new ByColumnStatisticAccumulator.ByContinuousColumnStats[totalColumns];
        this.m_userDefinedFreedman = new boolean[totalColumns];
        this.m_userDefinedSturges = new boolean[totalColumns];
        this.m_userDefinedScott = new boolean[totalColumns];
        this.m_calculateFreedmanNumBinsRun = false;
        this.m_anyFreedman = false;
        this.m_anySturges = false;
        this.m_anyScott = false;
        String[] udPath = new String[]{USER_DEFINED_ATTRIBUTE_TAG, "", ""};
        int newCol = existColumns;
        for (int column = 0; column < this.m_numColumns; ++column) {
            boolean freedman;
            int origColumnNum;
            String columnName;
            udPath[1] = columnName = (String)this.m_binColumns.get(column);
            int columnNum = origColumnNum = this.m_metaData.nameToOrdinal(columnName);
            if (!this.m_replace) {
                this.m_mapping[columnNum] = newCol;
                columnNum = newCol++;
            } else {
                this.m_mapping[columnNum] = columnNum;
            }
            this.m_columnsToBin[origColumnNum] = true;
            this.m_bCS[origColumnNum] = null;
            this.m_freedmanBCS[origColumnNum] = null;
            udPath[2] = NUM_BINS_ATTRIBUTE_TAG;
            this.m_numBins[columnNum] = userDefined ? dialogProps.getInt(udPath, binCount) : binCount;
            udPath[2] = STURGES_ATTRIBUTE_TAG;
            boolean sturges = this.m_allSturges ? true : userDefined && dialogProps.getBoolean(udPath, false) && !this.m_allScott && !this.m_allFreedman;
            udPath[2] = SCOTT_ATTRIBUTE_TAG;
            boolean scott = this.m_allScott ? true : userDefined && dialogProps.getBoolean(udPath, false) && !this.m_allSturges && !this.m_allFreedman;
            udPath[2] = FREEDMAN_ATTRIBUTE_TAG;
            boolean bl2 = this.m_allFreedman ? true : (freedman = userDefined && dialogProps.getBoolean(udPath, false) && !this.m_allScott && !this.m_allSturges);
            if (sturges) {
                this.m_numBins[columnNum] = CreateBinsEngineNode.sturges(this.m_metaData);
                this.m_userDefinedSturges[columnNum] = true;
                this.m_anySturges = true;
            } else if (scott) {
                this.m_numBins[columnNum] = CreateBinsEngineNode.scott(this.m_metaData, udPath[1]);
                this.m_userDefinedScott[columnNum] = true;
                this.m_anyScott = true;
            } else if (freedman) {
                this.m_freedmanBCS[origColumnNum] = new ByColumnStatisticAccumulator.ByContinuousColumnStats(1, this.m_metaData.getColumnMin(columnName), this.m_metaData.getColumnMax(columnName), this.m_metaData.getNumRows(), 4, this.m_kValue);
                this.m_userDefinedFreedman[origColumnNum] = true;
                this.m_calculateFreedmanNumBinsRun = true;
                this.m_anyFreedman = true;
                continue;
            }
            this.setColumnBinProperties(columnNum, origColumnNum, columnName, userDefined, dialogProps);
        }
        this.m_calculateHistogramRun = true;
        this.setUpdateResponsibility(this);
    }

    private void setColumnBinProperties(int columnNum, int origColumnNum, String columnName, boolean userDefined, XTProps dialogProps) {
        String[] udPath = new String[]{USER_DEFINED_ATTRIBUTE_TAG, columnName, ""};
        this.m_binMaxVals[columnNum] = new double[this.m_numBins[columnNum]];
        this.m_binRanges[columnNum] = new double[2];
        this.m_newLevels[columnNum] = new String[this.m_numBins[columnNum]];
        this.m_orderNewLevels[columnNum] = new int[this.m_numBins[columnNum]];
        for (int i = 0; i < this.m_orderNewLevels[columnNum].length; ++i) {
            this.m_orderNewLevels[columnNum][i] = -1;
        }
        udPath[2] = EQUAL_COUNTS_ATTRIBUTE_TAG;
        if (this.m_equalCounts || userDefined && dialogProps.getBoolean(udPath, false)) {
            int kValue = this.m_kValue;
            long numRows = this.m_metaData.getNumRows();
            try {
                this.m_bCS[origColumnNum] = new ByColumnStatisticAccumulator.ByContinuousColumnStats(1, this.m_metaData.getColumnMin(columnName), this.m_metaData.getColumnMax(columnName), numRows, this.m_numBins[columnNum], kValue);
                this.m_bCS[origColumnNum].initQuantileStatistics(numRows);
            }
            catch (OutOfMemoryError oom) {
                String totalMem = this.getNetworkManager().getWorksheetPropertiesManager().formatFreeDouble((double)(this.m_numBins[columnNum] * kValue) * 2.0);
                this.printlnError("Unable to allocate required space.  Requesting " + this.m_numBins[columnNum] + " bins * " + kValue + " doubles = " + totalMem + " bytes");
                for (int i = 0; i < this.m_columnsToBin.length; ++i) {
                    this.m_bCS[i] = null;
                }
                return;
            }
            catch (Exception e) {
                this.printlnError("Unable to calculate equal counts.");
                for (int i = 0; i < this.m_columnsToBin.length; ++i) {
                    this.m_bCS[i] = null;
                }
                return;
            }
        } else {
            double[] edges = null;
            boolean useEdges = false;
            udPath[2] = EQUAL_RANGE_ATTRIBUTE_TAG;
            if (userDefined && !dialogProps.getBoolean(udPath, false)) {
                udPath[2] = RANGE_SPECS_ATTRIBUTE_TAG;
                String str = dialogProps.getValue(udPath);
                if (str.length() > 0) {
                    edges = this.convertStringToArray(str);
                    useEdges = edges != null && edges.length > 0;
                }
            }
            double maxVal = this.m_metaData.getColumnMax(columnName);
            double minVal = this.m_metaData.getColumnMin(columnName);
            double binInc = (maxVal - minVal) / (double)this.m_numBins[columnNum];
            double maxBinVal = maxVal;
            double minBinVal = minVal;
            for (int bin = 0; bin < this.m_numBins[columnNum]; ++bin) {
                String highStr;
                if (useEdges) {
                    if (bin == 0) {
                        maxBinVal = minBinVal = edges[bin];
                    } else if (bin < edges.length) {
                        if (maxBinVal < edges[bin]) {
                            maxBinVal = edges[bin];
                        }
                        if (minBinVal > edges[bin]) {
                            minBinVal = edges[bin];
                        }
                    }
                }
                if (bin < this.m_numBins[columnNum] - 1) {
                    this.m_binMaxVals[columnNum][bin] = useEdges ? edges[bin] : minVal + binInc * (double)(bin + 1);
                    if (bin == this.m_numBins[columnNum] - 2) {
                        this.m_binMaxVals[columnNum][bin + 1] = maxVal;
                    }
                }
                this.m_binRanges[columnNum][0] = minBinVal;
                this.m_binRanges[columnNum][1] = maxBinVal;
                this.m_newLevels[columnNum][bin] = this.m_format.format(bin + 1);
                String lowStr = useEdges ? (bin == 0 ? this.getRoundedString(this.m_metaData, origColumnNum, minVal) : this.getRoundedString(this.m_metaData, origColumnNum, edges[bin - 1])) : this.getRoundedString(this.m_metaData, origColumnNum, minVal + binInc * (double)bin);
                if (bin == this.m_numBins[columnNum] - 1) {
                    highStr = this.getRoundedString(this.m_metaData, origColumnNum, maxVal);
                    String[] stringArray = this.m_newLevels[columnNum];
                    int n = bin;
                    stringArray[n] = stringArray[n] + ": [" + lowStr + "," + highStr + "]";
                    continue;
                }
                highStr = useEdges ? this.getRoundedString(this.m_metaData, origColumnNum, edges[bin]) : this.getRoundedString(this.m_metaData, origColumnNum, minVal + binInc * (double)(bin + 1));
                String[] stringArray = this.m_newLevels[columnNum];
                int n = bin;
                stringArray[n] = stringArray[n] + ": [" + lowStr + "," + highStr + ")";
            }
        }
    }

    protected double getBinNum(int column, double val) {
        if (Double.isNaN(val)) {
            return val;
        }
        for (int bin = 0; bin < this.m_numBins[column]; ++bin) {
            if (!(val < this.m_binMaxVals[column][bin])) continue;
            return bin;
        }
        return this.m_numBins[column] - 1;
    }

    public void execute(CNKProcJavaTransform proc) {
        long total;
        long chunk;
        boolean endCase;
        long start = proc.getChunkInputPosition(0);
        boolean bl = endCase = start + (chunk = (long)proc.getChunkInputRows(0)) == (total = this.m_metaData.getNumRows());
        if (this.m_calculateFreedmanNumBinsRun) {
            try {
                this.calculateFreedmanNumBins(proc);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.printlnError("Unable to calculate the number of bins with Freedman-Diaconis.");
                this.m_calculateFreedmanNumBinsRun = false;
            }
        }
        if (this.m_calculateHistogramRun) {
            try {
                this.calculateHistogram(proc);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.printlnError("Unable to calculate equal counts.  Using equal ranges.");
                this.m_calculateHistogramRun = false;
            }
        }
        if (start == 0L) {
            this.resetProgressIndicator();
        }
        int inputRows = proc.getChunkInputRows(0);
        int inputColumns = this.m_metaData.getNumColumns();
        double[] inputColumn = null;
        double[] binOutputColumn = null;
        for (int column = 0; column < inputColumns; ++column) {
            int mappedColumn = this.m_mapping[column];
            if (this.m_columnsToBin[column]) {
                inputColumn = proc.getChunkInputColumnData(0, column);
                if (!this.m_replace) {
                    proc.copyColumnData(0, column, 0, 0, column, 0, inputRows);
                }
                binOutputColumn = proc.getChunkOutputColumnData(0, mappedColumn);
                for (int row = 0; row < inputRows; ++row) {
                    if (Double.isNaN(inputColumn[row])) {
                        binOutputColumn[row] = inputColumn[row];
                        continue;
                    }
                    double num = this.getBinNum(mappedColumn, inputColumn[row]);
                    double mapped = this.findLevel(mappedColumn, num);
                    if (mapped == -1.0) {
                        this.m_orderNewLevels[mappedColumn][this.m_lastLevel[mappedColumn]] = (int)num;
                        int n = mappedColumn;
                        int n2 = this.m_lastLevel[n];
                        this.m_lastLevel[n] = n2 + 1;
                        mapped = n2;
                    }
                    binOutputColumn[row] = mapped;
                }
                if (!endCase) continue;
                int numLevels = this.m_lastLevel[mappedColumn];
                String[] outLevels = new String[numLevels];
                for (int i = 0; i < outLevels.length; ++i) {
                    int levelNum = this.m_orderNewLevels[mappedColumn][i];
                    outLevels[i] = this.m_newLevels[mappedColumn][levelNum];
                }
                proc.getOutbuf().setColumnLevelStrings(mappedColumn, outLevels);
                continue;
            }
            proc.copyColumnData(0, column, 0, 0, column, 0, inputRows);
        }
        double percent = (double)(start + chunk) / (double)total;
        this.updateProgressIndicator((int)(100.0 * percent), this);
    }

    protected double findLevel(int column, double binNum) {
        for (int i = 0; i < this.m_lastLevel[column]; ++i) {
            if ((double)this.m_orderNewLevels[column][i] != binNum) continue;
            return i;
        }
        return -1.0;
    }

    protected void updateBinColumn(XTMetaData outputMD, String colName, boolean replace, String suffix) {
        String[] levels = new String[]{};
        if (!replace) {
            outputMD.appendCategoricalDataField(colName + "." + suffix, levels);
        } else {
            outputMD.appendCategoricalDataField(colName, levels);
        }
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        String colName;
        int column;
        int existColumns;
        XTProps dialogProps = this.getNodeProperties();
        XTMetaData metaData = this.getInputMetaData(0);
        Vector binColumns = dialogProps.getSubProperties(COLUMNS_ATTRIBUTE_TAG);
        boolean replace = dialogProps.getBoolean(REPLACE_ATTRIBUTE_TAG, true);
        XTMetaData outputMD = null;
        try {
            outputMD = new XTMetaData();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        int totalColumns = existColumns = metaData.getNumColumns();
        int numColumns = binColumns.size();
        if (!replace) {
            totalColumns += numColumns;
        }
        boolean[] columnsToBin = new boolean[totalColumns];
        String suffix = dialogProps.getValue(SUFFIX_ATTRIBUTE_TAG, "bin");
        for (column = 0; column < numColumns; ++column) {
            columnsToBin[column] = false;
        }
        int exist = existColumns;
        for (column = 0; column < numColumns; ++column) {
            if (!replace) {
                columnsToBin[exist++] = true;
                continue;
            }
            colName = (String)binColumns.get(column);
            columnsToBin[metaData.nameToOrdinal((String)colName)] = true;
        }
        int newCol = 0;
        for (column = 0; column < totalColumns; ++column) {
            colName = null;
            colName = column < existColumns ? metaData.ordinalToName(column) : (String)binColumns.get(newCol++);
            if (columnsToBin[column]) {
                this.updateBinColumn(outputMD, colName, replace, suffix);
                continue;
            }
            if (metaData.isCategoricalColumn(column)) {
                outputMD.appendCategoricalDataField(colName, metaData.getCategoricalDataFieldLevels(colName));
                outputMD.setDataFieldRole(colName, metaData.getColumnRole(colName));
                continue;
            }
            if (metaData.isContinuousColumn(column)) {
                outputMD.appendContinousDataField(colName);
                outputMD.setDataFieldRole(colName, metaData.getColumnRole(colName));
                continue;
            }
            if (metaData.isDateTimeColumn(column)) {
                outputMD.appendDateTimeDataField(colName);
                outputMD.setDataFieldRole(colName, metaData.getColumnRole(colName));
                continue;
            }
            if (metaData.isBlobColumn(column)) {
                outputMD.appendBlobDataField(colName, metaData.getBlobDataFieldClassName(column));
                outputMD.setDataFieldRole(colName, metaData.getColumnRole(colName));
                continue;
            }
            outputMD.appendStringDataField(colName, metaData.getStringDataFieldWidth(colName));
            outputMD.setDataFieldRole(colName, metaData.getColumnRole(colName));
        }
        return outputMD;
    }

    private void calculateFreedmanNumBins(CNKProcJavaTransform proc) throws Exception {
        if (this.m_statusBarText == null) {
            this.m_statusBarText = (String)EngineMessageHandler.sendMessageToApp("getStatusText", new Object[0]);
            String str = this.m_statusBarText + ": Calculating bin count using Freedman-Diaconis...";
            EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{str});
            this.resetProgressIndicator();
        }
        long curPos = proc.getChunkInputPosition(0);
        int nRowBlock = proc.getChunkInputRows(0);
        long totRows = this.m_metaData.getNumRows();
        double startPercent = 100.0 * (double)curPos / (double)totRows;
        double chunkPercent = 100.0 * (double)nRowBlock / (double)totRows;
        if (curPos + (long)nRowBlock > totRows) {
            nRowBlock = (int)(totRows - curPos);
        }
        int totalColumns = this.m_columnsToBin.length;
        int idx = 0;
        for (int i = 0; i < totalColumns; ++i) {
            if (this.m_columnsToBin[i] && this.m_freedmanBCS[i] != null) {
                double[] columnData = proc.getChunkInputColumnData(0, i);
                for (int j = 0; j < nRowBlock; ++j) {
                    this.m_freedmanBCS[i].updateBinAndRowCount(columnData[j]);
                }
                ++idx;
            }
            double percent = startPercent + chunkPercent * (double)i / (double)totalColumns;
            this.updateProgressIndicator((int)percent, this);
        }
        proc.setChunkOutputReleaseRows(0, 0);
        if (curPos + (long)nRowBlock == this.m_metaData.getNumRows()) {
            proc.setChunkNextInputPosition(0, 0L);
            this.m_calculateFreedmanNumBinsRun = false;
            EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{this.m_statusBarText});
            this.m_statusBarText = null;
            XTProps dialogProps = this.getNodeProperties();
            boolean userDefined = dialogProps.getBoolean(USER_DEFINED_ATTRIBUTE_TAG, false) || dialogProps.getBoolean(IS_USER_DEFINED_ATTRIBUTE_TAG, false);
            int count = -1;
            for (int i = 0; i < this.m_columnsToBin.length; ++i) {
                int numBins;
                if (!this.m_columnsToBin[i]) continue;
                ++count;
                if (!this.m_userDefinedFreedman[i] && !this.m_allFreedman) continue;
                String columnName = (String)this.m_binColumns.get(count);
                int columnNum = this.m_mapping[i];
                int origColumnNum = this.m_metaData.nameToOrdinal(columnName);
                double quarterBound = this.m_freedmanBCS[origColumnNum].getQuantileBound(0);
                double threeQuarterBound = this.m_freedmanBCS[origColumnNum].getQuantileBound(2);
                double iqr = threeQuarterBound - quarterBound;
                if (iqr == 0.0) {
                    iqr = this.m_metaData.getColumnMax(columnName) - this.m_metaData.getColumnMin(columnName);
                    this.printlnWarning("Failure in Freedman-Diaconis: Interquantile Range is 0 for column: " + columnName);
                    this.printlnWarning("Using full range (" + iqr + ") as Interquantile Range.");
                }
                double val = 2.0 * iqr / Math.pow(this.m_metaData.getNumRows(), 0.3333333333333333);
                val = (this.m_metaData.getColumnMax(columnName) - this.m_metaData.getColumnMin(columnName)) / val;
                this.m_numBins[columnNum] = numBins = (int)Math.ceil(val);
                this.setColumnBinProperties(columnNum, origColumnNum, columnName, userDefined, dialogProps);
            }
        }
    }

    private void calculateHistogram(CNKProcJavaTransform proc) throws Exception {
        if (this.m_statusBarText == null) {
            this.m_statusBarText = (String)EngineMessageHandler.sendMessageToApp("getStatusText", new Object[0]);
            String str = this.m_statusBarText + ": Calculating bin size using quantile approximation...";
            EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{str});
            this.resetProgressIndicator();
        }
        long curPos = proc.getChunkInputPosition(0);
        int nRowBlock = proc.getChunkInputRows(0);
        long totRows = this.m_metaData.getNumRows();
        double startPercent = 100.0 * (double)curPos / (double)totRows;
        double chunkPercent = 100.0 * (double)nRowBlock / (double)totRows;
        if (curPos + (long)nRowBlock > totRows) {
            nRowBlock = (int)(totRows - curPos);
        }
        int totalColumns = this.m_columnsToBin.length;
        int idx = 0;
        for (int i = 0; i < totalColumns; ++i) {
            if (this.m_columnsToBin[i] && this.m_bCS[i] != null) {
                double[] columnData = proc.getChunkInputColumnData(0, i);
                for (int j = 0; j < nRowBlock; ++j) {
                    this.m_bCS[i].updateBinAndRowCount(columnData[j]);
                }
                ++idx;
            }
            double percent = startPercent + chunkPercent * (double)i / (double)totalColumns;
            this.updateProgressIndicator((int)percent, this);
        }
        proc.setChunkOutputReleaseRows(0, 0);
        if (curPos + (long)nRowBlock == this.m_metaData.getNumRows()) {
            proc.setChunkNextInputPosition(0, 0L);
            this.m_calculateHistogramRun = false;
            EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{this.m_statusBarText});
            this.m_statusBarText = null;
            DecimalFormat format = new DecimalFormat();
            format.setMaximumFractionDigits(0);
            format.setGroupingUsed(false);
            for (int i = 0; i < this.m_columnsToBin.length; ++i) {
                double lowVal;
                if (!this.m_columnsToBin[i] || this.m_bCS[i] == null) continue;
                int outputIndex = this.m_replace ? i : this.m_mapping[i];
                int binCount = this.m_bCS[i].getNumQuantileBounds() + 1;
                int digitCount = (int)(Math.log(binCount) / Math.log(10.0) + 1.0E-4) + 1;
                format.setMinimumIntegerDigits(digitCount);
                this.m_binRanges[outputIndex][0] = lowVal = this.m_bCS[i].getColumnMin();
                this.m_binRanges[outputIndex][1] = this.m_bCS[i].getColumnMax();
                for (int j = 0; j < binCount; ++j) {
                    double highVal;
                    this.m_binMaxVals[outputIndex][j] = highVal = j == binCount - 1 ? this.m_bCS[i].getColumnMax() : this.m_bCS[i].getQuantileBound(j);
                    if (j < binCount - 1) {
                        this.m_binMaxVals[outputIndex][j] = highVal;
                        if (j == binCount - 2) {
                            this.m_binMaxVals[outputIndex][j + 1] = highVal;
                        }
                    }
                    this.m_newLevels[outputIndex][j] = format.format(j + 1);
                    String lowStr = this.getRoundedString(this.m_metaData, i, lowVal);
                    String highStr = this.getRoundedString(this.m_metaData, i, highVal);
                    if (j == binCount - 1) {
                        String[] stringArray = this.m_newLevels[outputIndex];
                        int n = j;
                        stringArray[n] = stringArray[n] + ": [" + lowStr + "," + highStr + "]";
                    } else {
                        String[] stringArray = this.m_newLevels[outputIndex];
                        int n = j;
                        stringArray[n] = stringArray[n] + ": [" + lowStr + "," + highStr + ")";
                    }
                    lowVal = highVal;
                }
                this.m_bCS[i] = null;
            }
            this.m_bCS = null;
        }
    }

    public String getRoundedString(XTMetaData md, int column, double val) {
        if (md.isDateTimeColumn(column)) {
            return this.getNetworkManager().getWorksheetPropertiesManager().getDateFormatter().convertJulianDateToString(val);
        }
        return this.getNetworkManager().getWorksheetPropertiesManager().formatDouble(val);
    }

    public double parseRoundedString(XTMetaData md, int column, String str) {
        if (md.isDateTimeColumn(column)) {
            double val = this.getNetworkManager().getWorksheetPropertiesManager().getDateParser().convertStringToTimeDate(str);
            return val / 8.64E7;
        }
        return this.getNetworkManager().getWorksheetPropertiesManager().parseDouble(str);
    }

    public String convertArrayToString(double[] edges) {
        return this.convertArrayToString(null, 0, edges, false);
    }

    public String convertArrayToString(XTMetaData md, int columnNum, double[] edges) {
        return this.convertArrayToString(md, columnNum, edges, true);
    }

    private String convertArrayToString(XTMetaData md, int columnNum, double[] edges, boolean convert) {
        StringBuffer buff = new StringBuffer("");
        for (int i = 0; i < edges.length; ++i) {
            if (i > 0) {
                buff.append("; ");
            }
            if (convert) {
                buff.append(this.getRoundedString(md, columnNum, edges[i]));
                continue;
            }
            buff.append(Double.toString(edges[i]));
        }
        return buff.toString();
    }

    public double[] convertStringToArray(String stringList) {
        return this.convertStringToArray(null, 0, stringList, false);
    }

    public double[] convertStringToArray(XTMetaData md, int columnNum, String stringList) {
        return this.convertStringToArray(md, columnNum, stringList, true);
    }

    private double[] convertStringToArray(XTMetaData md, int columnNum, String stringList, boolean convert) {
        String n;
        String grouping = String.valueOf(this.getNetworkManager().getWorksheetPropertiesManager().getThousandsSeparator());
        String str = stringList.replaceAll(grouping, "").trim();
        Vector<String> numbers = new Vector<String>();
        int comma = str.indexOf(59);
        int len = str.length();
        int beg = 0;
        while (comma > 0) {
            n = str.substring(beg, comma).trim();
            if (n.length() > 0) {
                numbers.add(n);
            }
            beg = comma + 1;
            comma = str.indexOf(59, beg);
        }
        if (beg < len && (n = str.substring(beg, len).trim()).length() > 0) {
            numbers.add(n);
        }
        double[] tedges = new double[numbers.size()];
        int badNumbers = 0;
        for (int i = 0; i < tedges.length; ++i) {
            try {
                String numStr = (String)numbers.get(i);
                if (numStr.equals("Inf")) {
                    tedges[i - badNumbers] = Double.POSITIVE_INFINITY;
                    continue;
                }
                if (numStr.equals("-Inf")) {
                    tedges[i - badNumbers] = Double.NEGATIVE_INFINITY;
                    continue;
                }
                tedges[i - badNumbers] = convert ? this.parseRoundedString(md, columnNum, (String)numbers.get(i)) : Double.parseDouble((String)numbers.get(i));
                if (!Double.isInfinite(tedges[i - badNumbers]) && !Double.isNaN(tedges[i - badNumbers])) continue;
                ++badNumbers;
                continue;
            }
            catch (NumberFormatException e) {
                ++badNumbers;
            }
        }
        double[] edges = new double[tedges.length - badNumbers];
        for (int i = 0; i < edges.length; ++i) {
            edges[i] = tedges[i];
        }
        Arrays.sort(edges);
        return edges;
    }

    public static int sturges(XTMetaData md) {
        long numRows = md.getNumRows();
        if (numRows > 0L) {
            double log = Math.log(numRows);
            int numBins = (int)Math.ceil((log /= Math.log(2.0)) + 1.0);
            return numBins;
        }
        return 1;
    }

    public static int scott(XTMetaData md, String cName) {
        double stdDev = md.getColumnStandardDeviation(cName);
        long numRows = md.getNumRows();
        double range = md.getColumnMax(cName) - md.getColumnMin(cName);
        double val = Math.pow(numRows, 0.3333333333333333);
        val = 3.5 * stdDev / val;
        val = range / val;
        int numBins = (int)Math.ceil(val);
        return numBins;
    }
}

