/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcGLMFit;
import com.insightful.cnkjava.CNKProcIGLM;
import com.insightful.miner.EngineMessageHandler;
import com.insightful.miner.LinearRegressionEngineNode;
import com.insightful.miner.PredictEngineNode;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.util.Arrays;
import java.util.Vector;

public class LogisticRegressionEngineNode
extends LinearRegressionEngineNode {
    public static String FAMILY_TAG = "iglm.family";
    public static String LINK_TAG = "iglm.link";
    public static String VAR_TAG = "iglm.var";
    public static String MEAN_TAG = "iglm.mean";
    private String m_modelString = null;
    public static String MODEL_TYPE_MULINOMIALLOGISTIC = "multinomialLogistic";

    public boolean hasCNKProc() {
        return false;
    }

    public boolean hasDataCacheProc() {
        return true;
    }

    public void procExtractResults(CNKProc proc) {
        if (proc instanceof CNKProcIGLM) {
            this.m_modelString = ((CNKProcIGLM)proc).getModel();
            XMLTree modelTree = XMLTree.readFromString(this.m_modelString);
            this.setNodeCache("model", modelTree);
        }
    }

    public String getModelType() {
        return MODEL_TYPE_MULINOMIALLOGISTIC;
    }

    public boolean isDataCacheProcOutputMetaDataComplete(int outputNum) {
        return true;
    }

    public String getDepVar(XTProps props, XTMetaData md) {
        return PredictEngineNode.getFirstDependentVar(props, md, XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG);
    }

    public String getDataDictionaryAsString() throws Exception {
        XTProps props = this.getNodeProperties();
        XTMetaData mdModel = this.getDataDictionayMetaData();
        String actualDepCol = this.getDepVar(props, mdModel);
        if (props.getValue("probabilityFor").equals("specifiedCategory")) {
            Vector levels = mdModel.getCategoricalDataFieldLevels(actualDepCol);
            String levelSpec = props.getValue("specifiedCategory", "");
            if (levelSpec.length() == 0) {
                throw new Exception("Must specify a category");
            }
            int levelSpecIndex = levels.indexOf(levelSpec);
            if (levelSpecIndex > 0) {
                String swap = (String)levels.get(0);
                levels.set(0, levelSpec);
                levels.set(levelSpecIndex, swap);
                mdModel.reorderCategoricalLevels(actualDepCol, levels);
            }
        } else {
            Vector sorted = mdModel.getSortedCategoricalDataFieldLevels(actualDepCol);
            Vector reverseSorted = new Vector();
            for (int i = sorted.size() - 1; i >= 0; --i) {
                reverseSorted.add(sorted.get(i));
            }
            mdModel.reorderCategoricalLevels(actualDepCol, reverseSorted);
        }
        return mdModel.writeToString();
    }

    protected void setMean(CNKProcIGLM proc1, XTProps props) throws Exception {
        XTMetaData md = this.getInputMetaData(0);
        String depVar = this.getDepVar(props, md);
        Vector levels = md.getCategoricalDataFieldLevels(depVar);
        Object[] levelVals = new String[]{(String)levels.get(0), (String)levels.get(1)};
        Arrays.sort(levelVals);
        String posResp = props.getValue("probabilityFor", "lastCategory");
        String specResp = props.getValue("specifiedCategory", "");
        int numerator = 1;
        if (!posResp.equals("lastCategory") && specResp.length() != 0 && specResp.equals(levelVals[0])) {
            numerator = 0;
        }
        double mean = (double)Long.parseLong(md.getLevelCount(depVar, (String)levelVals[numerator])) / ((double)Long.parseLong(md.getLevelCount(depVar, (String)levelVals[0])) + (double)Long.parseLong(md.getLevelCount(depVar, (String)levelVals[1])));
        String meanStr = Double.toString(mean);
        proc1.setMean(meanStr);
    }

    protected void setCNKProcProps(CNKProcIGLM proc1, XTProps props) throws Exception {
        this.setMean(proc1, props);
        super.setCNKProcProps(proc1, props);
        proc1.setMaxIterations(props.getInt("maxIterations", 10));
        proc1.setEpsilon(props.getDouble("convergenceTolerance", 1.0E-4));
    }

    protected boolean checkDepVar(String depVar, XTMetaData md) {
        if (depVar == null) {
            this.printlnError("can't create model: no dependent variable");
            return false;
        }
        if (md.getCategoricalDataFieldLevels(depVar).size() != 2) {
            this.printlnError("can't create logistic regression model: dependent variable can only have only 2 levels");
            return false;
        }
        return true;
    }

    public boolean executeDataCacheProc() throws Exception {
        XTMetaData md;
        XTProps props = this.getNodeProperties();
        String depVar = this.getDepVar(props, md = this.getInputMetaData(0));
        boolean check = this.checkDepVar(depVar, md);
        if (!check) {
            return false;
        }
        String origText = (String)EngineMessageHandler.sendMessageToApp("getStatusText", new Object[0]);
        String str = origText + ": Building model...";
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{str});
        CNKProcIGLM proc1 = new CNKProcIGLM();
        this.setCNKProcProps(proc1, props);
        this.printlnVerbose("logistic regression: creating model");
        boolean ok = this.getNetworkManager().executeCNKProc(this.getNodeID(), proc1);
        this.procDelete(proc1);
        if (!ok || this.m_modelString == null) {
            return false;
        }
        Vector outputSpecs = this.getOutputSpecs();
        PredictEngineNode.isConflictingIO(outputSpecs, this);
        if (outputSpecs.size() < 1) {
            return ok;
        }
        str = origText + ": Predicting...";
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{str});
        CNKProcGLMFit proc2 = new CNKProcGLMFit();
        proc2.setModel(this.m_modelString);
        PredictEngineNode.defineOutputsFromSpecs(proc2, outputSpecs);
        this.printlnVerbose("logistic regression: predicting from training data.");
        ok = this.getNetworkManager().executeCNKProc(this.getNodeID(), proc2);
        this.procDelete(proc2);
        this.m_modelString = null;
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{origText});
        return ok;
    }
}

