/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ColumnFilterGenerator;
import com.insightful.miner.ColumnFilterTools;
import com.insightful.miner.HtmlFrame;
import com.insightful.miner.PredictableNodeModel;
import com.insightful.miner.RegressionDialog;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.Frame;
import java.awt.List;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LogisticRegressionNodeModel
extends PredictableNodeModel
implements ColumnFilterGenerator {
    public void initializeNodeModel() {
        XTProps props = this.getXTProps();
        props.set(new String[]{"copyInputColumns", "independent"}, props.getValue(new String[]{"copyInputColumns", "independent"}, "false"));
        props.set(new String[]{"copyInputColumns", "dependent"}, props.getValue(new String[]{"copyInputColumns", "dependent"}, "true"));
        props.set(new String[]{"copyInputColumns", "other"}, props.getValue(new String[]{"copyInputColumns", "other"}, "false"));
        props.set(new String[]{"newColumns", "probability"}, props.getValue(new String[]{"newColumns", "probability"}, "true"));
        props.set(new String[]{"newColumns", "classification"}, props.getValue(new String[]{"newColumns", "classification"}, "true"));
        props.set(new String[]{"newColumns", "agreement"}, props.getValue(new String[]{"newColumns", "agreement"}, "false"));
    }

    public void showPropertiesDialog(boolean modality) {
        RegressionDialog dialog = RegressionDialog.getInstance();
        dialog.setModal(modality);
        dialog.show(this, 0);
    }

    public boolean isPropertiesValid() {
        String role;
        int i;
        boolean indepValid = false;
        boolean depValid = false;
        XTProps props = this.getXTProps();
        Vector roleVec = props.getSubPropertyValues("columnRoles");
        try {
            if (this.isInputValid()) {
                XTMetaData md = this.getInputMetaData(0);
                Vector columns = props.getSubProperties("columnRoles");
                for (i = columns.size() - 1; i >= 0; --i) {
                    if (md.nameToOrdinal((String)columns.get(i)) != -1) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        indepValid = props.getBoolean("includeIntercept", true);
        for (int i2 = 0; !(depValid && indepValid || i2 >= roleVec.size()); ++i2) {
            role = (String)roleVec.get(i2);
            if (!depValid && XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG.equals(role)) {
                depValid = true;
            }
            if (indepValid || !XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG.equals(role)) continue;
            indepValid = true;
        }
        if (this.getState() != null && this.isInputValid()) {
            try {
                XTMetaData md = this.getInputMetaData(0);
                if (md != null) {
                    roleVec = md.getColumnRoles();
                    for (i = 0; !(depValid && indepValid || i >= roleVec.size()); ++i) {
                        role = (String)roleVec.get(i);
                        if (!depValid && XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG.equals(role) && md.isCategoricalColumn(i)) {
                            depValid = true;
                        }
                        if (indepValid || !XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG.equals(role)) continue;
                        indepValid = true;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return indepValid && depValid;
    }

    public void showView(Frame frame) {
        try {
            XMLTree xt = this.getFittedModel();
            if (xt != null) {
                String htmlString = xt.getHtmlString(XMLTree.GENERAL_REGRESSION_XSL_FILE, this.getLabelText());
                new HtmlFrame(htmlString);
            } else {
                super.showView(frame);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getModelOutputType() {
        return "classification";
    }

    public String getModelAlgorithm() {
        return "glm";
    }

    public String[] getFilterColumnsToExclude() {
        String[] colNames = null;
        double[] importanceValues = null;
        try {
            XMLTree xt = this.getFittedModel();
            if (xt != null) {
                Element elt = (Element)xt.getXML().getElementsByTagName("GeneralRegressionModel").item(0);
                Element elt1 = (Element)elt.getElementsByTagName("PPMatrix").item(0);
                int numNames = Integer.parseInt((elt = (Element)elt.getElementsByTagName("Importance").item(0)).getAttribute("count"));
                if (numNames > 0) {
                    int i;
                    NodeList lPPCells = elt1.getElementsByTagName("PPCell");
                    int nPPCels = lPPCells.getLength();
                    NodeList effects = elt.getElementsByTagName("Effect");
                    if (effects.getLength() != numNames) {
                        throw new RuntimeException("number of Effect elements does not match Importance count attribute");
                    }
                    List arName = new List();
                    List arValues = new List();
                    for (i = 0; i < numNames; ++i) {
                        String effectName = ((Element)effects.item(i)).getAttribute("name");
                        boolean add = false;
                        for (int j = 0; j < nPPCels && !add; ++j) {
                            String PPTermName = ((Element)lPPCells.item(j)).getAttribute("variableName");
                            if (effectName.compareTo(PPTermName) != 0) continue;
                            add = PPTermName.compareTo(((Element)lPPCells.item(j)).getAttribute("predictorName")) == 0;
                        }
                        if (!add) continue;
                        arName.add(effectName);
                        arValues.add(((Element)effects.item(i)).getAttribute("Pr"));
                    }
                    numNames = arName.getItemCount();
                    if (numNames > 0) {
                        colNames = arName.getItems();
                        importanceValues = new double[numNames];
                        for (i = 0; i < numNames; ++i) {
                            importanceValues[i] = 1.0 - Double.parseDouble(arValues.getItem(i));
                        }
                    }
                    colNames = ColumnFilterTools.showDefaultFilterSpecificationDialog(colNames, importanceValues, "Column Importance");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return colNames;
    }
}

