/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.FlavorMap;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class MinerDropTarget
extends DropTarget {
    private MinerDropTargetAutoScroller m_minerDropTargetAutoScroller = null;

    public MinerDropTarget(Component c, DropTargetListener dtl) {
        super(c, dtl);
    }

    public MinerDropTarget(Component c, int ops, DropTargetListener dtl, boolean act, FlavorMap fm) {
        super(c, ops, dtl, act, fm);
    }

    public MinerDropTarget(Component c, int ops, DropTargetListener dtl) throws HeadlessException {
        this(c, ops, dtl, true);
    }

    public MinerDropTarget(Component c, int ops, DropTargetListener dtl, boolean act) throws HeadlessException {
        this(c, ops, dtl, act, null);
    }

    protected DropTarget.DropTargetAutoScroller createDropTargetAutoScroller(Component c, Point p) {
        return null;
    }

    protected void initializeAutoscrolling(Point p) {
        Component comp = this.getComponent();
        if (comp == null || !(comp instanceof Autoscroll)) {
            return;
        }
        this.m_minerDropTargetAutoScroller = new MinerDropTargetAutoScroller(comp, p);
    }

    protected void updateAutoscroll(Point dragCursorLocn) {
        if (this.m_minerDropTargetAutoScroller != null) {
            this.m_minerDropTargetAutoScroller.updateLocation(dragCursorLocn);
        }
    }

    protected void clearAutoscroll() {
        if (this.m_minerDropTargetAutoScroller != null) {
            this.m_minerDropTargetAutoScroller.stop();
            this.m_minerDropTargetAutoScroller = null;
        }
    }

    protected static class MinerDropTargetAutoScroller
    implements ActionListener {
        private Component component;
        private Autoscroll autoScroll;
        private Timer timer;
        private Point locn;
        private Point prev;
        private Rectangle outer = new Rectangle();
        private Rectangle inner = new Rectangle();
        private int hysteresis = 10;

        protected MinerDropTargetAutoScroller(Component c, Point p) {
            this.component = c;
            this.autoScroll = (Autoscroll)((Object)this.component);
            Toolkit t = Toolkit.getDefaultToolkit();
            Integer initial = new Integer(100);
            Integer interval = new Integer(100);
            try {
                initial = (Integer)t.getDesktopProperty("DnD.Autoscroll.initialDelay");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                interval = (Integer)t.getDesktopProperty("DnD.Autoscroll.interval");
            }
            catch (Exception e) {
                // empty catch block
            }
            this.timer = new Timer(interval, this);
            this.timer.setCoalesce(true);
            this.timer.setInitialDelay(initial);
            this.locn = p;
            this.prev = p;
            try {
                Integer integer = (Integer)t.getDesktopProperty("DnD.Autoscroll.cursorHysteresis");
                if (integer != null) {
                    this.hysteresis = integer;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.timer.start();
        }

        private void updateRegion() {
            Insets i = this.autoScroll.getAutoscrollInsets();
            Dimension size = this.component.getSize();
            if (size.width != this.outer.width || size.height != this.outer.height) {
                this.outer.reshape(0, 0, size.width, size.height);
            }
            if (this.inner.x != i.left || this.inner.y != i.top) {
                this.inner.setLocation(i.left, i.top);
            }
            int newWidth = size.width - (i.left + i.right);
            int newHeight = size.height - (i.top + i.bottom);
            if (newWidth != this.inner.width || newHeight != this.inner.height) {
                this.inner.setSize(newWidth, newHeight);
            }
        }

        protected synchronized void updateLocation(Point newLocn) {
            this.prev = this.locn;
            this.locn = newLocn;
            if (Math.abs(this.locn.x - this.prev.x) > this.hysteresis || Math.abs(this.locn.y - this.prev.y) > this.hysteresis) {
                if (this.timer.isRunning()) {
                    this.timer.stop();
                }
            } else if (!this.timer.isRunning()) {
                this.timer.start();
            }
        }

        protected void stop() {
            this.timer.stop();
        }

        public synchronized void actionPerformed(ActionEvent e) {
            this.updateRegion();
            if (this.outer.contains(this.locn) && !this.inner.contains(this.locn)) {
                this.autoScroll.autoscroll(this.locn);
            }
        }
    }
}

