/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.gdevice.SCanvas;
import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.AppAction;
import com.insightful.miner.ExplorerPane;
import com.insightful.miner.GuiMessageHandler;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MinerOutputHandler;
import com.insightful.miner.MinerPopupMenu;
import com.insightful.miner.TextOutputScrollPane;
import com.insightful.miner.WorksheetDocument;
import com.insightful.miner.WorksheetView;
import com.insightful.miner.XTProps;
import com.insightful.miner.graph.GraphFrame;
import com.insightful.splus.SplusCanvasHandler;
import com.insightful.splus.SplusHelpManagerInstance;
import com.insightful.splus.SplusHelpQueryHandler;
import com.insightful.splus.SplusOutputHandler;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.graph.GraphWindow;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.border.BevelBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class MinerFrame
extends JFrame
implements SplusCanvasHandler,
SplusHelpQueryHandler {
    private MinerApp m_app;
    private JMenuBar m_menuBar;
    private JToolBar m_toolBar;
    private JLabel m_statusBar;
    private JLabel m_progressLabel;
    private int m_numDots = 0;
    private int m_indeterminateIndex = 0;
    private JProgressBar m_progressBar;
    private JFrame m_bdlProgress = null;
    private JSplitPane m_horizSplitPane;
    private JSplitPane m_vertSplitPane;
    private JPanel m_messagePane;
    private JPanel m_commandLinePane;
    private TextOutputScrollPane m_outputScrollPane;
    private JTextField m_inputField;
    private JButton m_cmdButton;
    private MinerOutputHandler m_outputHandler;
    private ExplorerPane m_explorer;
    private JDesktopPane m_desktop;
    private boolean m_initialized = false;
    private int m_lastHeight = 0;
    private WorksheetView m_currentDocView;
    private int m_docCount;
    private static String m_nextSplusGraphTitle;
    private static final int WINDOW_OFFSET = 25;
    private static final int WINDOW_MAX = 5;
    private Image m_appIcon = MinerApp.getResourceManager().getImage("minerapp.gif");

    public MinerFrame(MinerApp app) {
        super(MinerApp.getText("MinerFrame_product_title"));
        this.m_app = app;
        if (!MinerApp.isInBDL()) {
            SplusSystem.setCanvasHandler((SplusCanvasHandler)this);
            SplusSystem.setDefaultFrame((Frame)this);
            SplusSystem.setHelpQueryHandler((SplusHelpQueryHandler)this);
        }
        this.setIconImage(this.m_appIcon);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MinerApp.exit();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                int newHeight = MinerFrame.this.getHeight();
                if (MinerFrame.this.m_initialized && MinerFrame.this.m_lastHeight > 0) {
                    int diff = newHeight - MinerFrame.this.m_lastHeight;
                    int loc = MinerFrame.this.m_vertSplitPane.getDividerLocation();
                    if (diff > 0) {
                        MinerFrame.this.m_vertSplitPane.setDividerLocation(loc + diff);
                    }
                }
                MinerFrame.this.m_lastHeight = newHeight;
            }
        });
        this.m_outputScrollPane = new TextOutputScrollPane();
        this.m_outputScrollPane.setEditable(false);
        this.m_outputScrollPane.m_textArea.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.getButton() != 1) {
                    MinerPopupMenu menu = new MinerPopupMenu();
                    menu.add(new AppAction("Clear Pane"){

                        public void actionPerformed(ActionEvent e) {
                            MinerFrame.this.m_outputScrollPane.clearPane();
                        }

                        public boolean canAct() {
                            return true;
                        }
                    });
                    menu.add(new AppAction("Copy Selection"){

                        public void actionPerformed(ActionEvent e) {
                            ((MinerFrame)MinerFrame.this).m_outputScrollPane.m_textArea.copy();
                        }

                        public boolean canAct() {
                            return true;
                        }
                    });
                    ((JPopupMenu)menu).show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        try {
            if (MinerApp.isSplusLicensed()) {
                this.m_outputHandler = new MinerOutputHandler(this.m_outputScrollPane);
                MinerApp.getSession().startPollOutput((SplusOutputHandler)this.m_outputHandler);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        XTProps props = MinerApp.getGlobalOptions();
        this.m_menuBar = MinerApp.buildMainMenuBar();
        if (!MinerApp.isInBDL()) {
            SplusSystem.setMainMenuBar((JMenuBar)this.m_menuBar);
        }
        this.setJMenuBar(this.m_menuBar);
        this.m_toolBar = MinerApp.buildMainToolBar();
        if (!MinerApp.isInBDL()) {
            SplusSystem.setMainToolBar((JToolBar)this.m_toolBar);
        }
        this.getContentPane().add((Component)this.m_toolBar, "North");
        this.m_horizSplitPane = new JSplitPane(1);
        this.getContentPane().add((Component)this.m_horizSplitPane, "Center");
        this.m_explorer = new ExplorerPane(props);
        this.m_horizSplitPane.setLeftComponent(this.m_explorer);
        this.m_vertSplitPane = new JSplitPane(0);
        this.m_horizSplitPane.setRightComponent(this.m_vertSplitPane);
        this.m_desktop = new JDesktopPane();
        this.m_desktop.addKeyListener(new FramesKeyListener());
        this.m_vertSplitPane.setLeftComponent(this.m_desktop);
        this.m_messagePane = new JPanel(new BorderLayout());
        this.m_commandLinePane = this.getCmdPanel();
        this.m_messagePane.add((Component)this.m_commandLinePane, "North");
        if (!MinerApp.isSplusLicensed()) {
            this.m_commandLinePane.setVisible(false);
        } else {
            this.m_commandLinePane.setVisible(props.getBoolean("commandLineVisible", false));
        }
        this.m_messagePane.add((Component)this.m_outputScrollPane, "Center");
        this.m_vertSplitPane.setRightComponent(this.m_messagePane);
        Dimension screenSize = this.getToolkit().getScreenSize();
        String[] path = new String[]{"applicationDimensions", ""};
        path[1] = "windowsHeight";
        int propsWindowHeight = props.getInt(path, 600);
        path[1] = "windowsWidth";
        int propsWindowWidth = props.getInt(path, 800);
        path[1] = "explorerWidth";
        int propsExplorerWidth = props.getInt(path, 250);
        path[1] = "messageHeight";
        int propsMessageHeight = props.getInt(path, 400);
        if (propsWindowHeight > screenSize.height) {
            propsWindowHeight = screenSize.height;
        }
        if (propsWindowWidth > screenSize.width) {
            propsWindowWidth = screenSize.width;
        }
        try {
            JPanel statusPanel = new JPanel();
            this.m_statusBar = new JLabel(MinerApp.getText("MinerFrame_statusbar_ready"));
            JPanel progPanel = new JPanel();
            this.m_progressBar = new JProgressBar(0, 0, 100);
            this.m_progressBar.setStringPainted(true);
            this.m_progressLabel = new JLabel(MinerApp.getText("MinerFrame_progressbar_progress"));
            this.m_progressLabel.setLabelFor(this.m_progressBar);
            progPanel.add(this.m_progressLabel);
            progPanel.add(this.m_progressBar);
            statusPanel.setLayout(new BorderLayout());
            this.m_statusBar.setBorder(new BevelBorder(1));
            progPanel.setBorder(new BevelBorder(1));
            this.m_statusBar.setMinimumSize(new Dimension(80, 20));
            this.m_statusBar.setPreferredSize(new Dimension(propsWindowWidth * 2 / 3, 20));
            this.m_progressBar.setMinimumSize(new Dimension(80, 15));
            this.m_progressBar.setPreferredSize(new Dimension(propsWindowWidth / 3, 15));
            statusPanel.add((Component)this.m_statusBar, "Center");
            statusPanel.add((Component)progPanel, "East");
            this.getContentPane().add((Component)statusPanel, "South");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_horizSplitPane.setPreferredSize(new Dimension(propsWindowWidth, propsWindowHeight));
        this.m_explorer.setPreferredSize(new Dimension(propsExplorerWidth, propsWindowHeight));
        this.m_messagePane.setPreferredSize(new Dimension(propsWindowWidth, propsExplorerWidth));
        this.m_statusBar.setPreferredSize(new Dimension(propsWindowWidth, 25));
        this.m_horizSplitPane.setDividerLocation(propsExplorerWidth);
        this.m_vertSplitPane.setDividerLocation(propsMessageHeight);
        this.m_messagePane.setVisible(props.getBoolean("messagePaneVisible", true));
        this.m_explorer.setVisible(props.getBoolean("explorerVisible", true));
        this.setSize(propsWindowWidth, propsWindowHeight);
        if (propsWindowHeight >= screenSize.height - 20 && propsWindowWidth >= screenSize.width) {
            this.setState(6);
        } else {
            this.setLocation((screenSize.width - propsWindowWidth) / 2, (screenSize.height - propsWindowHeight) / 2);
        }
        TraversalPolicy tp = new TraversalPolicy();
        this.setFocusTraversalPolicy(tp);
        this.m_initialized = true;
    }

    private Component navigate(Component comp, boolean next) {
        Component ret = this.m_desktop;
        if (comp == null) {
            return ret;
        }
        if (comp instanceof ExplorerPane || comp instanceof JTree) {
            ret = next ? this.m_desktop : (this.m_messagePane == null || !this.m_messagePane.isVisible() ? this.navigate(this.m_outputScrollPane.m_textArea, next) : this.m_outputScrollPane.m_textArea);
        } else if (comp instanceof JDesktopPane || comp instanceof JInternalFrame) {
            ret = next ? (this.m_commandLinePane == null || !this.m_commandLinePane.isVisible() || !this.m_messagePane.isVisible() ? this.navigate(this.m_inputField, next) : this.m_inputField) : (this.m_explorer == null || !this.m_explorer.isVisible() ? this.navigate(this.m_explorer, next) : this.m_explorer);
        } else if (comp instanceof JTextField) {
            ret = next ? (this.m_messagePane == null || !this.m_messagePane.isVisible() ? this.navigate(this.m_outputScrollPane.m_textArea, next) : this.m_outputScrollPane.m_textArea) : this.m_desktop;
        } else if (comp instanceof JTextPane || comp instanceof TextOutputScrollPane) {
            ret = next ? (this.m_explorer == null || !this.m_explorer.isVisible() ? this.navigate(this.m_explorer, next) : this.m_explorer) : (this.m_commandLinePane == null || !this.m_commandLinePane.isVisible() || !this.m_messagePane.isVisible() ? this.navigate(this.m_inputField, next) : this.m_inputField);
        }
        return ret;
    }

    public void saveWindowInfo() {
        String[] path = new String[]{"applicationDimensions", ""};
        Rectangle rect = this.getBounds();
        XTProps props = MinerApp.getGlobalOptions();
        path[1] = "windowsHeight";
        props.set(path, Integer.toString(rect.height));
        path[1] = "windowsWidth";
        props.set(path, Integer.toString(rect.width));
        path[1] = "explorerWidth";
        props.set(path, Integer.toString(this.m_horizSplitPane.getDividerLocation()));
        path[1] = "messageHeight";
        props.set(path, Integer.toString(this.m_vertSplitPane.getDividerLocation()));
        props.set("commandLineVisible", this.m_commandLinePane.isVisible());
        props.set("messagePaneVisible", this.m_messagePane.isVisible());
        props.set("explorerVisible", this.m_explorer.isVisible());
    }

    public JMenuBar getJMenuBar() {
        return this.m_menuBar;
    }

    private JPanel getCmdPanel() {
        JLabel cmdLabel = new JLabel(" " + MinerApp.getText("MinerFrame_cmd_line_command") + ": ");
        this.m_inputField = new JTextField();
        this.m_inputField.setText("");
        this.m_inputField.setColumns(20);
        this.m_cmdButton = new JButton();
        this.m_cmdButton.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                String cmd = MinerFrame.this.m_inputField.getText() + "\n";
                if (cmd.equals("\n")) {
                    return;
                }
                MinerFrame.this.m_inputField.setText("");
                MinerFrame.this.m_outputScrollPane.append("> " + cmd, MinerApp.getMessageSeverity());
                try {
                    MinerApp.writeEngineInput(cmd);
                }
                catch (Exception ex) {
                    MinerFrame.this.m_outputScrollPane.append(ex.toString(), MinerApp.getMessageSeverity());
                }
            }
        });
        this.m_cmdButton.setText(MinerApp.getText("MinerFrame_cmd_line_evaluate"));
        this.m_inputField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MinerFrame.this.m_cmdButton.doClick();
            }
        });
        JPanel cmdPanel = new JPanel(new BorderLayout());
        cmdPanel.add((Component)cmdLabel, "West");
        cmdPanel.add((Component)this.m_inputField, "Center");
        cmdPanel.add((Component)this.m_cmdButton, "East");
        return cmdPanel;
    }

    public void setCommandLineEnabled(boolean enabled) {
        this.m_cmdButton.setEnabled(enabled);
    }

    public void resetNextWindowLocation() {
        MinerApp.resetNextWindowLocation();
    }

    public Point getNextWindowLocation() {
        return MinerApp.getNextWindowLocation();
    }

    public static String getNextSplusGraphTitle() {
        String ret = m_nextSplusGraphTitle;
        m_nextSplusGraphTitle = null;
        return ret;
    }

    public static void setNextSplusGraphTitle(String newTitle) {
        m_nextSplusGraphTitle = newTitle;
    }

    public void showNewCanvas(SCanvas canvas) {
        new GraphFrame(canvas, MinerFrame.getNextSplusGraphTitle(), this.getAppIcon(), this.getNextWindowLocation());
    }

    public SCanvas getActiveCanvas() {
        throw new RuntimeException("Method not implemented.");
    }

    public SCanvas getCurrentDeviceCanvas() {
        throw new RuntimeException("Method not implemented.");
    }

    public void addGraphWindow(GraphWindow window) {
        throw new RuntimeException("Method not implemented.");
    }

    public Image getAppIcon() {
        return this.m_appIcon;
    }

    public void displayHelpOnTopic(String p0) {
        MinerApp.getHelpManager().showTopic(p0);
    }

    public void displayHelpView(String p0) {
        throw new RuntimeException("Method not implemented.");
    }

    public SplusHelpManagerInstance getHelpManagerInstance() {
        throw new RuntimeException("Method not implemented.");
    }

    public MinerOutputHandler getOutputHandler() {
        return this.m_outputHandler;
    }

    public TextOutputScrollPane getOutputScrollPane() {
        return this.m_outputScrollPane;
    }

    public JDesktopPane getDesktop() {
        return this.m_desktop;
    }

    private void bdlProgressInit() {
        if (this.m_bdlProgress == null) {
            this.m_bdlProgress = new JFrame("Execution Progress");
            Container cont = this.m_bdlProgress.getContentPane();
            cont.setLayout(new BorderLayout());
            JPanel statusPanel = new JPanel();
            this.m_statusBar = new JLabel(this.m_statusBar.getText());
            statusPanel.setLayout(new BorderLayout());
            this.m_statusBar.setBorder(new BevelBorder(1));
            this.m_statusBar.setMinimumSize(new Dimension(150, 20));
            this.m_statusBar.setPreferredSize(new Dimension(150, 20));
            statusPanel.add((Component)this.m_statusBar, "Center");
            JPanel progPanel = new JPanel();
            this.m_progressBar = new JProgressBar(0, 0, 100);
            this.m_progressBar.setStringPainted(true);
            this.m_progressLabel = new JLabel("Progress");
            this.m_progressLabel.setLabelFor(this.m_progressBar);
            progPanel.add(this.m_progressLabel);
            progPanel.add(this.m_progressBar);
            progPanel.setBorder(new BevelBorder(1));
            this.m_progressBar.setMinimumSize(new Dimension(150, 15));
            this.m_progressBar.setPreferredSize(new Dimension(150, 30));
            cont.add((Component)statusPanel, "North");
            cont.add((Component)progPanel, "Center");
            this.m_bdlProgress.setBounds(20, 20, 350, 100);
            this.m_bdlProgress.setResizable(true);
        }
    }

    public void showBDLProgress(boolean show) {
        this.bdlProgressInit();
        this.m_bdlProgress.setVisible(show);
    }

    public void setSameProgressDone() {
        String str = this.m_progressBar.getString();
        if (this.m_numDots < 5) {
            ++this.m_numDots;
            this.m_progressBar.setString(str + ".");
        } else {
            this.m_numDots = 0;
            String newStr = str.substring(0, str.indexOf("."));
            this.m_progressBar.setString(newStr);
        }
    }

    public void setProgressDone(int percent) {
        this.m_numDots = 0;
        this.m_progressBar.setString(String.valueOf(percent) + "%");
        this.m_progressBar.setValue(percent);
    }

    public int getProgressDone() {
        return this.m_progressBar.getValue();
    }

    public String getStatusText() {
        return this.m_statusBar.getText();
    }

    public void setStatusText(String str) {
        this.m_statusBar.setText("  " + str.trim());
    }

    public void toggleToolBar() {
        this.m_toolBar.setVisible(!this.m_toolBar.isVisible());
    }

    public void toggleExplorer() {
        if (this.m_explorer.isVisible()) {
            this.m_explorer.setVisible(false);
        } else {
            this.m_explorer.setVisible(true);
            this.m_horizSplitPane.setDividerLocation(250);
        }
    }

    public void toggleMessagePane() {
        if (this.m_messagePane.isVisible()) {
            this.m_messagePane.setVisible(false);
        } else {
            this.m_messagePane.setVisible(true);
            this.m_vertSplitPane.setDividerLocation(400);
        }
    }

    public void toggleCommandLine() {
        if (this.m_commandLinePane.isVisible()) {
            this.m_commandLinePane.setVisible(false);
        } else {
            this.m_commandLinePane.setVisible(true);
        }
    }

    public void appendToMessagePane(String str) {
        this.m_outputScrollPane.append(str, MinerApp.getMessageSeverity());
    }

    public JInternalFrame addWorksheet(WorksheetView v) {
        final WorksheetView view = v;
        String title = view.getDoc() == null ? "" : view.getDoc().getName();
        JInternalFrame frame = new JInternalFrame(title, true, true, true);
        frame.setFrameIcon(MinerApp.getResourceManager().getIcon("minerapp.gif"));
        frame.setIconifiable(true);
        frame.setDefaultCloseOperation(2);
        frame.setSize(400, 300);
        int offset = this.m_docCount % 5 * 25;
        frame.setLocation(new Point(offset, offset));
        ++this.m_docCount;
        view.initialize(this.m_app, frame);
        view.addKeyListener(new ViewKeyListener(frame, view));
        frame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameActivated(InternalFrameEvent e) {
                if (view != MinerFrame.this.m_currentDocView) {
                    MinerFrame.this.m_currentDocView = view;
                    view.requestFocus();
                    AppAction.updateAllActions();
                }
            }

            public void internalFrameClosed(InternalFrameEvent e) {
                if (MinerFrame.this.m_currentDocView == view) {
                    MinerFrame.this.m_currentDocView = null;
                    AppAction.updateAllActions();
                }
                MinerApp.updateFrameWindowMenu();
            }
        });
        if (MinerApp.isInteractive()) {
            frame.addVetoableChangeListener(new VetoableChangeListener(){

                public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                    if (evt.getPropertyName().equals("closed") && evt.getOldValue() == Boolean.FALSE && evt.getNewValue() == Boolean.TRUE) {
                        WorksheetDocument doc;
                        block9: {
                            doc = view.getDoc();
                            try {
                                String worksheetID = MinerApp.getCurrentWorksheetID(doc);
                                Object obj = GuiMessageHandler.sendMessageToEngine(worksheetID, "", "isRunning", new Object[0]);
                                if (obj == null || !(obj instanceof Boolean) || !((Boolean)obj).booleanValue()) break block9;
                                int answer = AcceleratorOptionPane.showOKCancelDialog(view.getFrame(), MinerApp.getText("MinerFrame_msg_clickOKtoEndSession"), MinerApp.getText("MinerFrame_msg_closingRunningDocument"), 3);
                                if (answer == 0) {
                                    MinerApp.doStop();
                                    break block9;
                                }
                                throw new PropertyVetoException("", evt);
                            }
                            catch (Exception e) {
                                if (!(e instanceof PropertyVetoException)) break block9;
                                throw new PropertyVetoException("", evt);
                            }
                        }
                        if (doc.isModified()) {
                            String msg = MinerApp.getText("MinerFrame_msg_saveChangesTo") + " ";
                            msg = doc.getName().equals("") ? msg + MinerApp.getText("MinerFrame_msg_modifiedDocument") : msg + doc.getName();
                            msg = msg + "\n  (";
                            msg = doc.getLocation().equals("") ? msg + MinerApp.getText("MinerFrame_msg_noLocation") : msg + doc.getLocation();
                            msg = msg + ")";
                            int answer = AcceleratorOptionPane.showYesNoCancelDialog(view.getFrame(), msg, MinerApp.getText("MinerFrame_msg_closingModifiedDocument"), 3);
                            if (answer == 1 || answer == 0) {
                                if (answer == 0) {
                                    if (doc.isPreVersion70() && AcceleratorOptionPane.showOKCancelDialog(MinerApp.getMainFrame(), MinerApp.getText("WorksheetDocument_msg_savePre70Warning"), MinerApp.getText("WorksheetDocument_msg_savePre70WarningTitle"), 2) != 0) {
                                        throw new PropertyVetoException("", evt);
                                    }
                                    MinerApp.saveWorksheet();
                                }
                            } else {
                                throw new PropertyVetoException("", evt);
                            }
                        }
                        MinerApp.closeDocWorksheet(doc);
                    }
                }
            });
        }
        Container contentPane = frame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)((Object)view));
        this.getDesktop().add(frame);
        this.getDesktop().setSelectedFrame(frame);
        view.initializeDragDropHandling();
        frame.show();
        try {
            frame.setMaximum(true);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
        return frame;
    }

    public void closeDocuments() throws PropertyVetoException {
        JInternalFrame[] frames = this.getDesktop().getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            JInternalFrame f = frames[i];
            f.setClosed(true);
        }
    }

    public WorksheetView getCurrentView() {
        return this.m_currentDocView;
    }

    public void setCurrentView(WorksheetView view) {
        this.m_currentDocView = view;
    }

    public ExplorerPane getExplorerPane() {
        return this.m_explorer;
    }

    public void setEnabledFromDialog(boolean enable) {
        Action a;
        AbstractButton b;
        Component comp;
        int i;
        this.m_explorer.setEnabled(enable);
        JInternalFrame[] frames = this.m_desktop.getAllFrames();
        for (i = 0; i < frames.length; ++i) {
            comp = frames[i].getContentPane().getComponent(0);
            if (comp instanceof WorksheetView) {
                WorksheetView v = (WorksheetView)((Object)comp);
                v.setMouseEnabled(enable);
                v.setKeyEnabled(enable);
                continue;
            }
            comp.setEnabled(enable);
        }
        if (this.m_inputField != null) {
            this.m_inputField.setEnabled(enable);
        }
        if (this.m_cmdButton != null) {
            this.m_cmdButton.setEnabled(enable);
        }
        this.m_outputScrollPane.m_textArea.setEnabled(enable);
        for (i = 0; i < this.m_menuBar.getComponentCount(); ++i) {
            comp = this.m_menuBar.getComponent(i);
            if (comp instanceof JMenuItem) {
                b = (JMenuItem)comp;
                a = b.getAction();
                if (a != null) {
                    a.setEnabled(enable);
                    continue;
                }
                ((JMenuItem)b).setEnabled(enable);
                continue;
            }
            comp.setEnabled(enable);
        }
        for (i = 0; i < this.m_toolBar.getComponentCount(); ++i) {
            comp = this.m_toolBar.getComponent(i);
            if (comp instanceof JButton) {
                b = (JButton)comp;
                a = b.getAction();
                if (a != null) {
                    a.setEnabled(enable);
                    continue;
                }
                comp.setEnabled(enable);
                continue;
            }
            comp.setEnabled(enable);
        }
        if (enable) {
            AppAction.updateAllActions();
        }
    }

    public class FramesKeyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                try {
                    WorksheetView view = (WorksheetView)((Object)MinerFrame.this.m_desktop.getSelectedFrame().getContentPane().getComponent(0));
                    WorksheetDocument doc = view.getDoc();
                    JGoListPosition pos = doc.getFirstObjectPos();
                    pos = doc.getNextObjectPosAtTop(pos);
                    JGoObject obj = doc.getObjectAtPos(pos);
                    if (obj != null) {
                        view.getSelection().clearSelection();
                        view.getSelection().extendSelection(obj);
                        view.scrollRectToVisible(obj.getBoundingRect());
                    }
                    view.requestFocusInWindow();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    public class ViewKeyListener
    extends KeyAdapter {
        private JInternalFrame m_jif = null;
        private WorksheetView m_view = null;
        private WorksheetDocument m_doc = null;
        private JGoListPosition m_pos = null;

        public ViewKeyListener(JInternalFrame jif, WorksheetView view) {
            this.m_jif = jif;
            this.m_view = view;
        }

        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            if (key == 27) {
                MinerFrame.this.m_desktop.requestFocusInWindow();
            } else if (key == 10) {
                boolean shift = e.isShiftDown();
                if (this.m_pos == null) {
                    this.m_doc = this.m_view.getDoc();
                    this.m_pos = this.m_doc.getFirstObjectPos();
                } else {
                    try {
                        this.m_pos = shift ? this.m_doc.getPrevObjectPosAtTop(this.m_pos) : this.m_doc.getNextObjectPosAtTop(this.m_pos);
                    }
                    catch (Exception ex) {
                        this.m_pos = null;
                    }
                    if (this.m_pos == null) {
                        this.m_pos = shift ? this.m_doc.getLastObjectPos() : this.m_doc.getFirstObjectPos();
                    }
                }
                JGoObject obj = this.m_doc.getObjectAtPos(this.m_pos);
                if (obj != null) {
                    this.m_view.getSelection().clearSelection();
                    this.m_view.getSelection().extendSelection(obj);
                    this.m_view.scrollRectToVisible(obj.getBoundingRect());
                }
            }
        }
    }

    public class TraversalPolicy
    extends FocusTraversalPolicy {
        public Component getComponentAfter(Container root, Component component) {
            return MinerFrame.this.navigate(component, true);
        }

        public Component getComponentBefore(Container root, Component component) {
            return MinerFrame.this.navigate(component, false);
        }

        public Component getFirstComponent(Container root) {
            return MinerFrame.this.navigate(null, true);
        }

        public Component getLastComponent(Container root) {
            return MinerFrame.this.navigate(null, false);
        }

        public Component getInitialComponent(Container root) {
            return MinerFrame.this.navigate(null, true);
        }

        public Component getDefaultComponent(Container root) {
            return MinerFrame.this.navigate(null, true);
        }
    }
}

