/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcJavaTransformExec;
import com.insightful.miner.EngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.util.Vector;

public class ModifyColumnsEngineNode
extends EngineNode
implements CNKProcJavaTransformExec {
    private int[] m_outputColumnToInputColumnMap;
    public static final String MODIFIED_COLUMNS_TAG = "columns";
    public static final String IS_SELECTED_TAG = "isSelected";
    public static final String NEW_NAME_TAG = "newName";
    public static final String ROLE_TAG = "role";
    public static final String DATATYPE_TAG = "datatype";
    public static final String STRING_WIDTH_TAG = "stringSize";
    public static final String DUMMY_PROP_ATTRIBUTE_TAG = "dummyProp";

    public boolean hasCNKProc() {
        return true;
    }

    public boolean hasDataCacheProc() {
        return false;
    }

    public CNKProc procCreate() {
        CNKProcJavaTransform proc = new CNKProcJavaTransform();
        proc.setExecObject(this);
        return proc;
    }

    public void execute(CNKProcJavaTransform proc) {
        int inputRows;
        if (proc.getChunkInputPosition(0) == 0L) {
            XTMetaData inputMD = this.getInputMetaData(0);
            XTProps props = this.getNodeProperties();
            this.m_outputColumnToInputColumnMap = ModifyColumnsEngineNode.getOutputColumnToInputColumnArray(props, inputMD);
        }
        if ((inputRows = proc.getChunkInputRows(0)) < 1) {
            return;
        }
        for (int outCol = 0; outCol < this.m_outputColumnToInputColumnMap.length; ++outCol) {
            int inCol = this.m_outputColumnToInputColumnMap[outCol];
            proc.copyColumnData(0, outCol, 0, 0, inCol, 0, inputRows);
        }
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        XTProps props = this.getNodeProperties();
        XTMetaData inputMD = this.getInputMetaData(0);
        XTMetaData md = ModifyColumnsEngineNode.calculateOutputMetaData(props, inputMD, this.getWorksheetPropertiesManager().getDefaultStringSize());
        return md;
    }

    public EngineNode.InputRequirements getInputRequirements(int inputNum) {
        return EngineNode.InputRequirements.getMinRequirements();
    }

    public static Vector getSelectedInputColumnNames(XTProps props, XTMetaData inputMD) {
        Vector colNames = inputMD.getColumnNames();
        Vector<String> selectedColumns = new Vector<String>();
        String[] path = new String[]{MODIFIED_COLUMNS_TAG, "colNameDummy", IS_SELECTED_TAG};
        for (int i = 0; i < colNames.size(); ++i) {
            String colName;
            path[1] = colName = (String)colNames.get(i);
            boolean isSelected = props.getBoolean(path, true);
            if (!isSelected) continue;
            selectedColumns.add(colName);
        }
        return selectedColumns;
    }

    public static int[] getOutputColumnToInputColumnArray(XTProps props, XTMetaData inputMD) {
        Vector selectedInputColumns = ModifyColumnsEngineNode.getSelectedInputColumnNames(props, inputMD);
        int[] val = ModifyColumnsEngineNode.getColumnNamesToOrdinalArray(selectedInputColumns, inputMD);
        return val;
    }

    public static int[] getColumnNamesToOrdinalArray(Vector colNames, XTMetaData md) {
        int[] val = new int[colNames.size()];
        for (int i = 0; i < val.length; ++i) {
            String colName = (String)colNames.get(i);
            val[i] = md.nameToOrdinal(colName);
        }
        return val;
    }

    public static XTMetaData calculateOutputMetaData(XTProps props, XTMetaData inputMD, int defaultStringSize) {
        XTMetaData md = null;
        try {
            if (inputMD == null) {
                inputMD = new XTMetaData();
            }
            md = new XTMetaData();
            Vector colNames = ModifyColumnsEngineNode.getSelectedInputColumnNames(props, inputMD);
            String[] path = new String[]{MODIFIED_COLUMNS_TAG, "colNameDummy", "colPropDummy"};
            for (int i = 0; i < colNames.size(); ++i) {
                String colName;
                path[1] = colName = (String)colNames.get(i);
                path[2] = NEW_NAME_TAG;
                String newName = props.getValue(path, "");
                if ("".equals(newName)) {
                    newName = colName;
                }
                path[2] = ROLE_TAG;
                String newRole = props.getValue(path, "");
                if ("".equals(newRole)) {
                    newRole = inputMD.getColumnRole(colName);
                }
                if ("".equals(newRole)) {
                    newRole = XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG;
                }
                path[2] = DATATYPE_TAG;
                String newDatatype = props.getValue(path, "");
                if ("".equals(newDatatype)) {
                    newDatatype = inputMD.getColumnType(colName);
                }
                if ("".equals(newDatatype)) {
                    newDatatype = XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG;
                }
                if (newDatatype.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG)) {
                    md.appendCategoricalDataField(newName, new String[0]);
                } else if (newDatatype.equals(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG)) {
                    path[2] = STRING_WIDTH_TAG;
                    int newStringWidth = props.getInt(path, -1);
                    if (newStringWidth <= 0) {
                        newStringWidth = inputMD.getStringDataFieldWidth(colName);
                    }
                    if (newStringWidth <= 0) {
                        newStringWidth = defaultStringSize;
                    }
                    md.appendStringDataField(newName, newStringWidth);
                } else if (newDatatype.equals(XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG)) {
                    md.appendDateTimeDataField(newName);
                } else if (newDatatype.equals(XTMetaData.BLOB_TYPE_ATTRIBUTE_TAG)) {
                    md.appendBlobDataField(newName, inputMD.getBlobDataFieldClassName(colName));
                } else {
                    md.appendContinousDataField(newName);
                }
                md.setDataFieldRole(newName, newRole);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return md;
    }
}

