/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKBlobClassHandler;
import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.CreateDictionaryDialog;
import com.insightful.miner.FixedFormatDictionary;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.ReadFixedFormatFileDialog;
import com.insightful.miner.WideFileChooser;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.util.FileUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.xml.sax.Attributes;

public class ModifyColumnsPanel
extends JPanel {
    public static String NEW_NAME_ATTRIBUTE_TAG = "new_name";
    private XTMetaData metaData;
    private NodeDialog.DialogTable table;
    private MCTableModel tableModel;
    private NodeDialog.TableSorter sortingModel;
    private int[] m_tableMaxStringValues;
    private JScrollPane scrollingTable;
    private ListModel listModel;
    private int rowHeight = 25;
    private int rowWidth = 79;
    private int headerWidth = 90;
    private int iconWidth = 75;
    private String rolesDefaultString = XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG;
    private String datatypesDefaultString = XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG;
    private static final Dimension buttonSize = new Dimension(110, 25);
    private static final int namesColumn = 1;
    private static final int checkBoxColumn = 0;
    private static final int newNamesColumn = 2;
    private static final int rolesColumn = 3;
    private static final int newRolesColumn = 4;
    private static final int typesColumn = 5;
    private static final int newTypesColumn = 6;
    private static final int categorical = 0;
    private static final int continuous = 1;
    private static final int string = 2;
    private static final int dateTime = 3;
    private static final int independent = 4;
    private static final int dependent = 5;
    private static final int information = 6;
    private static final String[] iconStrings = new String[]{"categorical_type.gif", "continuous_type.gif", "string_type.gif", "dateTime_type.gif", "independent_role.gif", "dependent_role.gif", "no_role.gif"};
    private static final String[] engineStrings = new String[]{XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG, XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG, XTMetaData.STRING_TYPE_ATTRIBUTE_TAG, XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG, XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG, XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG, XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG};
    private AbstractAction loadDictionaryAction;
    private AbstractAction saveDictionaryAction;
    private AbstractAction selectAllAction;
    private AbstractAction clearAllAction;
    private AbstractAction includeAction;
    private AbstractAction excludeAction;
    private AbstractAction clearSelectedColumnsAction;
    private AbstractAction independentAction;
    private AbstractAction dependentAction;
    private AbstractAction noneAction;
    private AbstractAction clearRolesAction;
    private AbstractAction categoricalAction;
    private AbstractAction continuousAction;
    private AbstractAction stringAction;
    private AbstractAction stringSizeAction;
    private AbstractAction dateTimeAction;
    private AbstractAction clearTypesAction;

    public ModifyColumnsPanel() {
        this.createActions();
        this.createLayout();
        this.setPreferredSize(new Dimension(500, 500));
    }

    public void restoreProperties(XTMetaData inputMD, XTProps props) {
        int i;
        this.metaData = inputMD;
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        this.tableModel.clearTable();
        this.scrollingTable.setRowHeaderView(null);
        if (inputMD == null || props == null) {
            return;
        }
        Vector names = inputMD.getColumnNames();
        Vector roles = inputMD.getColumnRoles();
        Vector datatypes = inputMD.getColumnTypes();
        Vector propNames = props.getSubProperties("columns");
        int propNamesLength = propNames.size();
        String[] path = new String[]{"columns", "", ""};
        int namesSize = names.size();
        this.m_tableMaxStringValues = new int[namesSize];
        TableModelListener[] listeners = this.tableModel.getTableModelListeners();
        for (i = 0; i < listeners.length; ++i) {
            this.tableModel.removeTableModelListener(listeners[i]);
        }
        for (i = 0; i < namesSize; ++i) {
            path[1] = (String)names.get(i);
            String role = (String)roles.get(i);
            String datatype = (String)datatypes.get(i);
            if (role.length() < 1) {
                role = this.rolesDefaultString;
            }
            if (datatype.length() < 1) {
                datatype = this.datatypesDefaultString;
            }
            String newName = "";
            String newRole = "";
            String newDataType = "";
            boolean newSelected = true;
            int newStringWidth = -1;
            if (propNamesLength > 20 || propNames.contains(path[1])) {
                path[2] = "isSelected";
                newSelected = props.getBoolean(path, true);
                path[2] = "newName";
                newName = props.getValue(path, "");
                path[2] = "role";
                newRole = props.getValue(path, "");
                path[2] = "datatype";
                newDataType = props.getValue(path, "");
                path[2] = "stringSize";
                newStringWidth = props.getInt(path, -1);
                if (datatype.equals(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG) && newDataType.equals("") && newStringWidth >= 0) {
                    newDataType = XTMetaData.STRING_TYPE_ATTRIBUTE_TAG;
                }
            }
            Object typeObject = null;
            typeObject = datatype.equals(XTMetaData.BLOB_TYPE_ATTRIBUTE_TAG) ? CNKBlobClassHandler.getDisplayClassName(inputMD.getBlobDataFieldClassName(i)) : ModifyColumnsPanel.getIconForString(datatype);
            this.tableModel.addRow(new Object[]{new Boolean(newSelected), path[1], newName, ModifyColumnsPanel.getIconForString(role), ModifyColumnsPanel.getIconForString(newRole), typeObject, ModifyColumnsPanel.getIconForString(newDataType)});
            this.m_tableMaxStringValues[i] = newDataType.equals(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG) ? newStringWidth : -1;
        }
        for (i = 0; i < listeners.length; ++i) {
            this.tableModel.addTableModelListener(listeners[i]);
        }
        this.tableModel.fireTableDataChanged();
        listeners = null;
        path = null;
    }

    public static Object getIconForString(String str) {
        for (int k = 0; k < engineStrings.length; ++k) {
            if (!str.equals(engineStrings[k])) continue;
            return MinerApp.getResourceManager().getIcon(iconStrings[k]);
        }
        return str;
    }

    public static String getStringForIcon(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        String val = "";
        String str = "";
        if (obj instanceof ImageIcon) {
            str = ((ImageIcon)obj).getDescription();
        }
        for (int k = 0; k < iconStrings.length; ++k) {
            if (!str.equals(iconStrings[k])) continue;
            val = engineStrings[k];
            break;
        }
        return val;
    }

    public void saveProperties(XTProps props) throws NodeDialog.DialogException {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        int rowCount = this.table.getRowCount();
        HashMap<String, String> map = new HashMap<String, String>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            String colName = (String)this.table.getValueAt(i, 2);
            if (colName.length() == 0) {
                colName = (String)this.table.getValueAt(i, 1);
            }
            if (map.get(colName) != null) {
                throw new NodeDialog.DialogException(MinerApp.getText("ModifyColumnsPanel_duplicateColumnError") + colName);
            }
            map.put(colName, colName);
        }
        props.removeProperty(new String[]{"columns"});
        String[] path = new String[]{"columns", "", ""};
        for (int i = 0; i < rowCount; ++i) {
            String columnName = (String)this.table.getValueAt(i, 1);
            boolean columnSelected = (Boolean)this.table.getValueAt(i, 0);
            String newName = (String)this.table.getValueAt(i, 2);
            String newRoleString = ModifyColumnsPanel.getStringForIcon(this.table.getValueAt(i, 4));
            String oldRoleString = ModifyColumnsPanel.getStringForIcon(this.table.getValueAt(i, 3));
            String newTypeString = ModifyColumnsPanel.getStringForIcon(this.table.getValueAt(i, 6));
            String oldTypeString = ModifyColumnsPanel.getStringForIcon(this.table.getValueAt(i, 5));
            boolean boolNewName = newName.length() > 0 && !newName.equals(columnName);
            boolean newRole = newRoleString.length() > 0 && !newRoleString.equals(oldRoleString);
            boolean newType = newTypeString.length() > 0 && !newTypeString.equals(oldTypeString);
            boolean newMax = this.m_tableMaxStringValues[i] > 0;
            path[1] = columnName;
            if (!columnSelected) {
                path[2] = "isSelected";
                props.set(path, columnSelected);
            }
            if (boolNewName) {
                path[2] = "newName";
                props.set(path, newName);
            }
            if (newRole) {
                path[2] = "role";
                props.set(path, newRoleString);
            }
            if (newType) {
                path[2] = "datatype";
                props.set(path, newTypeString);
            }
            if (!newMax) continue;
            path[2] = "stringSize";
            props.set(path, Integer.toString(this.m_tableMaxStringValues[i]));
        }
    }

    private void createFixedFormatProperties(XTProps props) {
        props.removeProperty(new String[]{"columns"});
        int rowCount = this.table.getRowCount();
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        String[] path = new String[]{"columns", "", ""};
        for (int i = 0; i < rowCount; ++i) {
            String columnName = (String)this.table.getValueAt(i, 1);
            String newColumnName = (String)this.table.getValueAt(i, 2);
            String newRoleString = ModifyColumnsPanel.getStringForIcon(this.table.getValueAt(i, 4));
            String oldRoleString = ModifyColumnsPanel.getStringForIcon(this.table.getValueAt(i, 3));
            String newTypeString = ModifyColumnsPanel.getStringForIcon(this.table.getValueAt(i, 6));
            String oldTypeString = ModifyColumnsPanel.getStringForIcon(this.table.getValueAt(i, 5));
            boolean newRole = newRoleString.length() > 0 && !newRoleString.equals(oldRoleString);
            boolean newType = newTypeString.length() > 0 && !newTypeString.equals(oldTypeString);
            path[1] = columnName;
            path[2] = "newName";
            props.set(path, newColumnName);
            path[2] = "role";
            if (newRole) {
                props.set(path, newRoleString);
            } else {
                props.set(path, oldRoleString);
            }
            path[2] = "datatype";
            if (newType) {
                props.set(path, newTypeString);
                continue;
            }
            props.set(path, oldTypeString);
        }
    }

    public void createActions() {
        this.selectAllAction = new AbstractAction(MinerApp.getText("ModifyColumnsPanel_selectAll")){

            public void actionPerformed(ActionEvent e) {
                if (ModifyColumnsPanel.this.table.getRowCount() > 0) {
                    ModifyColumnsPanel.this.table.selectAll();
                }
            }
        };
        this.includeAction = new AbstractAction(MinerApp.getText("ModifyColumnsPanel_include")){

            public void actionPerformed(ActionEvent e) {
                ModifyColumnsPanel.this.setSelectedColumns(true);
            }
        };
        this.excludeAction = new AbstractAction(MinerApp.getText("ModifyColumnsPanel_exclude")){

            public void actionPerformed(ActionEvent e) {
                ModifyColumnsPanel.this.setSelectedColumns(false);
            }
        };
        this.independentAction = new AbstractAction(MinerApp.getText("ModifyColumnsPanel_independent")){

            public void actionPerformed(ActionEvent e) {
                ModifyColumnsPanel.this.setRowValue(MinerApp.getResourceManager().getIcon(iconStrings[4]), 4);
            }
        };
        this.dependentAction = new AbstractAction(MinerApp.getText("ModifyColumnsPanel_dependent")){

            public void actionPerformed(ActionEvent e) {
                ModifyColumnsPanel.this.setRowValue(MinerApp.getResourceManager().getIcon(iconStrings[5]), 4);
            }
        };
        this.noneAction = new AbstractAction(MinerApp.getText("ModifyColumnsPanel_none")){

            public void actionPerformed(ActionEvent e) {
                ModifyColumnsPanel.this.setRowValue(MinerApp.getResourceManager().getIcon(iconStrings[6]), 4);
            }
        };
        this.clearRolesAction = new AbstractAction(MinerApp.getText("ModifyColumnsPanel_clear")){

            public void actionPerformed(ActionEvent e) {
                ModifyColumnsPanel.this.setRowValue(null, 4);
            }
        };
        this.categoricalAction = new AbstractAction(MinerApp.getText("ModifyColumnsPanel_categorical")){

            public void actionPerformed(ActionEvent e) {
                ModifyColumnsPanel.this.setRowValue(MinerApp.getResourceManager().getIcon(iconStrings[0]), 6);
                ModifyColumnsPanel.this.clearMaxStringSize();
            }
        };
        this.continuousAction = new AbstractAction(MinerApp.getText("ModifyColumnsPanel_continuous")){

            public void actionPerformed(ActionEvent e) {
                ModifyColumnsPanel.this.setRowValue(MinerApp.getResourceManager().getIcon(iconStrings[1]), 6);
                ModifyColumnsPanel.this.clearMaxStringSize();
            }
        };
        this.stringAction = new AbstractAction(MinerApp.getText("ModifyColumnsPanel_string")){

            public void actionPerformed(ActionEvent e) {
                ModifyColumnsPanel.this.setRowValue(MinerApp.getResourceManager().getIcon(iconStrings[2]), 6);
            }
        };
        this.stringSizeAction = new AbstractAction("[  ]"){

            public void actionPerformed(ActionEvent e) {
                if (ModifyColumnsPanel.this.setMaxStringSize()) {
                    ModifyColumnsPanel.this.stringAction.actionPerformed(e);
                }
            }
        };
        this.dateTimeAction = new AbstractAction(MinerApp.getText("ModifyColumnsPanel_dateTime")){

            public void actionPerformed(ActionEvent e) {
                ModifyColumnsPanel.this.setRowValue(MinerApp.getResourceManager().getIcon(iconStrings[3]), 6);
                ModifyColumnsPanel.this.clearMaxStringSize();
            }
        };
        this.clearTypesAction = new AbstractAction(MinerApp.getText("ModifyColumnsPanel_clear")){

            public void actionPerformed(ActionEvent e) {
                ModifyColumnsPanel.this.setRowValue(null, 6);
                ModifyColumnsPanel.this.clearMaxStringSize();
            }
        };
        this.loadDictionaryAction = new AbstractAction(MinerApp.getText("ModifyColumnsPanel_loadDictionary")){

            public void actionPerformed(ActionEvent e) {
                ModifyColumnsPanel.this.updateColumnInfo();
            }
        };
        this.saveDictionaryAction = new AbstractAction(MinerApp.getText("ModifyColumnsPanel_saveDictionary")){

            public void actionPerformed(ActionEvent e) {
                ModifyColumnsPanel.this.saveColumnInfo();
            }
        };
    }

    private void updateColumnInfo() {
        JTextField placeKeeper = new JTextField("");
        JDialog owner = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, this);
        ReadFixedFormatFileDialog.browseDictionaryFileName(owner, placeKeeper);
        String file = placeKeeper.getText();
        if (file.length() > 0) {
            int i;
            File ffdFile = new File(file);
            ModifyColumnsDictionary ffd = new ModifyColumnsDictionary(ffdFile);
            if (ffd == null || ffd.isEmpty()) {
                AcceleratorOptionPane.showOKDialog(this, MinerApp.getText("ModifyColumnsPanel_msg_dictoryFormatNotRecognized"), MinerApp.getText("ModifyColumnsPanel_msg_invalidDirectoryFormat"), 0);
                return;
            }
            TableModelListener[] listeners = this.tableModel.getTableModelListeners();
            for (int i2 = 0; i2 < listeners.length; ++i2) {
                this.tableModel.removeTableModelListener(listeners[i2]);
            }
            List list = ffd.getNames();
            int listLength = list.size();
            for (i = 0; i < listLength; ++i) {
                String newName;
                String role;
                String colName = (String)list.get(i);
                int rowNum = this.metaData.nameToOrdinal(colName);
                if (rowNum < 0) continue;
                String type = ffd.getType(colName);
                if (type != null) {
                    this.sortingModel.setValueAt(ModifyColumnsPanel.getIconForString(type), rowNum, 6);
                }
                if ((role = ffd.getRole(colName)) != null) {
                    this.sortingModel.setValueAt(ModifyColumnsPanel.getIconForString(role), rowNum, 4);
                }
                if ((newName = ffd.getNewName(colName)) == null) continue;
                this.sortingModel.setValueAt(newName, rowNum, 2);
            }
            for (i = 0; i < listeners.length; ++i) {
                this.tableModel.addTableModelListener(listeners[i]);
            }
            this.tableModel.fireTableDataChanged();
        }
    }

    private void saveColumnInfo() {
        JDialog owner = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, this);
        WideFileChooser fc = new WideFileChooser(SplusSystem.getCwd().getAbsolutePath());
        CreateDictionaryDialog.TextFileFilter tff = new CreateDictionaryDialog.TextFileFilter();
        CreateDictionaryDialog.CSVFileFilter cff = new CreateDictionaryDialog.CSVFileFilter();
        CreateDictionaryDialog.XMLFileFilter xff = new CreateDictionaryDialog.XMLFileFilter();
        fc.setAcceptAllFileFilterUsed(false);
        fc.addChoosableFileFilter(cff);
        fc.addChoosableFileFilter(tff);
        fc.addChoosableFileFilter(xff);
        fc.setFileSelectionMode(0);
        fc.setFileFilter(cff);
        while (fc.showSaveDialog(owner) == 0) {
            File file = fc.getSelectedFile();
            String filename = file.getAbsolutePath();
            if (!FileUtilities.confirmSaveAs((Component)this, (String)filename)) continue;
            FileFilter currentFF = fc.getFileFilter();
            if (file.getName().indexOf(".") == -1 && !file.exists()) {
                filename = xff == currentFF ? filename + ".xml" : (cff == currentFF ? filename + ".csv" : filename + ".txt");
                file = new File(filename);
            }
            boolean xml = xff.accept(file) || xff == currentFF && (cff.accept(file) || tff.accept(file));
            try {
                XTProps props = new XTProps();
                this.createFixedFormatProperties(props);
                ModifyColumnsDictionary ffd = new ModifyColumnsDictionary(props);
                if (xml) {
                    ffd.saveXML(new FileOutputStream(file));
                } else {
                    ffd.saveCSV(new FileOutputStream(file));
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }

    private void setSelectedColumns(boolean isSelected) {
        int[] rows = this.table.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            this.table.setValueAt(new Boolean(isSelected), rows[i], 0);
        }
        this.table.repaint();
        rows = null;
    }

    private void setRowValue(ImageIcon icon, int column) {
        int[] rows = this.table.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            if (icon != null) {
                this.sortingModel.setValueAt(icon, rows[i], column);
                continue;
            }
            this.sortingModel.setValueAt("", rows[i], column);
        }
    }

    public static String stringSizeIntToUserString(int size) {
        if (size < 0) {
            return "";
        }
        if (size < 4) {
            size = 4;
        }
        String userString = String.valueOf(size - 1);
        return userString;
    }

    public static int userStringToStringSizeInt(Component comp, String str) {
        int size = -1;
        try {
            size = Integer.parseInt(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (size >= 0) {
            if (++size < 4) {
                AcceleratorOptionPane.showOKDialog(comp, MinerApp.getText("ModifyColumnsPanel_msg_minimumString"));
                size = 4;
            } else if (size > 255) {
                // empty if block
            }
        }
        return size;
    }

    private boolean setMaxStringSize() {
        try {
            String val;
            int[] selectedRows = this.table.getSelectedRows();
            if (selectedRows == null || selectedRows.length < 1) {
                return false;
            }
            int minSize = -1;
            int maxSize = -1;
            for (int i = 0; i < selectedRows.length; ++i) {
                int oneSize = this.m_tableMaxStringValues[selectedRows[i]];
                if (oneSize < 0) continue;
                if (minSize < 0) {
                    minSize = maxSize = oneSize;
                    continue;
                }
                if (oneSize < minSize) {
                    minSize = oneSize;
                    continue;
                }
                if (oneSize <= maxSize) continue;
                maxSize = oneSize;
            }
            String msg = "Set maximum string size for";
            if (selectedRows.length < 2) {
                msg = msg + " selected row";
                if (minSize >= 0) {
                    msg = msg + " (current size=" + ModifyColumnsPanel.stringSizeIntToUserString(minSize) + ")";
                }
            } else {
                msg = msg + " " + selectedRows.length + " selected rows";
                if (minSize >= 0) {
                    msg = minSize == maxSize ? msg + " (current size=" + ModifyColumnsPanel.stringSizeIntToUserString(minSize) + ")" : msg + " (current sizes from " + ModifyColumnsPanel.stringSizeIntToUserString(minSize) + " to " + ModifyColumnsPanel.stringSizeIntToUserString(maxSize) + ")";
                }
            }
            if ((val = JOptionPane.showInputDialog(this, msg + ".\n" + MinerApp.getText("ModifyColumnsPanel_msg_leaveTextFieldEmpty"), MinerApp.getText("ModifyColumnsPanel_msg_setStringSize"), 3)) == null) {
                return false;
            }
            int newSize = ModifyColumnsPanel.userStringToStringSizeInt(this, val);
            for (int i = 0; i < selectedRows.length; ++i) {
                this.m_tableMaxStringValues[selectedRows[i]] = newSize;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private void clearMaxStringSize() {
        try {
            int[] selectedRows = this.table.getSelectedRows();
            if (selectedRows == null) {
                return;
            }
            for (int i = 0; i < selectedRows.length; ++i) {
                this.m_tableMaxStringValues[selectedRows[i]] = -1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createLayout() {
        JPanel upperButtonPanel = new JPanel();
        upperButtonPanel.setLayout(new BoxLayout(upperButtonPanel, 0));
        upperButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        JButton selectAllButton = new JButton(this.selectAllAction);
        selectAllButton.setPreferredSize(buttonSize);
        selectAllButton.setMnemonic('a');
        JButton loadDictionaryButton = new JButton(this.loadDictionaryAction);
        loadDictionaryButton.setPreferredSize(buttonSize);
        loadDictionaryButton.setMnemonic('l');
        JButton saveDictionaryButton = new JButton(this.saveDictionaryAction);
        saveDictionaryButton.setPreferredSize(buttonSize);
        saveDictionaryButton.setMnemonic('v');
        upperButtonPanel.add(loadDictionaryButton);
        upperButtonPanel.add(Box.createHorizontalStrut(5));
        upperButtonPanel.add(saveDictionaryButton);
        upperButtonPanel.add(Box.createGlue());
        upperButtonPanel.add(selectAllButton);
        this.tableModel = new MCTableModel();
        this.tableModel.setColumnIdentifiers(new Object[]{" ", MinerApp.getText("ModifyColumnsPanel_columns"), MinerApp.getText("ModifyColumnsPanel_newNames"), MinerApp.getText("ModifyColumnsPanel_roles"), MinerApp.getText("ModifyColumnsPanel_newRoles"), MinerApp.getText("ModifyColumnsPanel_types"), MinerApp.getText("ModifyColumnsPanel_newTypes")});
        this.sortingModel = new NodeDialog.TableSorter(this.tableModel);
        this.table = new NodeDialog.DialogTable(this.sortingModel);
        this.sortingModel.addMouseListenerToHeaderInTable(this.table);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setAutoResizeMode(0);
        this.table.setRowHeight(this.rowHeight);
        int columnCount = this.tableModel.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            TableColumn column = this.table.getColumn(this.table.getColumnName(i));
            column.setPreferredWidth(this.iconWidth);
            column.setCellRenderer(new NodeDialog.GeneralRenderer());
        }
        this.table.getColumn(this.table.getColumnName(1)).setPreferredWidth(this.rowWidth);
        TableColumn checkBoxTableColumn = this.table.getColumn(this.table.getColumnName(0));
        checkBoxTableColumn.setCellEditor(new DefaultCellEditor(new JCheckBox()));
        checkBoxTableColumn.setCellRenderer(new BooleanRenderer());
        checkBoxTableColumn.setPreferredWidth(15);
        this.table.setDefaultRenderer(String.class, new NodeDialog.LeftJustifiedStringRenderer());
        this.scrollingTable = new JScrollPane(this.table);
        this.scrollingTable.setPreferredSize(new Dimension(400, 150));
        JPanel selectColumnsPanel = new JPanel(new GridBagLayout());
        selectColumnsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ModifyColumnsPanel_selectColumns")), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        JButton includeButton = new JButton(this.includeAction);
        includeButton.setMnemonic('i');
        includeButton.setMaximumSize(buttonSize);
        includeButton.setMinimumSize(buttonSize);
        JButton excludeButton = new JButton(this.excludeAction);
        excludeButton.setMaximumSize(buttonSize);
        excludeButton.setMinimumSize(buttonSize);
        excludeButton.setMnemonic('x');
        JButton clearSelectedColumnsButton = new JButton(this.clearSelectedColumnsAction);
        clearSelectedColumnsButton.setPreferredSize(buttonSize);
        GridBagConstraints selectConstraints = new GridBagConstraints();
        selectConstraints.fill = 1;
        selectConstraints.weightx = 1.0;
        selectConstraints.insets = new Insets(5, 0, 5, 0);
        selectColumnsPanel.add((Component)includeButton, selectConstraints);
        selectConstraints.gridy = 1;
        selectColumnsPanel.add((Component)excludeButton, selectConstraints);
        JPanel setRolesPanel = new JPanel(new GridBagLayout());
        setRolesPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ModifyColumnsPanel_setRoles")), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        JButton independentButton = new JButton(this.independentAction);
        independentButton.setMnemonic('p');
        independentButton.setMaximumSize(buttonSize);
        independentButton.setMinimumSize(buttonSize);
        JButton dependentButton = new JButton(this.dependentAction);
        dependentButton.setMaximumSize(buttonSize);
        dependentButton.setMinimumSize(buttonSize);
        dependentButton.setMnemonic('d');
        JButton noneButton = new JButton(this.noneAction);
        noneButton.setMaximumSize(buttonSize);
        noneButton.setMinimumSize(buttonSize);
        noneButton.setMnemonic('n');
        JButton clearRolesButton = new JButton(this.clearRolesAction);
        clearRolesButton.setMaximumSize(buttonSize);
        clearRolesButton.setMinimumSize(buttonSize);
        clearRolesButton.setMnemonic('e');
        GridBagConstraints rolesConstraints = new GridBagConstraints();
        rolesConstraints.fill = 1;
        rolesConstraints.weightx = 1.0;
        rolesConstraints.insets = new Insets(5, 0, 5, 0);
        setRolesPanel.add((Component)independentButton, rolesConstraints);
        rolesConstraints.gridy = 1;
        setRolesPanel.add((Component)dependentButton, rolesConstraints);
        rolesConstraints.gridy = 2;
        setRolesPanel.add((Component)noneButton, rolesConstraints);
        rolesConstraints.gridy = 3;
        setRolesPanel.add((Component)clearRolesButton, rolesConstraints);
        JPanel setDatatypePanel = new JPanel(new GridBagLayout());
        setDatatypePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ModifyColumnsPanel_setDatatype")), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        JButton categoricalButton = new JButton(this.categoricalAction);
        categoricalButton.setMinimumSize(buttonSize);
        categoricalButton.setMaximumSize(buttonSize);
        categoricalButton.setMnemonic('g');
        JButton continuousButton = new JButton(this.continuousAction);
        continuousButton.setMinimumSize(buttonSize);
        continuousButton.setMaximumSize(buttonSize);
        continuousButton.setMnemonic('u');
        JButton stringButton = new JButton(this.stringAction);
        JButton stringSizeButton = new JButton(this.stringSizeAction);
        Dimension stringButtonSize = buttonSize;
        stringButton.setMinimumSize(stringButtonSize);
        stringButton.setMaximumSize(stringButtonSize);
        stringButton.setMnemonic('s');
        JPanel stringButtonPanel = new JPanel(new BorderLayout());
        stringButtonPanel.add((Component)stringButton, "Center");
        stringButtonPanel.add((Component)stringSizeButton, "East");
        JButton dateTimeButton = new JButton(this.dateTimeAction);
        dateTimeButton.setMaximumSize(buttonSize);
        dateTimeButton.setMinimumSize(buttonSize);
        dateTimeButton.setMnemonic('t');
        JButton clearTypesButton = new JButton(this.clearTypesAction);
        clearTypesButton.setMaximumSize(buttonSize);
        clearTypesButton.setMinimumSize(buttonSize);
        clearTypesButton.setMnemonic('r');
        GridBagConstraints datatypeConstraints = new GridBagConstraints();
        datatypeConstraints.fill = 1;
        datatypeConstraints.weightx = 1.0;
        datatypeConstraints.insets = new Insets(5, 0, 5, 0);
        setDatatypePanel.add((Component)categoricalButton, datatypeConstraints);
        datatypeConstraints.gridy = 1;
        setDatatypePanel.add((Component)continuousButton, datatypeConstraints);
        datatypeConstraints.gridy = 2;
        setDatatypePanel.add((Component)stringButtonPanel, datatypeConstraints);
        datatypeConstraints.gridy = 3;
        setDatatypePanel.add((Component)dateTimeButton, datatypeConstraints);
        datatypeConstraints.gridy = 4;
        setDatatypePanel.add((Component)clearTypesButton, datatypeConstraints);
        JPanel lowerButtonPanel = new JPanel(new GridLayout(1, 3));
        lowerButtonPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        lowerButtonPanel.add(selectColumnsPanel);
        lowerButtonPanel.add(setRolesPanel);
        lowerButtonPanel.add(setDatatypePanel);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ModifyColumnsPanel_modifyColumns")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.add((Component)upperButtonPanel, "North");
        this.add((Component)this.scrollingTable, "Center");
        this.add((Component)lowerButtonPanel, "South");
    }

    private class ModifyColumnsDictionary
    extends FixedFormatDictionary {
        private HashMap m_newNames;

        public ModifyColumnsDictionary(File file) {
            super(file);
        }

        public ModifyColumnsDictionary(XTProps mcProps) {
            String[] path = new String[3];
            path[0] = "columns";
            Vector propNames = mcProps.getSubProperties(path[0]);
            for (int i = 0; i < propNames.size(); ++i) {
                String name = path[1] = (String)propNames.get(i);
                path[2] = "newName";
                String newName = mcProps.getValue(path, "");
                path[2] = "role";
                String newRole = mcProps.getValue(path, "");
                path[2] = "datatype";
                String newDataType = mcProps.getValue(path, "");
                this.addEntry(name, newName, newDataType, newRole);
            }
        }

        public HashMap getNewNames() {
            if (this.m_newNames == null) {
                this.m_newNames = new HashMap();
            }
            return this.m_newNames;
        }

        public String getNewName(String name) {
            String newName = (String)this.getNewNames().get(name);
            if (newName == null) {
                return "";
            }
            return newName;
        }

        public void setNewName(String name, String newName) {
            this.getNewNames().put(name, newName);
        }

        public void addEntry(String name, String newName, String type, String role) {
            this.addEntry(name, type, role, null, null, null);
            this.getNewNames().put(name, newName);
        }

        protected void writeEntryInfoXML(String name, FixedFormatDictionary.Entry entry, Writer writer) throws IOException {
            super.writeEntryInfoXML(name, entry, writer);
            String newName = this.getNewName(name);
            writer.write(NEW_NAME_ATTRIBUTE_TAG + "=\"" + newName + "\" ");
        }

        protected void writeEntryInfoCSV(String name, FixedFormatDictionary.Entry entry, Writer writer) throws IOException {
            super.writeEntryInfoCSV(name, entry, writer);
            String newName = this.getNewName(name);
            writer.write(", " + newName);
        }

        protected void handleEntryFromCSV(String str, FixedFormatDictionary.Entry entry) {
            super.handleEntryFromCSV(str, entry);
            StringTokenizer tokenizer = new StringTokenizer(str, ",");
            int count = 0;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                if (count++ != 6) continue;
                this.setNewName(entry.name, token);
                break;
            }
        }

        protected void handleEntryFromXML(Attributes attributes, FixedFormatDictionary.Entry entry) {
            super.handleEntryFromXML(attributes, entry);
            String temp = attributes.getValue(NEW_NAME_ATTRIBUTE_TAG);
            if (temp != null) {
                this.setNewName(entry.name, temp);
            }
        }
    }

    private class BooleanRenderer
    implements TableCellRenderer,
    Serializable {
        private JCheckBox rend = new JCheckBox();

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null || !(value instanceof Boolean)) {
                return null;
            }
            this.rend.setSelected((Boolean)value);
            return this.rend;
        }
    }

    private class MCTableModel
    extends DefaultTableModel {
        private MCTableModel() {
        }

        public void setValueAt(Object aValue, int row, int column) {
            Vector rowVector = (Vector)this.dataVector.elementAt(row);
            rowVector.setElementAt(aValue, column);
        }

        public boolean isCellEditable(int row, int column) {
            boolean isEditable = super.isCellEditable(row, column);
            if (column == 1 || column > 2) {
                isEditable = false;
            }
            return isEditable;
        }

        public void clearTable() {
            this.dataVector.removeAllElements();
            this.fireTableDataChanged();
        }
    }
}

