/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ActivityNodeArea;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NeuralNetViewer;
import com.insightful.miner.NeuralNetworkDialog;
import com.insightful.miner.NeuralNetworkExecViewer;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.WorksheetDocument;
import com.insightful.miner.WorksheetView;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class NeuralNetSettingsPanel
extends JPanel {
    private static Color RUNNING_COLOR = Color.GREEN.darker().darker().darker();
    private static Color FINISHED_COLOR = Color.RED;
    private static Color PAUSED_COLOR = Color.BLUE;
    private JPanel controlPanel = null;
    private XTProps xtprops = null;
    private boolean noError = true;
    private boolean promptForFileOnTermination = false;
    private Vector inputElements = null;
    private JComboBox trainingMethodComboBox;
    private JTextField accuracyTextField;
    private JTextField epochsTextField;
    private JTextField learningRateTextField;
    private JTextField momentumTextField;
    private JTextField weightDecayTextField;
    private JRadioButton jitterWeightsButton;
    private JRadioButton useCurrentButton;
    private JRadioButton loadWeightsRadioButton;
    private JRadioButton loadFinalWeightFileButton;
    private JRadioButton useBestButton;
    private JRadioButton useLastButton;
    public JButton pauseContinueButton;
    public JButton saveButton;
    private JButton stopButton;
    private JButton saveBestButton;
    public JButton loadWeightsButton;
    public JCheckBox colorizeWeightsCheckBox;
    private JLabel epochsResultLabel;
    private JLabel statusResultLabel;
    private JLabel mseResultLabel;
    private JLabel numHiddenLayersLabel;
    private JLabel numHiddenNodes;
    private JLabel numInputs;
    private JLabel numOutputs;
    private JPanel nnpanel = null;
    private JLabel mseLabel;
    private NeuralNetViewer viewer = null;
    private boolean runComplete = false;
    private ItemListener selectTrainMethodListener;
    private int neuralNetwork = 0;
    public static final int CLASSIFICATION_NEURAL_NETWORK = 1;
    public static final int REGRESSION_NEURAL_NETWORK = 0;
    private AbstractAction pauseContinueAction;
    private AbstractAction saveAction;
    private AbstractAction stopAction;
    private AbstractAction failAction;
    private AbstractAction saveBestAction;
    private AbstractAction loadWeightsAction;
    private AbstractAction loadWeightsRadioButtonAction;
    private AbstractAction useCurrentWeightsRadioButtonAction;
    private AbstractAction jitterWeightsRadioButtonAction;
    private AbstractAction loadFinalWeightFileButtonAction;
    private AbstractAction useBestWeightsRadioButtonAction;
    private AbstractAction useLastWeightsRadioButtonAction;
    public static final int RUNNING_MODE = 0;
    public static final int PAUSE_REQUESTED_MODE = 1;
    public static final int PAUSED_MODE = 2;
    public static final int STOP_REQUESTED_MODE = 3;
    public static final int WAITING_MODE = 4;
    public static final int COMPLETED_MODE = 5;

    public NeuralNetSettingsPanel(NeuralNetViewer v) {
        this.viewer = v;
        this.inputElements = new Vector();
        this.createActions();
        this.setLayout(new BorderLayout());
        this.nnpanel = this.createNNetOptionsPanel();
        this.nnpanel.validate();
        this.add(this.nnpanel);
        this.enableInputs(false);
        this.setVisible(true);
        this.initializeDialog();
    }

    public void initializeDialog() {
        if (this.viewer.getExecViewer() == null) {
            this.initializeRunControlButtons(false);
            this.setStatusResult(5);
            this.setLabelBackground(5);
        } else {
            this.initializeRunControlButtons(true);
            this.setStatusResult(0);
            this.setLabelBackground(0);
        }
    }

    private void initializeRunControlButtons(boolean enabled) {
        this.pauseContinueButton.setEnabled(enabled);
        this.stopButton.setEnabled(enabled);
    }

    private void setStatusResult(int state) {
        String msg = "";
        switch (state) {
            case 0: {
                msg = NeuralNetViewer.getText("nnvis_statusRunningLabel");
                break;
            }
            case 1: {
                msg = NeuralNetViewer.getText("nnvis_statusPauseRequestedLabel");
                break;
            }
            case 2: {
                msg = NeuralNetViewer.getText("nnvis_statusWaitingLabel");
                break;
            }
            case 3: {
                msg = NeuralNetViewer.getText("nnvis_statusStopRequestedLabel");
                break;
            }
            case 4: {
                msg = NeuralNetViewer.getText("nnvis_statusWaitingLabel");
                break;
            }
            case 5: {
                msg = NeuralNetViewer.getText("nnvis_statusCompletedLabel");
            }
        }
        this.statusResultLabel.setText(msg);
    }

    private void setLabelBackground(int state) {
        Color foreground = null;
        switch (state) {
            case 2: {
                foreground = PAUSED_COLOR;
            }
            case 5: {
                foreground = FINISHED_COLOR;
            }
        }
        foreground = RUNNING_COLOR;
        this.mseResultLabel.setForeground(foreground);
        this.epochsResultLabel.setForeground(foreground);
        this.statusResultLabel.setForeground(foreground);
    }

    public void releaseMemory() {
        for (int i = 0; i < this.inputElements.size(); ++i) {
            this.inputElements.setElementAt(null, i);
            this.inputElements.remove(i);
        }
        this.inputElements = null;
        this.nnpanel.removeAll();
        this.removeAll();
    }

    public JPanel createNNetOptionsPanel() {
        JPanel settingsPanel = new JPanel();
        JTabbedPane tabs = new JTabbedPane(1);
        tabs.add(NeuralNetViewer.getText("nnvis_gui_controlPanel"), this.getControlPanel());
        tabs.add(MinerApp.getText("NeuralNetworkDialog_training"), this.getTrainingOptionsPanel());
        tabs.add(NeuralNetViewer.getText("nnvis_gui_weight_settings"), this.getWeightsPanel());
        tabs.add(NeuralNetViewer.getText("nnvis_gui_weight_model"), this.getFinalWeightsPanel());
        settingsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 3, 0, 3);
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        settingsPanel.add((Component)this.getnetArchPanel(), gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        settingsPanel.add((Component)tabs, gbc);
        return settingsPanel;
    }

    private JPanel getnetArchPanel() {
        JPanel netArchPanel = new JPanel(new GridBagLayout());
        JLabel numHiddenNodesLabel = new JLabel(NeuralNetViewer.getText("nnvis_gui_numNodesHiddenLayer"));
        JLabel numInputsLabel = new JLabel(NeuralNetViewer.getText("nnvis_gui_numInputs"));
        JLabel numOutputsLabel = new JLabel(NeuralNetViewer.getText("nnvis_gui_numOutputsLabel"));
        this.numHiddenNodes = new JLabel();
        this.numInputs = new JLabel();
        this.numOutputs = new JLabel();
        this.numHiddenNodes.setForeground(PAUSED_COLOR);
        this.numInputs.setForeground(PAUSED_COLOR);
        this.numOutputs.setForeground(PAUSED_COLOR);
        netArchPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("NeuralNetworkDialog_network")), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        Insets none = new Insets(0, 0, 0, 0);
        Insets indent = new Insets(0, 10, 0, 0);
        GridBagConstraints nc = new GridBagConstraints();
        nc.anchor = 18;
        nc.insets = none;
        nc.gridx = 0;
        nc.gridy = 0;
        netArchPanel.add((Component)numInputsLabel, nc);
        nc.gridx = 1;
        nc.weightx = 1.0;
        nc.insets = indent;
        netArchPanel.add((Component)this.numInputs, nc);
        nc.gridx = 0;
        nc.gridy = 1;
        nc.weightx = 0.0;
        nc.insets = none;
        netArchPanel.add((Component)numHiddenNodesLabel, nc);
        nc.gridx = 1;
        nc.weightx = 1.0;
        nc.weighty = 1.0;
        nc.insets = indent;
        netArchPanel.add((Component)this.numHiddenNodes, nc);
        nc.gridy = 2;
        nc.gridx = 0;
        nc.weightx = 0.0;
        nc.insets = none;
        netArchPanel.add((Component)numOutputsLabel, nc);
        nc.gridx = 1;
        nc.weightx = 1.0;
        nc.weighty = 1.0;
        nc.insets = indent;
        netArchPanel.add((Component)this.numOutputs, nc);
        return netArchPanel;
    }

    private JPanel getTrainingOptionsPanel() {
        JPanel trainingOptionsPanel = new JPanel(new GridBagLayout());
        this.selectTrainMethodListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                String val;
                String s = (String)e.getItem();
                if (s.equalsIgnoreCase(NeuralNetworkDialog.trainingMethodStrings[4])) {
                    NeuralNetSettingsPanel.this.momentumTextField.setEnabled(false);
                    NeuralNetSettingsPanel.this.weightDecayTextField.setEnabled(false);
                } else if (NeuralNetSettingsPanel.this.epochsTextField.isEnabled()) {
                    NeuralNetSettingsPanel.this.momentumTextField.setEnabled(true);
                    NeuralNetSettingsPanel.this.weightDecayTextField.setEnabled(true);
                }
                if (NeuralNetSettingsPanel.this.momentumTextField.isEnabled() && (val = NeuralNetSettingsPanel.this.momentumTextField.getText()).length() == 0) {
                    NeuralNetSettingsPanel.this.momentumTextField.setText("0.0");
                }
                if (NeuralNetSettingsPanel.this.weightDecayTextField.isEnabled() && (val = NeuralNetSettingsPanel.this.weightDecayTextField.getText()).length() == 0) {
                    NeuralNetSettingsPanel.this.weightDecayTextField.setText("1.0");
                }
            }
        };
        JLabel trainingMethodLabel = new JLabel(MinerApp.getText("NeuralNetworkDialog_trainingMethod"));
        this.trainingMethodComboBox = new JComboBox<String>(NeuralNetworkDialog.trainingMethodStrings);
        trainingMethodLabel.setDisplayedMnemonic(MinerApp.getText("NeuralNetworkDialog_trainingMethodHotkey").charAt(0));
        trainingMethodLabel.setLabelFor(this.trainingMethodComboBox);
        this.trainingMethodComboBox.addItemListener(this.selectTrainMethodListener);
        this.trainingMethodComboBox.setEditable(false);
        this.inputElements.add(this.trainingMethodComboBox);
        JLabel accuracyLabel = new JLabel(MinerApp.getText("NeuralNetworkDialog_accuracy"));
        this.accuracyTextField = new JTextField(10);
        this.accuracyTextField.setPreferredSize(this.trainingMethodComboBox.getPreferredSize());
        accuracyLabel.setDisplayedMnemonic(MinerApp.getText("NeuralNetworkDialog_accuracyHotkey").charAt(0));
        accuracyLabel.setLabelFor(this.accuracyTextField);
        this.accuracyTextField.setDocument(new NodeDialog.InputDoubleDoc());
        this.inputElements.add(this.accuracyTextField);
        JLabel epochsLabel = new JLabel(MinerApp.getText("NeuralNetworkDialog_epochs"));
        this.epochsTextField = new JTextField(10);
        this.epochsTextField.setPreferredSize(this.trainingMethodComboBox.getPreferredSize());
        epochsLabel.setDisplayedMnemonic('p');
        epochsLabel.setLabelFor(this.epochsTextField);
        this.epochsTextField.setDocument(new NodeDialog.InputIntegerDoc());
        this.inputElements.add(this.epochsTextField);
        JLabel learningRateLabel = new JLabel(MinerApp.getText("NeuralNetworkDialog_learningRate"));
        this.learningRateTextField = new JTextField(10);
        this.learningRateTextField.setPreferredSize(this.trainingMethodComboBox.getPreferredSize());
        learningRateLabel.setDisplayedMnemonic(MinerApp.getText("NeuralNetworkDialog_learningRateHotkey").charAt(0));
        learningRateLabel.setLabelFor(this.learningRateTextField);
        this.learningRateTextField.setDocument(new NodeDialog.InputDoubleDoc());
        this.inputElements.add(this.learningRateTextField);
        JLabel momentumLabel = new JLabel(MinerApp.getText("NeuralNetworkDialog_momentum"));
        this.momentumTextField = new JTextField(10);
        this.momentumTextField.setPreferredSize(this.trainingMethodComboBox.getPreferredSize());
        momentumLabel.setDisplayedMnemonic(MinerApp.getText("NeuralNetworkDialog_momentumHotkey").charAt(0));
        momentumLabel.setLabelFor(this.momentumTextField);
        this.momentumTextField.setDocument(new NodeDialog.InputDoubleDoc());
        this.inputElements.add(this.momentumTextField);
        JLabel weightDecayLabel = new JLabel(MinerApp.getText("NeuralNetworkDialog_weightDecay"));
        this.weightDecayTextField = new JTextField(10);
        this.weightDecayTextField.setPreferredSize(this.trainingMethodComboBox.getPreferredSize());
        weightDecayLabel.setDisplayedMnemonic(MinerApp.getText("NeuralNetworkDialog_weightDecayHotkey").charAt(0));
        weightDecayLabel.setLabelFor(this.weightDecayTextField);
        this.weightDecayTextField.setDocument(new NodeDialog.InputDoubleDoc());
        this.inputElements.add(this.weightDecayTextField);
        trainingOptionsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Insets none = new Insets(0, 0, 0, 0);
        Insets indent = new Insets(0, 10, 0, 0);
        GridBagConstraints tc = new GridBagConstraints();
        tc.anchor = 18;
        tc.fill = 2;
        tc.gridy = 0;
        tc.gridx = 0;
        tc.weightx = 0.0;
        tc.insets = none;
        trainingOptionsPanel.add((Component)trainingMethodLabel, tc);
        tc.gridx = 1;
        tc.weightx = 1.0;
        tc.insets = indent;
        trainingOptionsPanel.add((Component)this.trainingMethodComboBox, tc);
        tc.gridy = 1;
        tc.gridx = 0;
        tc.weightx = 0.0;
        tc.insets = none;
        trainingOptionsPanel.add((Component)accuracyLabel, tc);
        tc.gridx = 1;
        tc.weightx = 1.0;
        tc.insets = indent;
        trainingOptionsPanel.add((Component)this.accuracyTextField, tc);
        tc.gridy = 2;
        tc.gridx = 0;
        tc.weightx = 0.0;
        tc.insets = none;
        trainingOptionsPanel.add((Component)epochsLabel, tc);
        tc.gridx = 1;
        tc.weightx = 1.0;
        tc.insets = indent;
        trainingOptionsPanel.add((Component)this.epochsTextField, tc);
        tc.gridy = 3;
        tc.gridx = 0;
        tc.weightx = 0.0;
        tc.insets = none;
        trainingOptionsPanel.add((Component)learningRateLabel, tc);
        tc.gridx = 1;
        tc.weightx = 1.0;
        tc.insets = indent;
        trainingOptionsPanel.add((Component)this.learningRateTextField, tc);
        tc.gridy = 4;
        tc.gridx = 0;
        tc.weightx = 0.0;
        tc.weighty = 1.0;
        tc.insets = none;
        trainingOptionsPanel.add((Component)momentumLabel, tc);
        tc.gridx = 1;
        tc.weightx = 1.0;
        tc.insets = indent;
        trainingOptionsPanel.add((Component)this.momentumTextField, tc);
        tc.gridy = 5;
        tc.gridx = 0;
        tc.weightx = 0.0;
        tc.insets = none;
        trainingOptionsPanel.add((Component)weightDecayLabel, tc);
        tc.gridx = 1;
        tc.weightx = 1.0;
        tc.insets = indent;
        trainingOptionsPanel.add((Component)this.weightDecayTextField, tc);
        return trainingOptionsPanel;
    }

    private JPanel getWeightsPanel() {
        JPanel weightsPanel = new JPanel(new GridBagLayout());
        this.inputElements.add(weightsPanel);
        weightsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ButtonGroup bg = new ButtonGroup();
        this.useCurrentButton = new JRadioButton(this.useCurrentWeightsRadioButtonAction);
        bg.add(this.useCurrentButton);
        this.useCurrentButton.setMnemonic('R');
        this.inputElements.add(this.useCurrentButton);
        this.useCurrentButton.setSelected(true);
        this.jitterWeightsButton = new JRadioButton(this.jitterWeightsRadioButtonAction);
        bg.add(this.jitterWeightsButton);
        this.jitterWeightsButton.setMnemonic('W');
        this.inputElements.add(this.jitterWeightsButton);
        this.loadWeightsRadioButton = new JRadioButton(this.loadWeightsRadioButtonAction);
        bg.add(this.loadWeightsRadioButton);
        this.loadWeightsRadioButton.setMnemonic(76);
        this.inputElements.add(this.loadWeightsRadioButton);
        this.loadWeightsButton = new JButton(this.loadWeightsAction);
        this.loadWeightsButton.setEnabled(false);
        this.loadWeightsButton.setMnemonic(76);
        this.loadWeightsButton.setPreferredSize(new Dimension(70, 20));
        this.inputElements.add(this.loadWeightsButton);
        this.colorizeWeightsCheckBox = new JCheckBox(NeuralNetViewer.getText("nnvis_colorizeWeights"));
        this.colorizeWeightsCheckBox.setEnabled(false);
        this.colorizeWeightsCheckBox.setSelected(true);
        this.colorizeWeightsCheckBox.setMnemonic(83);
        this.inputElements.add(this.colorizeWeightsCheckBox);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridy = 0;
        constraints.gridx = 0;
        weightsPanel.add((Component)this.useCurrentButton, constraints);
        constraints.gridy = 0;
        constraints.gridx = 1;
        weightsPanel.add((Component)this.colorizeWeightsCheckBox, constraints);
        constraints.gridy = 1;
        constraints.gridx = 0;
        weightsPanel.add((Component)this.jitterWeightsButton, constraints);
        constraints.gridy = 2;
        constraints.gridx = 0;
        constraints.weighty = 1.0;
        weightsPanel.add((Component)this.loadWeightsRadioButton, constraints);
        constraints.gridx = 1;
        weightsPanel.add((Component)this.loadWeightsButton, constraints);
        return weightsPanel;
    }

    private JPanel getFinalWeightsPanel() {
        JPanel finalWeightsPanel = new JPanel(new GridBagLayout());
        this.inputElements.add(finalWeightsPanel);
        finalWeightsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ButtonGroup bg = new ButtonGroup();
        this.useBestButton = new JRadioButton(this.useBestWeightsRadioButtonAction);
        bg.add(this.useBestButton);
        this.useBestButton.setMnemonic('B');
        this.inputElements.add(this.useBestButton);
        this.useBestButton.setSelected(true);
        this.useLastButton = new JRadioButton(this.useLastWeightsRadioButtonAction);
        bg.add(this.useLastButton);
        this.useLastButton.setMnemonic('L');
        this.inputElements.add(this.useLastButton);
        this.loadFinalWeightFileButton = new JRadioButton(this.loadFinalWeightFileButtonAction);
        bg.add(this.loadFinalWeightFileButton);
        this.loadFinalWeightFileButton.setMnemonic('F');
        this.inputElements.add(this.loadFinalWeightFileButton);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridy = 0;
        finalWeightsPanel.add((Component)this.useBestButton, constraints);
        constraints.gridy = 1;
        finalWeightsPanel.add((Component)this.useLastButton, constraints);
        constraints.gridy = 2;
        constraints.weighty = 1.0;
        finalWeightsPanel.add((Component)this.loadFinalWeightFileButton, constraints);
        return finalWeightsPanel;
    }

    public void reset(boolean b) {
        if (b) {
            this.mseLabel.setText(NeuralNetViewer.getText("nnvis_mseLabel"));
        } else {
            this.mseLabel.setText(NeuralNetViewer.getText("nnvis_scaledEntropyLabel"));
        }
    }

    private JPanel getControlPanel() {
        this.controlPanel = new JPanel(new GridBagLayout());
        this.controlPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel epochsLabel = new JLabel(NeuralNetViewer.getText("nnvis_epochLabel"));
        JLabel statusLabel = new JLabel(NeuralNetViewer.getText("nnvis_statusLabel"));
        this.mseLabel = new JLabel(NeuralNetViewer.getText("nnvis_mseLabel"));
        this.epochsResultLabel = new JLabel("");
        this.statusResultLabel = new JLabel("");
        this.setStatusResult(0);
        this.mseResultLabel = new JLabel("");
        this.setLabelBackground(0);
        this.pauseContinueButton = new JButton(this.pauseContinueAction);
        this.pauseContinueButton.setMnemonic('P');
        this.pauseContinueButton.setPreferredSize(new Dimension(100, 20));
        this.saveButton = new JButton(this.saveAction);
        this.saveButton.setEnabled(false);
        this.saveButton.setMnemonic('S');
        this.saveButton.setPreferredSize(new Dimension(100, 20));
        this.saveBestButton = new JButton(this.saveBestAction);
        this.saveBestButton.setEnabled(false);
        this.saveBestButton.setMnemonic('B');
        this.saveBestButton.setPreferredSize(new Dimension(100, 20));
        this.stopButton = new JButton(this.stopAction);
        this.stopButton.setMnemonic('t');
        this.stopButton.setPreferredSize(new Dimension(100, 20));
        Insets none = new Insets(0, 0, 0, 0);
        Insets indent = new Insets(0, 10, 0, 0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = none;
        this.controlPanel.add((Component)epochsLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.insets = indent;
        this.controlPanel.add((Component)this.epochsResultLabel, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.insets = none;
        this.controlPanel.add((Component)statusLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.insets = indent;
        this.controlPanel.add((Component)this.statusResultLabel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.insets = none;
        this.controlPanel.add((Component)this.mseLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.insets = indent;
        this.controlPanel.add((Component)this.mseResultLabel, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 0, 0, 0);
        this.controlPanel.add((Component)this.pauseContinueButton, gbc);
        ++gbc.gridx;
        gbc.insets = new Insets(5, 10, 0, 0);
        this.controlPanel.add((Component)this.saveButton, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weighty = 1.0;
        gbc.insets = none;
        this.controlPanel.add((Component)this.stopButton, gbc);
        ++gbc.gridx;
        gbc.insets = indent;
        this.controlPanel.add((Component)this.saveBestButton, gbc);
        return this.controlPanel;
    }

    private int getNumEpochsCompleted() {
        return 0;
    }

    private String getStatus() {
        return NeuralNetViewer.getText("nnvis_statusRunningLabel");
    }

    private double getMSE() {
        return 0.0;
    }

    public void setNumInputs(int i) {
        if (this.numInputs != null) {
            this.numInputs.setText(Integer.toString(i));
        }
    }

    public void setNumOutputs(int i) {
        if (this.numOutputs != null) {
            if (i > 1) {
                --i;
            }
            this.numOutputs.setText(Integer.toString(i));
        }
    }

    public void setRunResultLabels(String lastEpoch, String lastTestVal) {
        this.epochsResultLabel.setText(lastEpoch);
        this.mseResultLabel.setText(this.formatLikeConvergenceTolerance(Double.parseDouble(lastTestVal)));
    }

    public void setEntropyLabel(String value) {
        this.mseResultLabel.setText(this.formatLikeConvergenceTolerance(Double.parseDouble(value)));
    }

    private String formatLikeConvergenceTolerance(double d) {
        DecimalFormat dformat = new DecimalFormat();
        String convTol = this.accuracyTextField.getText();
        if (convTol.indexOf(46) == -1) {
            MinerApp.getWorksheetPropertiesManager().initViewerRoundingObject(dformat, 3);
        } else {
            convTol = convTol.substring(convTol.indexOf(46), convTol.length());
            MinerApp.getWorksheetPropertiesManager().initViewerRoundingObject(dformat, convTol.length() - 1);
        }
        return dformat.format(d);
    }

    public void updateData(Hashtable h) {
        if (h != null) {
            double deviation = Double.NaN;
            try {
                deviation = Double.parseDouble((String)h.get(NeuralNetworkExecViewer.VALIDATEDEV_TAG));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (Double.isNaN(deviation)) {
                deviation = Double.parseDouble((String)h.get(NeuralNetworkExecViewer.DEV_TAG));
            }
            String currentNumEpochs = (String)h.get(NeuralNetworkExecViewer.EPOCH_TAG);
            this.runComplete = (Boolean)h.get(NeuralNetworkExecViewer.SEARCH_COMPLETE_TAG);
            this.epochsResultLabel.setText(currentNumEpochs);
            this.mseResultLabel.setText(this.formatLikeConvergenceTolerance(deviation));
            if (this.runComplete || this.epochsTextField.getText().equals(currentNumEpochs)) {
                this.stopButton.doClick();
                this.viewer.closeSmallGraphWindow();
            }
        }
        if (this.controlPanel != null) {
            this.controlPanel.repaint();
        }
    }

    public void updateLabels() {
        if (this.statusResultLabel.getText().equals(NeuralNetViewer.getText("nnvis_statusPauseRequestedLabel"))) {
            this.pauseContinueButton.setEnabled(true);
            this.setStatusResult(4);
        }
        if (this.statusResultLabel.getText().equals(NeuralNetViewer.getText("nnvis_statusStopRequestedLabel"))) {
            this.setStatusResult(5);
        }
        if (this.controlPanel != null) {
            this.controlPanel.repaint();
        }
    }

    public void doStopButton() {
        this.stopButton.doClick();
    }

    public void restoreProperties(XTProps xtprops) {
        int iMethod;
        String method = xtprops.getValue("trainingMethod", "rprop");
        for (iMethod = 0; iMethod < NeuralNetworkDialog.trainingMethods.length; ++iMethod) {
            if (!method.equals(NeuralNetworkDialog.trainingMethods[iMethod])) continue;
            this.trainingMethodComboBox.setSelectedIndex(iMethod);
            break;
        }
        this.accuracyTextField.setText(xtprops.getValue("attribute", "0.00001"));
        this.epochsTextField.setText(xtprops.getValue("epochs", "50"));
        this.viewer.getGraphPanel().resetEpochs(this.epochsTextField.getText());
        if (iMethod != 4) {
            this.learningRateTextField.setText(xtprops.getValue("learningRate", "0.001"));
            this.momentumTextField.setText(xtprops.getValue("momentum", "0.0"));
            this.weightDecayTextField.setText(xtprops.getValue("weightDecay", "1.0"));
        } else {
            this.learningRateTextField.setText(xtprops.getValue("learningRate", "0.001"));
            this.momentumTextField.setText("");
            this.momentumTextField.disable();
            this.weightDecayTextField.setText("");
            this.weightDecayTextField.disable();
        }
        String numHidLay = xtprops.getValue("hiddenLayers", "1");
        String hidNodes = xtprops.getValue("numNodesHiddenLayer", "10");
        this.numHiddenNodes.setText(hidNodes + " X " + numHidLay);
        this.loadWeightsRadioButton.setSelected(false);
        if (xtprops.getInt("finalModelOption", 1) == 1) {
            this.useBestButton.setSelected(true);
            this.useLastButton.setSelected(false);
        } else {
            this.useBestButton.setSelected(false);
            this.useLastButton.setSelected(true);
        }
    }

    public void saveProperties(XTProps xtprops) throws Exception {
        double d;
        String s = this.accuracyTextField.getText();
        try {
            d = Double.valueOf(s);
            if (d < 0.0 || d >= 1.0) {
                s = "0.00001";
            }
        }
        catch (Exception e) {
            s = "0.00001";
        }
        xtprops.set("attribute", s);
        xtprops.set("trainingMethod", NeuralNetworkDialog.trainingMethods[this.trainingMethodComboBox.getSelectedIndex()]);
        if (Double.parseDouble(this.epochsTextField.getText()) > Double.parseDouble(this.epochsResultLabel.getText())) {
            xtprops.set("epochs", this.epochsTextField.getText());
            this.viewer.setNumEpochs(Integer.parseInt(this.epochsTextField.getText()));
        } else {
            this.epochsTextField.setText(xtprops.getValue("epochs", "50"));
        }
        s = this.learningRateTextField.getText();
        try {
            d = Double.valueOf(s);
            if (d <= 0.0 || d > 1.0) {
                s = "0.001";
            }
        }
        catch (Exception e) {
            s = "0.001";
        }
        xtprops.set("learningRate", s);
        s = this.momentumTextField.getText();
        try {
            double d2 = Double.valueOf(s);
            if (d2 < 0.0 || d2 > 1.0) {
                s = "0.0";
            }
        }
        catch (Exception e) {
            s = "0.0";
        }
        xtprops.set("momentum", s);
        s = this.weightDecayTextField.getText();
        try {
            double d3 = Double.valueOf(s);
            if (d3 < 0.0 || d3 > 1.0) {
                s = "1.0";
            }
        }
        catch (Exception e) {
            s = "1.0";
        }
        xtprops.set("weightDecay", s);
        WorksheetView view = MinerApp.getViewWithID(this.viewer.getWorksheetId());
        WorksheetDocument doc = view.getDoc();
        BaseNodeArea area = doc.findFlatNodeByID(Integer.parseInt(this.viewer.getNodeId()));
        ActivityNodeModel model = ((ActivityNodeArea)area).getNodeModel();
        model.setXTProps(xtprops);
    }

    public void createActions() {
        this.loadWeightsRadioButtonAction = new AbstractAction(NeuralNetViewer.getText("nnvis_load_Weights_checkbox")){

            public void actionPerformed(ActionEvent e) {
                if (NeuralNetSettingsPanel.this.loadWeightsRadioButton.isSelected()) {
                    NeuralNetSettingsPanel.this.loadWeightsButton.setEnabled(true);
                    NeuralNetSettingsPanel.this.pauseContinueButton.setEnabled(false);
                } else {
                    NeuralNetSettingsPanel.this.loadWeightsButton.setEnabled(false);
                    NeuralNetSettingsPanel.this.pauseContinueButton.setEnabled(true);
                }
            }
        };
        this.jitterWeightsRadioButtonAction = new AbstractAction(NeuralNetViewer.getText("nnvis_jitterWeights")){

            public void actionPerformed(ActionEvent e) {
                if (NeuralNetSettingsPanel.this.jitterWeightsButton.isSelected()) {
                    NeuralNetSettingsPanel.this.loadWeightsButton.setEnabled(false);
                    NeuralNetSettingsPanel.this.pauseContinueButton.setEnabled(true);
                }
            }
        };
        this.useCurrentWeightsRadioButtonAction = new AbstractAction(NeuralNetViewer.getText("nnvis_useCurrentWeights")){

            public void actionPerformed(ActionEvent e) {
                if (NeuralNetSettingsPanel.this.useCurrentButton.isSelected()) {
                    NeuralNetSettingsPanel.this.loadWeightsButton.setEnabled(false);
                    NeuralNetSettingsPanel.this.pauseContinueButton.setEnabled(true);
                }
            }
        };
        this.useBestWeightsRadioButtonAction = new AbstractAction(NeuralNetViewer.getText("nnvis_useBestWeights")){

            public void actionPerformed(ActionEvent e) {
                if (NeuralNetSettingsPanel.this.useBestButton.isSelected()) {
                    ((NeuralNetworkExecViewer)NeuralNetSettingsPanel.this.viewer.getExecViewer()).setTerminateOption(1);
                }
            }
        };
        this.useLastWeightsRadioButtonAction = new AbstractAction(NeuralNetViewer.getText("nnvis_useLastWeights")){

            public void actionPerformed(ActionEvent e) {
                if (NeuralNetSettingsPanel.this.useLastButton.isSelected()) {
                    ((NeuralNetworkExecViewer)NeuralNetSettingsPanel.this.viewer.getExecViewer()).setTerminateOption(2);
                }
            }
        };
        this.loadFinalWeightFileButtonAction = new AbstractAction(NeuralNetViewer.getText("nnvis_useFileWeights")){

            public void actionPerformed(ActionEvent e) {
                if (NeuralNetSettingsPanel.this.loadFinalWeightFileButton.isSelected()) {
                    NeuralNetSettingsPanel.this.promptForFileOnTermination = true;
                }
            }
        };
        this.loadWeightsAction = new AbstractAction(NeuralNetViewer.getText("nnvis_loadWeights")){

            public void actionPerformed(ActionEvent e) {
                File f = NeuralNetSettingsPanel.this.viewer.getConfigFile(false, 0, null, null);
                if (f != null) {
                    String s = f.getAbsolutePath();
                    ((NeuralNetworkExecViewer)NeuralNetSettingsPanel.this.viewer.getExecViewer()).setRetrieveWeightsFile(s);
                } else {
                    ((NeuralNetworkExecViewer)NeuralNetSettingsPanel.this.viewer.getExecViewer()).setRetrieveWeightsFile(null);
                }
                NeuralNetSettingsPanel.this.pauseContinueButton.setEnabled(true);
            }
        };
        this.pauseContinueAction = new AbstractAction(NeuralNetViewer.getText("nnvis_pauseButtonText")){

            public void actionPerformed(ActionEvent e) {
                if (NeuralNetSettingsPanel.this.pauseContinueButton.getText().equals(NeuralNetViewer.getText("nnvis_pauseButtonText"))) {
                    NeuralNetSettingsPanel.this.setStatusResult(1);
                    NeuralNetSettingsPanel.this.pauseContinueButton.setEnabled(false);
                    NeuralNetSettingsPanel.this.pauseContinueButton.setText(NeuralNetViewer.getText("nnvis_continueButtonText"));
                    NeuralNetSettingsPanel.this.saveButton.setEnabled(true);
                    NeuralNetSettingsPanel.this.saveBestButton.setEnabled(true);
                    NeuralNetSettingsPanel.this.useCurrentButton.setSelected(true);
                    NeuralNetSettingsPanel.this.setLabelBackground(2);
                    ((NeuralNetSettingsPanel)NeuralNetSettingsPanel.this).viewer.fileMenuSave.setEnabled(true);
                    ((NeuralNetSettingsPanel)NeuralNetSettingsPanel.this).viewer.fileMenuLoad.setEnabled(true);
                    NeuralNetSettingsPanel.this.enableInputs(true);
                    if (NeuralNetSettingsPanel.this.trainingMethodComboBox.getSelectedIndex() == 4) {
                        NeuralNetSettingsPanel.this.momentumTextField.setEnabled(false);
                        NeuralNetSettingsPanel.this.weightDecayTextField.setEnabled(false);
                    }
                    NeuralNetSettingsPanel.this.viewer.getExecViewer().pause();
                    ((NeuralNetworkExecViewer)NeuralNetSettingsPanel.this.viewer.getExecViewer()).setSaveWeightsFile(null);
                    ((NeuralNetworkExecViewer)NeuralNetSettingsPanel.this.viewer.getExecViewer()).setSaveBestWeightsFile(null);
                    ((NeuralNetworkExecViewer)NeuralNetSettingsPanel.this.viewer.getExecViewer()).setRetrieveWeightsFile(null);
                    ((NeuralNetworkExecViewer)NeuralNetSettingsPanel.this.viewer.getExecViewer()).setJitterWeightsFlag(false);
                } else {
                    try {
                        NeuralNetSettingsPanel.this.saveProperties(NeuralNetSettingsPanel.this.viewer.getProperties());
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                    ((NeuralNetworkExecViewer)NeuralNetSettingsPanel.this.viewer.getExecViewer()).setJitterWeightsFlag(NeuralNetSettingsPanel.this.jitterWeightsButton.isSelected());
                    ((NeuralNetworkExecViewer)NeuralNetSettingsPanel.this.viewer.getExecViewer()).setWeightsRequested(NeuralNetSettingsPanel.this.colorizeWeightsCheckBox.isSelected());
                    NeuralNetSettingsPanel.this.pauseContinueButton.setText(NeuralNetViewer.getText("nnvis_pauseButtonText"));
                    NeuralNetSettingsPanel.this.setStatusResult(0);
                    NeuralNetSettingsPanel.this.saveButton.setEnabled(false);
                    NeuralNetSettingsPanel.this.saveBestButton.setEnabled(false);
                    NeuralNetSettingsPanel.this.setLabelBackground(0);
                    ((NeuralNetSettingsPanel)NeuralNetSettingsPanel.this).viewer.fileMenuSave.setEnabled(false);
                    ((NeuralNetSettingsPanel)NeuralNetSettingsPanel.this).viewer.fileMenuLoad.setEnabled(false);
                    NeuralNetSettingsPanel.this.enableInputs(false);
                    NeuralNetSettingsPanel.this.viewer.getExecViewer().continueRun();
                }
            }
        };
        this.saveAction = new AbstractAction(NeuralNetViewer.getText("nnvis_saveButtonText")){

            public void actionPerformed(ActionEvent e) {
                NeuralNetSettingsPanel.this.saveButton.setEnabled(false);
                NeuralNetSettingsPanel.this.pauseContinueButton.setEnabled(false);
                File f = NeuralNetSettingsPanel.this.viewer.getConfigFile(true, NeuralNetSettingsPanel.this.viewer.getCurrentEpoch(), null, NeuralNetViewer.getText("nnvis_gui_save_weights_file_default"));
                if (f != null) {
                    String s = f.getAbsolutePath();
                    ((NeuralNetworkExecViewer)NeuralNetSettingsPanel.this.viewer.getExecViewer()).setSaveWeightsFile(s);
                    NeuralNetSettingsPanel.this.viewer.addArrow();
                } else {
                    ((NeuralNetworkExecViewer)NeuralNetSettingsPanel.this.viewer.getExecViewer()).setSaveWeightsFile(null);
                    NeuralNetSettingsPanel.this.saveButton.setEnabled(true);
                }
                NeuralNetSettingsPanel.this.pauseContinueButton.setEnabled(true);
            }
        };
        this.saveBestAction = new AbstractAction(NeuralNetViewer.getText("nnvis_saveBestButtonText")){

            public void actionPerformed(ActionEvent e) {
                NeuralNetSettingsPanel.this.saveBestButton.setEnabled(false);
                NeuralNetSettingsPanel.this.pauseContinueButton.setEnabled(false);
                File f = NeuralNetSettingsPanel.this.viewer.getConfigFile(true, NeuralNetSettingsPanel.this.viewer.getBestEpoch(), null, NeuralNetViewer.getText("nnvis_gui_save_weights_file_default"));
                if (f != null) {
                    String s = f.getAbsolutePath();
                    ((NeuralNetworkExecViewer)NeuralNetSettingsPanel.this.viewer.getExecViewer()).setSaveBestWeightsFile(s);
                    NeuralNetSettingsPanel.this.viewer.saveBestArrow();
                } else {
                    ((NeuralNetworkExecViewer)NeuralNetSettingsPanel.this.viewer.getExecViewer()).setSaveBestWeightsFile(null);
                    NeuralNetSettingsPanel.this.saveBestButton.setEnabled(true);
                }
                NeuralNetSettingsPanel.this.pauseContinueButton.setEnabled(true);
            }
        };
        this.stopAction = new AbstractAction(NeuralNetViewer.getText("nnvis_stopButtonText")){

            public void actionPerformed(ActionEvent e) {
                if (!NeuralNetSettingsPanel.this.runComplete) {
                    NeuralNetSettingsPanel.this.viewer.getExecViewer().pause();
                    NeuralNetSettingsPanel.this.setStatusResult(3);
                } else {
                    NeuralNetSettingsPanel.this.setStatusResult(5);
                }
                NeuralNetSettingsPanel.this.saveButton.setEnabled(false);
                NeuralNetSettingsPanel.this.saveBestButton.setEnabled(false);
                NeuralNetSettingsPanel.this.stopButton.setEnabled(false);
                NeuralNetSettingsPanel.this.pauseContinueButton.setEnabled(false);
                NeuralNetSettingsPanel.this.setLabelBackground(5);
                NeuralNetSettingsPanel.this.enableInputs(false);
                try {
                    NeuralNetSettingsPanel.this.saveProperties(NeuralNetSettingsPanel.this.viewer.getProperties());
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
                if (NeuralNetSettingsPanel.this.promptForFileOnTermination) {
                    File f = NeuralNetSettingsPanel.this.viewer.getConfigFile(false, 0, null, null);
                    if (f != null) {
                        String ss = f.getAbsolutePath();
                        ((NeuralNetworkExecViewer)NeuralNetSettingsPanel.this.viewer.getExecViewer()).setRetrieveWeightsFile(ss);
                        ((NeuralNetworkExecViewer)NeuralNetSettingsPanel.this.viewer.getExecViewer()).setTerminateOption(3);
                    } else {
                        ((NeuralNetworkExecViewer)NeuralNetSettingsPanel.this.viewer.getExecViewer()).setRetrieveWeightsFile(null);
                        ((NeuralNetworkExecViewer)NeuralNetSettingsPanel.this.viewer.getExecViewer()).setTerminateOption(1);
                    }
                }
                if (!NeuralNetSettingsPanel.this.runComplete) {
                    NeuralNetSettingsPanel.this.viewer.getExecViewer().continueRun();
                    NeuralNetSettingsPanel.this.viewer.getExecViewer().finishNode();
                }
                NeuralNetSettingsPanel.this.viewer.createCacheFile();
            }
        };
    }

    private void enableInputs(boolean b) {
        for (int i = 0; i < this.inputElements.size(); ++i) {
            ((JComponent)this.inputElements.elementAt(i)).setEnabled(b);
            if (this.loadWeightsRadioButton.isSelected()) continue;
            this.loadWeightsButton.setEnabled(false);
        }
    }
}

