/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.DataCacheRowBuf;
import com.insightful.miner.EngineNode;
import com.insightful.miner.SortAndShuffle;
import com.insightful.miner.UniqueEngineNode;
import com.insightful.miner.XTMetaData;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Vector;

public class RankEngineNode
extends UniqueEngineNode {
    public static final String RANK_COL_NAME = "RANK";
    private boolean m_secondIndex = false;

    public boolean hasCNKProc() {
        return false;
    }

    public boolean hasDataCacheProc() {
        return true;
    }

    protected String getIndexColNameForAddingIndex() {
        if (this.m_secondIndex) {
            return RANK_COL_NAME;
        }
        return ".im_index_im.";
    }

    protected double getIndexStartVal() {
        if (this.m_secondIndex) {
            return 1.0;
        }
        return 0.0;
    }

    protected boolean handleRows() throws Exception {
        this.m_modifiedFile = this.createWorkspaceTempFile("mod", "tmp");
        this.m_modifiedBlobFile = this.createWorkspaceTempFile("mod", "tmp");
        this.m_secondIndex = true;
        boolean ok = this.fileManipulation(this.m_sortedFile, this.m_sortedBlobFile, this.getSortedMD(), this.m_modifiedFile, this.m_modifiedBlobFile, this.getModifiedMD(), 0);
        this.m_secondIndex = false;
        return ok;
    }

    protected boolean isRowSame(DataCacheRowBuf buf1, DataCacheRowBuf buf2, int indexCol) {
        int ncol = buf1.getNumColumns();
        if (ncol != buf2.getNumColumns()) {
            return false;
        }
        for (int i = 0; i < ncol; ++i) {
            if (i == indexCol || buf1.isSame(buf2, i)) continue;
            return false;
        }
        return true;
    }

    protected void output(DataCacheRowBuf inBuf, DataCacheRowBuf outBuf, DataOutput outStream, int numColumns, int rankColNum, double tied_rank, double numRows, RandomAccessFile streamForIndices, long curRowNum, int indexColNum) {
        int rDec = 0;
        for (int i = 0; i < numColumns; ++i) {
            if (i == rankColNum) {
                outBuf.setDouble(rankColNum, tied_rank);
                rDec = 1;
                continue;
            }
            outBuf.copyColumn(i, i - rDec, inBuf);
        }
        int numBytes = inBuf.getBytesPerRow();
        byte[] data = inBuf.getDataBytes();
        long byteLocation = (curRowNum - (long)numRows) * (long)numBytes;
        int r = 0;
        while ((double)r < numRows) {
            try {
                streamForIndices.seek(byteLocation);
                streamForIndices.read(data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            inBuf.setData(data, 0);
            outBuf.copyColumn(indexColNum, indexColNum, inBuf);
            outBuf.writeRow(outStream);
            byteLocation += (long)numBytes;
            ++r;
        }
    }

    protected boolean index(DataCacheRowBuf preBuf, DataInput preStream, DataCacheRowBuf newBuf, DataOutput newStream, XTMetaData preMD, XTMetaData newMD) {
        if (!this.m_secondIndex) {
            return super.index(preBuf, preStream, newBuf, newStream, preMD, newMD);
        }
        RandomAccessFile streamForIndices = null;
        boolean ok = false;
        try {
            long curRowNum;
            int rankColNum = newMD.nameToOrdinal(RANK_COL_NAME);
            int indexColNum = newMD.nameToOrdinal(".im_index_im.");
            int numColumns = newMD.getNumColumns();
            long numRows = preMD.getNumRows();
            streamForIndices = new RandomAccessFile(this.m_sortedFile, "r");
            DataCacheRowBuf lastBuf = new DataCacheRowBuf(preMD);
            long numEqual = 0L;
            double index = this.getIndexStartVal();
            for (curRowNum = 0L; curRowNum < numRows; ++curRowNum) {
                try {
                    preBuf.readRow(preStream);
                    if (curRowNum != 0L) {
                        boolean sameRow = this.isRowSame(preBuf, lastBuf, indexColNum);
                        if (sameRow) {
                            ++numEqual;
                        } else {
                            double tied_index = index;
                            if (numEqual != 0L) {
                                tied_index = (2.0 * index + (double)numEqual) / 2.0;
                                index += (double)(numEqual + 1L);
                            } else {
                                index += 1.0;
                            }
                            this.output(lastBuf, newBuf, newStream, numColumns, rankColNum, tied_index, numEqual + 1L, streamForIndices, curRowNum, indexColNum);
                            numEqual = 0L;
                        }
                    }
                    lastBuf.copyAllColumns(preBuf);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            double tied_index = index;
            if (numEqual != 0L) {
                tied_index = (2.0 * index + (double)numEqual) / 2.0;
                index += (double)numEqual;
            } else {
                index += 1.0;
            }
            this.output(lastBuf, newBuf, newStream, numColumns, rankColNum, tied_index, numEqual + 1L, streamForIndices, curRowNum, indexColNum);
            ok = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (streamForIndices != null) {
                streamForIndices.close();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return ok;
    }

    protected boolean handleUnsort() throws Exception {
        this.m_unsortedFile = this.createWorkspaceTempFile("unsort", "tmp");
        this.m_unsortedBlobFile = this.createWorkspaceTempFile("unsort", "tmp");
        return this.fileManipulation(this.m_modifiedFile, this.m_modifiedBlobFile, this.getModifiedMD(), this.m_unsortedFile, this.m_unsortedBlobFile, this.getUnsortedMD(), 3);
    }

    protected boolean unsort() throws Exception {
        return SortAndShuffle.sort(this.m_modifiedFile, this.m_unsortedFile, this.m_modifiedMD, (EngineNode)this, this.getMaxRowsPerBlock(), new String[]{".im_index_im."}, new boolean[]{true}, new boolean[]{true}, true, true);
    }

    protected boolean handleOutput() throws Exception {
        File outputFile = new File(this.getOutputDataCacheFileName(0));
        File outputBlobFile = new File(this.getNetworkManager().getOutputDataBlobFileName(this.getNodeID(), 0));
        XTMetaData outputMD = this.getOutputMD();
        this.setOutputMetaData(0, outputMD);
        return this.fileManipulation(this.m_unsortedFile, this.m_unsortedBlobFile, this.getUnsortedMD(), outputFile, outputBlobFile, outputMD, 4);
    }

    protected boolean drop(DataCacheRowBuf preBuf, DataInput preStream, DataCacheRowBuf newBuf, DataOutput newStream, XTMetaData preMD, XTMetaData newMD) {
        long numRows = preMD.getNumRows();
        int indexColNum = preMD.nameToOrdinal(RANK_COL_NAME);
        int numColumns = preMD.getNumColumns();
        for (long rowNum = 0L; rowNum < numRows; ++rowNum) {
            try {
                preBuf.readRow(preStream);
                int c = 0;
                for (int i = 0; i < numColumns; ++i) {
                    if (i != indexColNum) continue;
                    newBuf.copyColumn(c++, i, preBuf);
                }
                newBuf.writeRow(newStream);
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        return true;
    }

    protected XTMetaData getModifiedMD() {
        if (this.m_modifiedMD == null) {
            this.m_modifiedMD = (XTMetaData)this.getSortedMD().clone();
            this.m_modifiedMD.appendContinousDataField(RANK_COL_NAME);
        }
        return this.m_modifiedMD;
    }

    protected XTMetaData getOutputMD() {
        Vector<String> colNames = new Vector<String>();
        colNames.add(RANK_COL_NAME);
        XTMetaData md = this.getUnsortedMD().selectiveClone(colNames);
        return md;
    }
}

