/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.CreateDictionaryDialog;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.ReadOtherFileDialog;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ReadFixedFormatFileDialog
extends ReadOtherFileDialog {
    private JTextField m_NAStringTextField;
    private NodeDialog.DateParseFormatComboBox m_timeDateFormatComboBox;
    private JTextField m_dictionaryTextField;
    private static final String[] typeStrings = new String[]{XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG, XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG, XTMetaData.STRING_TYPE_ATTRIBUTE_TAG, XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG};
    private static final String[] roleStrings = new String[]{XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG, XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG, XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG};
    private static String[] m_typeDescriptionList = new String[]{"Text File (*.txt)", "Data File (*.dat)", "ASCII File (*.asc)", "Print Format File (*.prn)"};
    private static String[][] m_extensionList = new String[][]{{".txt"}, {".dat"}, {".asc"}, {".prn"}};
    private static ReadFixedFormatFileDialog m_ReadFixedFormatFileDialog = null;

    public static ReadFixedFormatFileDialog getReadFixedFormatFileDialog() {
        if (m_ReadFixedFormatFileDialog == null) {
            m_ReadFixedFormatFileDialog = new ReadFixedFormatFileDialog();
        }
        return m_ReadFixedFormatFileDialog;
    }

    protected ReadFixedFormatFileDialog() {
        Dimension min = new Dimension(550, 525);
        this.setMinimumSize(min);
        this.setSize(min);
    }

    protected void restoreSpecialFileProperties(XTProps props) {
        this.m_fileNameTextField.setText(props.getValue("filePath", ""));
        this.m_dictionaryTextField.setText(props.getValue("dictionaryFile", ""));
        this.m_NAStringTextField.setText(props.getValue("NAString", ""));
        this.m_timeDateFormatComboBox.setText(props.getValue("timeDateFormat", MinerApp.getWorksheetPropertiesManager().getDateParseString()));
    }

    protected void saveSpecialFileProperties(XTProps props) {
        String filename = this.m_fileNameTextField.getText();
        props.set("filePath", filename);
        filename = this.m_dictionaryTextField.getText();
        props.set("dictionaryFile", filename);
        props.set("NAString", this.m_NAStringTextField.getText());
        props.set("timeDateFormat", this.m_timeDateFormatComboBox.getText());
    }

    public JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel saveFilePanel = new JPanel(new GridBagLayout());
        this.m_timeDateFormatComboBox = new NodeDialog.DateParseFormatComboBox();
        Dimension minSize = this.m_timeDateFormatComboBox.getPreferredSize();
        this.m_timeDateFormatComboBox.setMinimumSize(minSize);
        this.m_fileNameTextField = new JTextField(25);
        this.m_fileNameTextField.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.checkReadFileName(ReadFixedFormatFileDialog.this.m_fileNameTextField, m_extensionList, null);
            }
        });
        this.m_fileNameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    ReadOtherFileDialog.checkReadFileName(ReadFixedFormatFileDialog.this.m_fileNameTextField, m_extensionList, null);
                }
            }
        });
        JLabel fileNameLabel = new JLabel(MinerApp.getText("ReadTextFileDialog_filename"));
        fileNameLabel.setDisplayedMnemonic(70);
        JButton browseButton = new JButton(new AbstractAction(MinerApp.getText("ReadTextFileDialog_browse")){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.browseReadFileName(m_ReadFixedFormatFileDialog, ReadFixedFormatFileDialog.this.m_fileNameTextField, m_extensionList, m_typeDescriptionList, null);
            }
        });
        browseButton.setMnemonic(66);
        fileNameLabel.setLabelFor(browseButton);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridwidth = 2;
        constraints.weightx = 0.0;
        saveFilePanel.add((Component)fileNameLabel, constraints);
        constraints.gridwidth = 6;
        constraints.gridx = 2;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        saveFilePanel.add((Component)this.m_fileNameTextField, constraints);
        constraints.gridx = 8;
        constraints.weightx = 0.0;
        constraints.gridwidth = 2;
        constraints.fill = 0;
        saveFilePanel.add((Component)browseButton, constraints);
        JPanel moreOptionsPanel = new JPanel(new GridBagLayout());
        moreOptionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ReadTextFileDialog_options")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel naLabel = new JLabel(MinerApp.getText("ReadTextFileDialog_missingValString"));
        this.m_NAStringTextField = new JTextField(15);
        naLabel.setDisplayedMnemonic('v');
        naLabel.setLabelFor(this.m_NAStringTextField);
        JLabel timeDateFormatLabel = new JLabel(MinerApp.getText("ReadTextFileDialog_dateTimeFormat"));
        timeDateFormatLabel.setDisplayedMnemonic('f');
        timeDateFormatLabel.setLabelFor(this.m_timeDateFormatComboBox);
        JLabel defaultStringTypeLabel = new JLabel(MinerApp.getText("ReadTextFileDialog_columnType"));
        defaultStringTypeLabel.setDisplayedMnemonic('d');
        this.m_defaultStringColumnTypeComboBox = new JComboBox<Object>(new Object[]{XTMetaData.STRING_TYPE_ATTRIBUTE_TAG, XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG});
        defaultStringTypeLabel.setLabelFor(this.m_defaultStringColumnTypeComboBox);
        JLabel dictionaryLabel = new JLabel(MinerApp.getText("ReadOtherFileDialog_dataDictionary"));
        dictionaryLabel.setDisplayedMnemonic('a');
        this.m_dictionaryTextField = new JTextField(15);
        JButton dictionaryBrowseButton = new JButton(new AbstractAction(MinerApp.getText("ReadTextFileDialog_browse")){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.browseDictionaryFileName(m_ReadFixedFormatFileDialog, ReadFixedFormatFileDialog.this.m_dictionaryTextField);
            }
        });
        dictionaryBrowseButton.setMnemonic(87);
        dictionaryLabel.setLabelFor(dictionaryBrowseButton);
        JButton createdictionaryBrowseButton = new JButton(new AbstractAction(MinerApp.getText("ReadFixedFormatFileDialog_createEdit")){

            public void actionPerformed(ActionEvent e) {
                CreateDictionaryDialog dlg = new CreateDictionaryDialog(ReadFixedFormatFileDialog.this, ReadFixedFormatFileDialog.this.m_dictionaryTextField.getText());
                dlg.show();
                if (dlg.success) {
                    ReadFixedFormatFileDialog.this.m_dictionaryTextField.setText(dlg.filename);
                }
            }
        });
        createdictionaryBrowseButton.setMnemonic(67);
        dictionaryLabel.setLabelFor(createdictionaryBrowseButton);
        int gridy = 0;
        GridBagConstraints optionsConstraints = new GridBagConstraints();
        optionsConstraints.anchor = 18;
        optionsConstraints.gridy = gridy++;
        optionsConstraints.weightx = 0.0;
        optionsConstraints.fill = 0;
        moreOptionsPanel.add((Component)dictionaryLabel, optionsConstraints);
        optionsConstraints.gridx = 1;
        optionsConstraints.weightx = 1.0;
        optionsConstraints.insets = new Insets(0, 25, 0, 0);
        optionsConstraints.fill = 2;
        moreOptionsPanel.add((Component)this.m_dictionaryTextField, optionsConstraints);
        optionsConstraints.weightx = 0.0;
        optionsConstraints.gridx = 2;
        optionsConstraints.insets = new Insets(0, 10, 0, 10);
        optionsConstraints.fill = 0;
        moreOptionsPanel.add((Component)dictionaryBrowseButton, optionsConstraints);
        optionsConstraints.weightx = 0.0;
        optionsConstraints.gridx = 3;
        optionsConstraints.insets = new Insets(0, 0, 0, 10);
        optionsConstraints.fill = 0;
        moreOptionsPanel.add((Component)createdictionaryBrowseButton, optionsConstraints);
        optionsConstraints.gridx = 0;
        optionsConstraints.gridy = gridy++;
        optionsConstraints.gridwidth = 3;
        optionsConstraints.weightx = 0.0;
        optionsConstraints.insets = new Insets(0, 0, 0, 0);
        optionsConstraints.fill = 0;
        moreOptionsPanel.add((Component)timeDateFormatLabel, optionsConstraints);
        optionsConstraints.gridx = 1;
        optionsConstraints.weightx = 1.0;
        optionsConstraints.gridwidth = 3;
        optionsConstraints.insets = new Insets(0, 25, 0, 0);
        optionsConstraints.fill = 2;
        moreOptionsPanel.add((Component)this.m_timeDateFormatComboBox, optionsConstraints);
        optionsConstraints.gridx = 0;
        optionsConstraints.gridy = gridy++;
        optionsConstraints.weightx = 0.0;
        optionsConstraints.insets = new Insets(0, 0, 0, 0);
        optionsConstraints.fill = 0;
        moreOptionsPanel.add((Component)defaultStringTypeLabel, optionsConstraints);
        optionsConstraints.gridx = 1;
        optionsConstraints.weightx = 1.0;
        optionsConstraints.weighty = 1.0;
        optionsConstraints.insets = new Insets(0, 25, 0, 0);
        optionsConstraints.fill = 2;
        moreOptionsPanel.add((Component)this.m_defaultStringColumnTypeComboBox, optionsConstraints);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)saveFilePanel, "North");
        topPanel.add((Component)moreOptionsPanel, "Center");
        topPanel.add((Component)this.createSamplePanel(true), "South");
        optionsPanel.add((Component)topPanel, "North");
        optionsPanel.add((Component)this.createPreviewPanel(), "Center");
        return optionsPanel;
    }
}

