/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.CreateDictionaryDialog;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MinerExtensionFileFilter;
import com.insightful.miner.ModifyColumnsPanel;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.WideFileChooser;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTNetwork;
import com.insightful.miner.XTProps;
import com.insightful.splus.SplusSystem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;

public class ReadOtherFileDialog
extends NodeDialog {
    private DecimalFormat m_decimalFormat = new DecimalFormat();
    private int m_decimalPlaces = -1;
    private static ReadOtherFileDialog m_ReadOtherFileDialog = null;
    private static final String m_defaultRowValue = "10";
    protected JComboBox m_typeComboBox;
    protected JTextField m_fileNameTextField;
    private JTextField m_rowsToPreviewTextField;
    private JComboBox m_roundingComboBox;
    private ModifyColumnsPanel m_modifyColumnsPanel;
    private boolean m_modifyColumnsActive = false;
    private JPanel m_previewPanel;
    private JButton m_fetchPreviewButton;
    private NodeDialog.DialogTable m_previewTable;
    protected JTextField m_startRowTextField;
    protected JTextField m_endRowTextField;
    private JTextField m_accessTableTextField;
    private JLabel accessLabel;
    protected JComboBox m_defaultStringColumnTypeComboBox;
    protected JRadioButton[] m_sampleRadioButtons;
    protected JTextField m_sampleProbabilityTextField;
    protected JTextField m_sampleNthRowTextField;
    private static String[] m_typeCodeList = new String[]{"DBASE", "GAUSS", "GAUSS96", "LOTUS", "MATLAB", "ACCESS97", "ACCESS2K", "MINITAB", "QUATTRO", "SPSS", "SPSSP", "STATA", "SYSTAT"};
    private static String[] m_typeDescriptionList = new String[]{"dBASE File (*.dbf)", "Gauss Data File (*.dat)", "Gauss Data File - Unix (*.dat)", "Lotus 1-2-3 (*.wks;*.wk1;*.wk3;*.wk4;*.wrk)", "Matlab Matrix (*.mat)", "Microsoft Access 97 (*.mdb)", "Microsoft Access 2000 (*.mdb)", "Mintab Workbook (*.mtw)", "Quattro Pro Worksheet (*.wq1;*.wb2;*.wb3)", "SPSS Data File (*.sav)", "SPSS Portable Data File (*.por)", "Stata Data File (*.dta)", "Systat File (*.syd, *.sys)"};
    private static String[][] m_extensionList = new String[][]{{".dbf"}, {".dat"}, {".dat"}, {".wks", ".wk1", ".wk3", ".wk4", ".wrk"}, {".mat"}, {".mdb"}, {".mdb"}, {".mtw"}, {".wq1", ".wb2", ".wb3"}, {".sav"}, {".por"}, {".dta"}, {".syd", ".sys"}};

    public static ReadOtherFileDialog getReadOtherFileDialog() {
        if (m_ReadOtherFileDialog == null) {
            m_ReadOtherFileDialog = new ReadOtherFileDialog();
        }
        return m_ReadOtherFileDialog;
    }

    protected ReadOtherFileDialog() {
        Dimension min = new Dimension(525, 525);
        this.setMinimumSize(min);
        this.setSize(min);
        this.setResizable(true);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Component comp = ReadOtherFileDialog.this.getGlassPane();
                Cursor oldCursor = comp.getCursor();
                comp.setCursor(Cursor.getPredefinedCursor(3));
                comp.setVisible(true);
                try {
                    if (ReadOtherFileDialog.this.isShowingModifyColumnsTab()) {
                        ReadOtherFileDialog.this.updateModifyColumnsTab();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                comp.setCursor(oldCursor);
                comp.setVisible(false);
            }
        });
    }

    private boolean isShowingModifyColumnsTab() {
        Component comp = this.tabbedPane.getSelectedComponent();
        return comp == this.m_modifyColumnsPanel;
    }

    protected void initPreview() {
        this.m_previewTable.setModel(new DefaultTableModel(){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        });
        this.m_fetchPreviewButton.setEnabled(!MinerApp.isRunning());
    }

    protected void updatePreview() {
        try {
            boolean previewHasWarning;
            int decimalPlaces;
            this.m_previewPanel.setCursor(Cursor.getPredefinedCursor(3));
            int fieldNumRows = -1;
            try {
                fieldNumRows = Integer.parseInt(this.m_rowsToPreviewTextField.getText());
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (fieldNumRows < 1) {
                this.m_rowsToPreviewTextField.setText("0");
            }
            if ((decimalPlaces = this.m_roundingComboBox.getSelectedIndex()) > 0 && decimalPlaces != this.m_decimalPlaces) {
                MinerApp.getWorksheetPropertiesManager().initViewerRoundingObject(this.m_decimalFormat, decimalPlaces);
                this.m_decimalPlaces = decimalPlaces;
            }
            XTProps currentFileProps = null;
            currentFileProps = this.getCurrentFileProperties();
            this.saveSampleProperties(currentFileProps);
            this.seedPanel.saveProperties(currentFileProps);
            XTProps previewProps = this.getDataSourcePreview(currentFileProps);
            XTMetaData metaData = this.getDataSourceMetaData(currentFileProps);
            XTProps previewInfo = this.getDataSourceInfo(currentFileProps);
            boolean previewHasError = previewInfo != null && !previewInfo.getValue("error", "").equals("");
            boolean bl = previewHasWarning = previewInfo != null && !previewInfo.getValue("warning", "").equals("");
            if (previewHasError) {
                this.initPreview();
                this.checkForErrorInDataSourceProps(previewInfo, "", false);
                throw new Exception();
            }
            if (previewHasWarning) {
                this.checkForErrorInDataSourceProps(previewInfo, "", false);
            } else if (previewProps == null || metaData == null || previewInfo == null) {
                this.initPreview();
                this.checkForErrorInDataSourceProps(null, "", false);
                throw new Exception();
            }
            Vector columnNames = metaData.getColumnNames();
            int numColumns = metaData.getNumColumns();
            boolean[] isDouble = new boolean[numColumns];
            for (int i = 0; i < numColumns; ++i) {
                isDouble[i] = metaData.isContinuousColumn(i);
            }
            Vector rowNumberStrings = previewProps.getSubProperties("previewRows");
            int numRows = rowNumberStrings.size();
            Vector<Vector> data = new Vector<Vector>();
            String[] path = new String[]{"previewRows", "dummyRowName"};
            for (int row = 0; row < numRows; ++row) {
                path[1] = (String)rowNumberStrings.get(row);
                Vector columnVals = previewProps.getSubPropertyValues(path);
                if (decimalPlaces > 0) {
                    for (int colNum = 0; colNum < numColumns && colNum < columnVals.size(); ++colNum) {
                        if (!isDouble[colNum]) continue;
                        String oldVal = (String)columnVals.get(colNum);
                        try {
                            double full = Double.parseDouble(oldVal);
                            String newVal = this.m_decimalFormat.format(full);
                            columnVals.set(colNum, newVal);
                            continue;
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                }
                data.add(columnVals);
            }
            this.m_previewTable.setModel(new DefaultTableModel(data, columnNames){

                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            });
        }
        catch (Exception e) {
            this.initPreview();
        }
        this.m_previewPanel.setCursor(Cursor.getPredefinedCursor(0));
    }

    public XTMetaData getDataSourceMetaData(XTProps props) throws Exception {
        XTMetaData md = null;
        try {
            this.getNodeModel().saveGuiNetworkToEngine();
            if (this.getNodeModel().getDocument().isDummyEngineConnection()) {
                return new XTMetaData();
            }
            md = (XTMetaData)this.getNodeModel().sendMessageToEngine("getDataSourceMetaData", new Object[]{props});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return md;
    }

    public XTProps getDataSourcePreview(XTProps props) throws Exception {
        XTProps previewProps = null;
        try {
            this.getNodeModel().saveGuiNetworkToEngine();
            if (this.getNodeModel().getDocument().isDummyEngineConnection()) {
                return new XTProps();
            }
            previewProps = (XTProps)this.getNodeModel().sendMessageToEngine("getDataSourcePreview", new Object[]{props});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return previewProps;
    }

    public XTProps getDataSourceInfo(XTProps props) throws Exception {
        XTProps info = null;
        try {
            this.getNodeModel().saveGuiNetworkToEngine();
            if (this.getNodeModel().getDocument().isDummyEngineConnection()) {
                return new XTProps();
            }
            info = (XTProps)this.getNodeModel().sendMessageToEngine("getDataSourceInfo", new Object[]{props});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return info;
    }

    private void updateModifyColumnsTab() {
        try {
            XTProps modifyProps;
            if (this.m_modifyColumnsActive) {
                modifyProps = new XTProps();
                this.m_modifyColumnsPanel.saveProperties(modifyProps);
            } else {
                modifyProps = new XTProps(this.getNodeModel().getXTProps());
            }
            XTProps currentFileProps = this.getCurrentFileProperties();
            XTMetaData metaData = this.getDataSourceMetaData(currentFileProps);
            this.m_modifyColumnsPanel.restoreProperties(metaData, modifyProps);
            this.m_modifyColumnsActive = true;
        }
        catch (Exception e) {
            this.m_modifyColumnsPanel.restoreProperties(null, null);
        }
    }

    public void onOk() {
        try {
            XTProps currentFileProps = this.getCurrentFileProperties();
            XTProps errorProps = this.getDataSourceInfo(currentFileProps);
            int val = this.checkForErrorInDataSourceProps(errorProps, "\n\nSave properties and close dialog?", true);
            if (val == 0) {
                super.onOk();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected int checkForErrorInDataSourceProps(XTProps errorProps, String yesNoCancelOption, boolean noAndCancelOptionsPresent) {
        return ReadOtherFileDialog.checkForErrorInDataSourceProps(this, errorProps, yesNoCancelOption, noAndCancelOptionsPresent);
    }

    protected static int checkForErrorInDataSourceProps(NodeDialog dialog, XTProps errorProps, String yesNoCancelOption, boolean noAndCancelOptionsPresent) {
        int val = 0;
        if (noAndCancelOptionsPresent) {
            val = 0;
        }
        boolean hasError = false;
        boolean hasWarning = false;
        String error = "";
        if (errorProps == null) {
            error = MinerApp.getText("ReadOtherFileDialog_msg_unknownError");
            hasError = true;
        } else {
            error = errorProps.getValue("error", "");
            String warnings = errorProps.getValue("warning", "");
            hasError = !error.equals("");
            boolean bl = hasWarning = !warnings.equals("");
            if (hasWarning) {
                if (hasError) {
                    error = error + "\n\n";
                }
                error = error + warnings;
            }
        }
        if (hasError || hasWarning) {
            String dialogTitle;
            String msg = error + yesNoCancelOption;
            if (hasError) {
                msg = MinerApp.getText("ReadOtherFileDialog_msg_error") + " " + msg;
            }
            String string = dialogTitle = hasError ? MinerApp.getText("ReadOtherFileDialog_msg_cantOpenDataSource") : MinerApp.getText("ReadOtherFileDialog_msg_warningTitle");
            if (noAndCancelOptionsPresent) {
                return AcceleratorOptionPane.showYesNoCancelDialog(dialog, msg, dialogTitle, 2);
            }
            return AcceleratorOptionPane.showOKDialog(dialog, msg, dialogTitle, 2);
        }
        return val;
    }

    public boolean displaySeedPanel() {
        return true;
    }

    public void restoreProperties() {
        super.restoreProperties();
        XTProps props = this.getNodeModel().getXTProps();
        this.restoreFileProperties(props);
        this.restoreSampleProperties(props);
        this.m_modifyColumnsActive = false;
    }

    protected void restoreFileProperties(XTProps props) {
        this.restoreSpecialFileProperties(props);
        this.restoreCommonFileProperties(props);
    }

    private void setAccessLabelEnabled() {
        int selectedIndex = this.m_typeComboBox.getSelectedIndex();
        boolean isMDB = selectedIndex >= 0 && selectedIndex < m_extensionList.length && m_extensionList[selectedIndex][0].equals(".mdb");
        this.m_accessTableTextField.setEnabled(isMDB);
        this.accessLabel.setEnabled(isMDB);
    }

    protected void restoreSpecialFileProperties(XTProps props) {
        String type = props.getValue("fileType", "ACCESS97");
        if (type.equals("ACCESS")) {
            type = "ACCESS97";
        }
        ReadOtherFileDialog.setComboBoxFromTypeString(type, m_typeCodeList, this.m_typeComboBox);
        this.setAccessLabelEnabled();
        String currentPath = props.getValue("filePath", "");
        this.m_fileNameTextField.setText(currentPath);
        this.m_accessTableTextField.setText(props.getValue("dbTable", ""));
    }

    protected void restoreCommonFileProperties(XTProps props) {
        this.initPreview();
        if (this.m_rowsToPreviewTextField != null) {
            this.m_rowsToPreviewTextField.setText(props.getValue("rowsToPreview", m_defaultRowValue));
        }
        if (this.m_startRowTextField != null) {
            this.m_startRowTextField.setText(props.getValue("startRow", ""));
        }
        if (this.m_endRowTextField != null) {
            this.m_endRowTextField.setText(props.getValue("endRow", ""));
        }
        if (this.m_defaultStringColumnTypeComboBox != null) {
            String defaultStringColumnType = props.getValue("defaultStringColumnType", "categorical");
            this.m_defaultStringColumnTypeComboBox.setSelectedItem(defaultStringColumnType);
        }
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        XTProps props = this.getNodeModel().getXTProps();
        this.checkSampleValues();
        this.saveSampleProperties(props);
        this.saveFileProperties(props);
        if (this.m_modifyColumnsActive) {
            this.m_modifyColumnsPanel.saveProperties(this.getNodeModel().getXTProps());
        }
    }

    protected XTProps getCurrentFileProperties() {
        XTProps props = null;
        try {
            props = new XTProps();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        this.saveFileProperties(props);
        return props;
    }

    protected void saveFileProperties(XTProps props) {
        this.saveSpecialFileProperties(props);
        this.saveCommonFileProperties(props);
    }

    protected void saveSpecialFileProperties(XTProps props) {
        String filename = this.m_fileNameTextField.getText();
        props.set("filePath", filename);
        props.set("fileType", m_typeCodeList[this.m_typeComboBox.getSelectedIndex()]);
        props.set("dbTable", this.m_accessTableTextField.getText());
    }

    protected void saveCommonFileProperties(XTProps props) {
        if (this.m_rowsToPreviewTextField != null) {
            props.set("rowsToPreview", this.m_rowsToPreviewTextField.getText());
        }
        if (this.m_startRowTextField != null) {
            props.set("startRow", this.m_startRowTextField.getText());
            props.set("endRow", this.m_endRowTextField.getText());
        }
        if (this.m_defaultStringColumnTypeComboBox != null) {
            Object obj = this.m_defaultStringColumnTypeComboBox.getSelectedItem();
            String defaultStringColumnType = "string";
            if (obj != null && obj instanceof String) {
                defaultStringColumnType = (String)obj;
            }
            props.set("defaultStringColumnType", defaultStringColumnType);
        }
    }

    public JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel saveFilePanel = new JPanel(new GridBagLayout());
        this.m_fileNameTextField = new JTextField(30);
        this.m_fileNameTextField.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.checkReadFileName(ReadOtherFileDialog.this.m_fileNameTextField, m_extensionList, ReadOtherFileDialog.this.m_typeComboBox);
            }
        });
        this.m_fileNameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    ReadOtherFileDialog.checkReadFileName(ReadOtherFileDialog.this.m_fileNameTextField, m_extensionList, ReadOtherFileDialog.this.m_typeComboBox);
                }
            }
        });
        JLabel fileNameLabel = new JLabel(MinerApp.getText("ReadTextFileDialog_filename"));
        fileNameLabel.setDisplayedMnemonic(70);
        JButton browseButton = new JButton(new AbstractAction(MinerApp.getText("ReadTextFileDialog_browse")){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.browseReadFileName(m_ReadOtherFileDialog, ReadOtherFileDialog.this.m_fileNameTextField, m_extensionList, m_typeDescriptionList, ReadOtherFileDialog.this.m_typeComboBox);
            }
        });
        browseButton.setMnemonic(66);
        fileNameLabel.setLabelFor(browseButton);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridwidth = 2;
        constraints.weightx = 0.0;
        saveFilePanel.add((Component)fileNameLabel, constraints);
        constraints.gridwidth = 6;
        constraints.gridx = 2;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        saveFilePanel.add((Component)this.m_fileNameTextField, constraints);
        constraints.gridx = 8;
        constraints.weightx = 0.0;
        constraints.gridwidth = 2;
        constraints.fill = 0;
        saveFilePanel.add((Component)browseButton, constraints);
        JPanel moreOptionsPanel = new JPanel(new GridBagLayout());
        moreOptionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ReadTextFileDialog_options")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel typeLabel = new JLabel(MinerApp.getText("ReadOtherFileDialog_type"));
        typeLabel.setDisplayedMnemonic(89);
        this.m_typeComboBox = new JComboBox<String>(m_typeDescriptionList);
        this.m_typeComboBox.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.checkFileNameOnComboBoxAction(ReadOtherFileDialog.this.m_fileNameTextField, m_extensionList, ReadOtherFileDialog.this.m_typeComboBox);
            }
        });
        this.m_typeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.this.setAccessLabelEnabled();
            }
        });
        typeLabel.setLabelFor(this.m_typeComboBox);
        this.accessLabel = new JLabel(MinerApp.getText("ReadOtherFileDialog_accessTable"));
        this.m_accessTableTextField = new JTextField(25);
        this.accessLabel.setDisplayedMnemonic('a');
        this.accessLabel.setLabelFor(this.m_accessTableTextField);
        JLabel defaultStringTypeLabel = new JLabel(MinerApp.getText("ReadTextFileDialog_columnType"));
        defaultStringTypeLabel.setDisplayedMnemonic('t');
        this.m_defaultStringColumnTypeComboBox = new JComboBox<Object>(new Object[]{XTMetaData.STRING_TYPE_ATTRIBUTE_TAG, XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG});
        defaultStringTypeLabel.setLabelFor(this.m_defaultStringColumnTypeComboBox);
        Insets noIndent = new Insets(0, 0, 0, 8);
        Insets indent = new Insets(0, 5, 0, 8);
        int gridy = 1;
        GridBagConstraints optionsConstraints = new GridBagConstraints();
        optionsConstraints.anchor = 18;
        optionsConstraints.fill = 0;
        moreOptionsPanel.add((Component)typeLabel, optionsConstraints);
        optionsConstraints.gridx = 1;
        optionsConstraints.weightx = 1.0;
        optionsConstraints.insets = indent;
        optionsConstraints.fill = 2;
        moreOptionsPanel.add((Component)this.m_typeComboBox, optionsConstraints);
        optionsConstraints.gridx = 0;
        optionsConstraints.gridy = gridy++;
        optionsConstraints.weightx = 0.0;
        optionsConstraints.gridwidth = 1;
        optionsConstraints.insets = noIndent;
        optionsConstraints.fill = 0;
        moreOptionsPanel.add((Component)this.accessLabel, optionsConstraints);
        optionsConstraints.gridx = 1;
        optionsConstraints.weightx = 1.0;
        optionsConstraints.weighty = 1.0;
        optionsConstraints.insets = indent;
        optionsConstraints.fill = 2;
        moreOptionsPanel.add((Component)this.m_accessTableTextField, optionsConstraints);
        optionsConstraints.gridx = 0;
        optionsConstraints.gridy = gridy++;
        optionsConstraints.weightx = 0.0;
        optionsConstraints.insets = noIndent;
        optionsConstraints.fill = 0;
        moreOptionsPanel.add((Component)defaultStringTypeLabel, optionsConstraints);
        optionsConstraints.gridx = 1;
        optionsConstraints.weightx = 1.0;
        optionsConstraints.insets = indent;
        optionsConstraints.fill = 2;
        moreOptionsPanel.add((Component)this.m_defaultStringColumnTypeComboBox, optionsConstraints);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)saveFilePanel, "North");
        topPanel.add((Component)moreOptionsPanel, "Center");
        topPanel.add((Component)this.createSamplePanel(true), "South");
        optionsPanel.add((Component)topPanel, "North");
        optionsPanel.add((Component)this.createPreviewPanel(), "Center");
        return optionsPanel;
    }

    protected JPanel createSamplePanel(boolean bordered) {
        this.m_sampleRadioButtons = new JRadioButton[3];
        ButtonGroup bg = new ButtonGroup();
        this.m_sampleRadioButtons[0] = new JRadioButton(MinerApp.getText("ReadOtherFileDialog_noSample"));
        this.m_sampleRadioButtons[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.this.m_sampleProbabilityTextField.setEnabled(false);
                ReadOtherFileDialog.this.m_sampleNthRowTextField.setEnabled(false);
            }
        });
        this.m_sampleRadioButtons[0].setMnemonic('n');
        this.m_sampleRadioButtons[1] = new JRadioButton(MinerApp.getText("ReadOtherFileDialog_randomSample"));
        this.m_sampleRadioButtons[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.this.m_sampleProbabilityTextField.setEnabled(true);
                ReadOtherFileDialog.this.m_sampleNthRowTextField.setEnabled(false);
            }
        });
        this.m_sampleRadioButtons[1].setMnemonic('m');
        this.m_sampleRadioButtons[2] = new JRadioButton(MinerApp.getText("ReadOtherFileDialog_sampleNthRow"));
        this.m_sampleRadioButtons[2].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.this.m_sampleProbabilityTextField.setEnabled(false);
                ReadOtherFileDialog.this.m_sampleNthRowTextField.setEnabled(true);
            }
        });
        this.m_sampleRadioButtons[2].setMnemonic('v');
        bg.add(this.m_sampleRadioButtons[0]);
        bg.add(this.m_sampleRadioButtons[1]);
        bg.add(this.m_sampleRadioButtons[2]);
        this.m_sampleProbabilityTextField = new JTextField(15);
        this.m_sampleProbabilityTextField.setDocument(new NodeDialog.InputIntegerDoc());
        this.m_sampleNthRowTextField = new JTextField(15);
        this.m_sampleNthRowTextField.setDocument(new NodeDialog.InputPositiveIntegerDoc());
        Insets none = new Insets(0, 0, 0, 0);
        Insets indent = new Insets(0, 35, 0, 0);
        JPanel samplePanel = new JPanel(new GridBagLayout());
        if (bordered) {
            samplePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ReadOtherFileDialog_sample")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        }
        JLabel startLabel = new JLabel(MinerApp.getText("ReadTextFileDialog_startRow"));
        this.m_startRowTextField = new JTextField(15);
        this.m_startRowTextField.setDocument(new NodeDialog.InputIntegerDoc());
        startLabel.setDisplayedMnemonic('s');
        startLabel.setLabelFor(this.m_startRowTextField);
        JLabel endLabel = new JLabel(MinerApp.getText("ReadTextFileDialog_endRow"));
        this.m_endRowTextField = new JTextField(15);
        this.m_endRowTextField.setDocument(new NodeDialog.InputIntegerDoc());
        endLabel.setDisplayedMnemonic('e');
        endLabel.setLabelFor(this.m_endRowTextField);
        JPanel rangePanel = new JPanel();
        rangePanel.setLayout(new BoxLayout(rangePanel, 0));
        rangePanel.add(startLabel);
        rangePanel.add(Box.createHorizontalStrut(5));
        rangePanel.add(this.m_startRowTextField);
        rangePanel.add(Box.createHorizontalStrut(10));
        rangePanel.add(endLabel);
        rangePanel.add(Box.createHorizontalStrut(5));
        rangePanel.add(this.m_endRowTextField);
        GridBagConstraints sConstraints = new GridBagConstraints();
        sConstraints.anchor = 18;
        sConstraints.gridy = 0;
        sConstraints.gridx = 0;
        sConstraints.fill = 2;
        sConstraints.gridwidth = 0;
        samplePanel.add((Component)rangePanel, sConstraints);
        ++sConstraints.gridy;
        sConstraints.gridx = 0;
        sConstraints.gridwidth = 1;
        sConstraints.fill = 0;
        samplePanel.add((Component)this.m_sampleRadioButtons[0], sConstraints);
        ++sConstraints.gridy;
        sConstraints.weightx = 0.0;
        samplePanel.add((Component)this.m_sampleRadioButtons[1], sConstraints);
        sConstraints.gridx = 1;
        sConstraints.weightx = 1.0;
        sConstraints.insets = indent;
        sConstraints.fill = 2;
        sConstraints.gridwidth = 0;
        samplePanel.add((Component)this.m_sampleProbabilityTextField, sConstraints);
        ++sConstraints.gridy;
        sConstraints.gridx = 0;
        sConstraints.weightx = 0.0;
        sConstraints.insets = none;
        sConstraints.fill = 0;
        samplePanel.add((Component)this.m_sampleRadioButtons[2], sConstraints);
        sConstraints.gridx = 1;
        sConstraints.weightx = 1.0;
        sConstraints.insets = indent;
        sConstraints.fill = 2;
        sConstraints.gridwidth = 0;
        samplePanel.add((Component)this.m_sampleNthRowTextField, sConstraints);
        return samplePanel;
    }

    protected void checkSampleValues() throws NodeDialog.DialogException {
        if (this.m_sampleNthRowTextField == null) {
            return;
        }
        int nthRow = Integer.parseInt(this.m_sampleNthRowTextField.getText());
        boolean nthSample = this.m_sampleRadioButtons[2].isSelected();
        int prob = Integer.parseInt(this.m_sampleProbabilityTextField.getText());
        boolean probSample = this.m_sampleRadioButtons[1].isSelected();
        if (nthSample && nthRow < 1) {
            throw new NodeDialog.DialogException("Value for N must be greater than 1");
        }
        if (probSample) {
            if (prob <= 0) {
                throw new NodeDialog.DialogException("Value for Random Sampling must be greater than 0");
            }
            if (prob > 100) {
                throw new NodeDialog.DialogException("Value for Random Sampling must be no greater than 100");
            }
        }
    }

    protected void saveSampleProperties(XTProps props) {
        if (this.m_sampleNthRowTextField == null) {
            return;
        }
        int nthRow = Integer.parseInt(this.m_sampleNthRowTextField.getText());
        boolean nthSample = this.m_sampleRadioButtons[2].isSelected();
        double prob = Double.parseDouble(this.m_sampleProbabilityTextField.getText());
        boolean probSample = this.m_sampleRadioButtons[1].isSelected();
        props.set("isSampleFraction", probSample);
        props.set("isSampleEachN", nthSample);
        props.set("sampleFraction", Double.toString(prob / 100.0));
        props.set("sampleEachN", nthRow);
    }

    protected void restoreSampleProperties(XTProps props) {
        if (this.m_sampleNthRowTextField == null) {
            return;
        }
        double val = Double.parseDouble(props.getValue("sampleFraction", "0.50"));
        this.m_sampleProbabilityTextField.setText(Integer.toString((int)(val * 100.0)));
        this.m_sampleNthRowTextField.setText(props.getValue("sampleEachN", "2"));
        boolean fraction = props.getBoolean("isSampleFraction", false);
        boolean nth = props.getBoolean("isSampleEachN", false);
        this.m_sampleRadioButtons[0].setSelected(true);
        this.m_sampleRadioButtons[1].setSelected(fraction);
        this.m_sampleRadioButtons[2].setSelected(nth);
        if (fraction) {
            this.m_sampleRadioButtons[1].doClick();
        } else if (nth) {
            this.m_sampleRadioButtons[2].doClick();
        } else {
            this.m_sampleRadioButtons[0].doClick();
        }
    }

    protected JPanel createPreviewPanel() {
        this.m_fetchPreviewButton = new JButton(new AbstractAction(MinerApp.getText("ReadOtherFileDialog_updatePreview")){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.this.updatePreview();
            }
        });
        this.m_fetchPreviewButton.setMnemonic('p');
        JLabel rowsToPreviewLabel = new JLabel(MinerApp.getText("ReadTextFileDialog_rowsToPreview"));
        rowsToPreviewLabel.setDisplayedMnemonic(82);
        this.m_rowsToPreviewTextField = new JTextField(5);
        rowsToPreviewLabel.setLabelFor(this.m_rowsToPreviewTextField);
        this.m_rowsToPreviewTextField.setDocument(new NodeDialog.InputIntegerDoc());
        this.m_rowsToPreviewTextField.setText(m_defaultRowValue);
        JLabel roundingLabel = new JLabel(MinerApp.getText("ReadTextFileDialog_rounding"));
        roundingLabel.setDisplayedMnemonic('g');
        this.m_roundingComboBox = new JComboBox<String>(new String[]{MinerApp.getText("ReadTextFileDialog_roundingNone"), "1", "2", "3", "4", "5"});
        roundingLabel.setLabelFor(this.m_roundingComboBox);
        this.m_roundingComboBox.setEditable(false);
        this.m_roundingComboBox.setSelectedIndex(2);
        Dimension comboBoxSize = this.m_roundingComboBox.getPreferredSize();
        this.m_rowsToPreviewTextField.setPreferredSize(comboBoxSize);
        this.m_fetchPreviewButton.setPreferredSize(comboBoxSize);
        this.m_fetchPreviewButton.setPreferredSize(new Dimension(150, (int)comboBoxSize.getHeight()));
        JPanel columnSelectionPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(5, 0, 5, 0);
        columnSelectionPanel.add((Component)this.m_fetchPreviewButton, constraints);
        constraints.gridx = 1;
        constraints.insets = new Insets(5, 15, 5, 0);
        columnSelectionPanel.add((Component)rowsToPreviewLabel, constraints);
        constraints.gridx = 2;
        constraints.weightx = 1.0;
        columnSelectionPanel.add((Component)this.m_rowsToPreviewTextField, constraints);
        constraints.gridx = 3;
        constraints.weightx = 0.0;
        columnSelectionPanel.add((Component)roundingLabel, constraints);
        constraints.gridx = 4;
        columnSelectionPanel.add((Component)this.m_roundingComboBox, constraints);
        this.m_previewTable = new NodeDialog.DialogTable();
        this.m_previewTable.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 35) {
                    int lastRow = ReadOtherFileDialog.this.m_previewTable.getRowCount() - 1;
                    if (lastRow > 0) {
                        ReadOtherFileDialog.this.m_previewTable.setRowSelectionInterval(lastRow, lastRow);
                        int colSel = ReadOtherFileDialog.this.m_previewTable.getSelectedColumn();
                        if (e.isControlDown()) {
                            colSel = ReadOtherFileDialog.this.m_previewTable.getColumnCount() - 1;
                            ReadOtherFileDialog.this.m_previewTable.setColumnSelectionInterval(colSel, colSel);
                        }
                        ReadOtherFileDialog.this.m_previewTable.scrollRectToVisible(ReadOtherFileDialog.this.m_previewTable.getCellRect(lastRow, colSel, true));
                        e.consume();
                    }
                } else if (e.getKeyCode() == 36) {
                    ReadOtherFileDialog.this.m_previewTable.setRowSelectionInterval(0, 0);
                    int colSel = ReadOtherFileDialog.this.m_previewTable.getSelectedColumn();
                    if (e.isControlDown()) {
                        colSel = 0;
                        ReadOtherFileDialog.this.m_previewTable.setColumnSelectionInterval(0, 0);
                    }
                    ReadOtherFileDialog.this.m_previewTable.scrollRectToVisible(ReadOtherFileDialog.this.m_previewTable.getCellRect(0, colSel, true));
                    e.consume();
                }
            }
        });
        this.m_previewTable.getTableHeader().setReorderingAllowed(false);
        this.m_previewTable.setRowSelectionAllowed(false);
        this.m_previewTable.setColumnSelectionAllowed(false);
        this.m_previewTable.setAutoResizeMode(0);
        JScrollPane scrollableTable = new JScrollPane(this.m_previewTable);
        scrollableTable.setPreferredSize(new Dimension(500, 175));
        JPanel createPreviewPanel = new JPanel(new BorderLayout());
        createPreviewPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ReadOtherFileDialog_preview")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        createPreviewPanel.add((Component)columnSelectionPanel, "North");
        createPreviewPanel.add((Component)scrollableTable, "Center");
        this.m_previewPanel = createPreviewPanel;
        return createPreviewPanel;
    }

    public Vector createOtherTabs() {
        Vector<ModifyColumnsPanel> panels = new Vector<ModifyColumnsPanel>();
        this.m_modifyColumnsPanel = new ModifyColumnsPanel();
        this.m_modifyColumnsPanel.setName(MinerApp.getText("ReadOtherFileDialog_modifyColumns"));
        panels.add(this.m_modifyColumnsPanel);
        return panels;
    }

    public static void checkWriteFileName(JTextField fileNameTextField, String[][] extensionList, JComboBox typeComboBox) {
        ReadOtherFileDialog.checkFileName(fileNameTextField, extensionList, typeComboBox, true);
    }

    public static void checkReadFileName(JTextField fileNameTextField, String[][] extensionList, JComboBox typeComboBox) {
        ReadOtherFileDialog.checkFileName(fileNameTextField, extensionList, typeComboBox, false);
    }

    private static void checkFileName(JTextField fileNameTextField, String[][] extensionList, JComboBox typeComboBox, boolean writeFile) {
        int currentIndex;
        String fileName = fileNameTextField.getText().trim();
        File filePtr = new File(fileName);
        fileNameTextField.setText(fileName);
        if (fileName.equals("") || filePtr.exists() || fileName.endsWith(File.separator)) {
            return;
        }
        if (MinerApp.isWindowsOS() && "\\\\".equals(filePtr.getParent())) {
            return;
        }
        if (fileName.startsWith(XTNetwork.PARAMETER_DELIMITER) && fileName.endsWith(XTNetwork.PARAMETER_DELIMITER)) {
            return;
        }
        int typeIndex = ReadOtherFileDialog.getFileNameTypeIndex(fileName, extensionList);
        int dotIndex = filePtr.getName().indexOf(".");
        if (typeIndex < 0 && dotIndex == -1) {
            if (!writeFile && MinerApp.doesEngineFileExist(MinerApp.getAbsolutePath(fileName))) {
                return;
            }
            typeIndex = typeComboBox != null ? typeComboBox.getSelectedIndex() : 0;
            fileName = fileName + extensionList[typeIndex][0];
            fileNameTextField.setText(fileName);
        } else if (!(typeComboBox == null || typeIndex < 0 || (currentIndex = typeComboBox.getSelectedIndex()) >= 0 && currentIndex < extensionList.length && ReadOtherFileDialog.fileNameMatchesExtension(fileName, extensionList[currentIndex]))) {
            typeComboBox.setSelectedIndex(typeIndex);
        }
    }

    public static boolean fileNameMatchesExtension(String fileName, String[] extensionList) {
        String lowerCaseFileName = fileName.toLowerCase();
        for (int j = 0; j < extensionList.length; ++j) {
            if (!lowerCaseFileName.endsWith(extensionList[j])) continue;
            return true;
        }
        return false;
    }

    public static int getFileNameTypeIndex(String fileName, String[][] extensionList) {
        String lowerCaseFileName = fileName.toLowerCase();
        for (int i = 0; i < extensionList.length; ++i) {
            for (int j = 0; j < extensionList[i].length; ++j) {
                if (!lowerCaseFileName.endsWith(extensionList[i][j])) continue;
                return i;
            }
        }
        return -1;
    }

    public static void checkFileNameOnComboBoxAction(JTextField fileNameTextField, String[][] extensionList, JComboBox typeComboBox) {
        int selectedType;
        String fileName = fileNameTextField.getText().trim();
        fileNameTextField.setText(fileName);
        if (fileName.equals("")) {
            return;
        }
        int typeIndex = ReadOtherFileDialog.getFileNameTypeIndex(fileName, extensionList);
        int n = selectedType = typeComboBox == null ? 0 : typeComboBox.getSelectedIndex();
        if (typeIndex >= 0 && typeIndex != selectedType) {
            int lastPeriod = fileName.lastIndexOf(".");
            fileName = fileName.substring(0, lastPeriod);
            fileName = fileName + extensionList[selectedType][0];
            fileNameTextField.setText(fileName);
        }
    }

    public static void browseDictionaryFileName(JTextField dictionaryTextField) {
        ReadOtherFileDialog.browseDictionaryFileName(null, dictionaryTextField);
    }

    public static void browseDictionaryFileName(JDialog owner, JTextField dictionaryTextField) {
        int returnVal;
        File file;
        String fileName = dictionaryTextField.getText().trim();
        dictionaryTextField.setText(fileName);
        String filePath = fileName;
        String defaultPath = filePath.equals("") ? SplusSystem.getCwd().getAbsolutePath() : MinerApp.getAbsolutePath(filePath);
        WideFileChooser chooser = new WideFileChooser(defaultPath);
        chooser.setFileSelectionMode(0);
        CreateDictionaryDialog.CSVFileFilter cff = new CreateDictionaryDialog.CSVFileFilter();
        CreateDictionaryDialog.TextFileFilter tff = new CreateDictionaryDialog.TextFileFilter();
        CreateDictionaryDialog.XMLFileFilter xff = new CreateDictionaryDialog.XMLFileFilter();
        chooser.addChoosableFileFilter(cff);
        chooser.addChoosableFileFilter(tff);
        chooser.addChoosableFileFilter(xff);
        chooser.setFileFilter(cff);
        if (!filePath.equals("") && !(file = new File(filePath)).isDirectory()) {
            if (xff.accept(file)) {
                chooser.setFileFilter(xff);
            } else if (tff.accept(file)) {
                chooser.setFileFilter(tff);
            } else if (cff.accept(file)) {
                chooser.setFileFilter(cff);
            }
            chooser.setSelectedFile(file);
        }
        if ((returnVal = owner != null ? chooser.showOpenDialog(owner, 600) : chooser.showOpenDialog(dictionaryTextField, 600)) != 0) {
            return;
        }
        File selectedFile = chooser.getSelectedFile();
        String selectedFilePath = selectedFile.getAbsolutePath();
        if (selectedFile.getName().indexOf(".") == -1 && !selectedFile.exists()) {
            selectedFilePath = chooser.getFileFilter() == xff ? selectedFilePath + ".xml" : (chooser.getFileFilter() == cff ? selectedFilePath + ".csv" : selectedFilePath + ".txt");
        }
        dictionaryTextField.setText(selectedFilePath);
        SplusSystem.setCwd((File)chooser.getCurrentDirectory());
    }

    public static void browseWriteFileName(JTextField fileNameTextField, String[][] extensionList, String[] typeDescriptionList, JComboBox typeComboBox) {
        ReadOtherFileDialog.browseFileName(fileNameTextField, extensionList, typeDescriptionList, typeComboBox, true);
    }

    public static void browseReadFileName(JTextField fileNameTextField, String[][] extensionList, String[] typeDescriptionList, JComboBox typeComboBox) {
        ReadOtherFileDialog.browseFileName(fileNameTextField, extensionList, typeDescriptionList, typeComboBox, false);
    }

    public static void browseWriteFileName(JDialog owner, JTextField fileNameTextField, String[][] extensionList, String[] typeDescriptionList, JComboBox typeComboBox) {
        ReadOtherFileDialog.browseFileName(owner, fileNameTextField, extensionList, typeDescriptionList, typeComboBox, true);
    }

    public static void browseReadFileName(JDialog owner, JTextField fileNameTextField, String[][] extensionList, String[] typeDescriptionList, JComboBox typeComboBox) {
        ReadOtherFileDialog.browseFileName(owner, fileNameTextField, extensionList, typeDescriptionList, typeComboBox, false);
    }

    public static void browseWriteDirectory(JDialog owner, JTextField tf) {
        ReadOtherFileDialog.browseFileName(owner, tf, null, null, null, true, true);
    }

    private static void browseFileName(JTextField fileNameTextField, String[][] extensionList, String[] typeDescriptionList, JComboBox typeComboBox, boolean writeFile) {
        ReadOtherFileDialog.browseFileName(null, fileNameTextField, extensionList, typeDescriptionList, typeComboBox, writeFile);
    }

    private static void browseFileName(JDialog owner, JTextField fileNameTextField, String[][] extensionList, String[] typeDescriptionList, JComboBox typeComboBox, boolean writeFile) {
        ReadOtherFileDialog.browseFileName(owner, fileNameTextField, extensionList, typeDescriptionList, typeComboBox, writeFile, false);
    }

    private static void browseFileName(JDialog owner, JTextField fileNameTextField, String[][] extensionList, String[] typeDescriptionList, JComboBox typeComboBox, boolean writeFile, boolean getDir) {
        String fileName = fileNameTextField.getText().trim();
        fileNameTextField.setText(fileName);
        String filePath = fileName;
        File file = new File(filePath);
        while (!file.exists()) {
            String tempFilePath = file.getParent();
            if (tempFilePath == null || filePath.equals(tempFilePath)) {
                filePath = "";
                break;
            }
            filePath = tempFilePath;
            file = new File(filePath);
        }
        String defaultPath = filePath.equals("") ? SplusSystem.getCwd().getAbsolutePath() : MinerApp.getAbsolutePath(filePath);
        WideFileChooser chooser = new WideFileChooser(defaultPath);
        int curTypeIndex = typeComboBox == null ? 0 : typeComboBox.getSelectedIndex();
        FileFilter filter = null;
        FileFilter initFilter = chooser.getAcceptAllFileFilter();
        if (getDir) {
            chooser.setFileSelectionMode(1);
        } else {
            for (int i = 0; i < extensionList.length; ++i) {
                filter = new MinerExtensionFileFilter(extensionList[i], typeDescriptionList[i]);
                chooser.addChoosableFileFilter(filter);
                if (i != curTypeIndex) continue;
                initFilter = filter;
            }
            chooser.setFileFilter(initFilter);
        }
        int returnVal = owner != null ? chooser.showOpenDialog(owner, 550) : chooser.showOpenDialog(fileNameTextField, 550);
        if (returnVal != 0) {
            return;
        }
        File selectedFile = chooser.getSelectedFile();
        if (selectedFile == null) {
            return;
        }
        String selectedFilePath = selectedFile.getAbsolutePath();
        fileNameTextField.setText(selectedFilePath);
        SplusSystem.setCwd((File)chooser.getCurrentDirectory());
        filter = chooser.getFileFilter();
        if (filter != chooser.getAcceptAllFileFilter()) {
            String type = filter.getDescription();
            for (int i = 0; i < typeDescriptionList.length; ++i) {
                if (!type.equals(typeDescriptionList[i])) continue;
                if (typeComboBox != null) {
                    typeComboBox.setSelectedIndex(i);
                    break;
                }
                if (selectedFile.getName().indexOf(".") != -1) continue;
                selectedFilePath = selectedFilePath + extensionList[i][0];
                fileNameTextField.setText(selectedFilePath);
                break;
            }
        }
        if (!getDir) {
            ReadOtherFileDialog.checkFileName(fileNameTextField, extensionList, typeComboBox, writeFile);
        }
    }

    public static boolean checkOverWriteFile(Component comp, String fileName) {
        try {
            String msg;
            int val;
            fileName = fileName.trim();
            if (fileName.equals("")) {
                return true;
            }
            if (MinerApp.doesEngineFileExist(fileName = MinerApp.getAbsolutePath(fileName)) && (val = AcceleratorOptionPane.showYesNoCancelDialog(comp, msg = MinerApp.getText("ReadOtherFileDialog_msg_fileAlreadyExists") + "\n" + fileName + "\n\n" + MinerApp.getText("ReadOtherFileDialog_msg_saveProperties"), MinerApp.getText("ReadOtherFileDialog_msg_replaceFile"), 2)) != 0) {
                return false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    public static void setComboBoxFromTypeString(String typeString, String[] typeCodeList, JComboBox typeComboBox) {
        for (int i = 0; i < typeCodeList.length; ++i) {
            if (!typeString.equals(typeCodeList[i])) continue;
            typeComboBox.setSelectedIndex(i);
            break;
        }
    }
}

