/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.EngineNode;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;

public class ReadPMMLFileEngineNode
extends EngineNode {
    private static Transformer m_transformer = null;
    private static DocumentBuilder m_documentBuilder = null;
    private static final boolean m_cacheXslTransformer = System.getProperty("iminer.cache.xsl.transformer", "T").substring(0, 1).toUpperCase().equals("T");

    public boolean hasDataCacheProc() {
        return true;
    }

    public boolean hasCNKProc() {
        return false;
    }

    public boolean executeDataCacheProc() throws Exception {
        XTProps props = this.getNodeProperties();
        String filename = this.getNetworkManager().getAbsolutePath(props.getValue("filePath"));
        FileInputStream ins = new FileInputStream(filename);
        File tempFile = this.createWorkspaceTempFile("imml", null);
        FileOutputStream os = new FileOutputStream(tempFile);
        XMLTree tree = XMLTree.readFromFile(ins);
        tree.applyXSLTransform(os, XMLTree.PMML_TO_IMML_XSL_FILE);
        os.close();
        XMLTree fittedModel = XMLTree.readFromFile(tempFile.getAbsolutePath());
        this.setNodeCache("model", fittedModel);
        tempFile.delete();
        return true;
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        try {
            return new XTMetaData();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

