/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.DataCacheRowBuf;
import com.insightful.miner.EngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Vector;

public class ReverseEngineNode
extends EngineNode {
    public static String REVERSE_COLUMNS_ATTRIBUTE_TAG = "reverseColumns";
    protected String[] m_reverseColNames = null;
    protected int[] m_reverseColNums = null;

    public boolean hasCNKProc() {
        return false;
    }

    public boolean hasDataCacheProc() {
        return true;
    }

    protected void setReverseColumns(XTProps props, XTMetaData md) {
        Vector eCols = props.getSubProperties(REVERSE_COLUMNS_ATTRIBUTE_TAG);
        int numCols = eCols.size();
        if (eCols.size() == 0) {
            numCols = md.getNumColumns();
            eCols = md.getColumnNames();
        }
        this.m_reverseColNames = new String[numCols];
        this.m_reverseColNums = new int[numCols];
        for (int i = 0; i < numCols; ++i) {
            this.m_reverseColNames[i] = (String)eCols.get(i);
            this.m_reverseColNums[i] = md.nameToOrdinal(this.m_reverseColNames[i]);
        }
    }

    public boolean executeDataCacheProc() throws Exception {
        XTMetaData md = this.getInputMetaData(0);
        XTProps props = this.getNodeProperties();
        this.setReverseColumns(props, md);
        long rows = md.getNumRows();
        RandomAccessFile inputFileStream = new RandomAccessFile(this.getInputDataCacheFileName(0), "r");
        DataCacheRowBuf buf = new DataCacheRowBuf(md);
        RandomAccessFile blobFile = null;
        if (buf.containsBlobs()) {
            String bFile = this.getNetworkManager().getInputDataBlobFileName(this.getNodeID(), 0);
            blobFile = new RandomAccessFile(bFile, "r");
            buf.setReadBlobFile(blobFile);
        }
        FileOutputStream oStream = new FileOutputStream(this.getOutputDataCacheFileName(0));
        BufferedOutputStream oBuffer = new BufferedOutputStream(oStream);
        DataOutputStream outputStream = new DataOutputStream(oBuffer);
        DataCacheRowBuf outputBuf = new DataCacheRowBuf(md);
        DataCacheRowBuf tempBuf = new DataCacheRowBuf(md);
        BufferedOutputStream outBlobFile = null;
        if (outputBuf.containsBlobs()) {
            String bFile = this.getNetworkManager().getOutputDataBlobFileName(this.getNodeID(), 0);
            outBlobFile = new BufferedOutputStream(new FileOutputStream(bFile, false));
            outputBuf.setWriteBlobFile(outBlobFile);
        }
        int nbytes = buf.getBytesPerRow();
        byte[] idata = new byte[nbytes];
        byte[] odata = new byte[nbytes];
        long or = 0L;
        long ir = (rows - 1L) * (long)nbytes;
        while (or < rows) {
            inputFileStream.seek(ir);
            inputFileStream.read(idata);
            outputBuf.setData(idata, 0);
            outputBuf.writeRow(outputStream);
            ++or;
            ir -= (long)nbytes;
        }
        inputFileStream.close();
        if (blobFile != null) {
            blobFile.close();
        }
        if (outputStream != null) {
            outputStream.flush();
            outputStream.close();
        }
        if (outBlobFile != null) {
            ((OutputStream)outBlobFile).flush();
            ((OutputStream)outBlobFile).close();
        }
        return true;
    }
}

