/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.SampleRowsEngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class SampleRowsDialog
extends NodeDialog {
    private int sampleSize = 0;
    private JRadioButton[] samplingMethodButtons;
    private JRadioButton[] sampleSizeButtons;
    private JRadioButton[] stratifiedSamplingButtons;
    private static final String[] samplingMethods = new String[]{SampleRowsEngineNode.SIMPLE_ATTRIBUTE_TAG, SampleRowsEngineNode.EVERY_N_ROWS_ATTRIBUTE_TAG, SampleRowsEngineNode.FIRST_N_ROWS_ATTRIBUTE_TAG, SampleRowsEngineNode.STRATIFIED_ATTRIBUTE_TAG};
    private static final String[] sampleSizeTypes = new String[]{SampleRowsEngineNode.PERCENTAGE_ATTRIBUTE_TAG, SampleRowsEngineNode.NUM_ROWS_ATTRIBUTE_TAG};
    private static final String[] stratifiedSamplingTypes = new String[]{SampleRowsEngineNode.PROPORTIONAL_ATTRIBUTE_TAG, SampleRowsEngineNode.EQUAL_SIZE_ATTRIBUTE_TAG};
    private JRadioButton proportionalRadioButton;
    private JRadioButton equalSizeRadioButton;
    private JComboBox selectColumnComboBox;
    private String[] categoricalColumns;
    private JTextField numSampleRowsTextField;
    private JComboBox percentageComboBox;
    private static final String[] percentagesString = new String[]{"0", "5", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55", "60", "65", "70", "75", "80", "85", "90", "95", "100"};
    private AbstractAction simpleRandomSamplingAction;
    private AbstractAction sampleEveryNRowsAction;
    private AbstractAction sampleFirstNRowsAction;
    private AbstractAction stratifiedSamplingAction;
    private AbstractAction percentageAction;
    private AbstractAction numSampleRowsAction;
    private AbstractAction enterSeedAction;
    private AbstractAction generateSeedAction;
    private AbstractAction newSeedEveryTimeAction;
    private static SampleRowsDialog instance = null;

    public static SampleRowsDialog getInstance() {
        if (instance == null) {
            instance = new SampleRowsDialog();
        }
        return instance;
    }

    private SampleRowsDialog() {
        Dimension min = new Dimension(525, 425);
        this.setMinimumSize(min);
        this.setSize(min);
    }

    public boolean displaySeedPanel() {
        return true;
    }

    public void restoreProperties() {
        super.restoreProperties();
        XTProps props = this.getNodeModel().getXTProps();
        this.proportionalRadioButton.setEnabled(false);
        this.equalSizeRadioButton.setEnabled(false);
        this.numSampleRowsTextField.setEnabled(false);
        this.percentageComboBox.setEnabled(false);
        String samplingMethodString = props.getValue(SampleRowsEngineNode.SAMPLE_METHOD_ATTRIBUTE_TAG, samplingMethods[0]);
        for (int i = 0; i < samplingMethods.length; ++i) {
            if (!samplingMethodString.equals(samplingMethods[i])) continue;
            this.samplingMethodButtons[i].setSelected(true);
            this.samplingMethodButtons[i].doClick();
        }
        String sampleSizeString = props.getValue(SampleRowsEngineNode.SAMPLE_SIZE_ATTRIBUTE_TAG, sampleSizeTypes[0]);
        for (int i = 0; i < sampleSizeTypes.length; ++i) {
            if (!sampleSizeString.equals(sampleSizeTypes[i])) continue;
            this.sampleSizeButtons[i].setSelected(true);
            this.sampleSizeButtons[i].doClick();
        }
        this.percentageComboBox.setSelectedItem(props.getValue(SampleRowsEngineNode.PERCENTAGE_SAMPLE_SIZE_ATTRIBUTE_TAG, Integer.toString(SampleRowsEngineNode.PERCENTAGE_SAMPLE_SIZE_DEFAULT)));
        this.numSampleRowsTextField.setText(props.getValue(SampleRowsEngineNode.ROWS_SAMPLE_SIZE_ATTRIBUTE_TAG, SampleRowsEngineNode.ROWS_SAMPLE_SIZE_DEFAULT));
        String stratifiedSamplingString = props.getValue(SampleRowsEngineNode.STRATIFIED_SAMPLE_ATTRIBUTE_TAG, stratifiedSamplingTypes[0]);
        for (int i = 0; i < stratifiedSamplingTypes.length; ++i) {
            if (!stratifiedSamplingString.equals(stratifiedSamplingTypes[i])) continue;
            this.stratifiedSamplingButtons[i].setSelected(true);
            this.stratifiedSamplingButtons[i].doClick();
        }
        XTMetaData metaData = null;
        try {
            metaData = this.getNodeModel().getInputMetaData(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.selectColumnComboBox.removeAllItems();
        this.selectColumnComboBox.addItem("    ");
        Vector columnNames = metaData.getColumnNames();
        Vector columnTypes = metaData.getColumnTypes();
        Vector columnsUsed = new Vector();
        if (!columnNames.isEmpty()) {
            int size = columnNames.size();
            for (int i = 0; i < size; ++i) {
                if (!columnTypes.get(i).equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG)) continue;
                this.selectColumnComboBox.addItem(columnNames.get(i));
                columnsUsed.add(columnNames.get(i));
            }
            String selectedColumn = props.getValue(SampleRowsEngineNode.STRATIFIED_COLUMN_ATTRIBUTE_TAG, "");
            size = columnsUsed.size();
            for (int i = 0; i < size; ++i) {
                if (!selectedColumn.equals(columnsUsed.get(i))) continue;
                this.selectColumnComboBox.setSelectedIndex(i + 1);
            }
        }
    }

    public void saveProperties() throws NodeDialog.DialogException {
        int i;
        super.saveProperties();
        XTProps props = this.getNodeModel().getXTProps();
        if (this.samplingMethodButtons[1].isSelected() && this.sampleSizeButtons[0].isSelected() && this.percentageComboBox.getSelectedIndex() * 5 > 50) {
            throw new NodeDialog.DialogException(MinerApp.getText("SampleRowsDialog_errorMessage"));
        }
        for (i = 0; i < samplingMethods.length; ++i) {
            if (!this.samplingMethodButtons[i].isSelected()) continue;
            props.set(SampleRowsEngineNode.SAMPLE_METHOD_ATTRIBUTE_TAG, samplingMethods[i]);
        }
        for (i = 0; i < sampleSizeTypes.length; ++i) {
            if (!this.sampleSizeButtons[i].isSelected()) continue;
            props.set(SampleRowsEngineNode.SAMPLE_SIZE_ATTRIBUTE_TAG, sampleSizeTypes[i]);
        }
        props.set(SampleRowsEngineNode.PERCENTAGE_SAMPLE_SIZE_ATTRIBUTE_TAG, (String)this.percentageComboBox.getSelectedItem());
        props.set(SampleRowsEngineNode.ROWS_SAMPLE_SIZE_ATTRIBUTE_TAG, this.numSampleRowsTextField.getText());
        for (i = 0; i < stratifiedSamplingTypes.length; ++i) {
            if (!this.stratifiedSamplingButtons[i].isSelected()) continue;
            props.set(SampleRowsEngineNode.STRATIFIED_SAMPLE_ATTRIBUTE_TAG, stratifiedSamplingTypes[i]);
        }
        String selectedColumn = (String)this.selectColumnComboBox.getSelectedItem();
        if (this.samplingMethodButtons[3].isSelected() && selectedColumn.trim().equals("")) {
            throw new NodeDialog.DialogException("A column must be selected for Stratified Sampling.");
        }
        props.set(SampleRowsEngineNode.STRATIFIED_COLUMN_ATTRIBUTE_TAG, selectedColumn);
    }

    public void createActions() {
        super.createActions();
        this.simpleRandomSamplingAction = new AbstractAction(MinerApp.getText("SampleRowsDialog_simpleRandomSampling")){

            public void actionPerformed(ActionEvent e) {
                SampleRowsDialog.this.proportionalRadioButton.setEnabled(false);
                SampleRowsDialog.this.equalSizeRadioButton.setEnabled(false);
                SampleRowsDialog.this.selectColumnComboBox.setEnabled(false);
            }
        };
        this.sampleEveryNRowsAction = new AbstractAction(MinerApp.getText("SampleRowsDialog_sampleEveryNRows")){

            public void actionPerformed(ActionEvent e) {
                SampleRowsDialog.this.proportionalRadioButton.setEnabled(false);
                SampleRowsDialog.this.equalSizeRadioButton.setEnabled(false);
                SampleRowsDialog.this.selectColumnComboBox.setEnabled(false);
            }
        };
        this.sampleFirstNRowsAction = new AbstractAction(MinerApp.getText("SampleRowsDialog_sampleFirstNRows")){

            public void actionPerformed(ActionEvent e) {
                SampleRowsDialog.this.proportionalRadioButton.setEnabled(false);
                SampleRowsDialog.this.equalSizeRadioButton.setEnabled(false);
                SampleRowsDialog.this.selectColumnComboBox.setEnabled(false);
            }
        };
        this.stratifiedSamplingAction = new AbstractAction(MinerApp.getText("SampleRowsDialog_stratifiedSampling")){

            public void actionPerformed(ActionEvent e) {
                SampleRowsDialog.this.proportionalRadioButton.setEnabled(true);
                SampleRowsDialog.this.equalSizeRadioButton.setEnabled(true);
                SampleRowsDialog.this.selectColumnComboBox.setEnabled(true);
            }
        };
        this.percentageAction = new AbstractAction(MinerApp.getText("SampleRowsDialog_percentage") + ":"){

            public void actionPerformed(ActionEvent e) {
                SampleRowsDialog.this.percentageComboBox.setEnabled(true);
                SampleRowsDialog.this.numSampleRowsTextField.setEnabled(false);
            }
        };
        this.numSampleRowsAction = new AbstractAction(MinerApp.getText("SampleRowsDialog_numRows") + ":"){

            public void actionPerformed(ActionEvent e) {
                SampleRowsDialog.this.percentageComboBox.setEnabled(false);
                SampleRowsDialog.this.numSampleRowsTextField.setEnabled(true);
            }
        };
    }

    protected void onOK() {
        this.percentageComboBox.setEditable(false);
        this.percentageComboBox.setEditable(true);
        super.onOk();
    }

    public JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel(new BorderLayout());
        JPanel topPanel = new JPanel(new GridBagLayout());
        JPanel samplingPanel = new JPanel(new GridBagLayout());
        samplingPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("SampleRowsDialog_samplingMethod")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        ButtonGroup samplingMethodGroup = new ButtonGroup();
        this.samplingMethodButtons = new JRadioButton[4];
        JRadioButton simpleRandomSamplingRadioButton = new JRadioButton(this.simpleRandomSamplingAction);
        simpleRandomSamplingRadioButton.setMnemonic('r');
        samplingMethodGroup.add(simpleRandomSamplingRadioButton);
        this.samplingMethodButtons[0] = simpleRandomSamplingRadioButton;
        JRadioButton sampleEveryNRowsRadioButton = new JRadioButton(this.sampleEveryNRowsAction);
        sampleEveryNRowsRadioButton.setMnemonic('s');
        samplingMethodGroup.add(sampleEveryNRowsRadioButton);
        this.samplingMethodButtons[1] = sampleEveryNRowsRadioButton;
        JRadioButton sampleFirstNRowsRadioButton = new JRadioButton(this.sampleFirstNRowsAction);
        sampleFirstNRowsRadioButton.setMnemonic('f');
        samplingMethodGroup.add(sampleFirstNRowsRadioButton);
        this.samplingMethodButtons[2] = sampleFirstNRowsRadioButton;
        JRadioButton stratifiedSamplingRadioButton = new JRadioButton(this.stratifiedSamplingAction);
        stratifiedSamplingRadioButton.setMnemonic('t');
        samplingMethodGroup.add(stratifiedSamplingRadioButton);
        this.samplingMethodButtons[3] = stratifiedSamplingRadioButton;
        GridBagConstraints samplingConstraints = new GridBagConstraints();
        samplingConstraints.anchor = 18;
        samplingConstraints.weightx = 1.0;
        samplingPanel.add((Component)simpleRandomSamplingRadioButton, samplingConstraints);
        samplingConstraints.gridy = 1;
        samplingPanel.add((Component)sampleEveryNRowsRadioButton, samplingConstraints);
        samplingConstraints.gridy = 2;
        samplingPanel.add((Component)sampleFirstNRowsRadioButton, samplingConstraints);
        samplingConstraints.gridy = 3;
        samplingConstraints.weighty = 1.0;
        samplingPanel.add((Component)stratifiedSamplingRadioButton, samplingConstraints);
        JPanel sampleSizePanel = new JPanel(new GridBagLayout());
        sampleSizePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("SampleRowsDialog_sampleSize")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        ButtonGroup sampleSizeGroup = new ButtonGroup();
        this.sampleSizeButtons = new JRadioButton[2];
        JRadioButton percentageRadioButton = new JRadioButton(this.percentageAction);
        percentageRadioButton.setMnemonic('p');
        sampleSizeGroup.add(percentageRadioButton);
        this.sampleSizeButtons[0] = percentageRadioButton;
        this.percentageComboBox = new JComboBox<String>(percentagesString);
        this.percentageComboBox.setEditable(true);
        JTextField editor = (JTextField)this.percentageComboBox.getEditor().getEditorComponent();
        editor.setDocument(new NodeDialog.InputDoubleDoc());
        editor.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SampleRowsDialog.this.percentageComboBox.setSelectedItem(SampleRowsDialog.this.percentageComboBox.getEditor().getItem());
                SampleRowsDialog.this.percentageComboBox.setEditable(false);
                SampleRowsDialog.this.percentageComboBox.setEditable(true);
            }
        });
        JRadioButton numSampleRowsRadioButton = new JRadioButton(this.numSampleRowsAction);
        numSampleRowsRadioButton.setMnemonic('n');
        sampleSizeGroup.add(numSampleRowsRadioButton);
        this.sampleSizeButtons[1] = numSampleRowsRadioButton;
        this.numSampleRowsTextField = new JTextField(11);
        this.numSampleRowsTextField.setDocument(new NodeDialog.InputIntegerDoc());
        this.percentageComboBox.setPreferredSize(this.numSampleRowsTextField.getPreferredSize());
        GridBagConstraints sampleSizeConstraints = new GridBagConstraints();
        sampleSizeConstraints.anchor = 18;
        sampleSizePanel.add((Component)percentageRadioButton, sampleSizeConstraints);
        sampleSizeConstraints.gridx = 1;
        sampleSizeConstraints.weightx = 1.0;
        sampleSizeConstraints.insets = new Insets(0, 35, 0, 0);
        sampleSizePanel.add((Component)this.percentageComboBox, sampleSizeConstraints);
        sampleSizeConstraints.gridx = 0;
        sampleSizeConstraints.gridy = 1;
        sampleSizeConstraints.weightx = 0.0;
        sampleSizeConstraints.insets = new Insets(0, 0, 0, 0);
        sampleSizePanel.add((Component)numSampleRowsRadioButton, sampleSizeConstraints);
        sampleSizeConstraints.gridx = 1;
        sampleSizeConstraints.weightx = 1.0;
        sampleSizeConstraints.insets = new Insets(0, 35, 0, 0);
        sampleSizeConstraints.weighty = 1.0;
        sampleSizePanel.add((Component)this.numSampleRowsTextField, sampleSizeConstraints);
        GridBagConstraints topConstraints = new GridBagConstraints();
        topConstraints.weightx = 0.5;
        topConstraints.weighty = 1.0;
        topConstraints.fill = 1;
        topPanel.add((Component)samplingPanel, topConstraints);
        topConstraints.gridx = 1;
        topPanel.add((Component)sampleSizePanel, topConstraints);
        JPanel centerPanel = new JPanel(new GridBagLayout());
        centerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("SampleRowsDialog_stratifiedSampling")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        ButtonGroup stratifiedSamplingGroup = new ButtonGroup();
        this.stratifiedSamplingButtons = new JRadioButton[2];
        this.proportionalRadioButton = new JRadioButton(MinerApp.getText("SampleRowsDialog_proportional"));
        this.proportionalRadioButton.setMnemonic('l');
        stratifiedSamplingGroup.add(this.proportionalRadioButton);
        this.stratifiedSamplingButtons[0] = this.proportionalRadioButton;
        this.equalSizeRadioButton = new JRadioButton(MinerApp.getText("SampleRowsDialog_equalSize"));
        this.equalSizeRadioButton.setMnemonic('q');
        stratifiedSamplingGroup.add(this.equalSizeRadioButton);
        this.stratifiedSamplingButtons[1] = this.equalSizeRadioButton;
        JLabel selectColumnLabel = new JLabel(MinerApp.getText("SampleRowsDialog_selectColumns"));
        this.categoricalColumns = new String[]{""};
        this.selectColumnComboBox = new JComboBox<String>(this.categoricalColumns);
        this.selectColumnComboBox.setPreferredSize(this.numSampleRowsTextField.getPreferredSize());
        GridBagConstraints centerConstraints = new GridBagConstraints();
        centerConstraints.anchor = 18;
        centerConstraints.gridy = 1;
        centerConstraints.insets = new Insets(0, 0, 0, 15);
        centerPanel.add((Component)selectColumnLabel, centerConstraints);
        centerConstraints.gridx = 1;
        centerConstraints.insets = new Insets(0, 0, 0, 30);
        centerPanel.add((Component)this.selectColumnComboBox, centerConstraints);
        centerConstraints.gridy = 0;
        centerConstraints.gridx = 2;
        centerConstraints.weightx = 1.0;
        centerConstraints.insets = new Insets(0, 0, 0, 0);
        centerPanel.add((Component)this.proportionalRadioButton, centerConstraints);
        centerConstraints.gridy = 1;
        centerConstraints.weighty = 1.0;
        centerPanel.add((Component)this.equalSizeRadioButton, centerConstraints);
        optionsPanel.add((Component)topPanel, "North");
        optionsPanel.add((Component)centerPanel, "Center");
        return optionsPanel;
    }
}

