/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.SetRolesPanelBase;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class SetRolesPanel
extends SetRolesPanelBase {
    private JList dependentList;
    private NodeDialog.DNDListModel dependentListModel;
    private String dependentType = "";
    private static final String dependentVariableErrorString = "SetRolesPanel_dependentVariableError";
    private static final String dependentString = "SetRolesPanel_dependent";
    private static final String addDependentString = ">>";
    private static final String removeDependentString = "<<";
    public static final String DEPENDENT_CHANGE = "dependentChange";
    private AbstractAction addDependentAction;
    private AbstractAction removeDependentAction;

    public SetRolesPanel(AbstractAction okAction) {
        this(okAction, "", true);
    }

    public SetRolesPanel(AbstractAction okAction, boolean allowInteractions) {
        this(okAction, "", allowInteractions);
    }

    public SetRolesPanel(AbstractAction okAction, String dependentType) {
        this(okAction, dependentType, true);
    }

    public SetRolesPanel(AbstractAction okAction, String dependentType, boolean allowInteractions) {
        super(allowInteractions);
        this.dependentType = dependentType;
        this.createLayout();
    }

    public void changeDependentType(String dependentType) {
        this.dependentType = dependentType;
    }

    public void restoreProperties(ActivityNodeModel model) {
        this.dependentListModel.removeAllElements();
        super.restoreProperties(model);
        XTProps props = model.getXTProps();
        XTMetaData metaData = null;
        try {
            metaData = model.getInputMetaData(0);
        }
        catch (Exception e) {
            AcceleratorOptionPane.showOKDialog(this, MinerApp.getText("NodeDialog_cannotRestoreProperties"), MinerApp.getText("NodeDialog_propertiesNotRestored"), 0);
            e.printStackTrace();
            return;
        }
        Vector names = metaData.getColumnNames();
        Vector types = metaData.getColumnTypes();
        Vector roles = metaData.getColumnRoles();
        Vector propNames = props.getSubProperties("columnRoles");
        Vector propRoles = props.getSubPropertyValues("columnRoles");
        int size = names.size();
        block2: for (int i = 0; i < size; ++i) {
            String propRole;
            String name;
            int index;
            String type = (String)types.get(i);
            if (this.excludedColumnTypes.contains(type) || (index = propNames.indexOf(name = (String)names.get(i))) == -1 || !(propRole = (String)propRoles.get(index)).equals(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG)) continue;
            this.dependentListModel.addElement(new NodeDialog.ModelTerm(name, type, (String)roles.get(i), i));
            int n = this.availableListModel.size();
            for (int k = 0; k < n; ++k) {
                NodeDialog.ModelTerm term = (NodeDialog.ModelTerm)this.availableListModel.get(k);
                if (!term.getText().equals(name)) continue;
                this.availableListModel.removeElementAt(k);
                continue block2;
            }
        }
    }

    public void saveProperties(ActivityNodeModel model) {
        super.saveProperties(model);
        XTProps props = model.getXTProps();
        NodeDialog.ColumnInformationObject object = null;
        if (!this.dependentListModel.isEmpty()) {
            object = (NodeDialog.ColumnInformationObject)this.dependentListModel.firstElement();
            props.set("columnRoles", object.getText(), XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG);
        }
    }

    private void fireDependentChange(String newValue) {
        this.firePropertyChange(DEPENDENT_CHANGE, null, newValue);
    }

    public void createActions() {
        super.createActions();
        this.addDependentAction = new AbstractAction(addDependentString){

            public void actionPerformed(ActionEvent e) {
                int selectedIndex;
                if (SetRolesPanel.this.dependentListModel.getSize() < 1 && (selectedIndex = SetRolesPanel.this.availableList.getSelectedIndex()) >= 0) {
                    SetRolesPanel.this.availableList.getSelectionModel().clearSelection();
                    NodeDialog.ColumnInformationObject selectedObject = (NodeDialog.ColumnInformationObject)SetRolesPanel.this.availableListModel.getElementAt(selectedIndex);
                    if (selectedObject.getType().equals(SetRolesPanel.this.dependentType) || SetRolesPanel.this.dependentType.equals("")) {
                        SetRolesPanel.this.availableListModel.removeElementAt(selectedIndex);
                        SetRolesPanel.this.dependentListModel.addElement(selectedObject);
                        SetRolesPanel.this.fireDependentChange(selectedObject.getText());
                    } else {
                        MinerApp.displayError(MinerApp.getText("SetRolesPanel_actionNotSuccesful"), MinerApp.getText(SetRolesPanel.dependentVariableErrorString));
                    }
                    SetRolesPanel.this.repaint();
                }
            }
        };
        this.removeDependentAction = new AbstractAction(removeDependentString){

            public void actionPerformed(ActionEvent e) {
                int selectedIndex;
                if (SetRolesPanel.this.dependentListModel.getSize() > 0 && (selectedIndex = SetRolesPanel.this.dependentList.getSelectedIndex()) >= 0) {
                    SetRolesPanel.this.dependentList.getSelectionModel().clearSelection();
                    NodeDialog.ColumnInformationObject selectedObject = (NodeDialog.ColumnInformationObject)SetRolesPanel.this.dependentListModel.getElementAt(selectedIndex);
                    SetRolesPanel.this.dependentListModel.removeElementAt(selectedIndex);
                    SetRolesPanel.this.availableListModel.addElement(selectedObject);
                    SetRolesPanel.this.availableScrollPane.sort();
                    SetRolesPanel.this.fireDependentChange(null);
                    SetRolesPanel.this.repaint();
                }
            }
        };
        this.autoFillAction = new AbstractAction("Auto >>"){

            public void actionPerformed(ActionEvent e) {
                Object[] values = SetRolesPanel.this.availableListModel.toArray();
                SetRolesPanel.this.availableListModel.removeAllElements();
                SetRolesPanel.this.availableListModel.removeListDataListeners();
                SetRolesPanel.this.independentListModel.removeListDataListeners();
                for (int i = 0; i < values.length; ++i) {
                    NodeDialog.ColumnInformationObject object = (NodeDialog.ColumnInformationObject)values[i];
                    String role = object.getRole();
                    boolean inAvailableList = true;
                    if (role.equals(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG) && SetRolesPanel.this.dependentListModel.getSize() < 1 && (object.getType().equals(SetRolesPanel.this.dependentType) || SetRolesPanel.this.dependentType.equals(""))) {
                        inAvailableList = false;
                        SetRolesPanel.this.dependentListModel.addElement(object);
                        SetRolesPanel.this.fireDependentChange(object.getText());
                    }
                    if (role.equals(XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG)) {
                        inAvailableList = false;
                        SetRolesPanel.this.independentListModel.addElement(object);
                    }
                    if (SetRolesPanel.this.independentListModel.getSize() > 1 && SetRolesPanel.this.allowInteractions) {
                        SetRolesPanel.this.interactionsButton.setEnabled(true);
                    }
                    if (inAvailableList) {
                        SetRolesPanel.this.availableListModel.addElement(object);
                    }
                    SetRolesPanel.this.availableListModel.undoRemoveListDataListeners();
                    SetRolesPanel.this.independentListModel.undoRemoveListDataListeners();
                    SetRolesPanel.this.availableListModel.listContentsChanged();
                    SetRolesPanel.this.independentListModel.listContentsChanged();
                }
            }
        };
    }

    private void createLayout() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("SetRolesPanel_variables")), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        NodeDialog.ColumnInformationRenderer renderer = new NodeDialog.ColumnInformationRenderer();
        this.addAvailableScrollPane(this, renderer, 0, 0);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 6;
        constraints.gridy = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)new JButton(this.removeDependentAction), constraints);
        constraints.gridx = 8;
        this.add((Component)new JButton(this.addDependentAction), constraints);
        JLabel dependentLabel = new JLabel(MinerApp.getText(dependentString) + ":");
        dependentLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.dependentListModel = new NodeDialog.DNDListModel();
        this.dependentList = new NodeDialog.DNDList(this.dependentListModel);
        this.dependentList.setCellRenderer(renderer);
        this.dependentList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 8 && SetRolesPanel.this.removeDependentAction.isEnabled()) {
                    SetRolesPanel.this.removeDependentAction.actionPerformed(new ActionEvent(SetRolesPanel.this, 0, "Remove"));
                }
            }
        });
        JScrollPane dependentScrollPane = new JScrollPane(this.dependentList);
        dependentScrollPane.setPreferredSize(new Dimension(125, 20));
        dependentScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        dependentScrollPane.setHorizontalScrollBarPolicy(31);
        dependentScrollPane.setVerticalScrollBarPolicy(21);
        constraints.gridx = 10;
        constraints.gridy = 0;
        constraints.gridwidth = 5;
        constraints.anchor = 11;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 1;
        this.add((Component)dependentLabel, constraints);
        constraints.gridy = 1;
        this.add((Component)dependentScrollPane, constraints);
        this.addIndependentScrollPane(this, renderer, 6, 2);
    }
}

