/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcSplusTransform;
import com.insightful.miner.CreateColumnsEngineNode;
import com.insightful.miner.EngineNode;
import com.insightful.miner.MinerApp;
import com.insightful.miner.XTProps;
import com.insightful.splus.util.StringUtilities;
import java.util.Vector;

public class SplusCreateColumnsEngineNode
extends CreateColumnsEngineNode {
    public CNKProc procCreate() throws Exception {
        CNKProcSplusTransform proc = this.getNetworkManager().createSplusProc();
        this.printColumnInfo();
        return proc;
    }

    public static String getEvalDataExpr(String outVar, String inVar, int numInputs) {
        StringBuffer expr = new StringBuffer();
        if (numInputs < 2) {
            expr.append(outVar + " <- " + inVar + "$in1;\n ");
        } else {
            expr.append(outVar + " <- list(");
            for (int i = 0; i < numInputs; ++i) {
                if (i > 0) {
                    expr.append(", ");
                }
                expr.append("in" + (i + 1) + "=" + inVar + "$in" + (i + 1));
            }
            expr.append(");\n ");
        }
        return expr.toString();
    }

    public void procSetProperties(CNKProc proc) {
        int i;
        CNKProcSplusTransform xform = (CNKProcSplusTransform)proc;
        XTProps props = this.getNodeProperties();
        boolean copyInput = this.getCopyFirstInputColumns(props);
        StringBuffer splusExpr = new StringBuffer("function(x) { \n");
        splusExpr.append(SplusCreateColumnsEngineNode.getEvalDataExpr("evalData", "x", this.getNumInputs()));
        Vector newColumnNames = this.getCalcColumnNames(props);
        Vector newExpressions = this.getCalcExpressions(props);
        splusExpr.append("newNames <- c(");
        for (i = 0; i < newColumnNames.size(); ++i) {
            String colName = (String)newColumnNames.get(i);
            splusExpr.append("\"" + colName + "\",");
        }
        splusExpr.append(");\n newExprs <- c(");
        for (i = 0; i < newExpressions.size(); ++i) {
            String expr = (String)newExpressions.get(i);
            splusExpr.append("\"" + StringUtilities.escapeSpecialCharacters((String)expr) + "\",");
        }
        splusExpr.append("); \n ");
        if (copyInput) {
            splusExpr.append("out <- c(x$in1); \n ");
        } else {
            splusExpr.append("out <- list(); \n ");
        }
        splusExpr.append("for (i in seq(along=newExprs)) { \n ");
        splusExpr.append("one.col <- eval(parse(text = newExprs[i]), local=evalData);\n ");
        splusExpr.append("one.col <- rep(one.col, len=nrow(x$in1));\n ");
        splusExpr.append("out[[newNames[i]]] <- one.col };\n ");
        splusExpr.append("\n return(list(out1=data.frame(out, check.names=F, stringsAsFactors=F))) }\n");
        String strExpr = splusExpr.toString();
        xform.setUseComplexTransform(true);
        xform.setTransform(strExpr);
    }

    public String getParseErrors(XTProps props) {
        StringBuffer errorBuf = new StringBuffer();
        if (!this.getNetworkManager().isSplusLicensed()) {
            return "S-PLUS Library not installed.  Cannot parse expression.";
        }
        Vector newColumnNames = this.getCalcColumnNames(props);
        Vector exprs = this.getCalcExpressions(props);
        for (int i = 0; i < exprs.size(); ++i) {
            String newColName = (String)newColumnNames.get(i);
            String expr = (String)exprs.get(i);
            String parseResult = MinerApp.splusParseTest(expr);
            if (parseResult.equals("complete")) continue;
            if (errorBuf.length() > 0) {
                errorBuf.append("\n\n");
            }
            errorBuf.append("Error parsing expression to compute: " + newColName + "\n\t");
            if (parseResult.equals("partial")) {
                errorBuf.append("Expression is incomplete.");
                continue;
            }
            errorBuf.append(parseResult);
        }
        return errorBuf.toString();
    }

    public EngineNode.InputRequirements getInputRequirements(int inputNum) {
        return EngineNode.InputRequirements.getMinRequirements();
    }
}

