/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcSplusTransform;
import com.insightful.miner.EngineNetworkManager;
import com.insightful.miner.SplusScriptEngineNode;
import com.insightful.miner.XTProps;
import com.insightful.miner.graphdlg.controls.MinerFunctionInfo;
import java.util.StringTokenizer;

public class SplusGraphEngineNode
extends SplusScriptEngineNode {
    private static String TEST_EXPRESSION = "if (IM$test) return(list(simple=T))\n";
    private static final String[] COL_NAME_FIELDS = new String[]{"xColumn", "yColumn", "zColumn", "dateColumn", "labelColumn", "groups", "high", "low", "open", "close", "volume"};
    private static final String[] COL_LIST_FIELDS = new String[]{"condColumnList", "xColumnList", "variables"};
    public static final String[] NODES_REQUIRE_SAMPLING = new String[]{".CloudPlotDialog", ".ParallelPlotDialog", ".ScatterPlotDialog", ".MatrixPlotDialog", ".TimeBarPlotDialog", ".TimeHighLowPlotDialog", ".TimeLinePlotDialog"};
    public static final boolean GRAPH_DO_SAMPLE_DEFAULT = true;

    public boolean isSampleRequired() {
        XTProps props = this.getNodeProperties();
        return props.getBoolean("doSample", true);
    }

    public boolean isBigdataScript() {
        return !this.isSampleRequired();
    }

    public String getTransformFunctionBody() {
        XTProps props = (XTProps)this.getNodeProperties().copy();
        StringBuffer buf = new StringBuffer();
        buf.append(TEST_EXPRESSION);
        String userExpr = SplusGraphEngineNode.getTransformFunctionBody(props, this.getNetworkManager());
        if (this.isBigdataScript()) {
            userExpr = "\nbd.internal.miner.execute.bigdata.script(IM=IM, num.inputs=1, num.outputs=0, user.fn=function(IM) {\n" + userExpr + "\n}\n)\n";
        }
        buf.append(userExpr);
        String fn = this.getSafeTransformFunction(buf.toString());
        return fn;
    }

    public void procSetProperties(CNKProc proc) {
        super.procSetProperties(proc);
        CNKProcSplusTransform xform = (CNKProcSplusTransform)proc;
        xform.setMangleColumnNames(false);
    }

    public static String getTransformFunctionBody(XTProps props, EngineNetworkManager mgr) {
        StringBuffer buf = new StringBuffer();
        buf.append("if (nrow(IM$in1) == 0) stop('Data contains no rows.')\n");
        buf.append("assign(\".splus.graph.script.data\", ");
        buf.append(SplusGraphEngineNode.getScriptDataExpression(props));
        buf.append(", frame=1, immediate=T)\n");
        buf.append("if (nrow(.splus.graph.script.data) == 0) stop('Data contains no rows after dropping rows with missing values.')\n");
        props.set(new String[]{"minerFunctionInfo", "controlList", "data"}, ".splus.graph.script.data");
        buf.append(MinerFunctionInfo.getFunctionCall(props, mgr));
        props.set(new String[]{"minerFunctionInfo", "controlList", "data"}, null);
        return buf.toString();
    }

    private static String getScriptDataExpression(XTProps props) {
        int i;
        StringBuffer buf = new StringBuffer();
        String funcName = props.getValue(new String[]{"minerFunctionInfo", "funcName"}, "");
        String[] propPath1 = new String[]{"minerFunctionInfo", "controlList", ""};
        String[] propPath2 = new String[]{"minerFunctionInfo", "controlList", "", ""};
        boolean dropMissings = !funcName.startsWith("menuTime");
        boolean allColumns = false;
        if (dropMissings) {
            buf.append("na.omit(");
        }
        buf.append("IM$in1");
        String curVal = "";
        for (i = 0; !allColumns && i < COL_LIST_FIELDS.length; ++i) {
            propPath1[2] = COL_LIST_FIELDS[i];
            curVal = props.getValue(propPath1, "").trim();
            if (curVal.indexOf("<ALL>") < 0) continue;
            allColumns = true;
        }
        if (!allColumns) {
            buf.append("[ , unique(c(");
            for (i = 0; i < COL_NAME_FIELDS.length; ++i) {
                propPath1[2] = COL_NAME_FIELDS[i];
                curVal = props.getValue(propPath1, "").trim();
                if (curVal.length() <= 0) continue;
                buf.append("'" + curVal + "', ");
            }
            StringTokenizer tokenizer = null;
            String str = "";
            for (int i2 = 0; !allColumns && i2 < COL_LIST_FIELDS.length; ++i2) {
                propPath1[2] = COL_LIST_FIELDS[i2];
                curVal = props.getValue(propPath1, "").trim();
                if (curVal.length() <= 0) continue;
                tokenizer = new StringTokenizer(curVal, ",");
                int numValues = tokenizer.countTokens();
                for (int j = 0; j < numValues; ++j) {
                    str = tokenizer.nextToken().trim();
                    if (str.equals("<NONE>")) continue;
                    buf.append("'" + str + "', ");
                }
            }
            if (buf.substring(buf.length() - 2).equals(", ")) {
                buf.delete(buf.length() - 2, buf.length());
            }
            buf.append(")), drop=F]");
        }
        if (dropMissings) {
            buf.append(")");
        }
        return buf.toString();
    }
}

