/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.gdevice.SCanvas;
import com.insightful.gdevice.SCanvasAWT;
import com.insightful.gdevice.SGraphicsDevice;
import com.insightful.gdevice.SGraphicsDeviceReceiver;
import com.insightful.gdevice.XML;
import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.MinerApp;
import com.insightful.miner.SplusScriptDialog;
import com.insightful.miner.TextFrame;
import com.insightful.miner.XTNetwork;
import com.insightful.miner.XTProps;
import com.insightful.miner.graph.CanvasTabbedPane;
import com.insightful.miner.graph.GraphFrame;
import com.insightful.splus.graph.GraphColorsDialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SplusScriptNodeModel
extends ActivityNodeModel {
    public SplusScriptNodeModel(Element elt) {
        super(elt);
    }

    public SplusScriptNodeModel(XTNetwork.NodeInfo elt) {
        super(elt);
    }

    public SplusScriptNodeModel(String script) {
        super(SplusScriptNodeModel.buildDefaultElement());
        try {
            XTProps props = new XTProps();
            props.set("function", script);
            this.setXTProps(props);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showPropertiesDialog(boolean modality) {
        SplusScriptDialog dialog = SplusScriptDialog.getInstance();
        dialog.setModal(modality);
        dialog.show(this);
    }

    public boolean isInputValid() {
        return true;
    }

    public boolean isPropertiesValid() {
        if (this.m_inputs == null) {
            return false;
        }
        int total = this.getNumInputs();
        int actual = this.m_inputs.size();
        if (total == -1 && actual == 0 || total != -1 && actual != total) {
            return false;
        }
        return this.getXTProps().getValue("function").length() > 0;
    }

    public void showView(Frame frame) {
        if (!this.getXTProps().getBoolean("storeOutputForView", true)) {
            super.showView(frame);
            return;
        }
        boolean hasCaches = false;
        try {
            XTProps textOutputCache = (XTProps)this.sendMessageToEngine("getNodeCacheXTProps", new Object[]{"textOutput"});
            if (textOutputCache != null) {
                String text = textOutputCache.getValue("asciiTextOutput");
                if (text == null || text.length() == 0) {
                    textOutputCache = null;
                } else {
                    TextFrame textFrame = new TextFrame(this.getLabelText(), text);
                    textFrame.show();
                    hasCaches = true;
                }
            }
            Object[] graphCacheNames = ((Set)this.sendMessageToEngine("getNodeCacheNames", new Object[0])).toArray();
            String curCacheName = null;
            XTProps graphOutputCache = null;
            String spjStr = null;
            ByteArrayInputStream inStr = null;
            Vector canvasVec = null;
            for (int i = 0; i < graphCacheNames.length; ++i) {
                curCacheName = (String)graphCacheNames[i];
                if (!curCacheName.startsWith("graphOutput")) continue;
                graphOutputCache = (XTProps)this.sendMessageToEngine("getNodeCacheXTProps", new Object[]{graphCacheNames[i]});
                if (graphOutputCache == null) {
                    hasCaches = true;
                    AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), "An error occurred retrieving a stored graph.\n\nThis may indicate an XML parsing error due to\na very large number of points in the graph.\nDecreasing the number of points may fix the problem.\n\nSee the log file for additional information.");
                    continue;
                }
                spjStr = graphOutputCache.getValue("spjGraphOutput");
                if (spjStr == null || spjStr.length() == 0) {
                    graphOutputCache = null;
                    continue;
                }
                inStr = new ByteArrayInputStream(spjStr.getBytes("UTF-8"));
                canvasVec = XML.readCanvasVectorFromXML((InputStream)inStr);
                inStr.close();
                if (canvasVec != null) {
                    for (int k = canvasVec.size() - 1; k >= 0; --k) {
                        SCanvasAWT canvas = (SCanvasAWT)canvasVec.elementAt(k);
                        if (canvas.getNumberCommands() != 0) continue;
                        canvasVec.remove(k);
                    }
                }
                if (canvasVec == null || canvasVec.size() == 0) {
                    graphOutputCache = null;
                    continue;
                }
                SCanvas firstCanvas = SCanvas.createSCanvas((SCanvasAWT)((SCanvasAWT)canvasVec.get(0)));
                SGraphicsDevice graphDevice = SGraphicsDeviceReceiver.getSGraphicsDeviceFactory().createGraphicsDevice(new Dimension(520, 390), false);
                graphDevice.addCanvas(firstCanvas);
                GraphFrame graphFrame = new GraphFrame(firstCanvas, this.getLabelText(), MinerApp.getMainFrame() == null ? null : MinerApp.getMainFrame().getAppIcon(), MinerApp.getNextWindowLocation());
                if (canvasVec.size() > 1) {
                    CanvasTabbedPane tabbedPane = graphFrame.getCanvasTabbedPane();
                    SCanvas curCanvas = null;
                    for (int j = 1; j < canvasVec.size(); ++j) {
                        curCanvas = SCanvas.createSCanvas((SCanvasAWT)((SCanvasAWT)canvasVec.get(j)));
                        graphDevice.addCanvas(curCanvas);
                        tabbedPane.addCanvasTab(curCanvas);
                    }
                }
                if (GraphColorsDialog.getStandardColorSchemeSize() == 0) {
                    MinerApp.eval("java.colorscheme.update.java()");
                }
                graphDevice.setColorScheme(GraphColorsDialog.getDefaultColorScheme());
                graphFrame.show();
                hasCaches = true;
            }
            if (!hasCaches) {
                super.showView(frame);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final Element buildDefaultElement() {
        Element activityNode = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document doc = factory.newDocumentBuilder().newDocument();
            activityNode = doc.createElement(XTNetwork.ACTIVITY_NODE_NODE_TAG);
            activityNode.setAttribute(XTNetwork.GUI_CLASS_ATTRIBUTE_TAG, "com.insightful.miner.SplusScriptNodeModel");
            activityNode.setAttribute(XTNetwork.ENGINE_CLASS_ATTRIBUTE_TAG, "com.insightful.miner.SplusScriptEngineNode");
            activityNode.setAttribute(XTNetwork.NUM_INPUTS_ATTRIBUTE_TAG, "1");
            activityNode.setAttribute(XTNetwork.NUM_OUTPUTS_ATTRIBUTE_TAG, "1");
            Element displayInfo = doc.createElement(XTNetwork.DISPLAY_INFO_NODE_TAG);
            activityNode.appendChild(displayInfo);
            displayInfo.setAttribute(XTNetwork.DEFAULT_LABEL_TEXT_ATTRIBUTE_TAG, "S-PLUS Script");
            displayInfo.setAttribute(XTNetwork.LABEL_TEXT_ATTRIBUTE_TAG, "S-PLUS Script");
            displayInfo.setAttribute(XTNetwork.SMALL_ICON_ATTRIBUTE_TAG, "splus_letters_small.gif");
            displayInfo.setAttribute(XTNetwork.LARGE_ICON_ATTRIBUTE_TAG, "splus_letters_large.gif");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return activityNode;
    }
}

