/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcJavaTransformExec;
import com.insightful.miner.EngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.util.Arrays;
import java.util.Vector;

public class StackEngineNode
extends EngineNode
implements CNKProcJavaTransformExec {
    public static String STACK_COLUMN_ATTRIBUTE_TAG = "stackColumns";
    public static String REPLICATE_COLUMN_ATTRIBUTE_TAG = "replicateColumns";
    public static String KEEP_GROUP_ATTRIBUTE_TAG = "keepGroup";
    public static String GROUP_COLUMN_ATTRIBUTE_TAG = "groupColumn";
    public static String STACK_COLUMN_NAME_ATTRIBUTE_TAG = "stackColumnName";
    private int[] m_columnsToStack;
    private XTMetaData m_metaData;
    private Vector m_valueColumnLevels;
    private int[][] m_valueMapping;
    private Vector m_stackColumnLevels;
    private int[] m_replicatedColumns;
    private int m_groupColumnNum;
    private long m_totalRows;
    private int m_currentColumn;
    private boolean m_isCategoricalStack;
    private boolean m_isStringStack;
    private double m_percent;

    public boolean hasCNKProc() {
        return true;
    }

    public boolean hasDataCacheProc() {
        return false;
    }

    public CNKProc procCreate() {
        CNKProcJavaTransform proc = new CNKProcJavaTransform();
        proc.setExecObject(this);
        return proc;
    }

    public void procSetProperties(CNKProc proc) {
        XTProps props = this.getNodeProperties();
        this.m_metaData = this.getInputMetaData(0);
        this.m_stackColumnLevels = props.getSubProperties(STACK_COLUMN_ATTRIBUTE_TAG);
        int numColumnsToStack = this.m_stackColumnLevels.size();
        this.m_columnsToStack = new int[numColumnsToStack];
        this.m_valueMapping = new int[numColumnsToStack][];
        this.m_valueColumnLevels = new Vector();
        String curType = "";
        for (int i = 0; i < numColumnsToStack; ++i) {
            String stackColumn = (String)this.m_stackColumnLevels.get(i);
            this.m_columnsToStack[i] = this.m_metaData.nameToOrdinal(stackColumn);
            if (i == 0) {
                this.m_isCategoricalStack = this.m_metaData.isCategoricalColumn(stackColumn);
                this.m_isStringStack = this.m_metaData.isStringColumn(stackColumn);
                curType = this.m_metaData.getColumnType(stackColumn);
            } else if (!curType.equals(this.m_metaData.getColumnType(stackColumn))) {
                this.printlnError("Stacked columns must be of the same type.");
            }
            if (!this.m_isCategoricalStack) continue;
            Vector levels = this.m_metaData.getCategoricalDataFieldLevels(stackColumn);
            int numLevels = levels.size();
            this.m_valueMapping[i] = new int[numLevels];
            for (int j = 0; j < numLevels; ++j) {
                String level = (String)levels.get(j);
                int levelIndex = this.m_valueColumnLevels.indexOf(level);
                if (levelIndex == -1) {
                    this.m_valueMapping[i][j] = this.m_valueColumnLevels.size();
                    this.m_valueColumnLevels.add(level);
                    continue;
                }
                this.m_valueMapping[i][j] = levelIndex;
            }
        }
        Vector replicateColumns = props.getSubProperties(REPLICATE_COLUMN_ATTRIBUTE_TAG);
        this.m_replicatedColumns = new int[replicateColumns.size()];
        for (int i = 0; i < this.m_replicatedColumns.length; ++i) {
            this.m_replicatedColumns[i] = this.m_metaData.nameToOrdinal((String)replicateColumns.get(i));
        }
        Arrays.sort(this.m_replicatedColumns);
        this.m_groupColumnNum = props.getBoolean(KEEP_GROUP_ATTRIBUTE_TAG, false) ? this.m_replicatedColumns.length + 1 : -1;
        this.m_totalRows = this.m_metaData.getNumRows();
        this.m_currentColumn = 0;
        this.m_percent = 0.0;
        this.setUpdateResponsibility(this);
    }

    public void execute(CNKProcJavaTransform proc) {
        int row;
        int nRowBlock = proc.getChunkInputRows(0);
        if (nRowBlock < 1) {
            return;
        }
        for (int repl = 0; repl < this.m_replicatedColumns.length; ++repl) {
            proc.copyColumnData(0, repl, 0, 0, this.m_replicatedColumns[repl], 0, nRowBlock);
        }
        double[] ibuf = null;
        double[] obuf = null;
        if (!this.m_isStringStack) {
            ibuf = proc.getChunkInputColumnData(0, this.m_columnsToStack[this.m_currentColumn]);
            obuf = proc.getChunkOutputColumnData(0, this.m_replicatedColumns.length);
        }
        if (this.m_isStringStack) {
            proc.copyColumnData(0, this.m_replicatedColumns.length, 0, 0, this.m_columnsToStack[this.m_currentColumn], 0, nRowBlock);
        } else {
            for (row = 0; row < nRowBlock; ++row) {
                if (this.m_isCategoricalStack) {
                    if (Double.isNaN(ibuf[row])) {
                        obuf[row] = ibuf[row];
                        continue;
                    }
                    obuf[row] = this.m_valueMapping[this.m_currentColumn][(int)ibuf[row]];
                    continue;
                }
                obuf[row] = ibuf[row];
            }
        }
        if (this.m_groupColumnNum != -1) {
            obuf = proc.getChunkOutputColumnData(0, this.m_groupColumnNum);
            for (row = 0; row < nRowBlock; ++row) {
                obuf[row] = this.m_currentColumn;
            }
        }
        this.m_percent += 100.0 * (double)nRowBlock / (double)(this.m_totalRows * (long)this.m_columnsToStack.length);
        this.updateProgressIndicator((int)this.m_percent);
        long start = proc.getChunkInputPosition(0);
        long end = start + (long)nRowBlock;
        if (end == this.m_totalRows) {
            ++this.m_currentColumn;
            if (this.m_currentColumn < this.m_columnsToStack.length) {
                proc.setChunkNextInputPosition(0, 0L);
            } else {
                proc.setChunkInputReleaseRows(0, nRowBlock);
                this.resetUpdateResponsibility();
            }
        } else {
            proc.setChunkInputReleaseRows(0, nRowBlock);
        }
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        XTMetaData inputMD = this.getInputMetaData(0);
        XTProps props = this.getNodeProperties();
        Vector keepColumns = props.getSubProperties(REPLICATE_COLUMN_ATTRIBUTE_TAG);
        XTMetaData outputMD = inputMD.selectiveClone(keepColumns);
        String valueColumn = props.getValue(STACK_COLUMN_NAME_ATTRIBUTE_TAG, "");
        if (valueColumn.equals("")) {
            valueColumn = props.getValue(STACK_COLUMN_ATTRIBUTE_TAG, "");
        }
        if (valueColumn.equals("")) {
            valueColumn = "Group.Value";
        }
        Vector stackColumnNames = props.getSubProperties(STACK_COLUMN_ATTRIBUTE_TAG);
        Vector<String> newValueLevels = new Vector<String>();
        boolean isCategorical = false;
        boolean isString = false;
        boolean isDate = false;
        int strWidth = 0;
        for (int i = 0; i < stackColumnNames.size(); ++i) {
            int colWidth;
            String colName = (String)stackColumnNames.get(i);
            if (i == 0) {
                isCategorical = inputMD.isCategoricalColumn(colName);
                isString = inputMD.isStringColumn(colName);
                isDate = inputMD.isDateTimeColumn(colName);
            }
            if (isCategorical) {
                Vector levels = inputMD.getCategoricalDataFieldLevels(colName);
                for (int j = 0; j < levels.size(); ++j) {
                    String level = (String)levels.get(j);
                    if (newValueLevels.indexOf(level) != -1) continue;
                    newValueLevels.add(level);
                }
                continue;
            }
            if (!isString || strWidth >= (colWidth = inputMD.getStringDataFieldWidth(colName))) continue;
            strWidth = colWidth;
        }
        if (isCategorical) {
            outputMD.appendCategoricalDataField(valueColumn, newValueLevels);
        } else if (isString) {
            outputMD.appendStringDataField(valueColumn, strWidth);
        } else if (isDate) {
            outputMD.appendDateTimeDataField(valueColumn);
        } else {
            outputMD.appendContinousDataField(valueColumn);
        }
        if (props.getBoolean(KEEP_GROUP_ATTRIBUTE_TAG, false)) {
            String groupColumn = props.getValue(GROUP_COLUMN_ATTRIBUTE_TAG, "Group.Column");
            outputMD.appendCategoricalDataField(groupColumn, stackColumnNames);
        }
        return outputMD;
    }
}

