/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.MinerApp;
import com.insightful.miner.WideFileChooser;
import com.insightful.miner.WorksheetFileFilter;
import com.insightful.splus.SplusSystem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class StartupDialog
extends JDialog {
    protected JRadioButton loadExisting = null;
    protected JRadioButton loadNew = null;
    protected JComboBox existingFile = null;
    protected JButton ok = null;
    protected JButton browse = null;
    protected JButton cancel = null;
    protected Dimension buttonSize = new Dimension(100, 25);
    protected String defaultPath = null;
    protected boolean fileExists = false;
    protected boolean cancelRequested = false;

    public StartupDialog(Vector recentPaths) {
        super(MinerApp.getMainFrame(), MinerApp.getText("StartupDialog_fileSelection"), true);
        this.setSize(570, 150);
        this.setLocationRelativeTo(this.getOwner());
        ButtonGroup group = new ButtonGroup();
        this.loadExisting = new JRadioButton(MinerApp.getText("StartupDialog_loadExisting") + " ");
        this.loadExisting.setMnemonic('e');
        this.loadNew = new JRadioButton(MinerApp.getText("StartupDialog_loadNew") + " ");
        this.loadNew.setMnemonic('n');
        this.existingFile = new JComboBox();
        this.browse = new JButton(MinerApp.getText("StartupDialog_browse"));
        this.browse.setMnemonic('b');
        this.ok = new JButton(MinerApp.getText("NodeDialog_ok"));
        this.ok.setMnemonic(MinerApp.getText("NodeDialog_okHotkey").charAt(0));
        this.cancel = new JButton(MinerApp.getText("NodeDialog_cancel"));
        this.cancel.setMnemonic(MinerApp.getText("NodeDialog_cancelHotkey").charAt(0));
        this.ok.setPreferredSize(this.cancel.getPreferredSize());
        this.existingFile.setEditable(true);
        for (int i = 0; i < recentPaths.size(); ++i) {
            File f = new File((String)recentPaths.get(i));
            if (!f.exists()) continue;
            this.existingFile.addItem((String)recentPaths.get(i));
        }
        if (this.existingFile.getItemCount() > 0) {
            this.existingFile.setSelectedIndex(0);
            this.defaultPath = (String)this.existingFile.getSelectedItem();
            this.fileExists = new File(this.defaultPath).exists();
        }
        group.add(this.loadExisting);
        group.add(this.loadNew);
        this.browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                block3: {
                    String selectedFilePath;
                    WideFileChooser chooser = null;
                    StartupDialog.this.defaultPath = (String)StartupDialog.this.existingFile.getSelectedItem();
                    boolean bl = StartupDialog.this.fileExists = StartupDialog.this.defaultPath != null;
                    if (StartupDialog.this.fileExists) {
                        File file = new File(StartupDialog.this.defaultPath);
                        StartupDialog.this.fileExists = file.exists() && file.isFile();
                    }
                    while (true) {
                        chooser = StartupDialog.this.fileExists ? new WideFileChooser(StartupDialog.this.defaultPath) : new WideFileChooser(SplusSystem.getCwd());
                        chooser.addChoosableFileFilter(new WorksheetFileFilter());
                        chooser.setMultiSelectionEnabled(false);
                        int returnVal = chooser.showOpenDialog(MinerApp.getMainFrame());
                        if (returnVal != 0) break block3;
                        selectedFilePath = chooser.getSelectedFile().getAbsolutePath();
                        File file = new File(selectedFilePath);
                        if (file.exists() && file.isFile()) break;
                        AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), MinerApp.getText("StatupDialog_msg_fileMustExist"));
                    }
                    for (int i = StartupDialog.this.existingFile.getItemCount() - 1; i >= 0; --i) {
                        if (!selectedFilePath.equals(StartupDialog.this.existingFile.getItemAt(i))) continue;
                        StartupDialog.this.existingFile.removeItemAt(i);
                    }
                    StartupDialog.this.existingFile.insertItemAt(chooser.getSelectedFile().getAbsolutePath(), 0);
                    StartupDialog.this.existingFile.setSelectedIndex(0);
                    StartupDialog.this.loadExisting.setSelected(true);
                }
            }
        });
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StartupDialog.this.onOK();
            }
        });
        this.getRootPane().setDefaultButton(this.ok);
        ActionListener cancelListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StartupDialog.this.onCancel();
            }
        };
        this.cancel.addActionListener(cancelListener);
        this.ok.registerKeyboardAction(cancelListener, KeyStroke.getKeyStroke("ESCAPE"), 2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                StartupDialog.this.onCancel();
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        Container container = this.getContentPane();
        constraints.fill = 0;
        constraints.gridheight = 1;
        Insets insets = new Insets(0, 5, 0, 5);
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.insets = insets;
        constraints.anchor = 17;
        container.add((Component)this.loadExisting, constraints);
        constraints.gridwidth = 10;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        container.add((Component)this.existingFile, constraints);
        constraints.weightx = 0.0;
        constraints.fill = 0;
        container.add((Component)this.browse, constraints);
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        container.add((Component)this.loadNew, constraints);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createHorizontalGlue());
        panel.add(this.ok);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.cancel);
        panel.add(Box.createHorizontalGlue());
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 25;
        constraints.insets = new Insets(10, 0, 0, 0);
        constraints.anchor = 10;
        constraints.fill = 1;
        container.add((Component)new JSeparator(), constraints);
        constraints.insets = new Insets(20, 0, 0, 0);
        constraints.anchor = 15;
        container.add((Component)panel, constraints);
        this.ok.setBounds(this.browse.getBounds());
        this.existingFile.setPreferredSize(new Dimension(250, 25));
        this.loadExisting.setSelected(true);
        this.setVisible(true);
    }

    public void onCancel() {
        this.cancelRequested = true;
        this.setVisible(false);
    }

    public void onOK() {
        File file;
        String path;
        if (this.loadExisting.isSelected() && (path = (String)this.existingFile.getSelectedItem()) != null && !(file = new File(path)).exists()) {
            AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), MinerApp.getText("StatupDialog_msg_selectedFileCouldnotbeFound"));
            return;
        }
        this.setVisible(false);
    }

    public boolean isCancelRequested() {
        return this.cancelRequested;
    }

    public boolean isExistingWorksheet() {
        return this.loadExisting.isSelected();
    }

    public boolean isNewWorksheet() {
        return this.loadNew.isSelected();
    }

    public String getWorksheetFilename() {
        return (String)this.existingFile.getSelectedItem();
    }
}

