/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.ReadOtherFileDialog;
import com.insightful.miner.ReadSplusFileDialog;
import com.insightful.miner.WorksheetPropertiesPanel;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class WriteSplusFileDialog
extends NodeDialog {
    private JTextField m_varNameTextField;
    private JComboBox m_typeComboBox;
    private JTextField m_fileNameTextField;
    public static String[] m_typeCodeList = ReadSplusFileDialog.m_typeCodeList;
    private static String[][] m_extensionList = ReadSplusFileDialog.m_extensionList;
    private static String[] m_typeDescriptionList = ReadSplusFileDialog.m_typeDescriptionList;
    private static String[][] m_SDDextensionList = ReadSplusFileDialog.m_SDDextensionList;
    private static String[] m_SDDtypeDescriptionList = ReadSplusFileDialog.m_SDDtypeDescriptionList;
    private static WriteSplusFileDialog m_WriteSplusFileDialog = null;

    public static WriteSplusFileDialog getWriteSplusFileDialog() {
        if (m_WriteSplusFileDialog == null) {
            m_WriteSplusFileDialog = new WriteSplusFileDialog();
        }
        return m_WriteSplusFileDialog;
    }

    protected WriteSplusFileDialog() {
        Dimension min = new Dimension(525, 525);
        this.setMinimumSize(min);
        this.setSize(min);
    }

    public void restoreProperties() {
        super.restoreProperties();
        XTProps props = this.getNodeModel().getXTProps();
        String type = props.getValue("fileType", "splusSDDFile");
        ReadOtherFileDialog.setComboBoxFromTypeString(type, m_typeCodeList, this.m_typeComboBox);
        String currentPath = props.getValue("filePath", "");
        this.m_fileNameTextField.setText(currentPath);
        String varName = props.getValue("splusVarName", "");
        this.m_varNameTextField.setText(varName);
    }

    public void saveProperties() {
        super.restoreProperties();
        this.saveFileProperties(this.getNodeModel().getXTProps());
    }

    public void saveFileProperties(XTProps props) {
        String filename = this.m_fileNameTextField.getText();
        props.set("filePath", filename);
        props.set("fileType", m_typeCodeList[this.m_typeComboBox.getSelectedIndex()]);
        props.set("splusVarName", this.m_varNameTextField.getText());
    }

    public XTProps getCurrentFileProperties() {
        XTProps props = null;
        try {
            props = new XTProps();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        this.saveFileProperties(props);
        return props;
    }

    public JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel saveFilePanel = new JPanel(new GridBagLayout());
        this.m_fileNameTextField = new JTextField(25);
        this.m_fileNameTextField.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.checkReadFileName(WriteSplusFileDialog.this.m_fileNameTextField, m_extensionList, WriteSplusFileDialog.this.m_typeComboBox);
            }
        });
        this.m_fileNameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    ReadOtherFileDialog.checkReadFileName(WriteSplusFileDialog.this.m_fileNameTextField, m_extensionList, WriteSplusFileDialog.this.m_typeComboBox);
                }
            }
        });
        JLabel fileNameLabel = WorksheetPropertiesPanel.createLabel(this.m_fileNameTextField, "WriteSplusFileDialog_fileLabel", "WriteSplusFileDialog_fileHotkey");
        JButton browseButton = WorksheetPropertiesPanel.createButton("WriteSplusFileDialog_fileBrowseLabel", "WriteSplusFileDialog_fileBrowseHotkey", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (WriteSplusFileDialog.this.selectedSDDFile()) {
                    ReadOtherFileDialog.browseReadFileName(WriteSplusFileDialog.this, WriteSplusFileDialog.this.m_fileNameTextField, m_SDDextensionList, m_SDDtypeDescriptionList, null);
                } else {
                    String newPath = WorksheetPropertiesPanel.browseForDirectory(WriteSplusFileDialog.this, WriteSplusFileDialog.this.m_fileNameTextField.getText());
                    if (newPath != null) {
                        WriteSplusFileDialog.this.m_fileNameTextField.setText(newPath);
                    }
                }
            }
        });
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridwidth = 2;
        constraints.weightx = 0.0;
        saveFilePanel.add((Component)fileNameLabel, constraints);
        constraints.gridwidth = 6;
        constraints.gridx = 2;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        saveFilePanel.add((Component)this.m_fileNameTextField, constraints);
        constraints.gridx = 8;
        constraints.weightx = 0.0;
        constraints.gridwidth = 2;
        constraints.fill = 0;
        saveFilePanel.add((Component)browseButton, constraints);
        JPanel moreOptionsPanel = new JPanel(new GridBagLayout());
        moreOptionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ReadTextFileDialog_options")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.m_typeComboBox = new JComboBox<String>(m_typeDescriptionList);
        JLabel typeLabel = WorksheetPropertiesPanel.createLabel(this.m_typeComboBox, "WriteSplusFileDialog_fileTypeLabel", "WriteSplusFileDialog_fileTypeHotkey");
        this.m_varNameTextField = new JTextField(25);
        JLabel varNameLabel = WorksheetPropertiesPanel.createLabel(this.m_varNameTextField, "WriteSplusFileDialog_varNameLabel", "WriteSplusFileDialog_varNameHotkey");
        JButton varNameBrowseButton = WorksheetPropertiesPanel.createButton("WriteSplusFileDialog_varNameBrowseLabel", "WriteSplusFileDialog_varNameBrowseHotkey", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (WriteSplusFileDialog.this.selectedSDDFile()) {
                    return;
                }
                if (WriteSplusFileDialog.this.m_varNameTextField == null) {
                    return;
                }
                String oldTable = WriteSplusFileDialog.this.m_varNameTextField.getText();
                String newTable = ReadSplusFileDialog.browseDataFrameNames(WriteSplusFileDialog.this, WriteSplusFileDialog.this.getCurrentFileProperties(), oldTable);
                if (newTable != null) {
                    WriteSplusFileDialog.this.m_varNameTextField.setText(newTable);
                }
            }
        });
        Insets none = new Insets(2, 0, 2, 0);
        Insets frontback = new Insets(2, 10, 2, 10);
        int gridy = 0;
        WorksheetPropertiesPanel.addGB(moreOptionsPanel, typeLabel, constraints, 0, gridy, 1, 1, 0.0, 0.0, 18, 0, none);
        WorksheetPropertiesPanel.addGB(moreOptionsPanel, this.m_typeComboBox, constraints, 2, gridy, 2, 1, 1.0, 0.0, 18, 2, frontback);
        WorksheetPropertiesPanel.addGB(moreOptionsPanel, varNameLabel, constraints, 0, ++gridy, 1, 1, 0.0, 0.0, 17, 0, none);
        WorksheetPropertiesPanel.addGB(moreOptionsPanel, this.m_varNameTextField, constraints, 2, gridy, 2, 1, 1.0, 0.0, 10, 2, frontback);
        WorksheetPropertiesPanel.addGB(moreOptionsPanel, varNameBrowseButton, constraints, 4, gridy, 1, 1, 0.0, 0.0, 12, 0, none);
        ++gridy;
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)saveFilePanel, "North");
        topPanel.add((Component)moreOptionsPanel, "Center");
        optionsPanel.add((Component)topPanel, "North");
        return optionsPanel;
    }

    public boolean selectedSDDFile() {
        return this.m_typeComboBox.getSelectedIndex() == 0;
    }
}

