/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcSplusTransform;
import com.insightful.miner.ReadSplusFileEngineNode;
import com.insightful.miner.SplusScriptEngineNode;
import com.insightful.miner.XTProps;
import com.insightful.splus.util.StringUtilities;

public class WriteSplusFileEngineNode
extends ReadSplusFileEngineNode {
    public void invalidateNodeState() {
        this.clearSDDTemp();
    }

    public boolean hasDynamicOutputs() {
        return false;
    }

    public String getWriteFnBody(String splusDir, String varName) {
        String fnBody = "function(IM){\nv <- \"" + StringUtilities.escapeSpecialCharacters((String)varName) + "\"\n" + "sdir <- \"" + StringUtilities.escapeSpecialCharacters((String)splusDir) + "\"\n" + "if (!is.dir(sdir)) {return(list(error=paste(\"directory\",sdir,\"not found\")))}\n" + "if (!isChapter(sdir)) {return(list(error=paste(\"directory\",sdir,\"is not a valid S-PLUS chapter\")))}\n" + "assign(v, IM$in1, where=sdir, immediate=T)\n" + "NULL}\n";
        return fnBody;
    }

    public String[] createSDDTemp() {
        try {
            this.clearSDDTemp();
            String sddTempDirName = this.getSDDTempDirName();
            String[] ret = new String[]{sddTempDirName, ""};
            this.printlnDebug("creating SDD temp directory " + sddTempDirName);
            String createChapterCmd = this.getCreateChapterCommand(sddTempDirName);
            String splusExpr = "{" + createChapterCmd + "}";
            String err = this.splusEvalGetError(splusExpr);
            if (err != null) {
                ret[1] = err;
                this.printlnDebug("error creating SDD temp directory: " + ret[1]);
            } else {
                this.printlnDebug("finished creating SDD temp directory");
            }
            return ret;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new String[]{"", "unknown error"};
        }
    }

    public CNKProc procCreate() throws Exception {
        XTProps props = this.getNodeProperties();
        String varName = this.getVarName(props);
        if (varName.equals("")) {
            throw new Exception("variable name empty");
        }
        String splusDir = null;
        if (this.isSDDFile(props)) {
            String[] vals = this.createSDDTemp();
            if (!vals[1].equals("")) {
                throw new Exception(vals[1]);
            }
            splusDir = vals[0];
        } else {
            splusDir = this.getAbsoluteFileName(props);
        }
        String fnBody = this.getWriteFnBody(splusDir, this.getVarName(props));
        CNKProcSplusTransform proc = this.getNetworkManager().createSplusProc();
        proc.setDefaultStringBytes(this.getWorksheetPropertiesManager().getDefaultStringSize());
        proc.setUseFlexibleTransform(true);
        proc.setTransform(fnBody);
        proc.setTransformTempVariable(SplusScriptEngineNode.getTempSplusVar(this));
        proc.setInputNeedsOneBlock(0, true);
        return proc;
    }

    public void procExtractResults(CNKProc proc) throws Exception {
        if (this.isSDDFile(this.getNodeProperties())) {
            XTProps props = this.getNodeProperties();
            String varName = StringUtilities.escapeSpecialCharacters((String)this.getVarName(props));
            String splusDir = StringUtilities.escapeSpecialCharacters((String)this.getSDDTempDirName());
            String fileName = StringUtilities.escapeSpecialCharacters((String)this.getAbsoluteFileName(props));
            String splusExpr = "{data.dump(\"" + varName + "\",file=\"" + fileName + "\",where=\"" + splusDir + "\");NULL}";
            String err = this.splusEvalGetError(splusExpr);
            this.clearSDDTemp();
            if (err != null) {
                throw new Exception(err);
            }
        }
    }

    public XTProps getAllTableNames(XTProps currentProps, int maxTableNames) {
        XTProps tnprops = null;
        try {
            tnprops = new XTProps();
            if (this.isSDDFile(currentProps)) {
                return tnprops;
            }
            String fileName = this.getAbsoluteFileName(currentProps);
            this.getTableNamesFromSplusDir(tnprops, fileName, maxTableNames);
        }
        catch (Exception ex) {
            tnprops.set("tableNameErrors", ex.getMessage() == null ? "Unknown error" : ex.getMessage());
        }
        return tnprops;
    }
}

