/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.dndtree;

import com.insightful.miner.dndtree.DefaultNodeFactory;
import com.insightful.miner.dndtree.DndId;
import com.insightful.miner.dndtree.InfoUndoManager;
import com.insightful.miner.dndtree.NodeFactory;
import com.insightful.miner.dndtree.NodeInfoTreeCellEditor;
import com.insightful.miner.dndtree.NodeInfoTreeCellRenderer;
import com.insightful.miner.dndtree.SubTreeNode;
import com.insightful.miner.dndtree.TreeDragGestureListener;
import com.insightful.miner.dndtree.TreeDropTargetListener;
import com.insightful.miner.dndtree.UndoableInfoEdit;
import com.insightful.miner.dndtree.VetoException;
import com.insightful.miner.dndtree.VetoableTreeStructureChangeEvent;
import com.insightful.miner.dndtree.VetoableTreeStructureChangeListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class Instrumenter {
    protected JTree m_tree;
    protected SubTreeNode[] m_arrCopiedNodes = null;
    protected UndoManager m_undoManager;
    protected UndoableEditSupport m_undoSupport = new UndoableEditSupport(this);
    protected NodeFactory m_nodeFactory;
    protected Hashtable m_hashDndOperations = new Hashtable();
    protected AbstractAction m_actAddAbove = new AbstractAction(){

        public void actionPerformed(ActionEvent ev) {
            try {
                Instrumenter.this.addNodeAbove();
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }

        public boolean isEnabled() {
            return true;
        }

        public void setEnabled(boolean b) {
        }
    };
    protected AbstractAction m_actAddBelow = new AbstractAction(){

        public void actionPerformed(ActionEvent ev) {
            try {
                Instrumenter.this.addNodeBelow();
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }

        public boolean isEnabled() {
            return true;
        }

        public void setEnabled(boolean b) {
        }
    };
    protected AbstractAction m_actAddChild = new AbstractAction(){

        public void actionPerformed(ActionEvent ev) {
            try {
                Instrumenter.this.addChildNode();
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }
    };
    protected AbstractAction m_actMakeAncestor = new AbstractAction(){

        public void actionPerformed(ActionEvent ev) {
            Instrumenter.this.makeAncestor();
        }
    };
    protected AbstractAction m_actMakeChild = new AbstractAction(){

        public void actionPerformed(ActionEvent ev) {
            Instrumenter.this.makeChild();
        }
    };
    protected AbstractAction m_actUndo = new AbstractAction(){

        public void actionPerformed(ActionEvent ev) {
            if (Instrumenter.this.m_undoManager != null && Instrumenter.this.m_undoManager.canUndo()) {
                Instrumenter.this.m_undoManager.undo();
            }
        }
    };
    protected AbstractAction m_actRedo = new AbstractAction(){

        public void actionPerformed(ActionEvent ev) {
            if (Instrumenter.this.m_undoManager != null && Instrumenter.this.m_undoManager.canRedo()) {
                Instrumenter.this.m_undoManager.redo();
            }
        }
    };
    protected AbstractAction m_actDelete = new AbstractAction(){

        public void actionPerformed(ActionEvent ev) {
            Instrumenter.this.deleteSelectedNodes();
        }
    };
    protected AbstractAction m_actMoveUp = new AbstractAction(){

        public void actionPerformed(ActionEvent ev) {
            Instrumenter.this.moveNodesUp();
        }
    };
    protected AbstractAction m_actMoveDown = new AbstractAction(){

        public void actionPerformed(ActionEvent ev) {
            Instrumenter.this.moveNodesDown();
        }
    };
    protected AbstractAction m_actCopy = new AbstractAction(){

        public void actionPerformed(ActionEvent ev) {
            Instrumenter.this.copyNode();
        }
    };
    protected AbstractAction m_actCut = new AbstractAction(){

        public void actionPerformed(ActionEvent ev) {
            Instrumenter.this.cutNode();
        }
    };
    protected AbstractAction m_actPaste = new AbstractAction(){

        public void actionPerformed(ActionEvent ev) {
            Instrumenter.this.pasteNode();
        }
    };
    protected AbstractAction m_actStartEdit = new AbstractAction(){

        public void actionPerformed(ActionEvent ev) {
            Instrumenter.this.startEdit();
        }
    };
    protected Action[] m_arrSelectionDependentActions = new Action[]{this.m_actDelete, this.m_actMoveUp, this.m_actMoveDown, this.m_actMakeAncestor, this.m_actMakeChild, this.m_actCopy, this.m_actCut, this.m_actStartEdit, this.m_actAddChild};
    public static final String ACTION_MOVE_UP = "Move Nodes Up";
    public static final String ACTION_MOVE_DOWN = "Move Nodes Down";
    public static final String ACTION_MAKE_ANCESTOR = "Make Nodes Ancestors";
    public static final String ACTION_MAKE_CHILD = "Make Nodes Children";
    public static final String ACTION_COPY = "Copy Nodes";
    public static final String ACTION_CUT = "Cut Nodes";
    public static final String ACTION_PASTE = "Paste Nodes";
    public static final String ACTION_UNDO = "Undo Edit";
    public static final String ACTION_REDO = "Redo Undo";
    public static final String ACTION_ADD_ABOVE = "Add Node Above";
    public static final String ACTION_ADD_BELOW = "Add Node Below";
    public static final String ACTION_ADD_CHILD = "Add Child Node";
    public static final String ACTION_DELETE = "Delete Nodes";
    public static final String ACTION_START_EDIT = "Start Node Edit";
    public final Hashtable m_hashDefaultActionMap = new Hashtable();
    public final Hashtable m_hashDefaultInputMap = new Hashtable();
    protected static long m_nNextInstrumentId = 0L;
    protected static Object m_obNextInstrumentIdSemaphore = new Object();
    protected final long m_nMyInstrumentId = Instrumenter.getNextInstrumentId();
    protected long m_nDndOperationId = 0L;
    protected transient Vector vetoableTreeStructureChangeListeners;

    protected Instrumenter() {
        this.createDefaultActionMap();
        this.createDefaultInputMap();
    }

    public static Instrumenter createInstrument(JTree tree, boolean full_instrumentation, boolean clear) {
        if (clear) {
            tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
        }
        Instrumenter retval = new Instrumenter();
        retval.instrument(tree, full_instrumentation);
        if (clear && retval.getNodeFactory() != null) {
            ((DefaultTreeModel)tree.getModel()).setRoot(retval.getNodeFactory().createNode(null));
        }
        return retval;
    }

    public static Instrumenter createInstrument(JTree tree, boolean full_instrumentation) {
        return Instrumenter.createInstrument(tree, full_instrumentation, false);
    }

    public static Instrumenter createInstrument(JTree tree) {
        return Instrumenter.createInstrument(tree, true);
    }

    protected void instrument(JTree tree, boolean full_instrumentation) {
        this.m_tree = tree;
        this.setUseDefaultTreeConfiguration(full_instrumentation);
        this.setUseDefaultUndoManager(full_instrumentation);
        this.m_tree.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("model")) {
                    if (Instrumenter.this.m_undoManager != null) {
                        Instrumenter.this.m_undoManager.discardAllEdits();
                    }
                    Instrumenter.this.m_arrCopiedNodes = null;
                    Instrumenter.this.updateActionObjects();
                }
            }
        });
        this.setUseDefaultKeyboardShortcuts(full_instrumentation);
        this.setUseDefaultActionMap(full_instrumentation);
        this.setUseDefaultDnd(full_instrumentation);
        this.m_tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                Instrumenter.this.infoTree_valueChanged(e);
            }
        });
        this.setUseDefaultCellEditor(full_instrumentation);
        this.configureCellEditor();
        this.m_tree.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("cellEditor")) {
                    Instrumenter.this.configureCellEditor();
                }
            }
        });
        this.setUseDefaultNodeFactory(full_instrumentation);
        this.updateActionObjects();
    }

    protected void configureCellEditor() {
        ((DefaultTreeCellEditor)this.m_tree.getCellEditor()).addCellEditorListener(new CellEditorListener(){

            public void editingStopped(ChangeEvent e) {
                Instrumenter.this.getFocusForTree();
            }

            public void editingCanceled(ChangeEvent e) {
                Instrumenter.this.getFocusForTree();
            }
        });
    }

    public void setUseDefaultDnd(boolean b) {
        if (b) {
            DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.m_tree, 3, new TreeDragGestureListener(this.m_tree, this));
            new DropTarget(this.m_tree, new TreeDropTargetListener(this.m_tree, this));
            this.m_tree.setCellRenderer(new NodeInfoTreeCellRenderer());
        }
    }

    public void setUseDefaultTreeConfiguration(boolean b) {
        if (b) {
            this.m_tree.setRootVisible(false);
            this.m_tree.setInvokesStopCellEditing(true);
            this.m_tree.setEditable(true);
            this.m_tree.setShowsRootHandles(true);
            this.m_tree.setAutoscrolls(true);
        }
    }

    public void setUseDefaultNodeFactory(boolean b) {
        if (b) {
            this.m_nodeFactory = new DefaultNodeFactory();
        }
    }

    public void setUseDefaultUndoManager(boolean b) {
        if (b) {
            this.setUndoManager(new InfoUndoManager());
        }
    }

    public void setUseDefaultKeyboardShortcuts(boolean b) {
        InputMap map = this.m_tree.getInputMap();
        Enumeration enumeration = this.m_hashDefaultInputMap.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            if (b) {
                map.put((KeyStroke)key, this.m_hashDefaultInputMap.get(key));
                continue;
            }
            map.remove((KeyStroke)key);
        }
    }

    public void setUseDefaultActionMap(boolean b) {
        ActionMap map = this.m_tree.getActionMap();
        Enumeration enumeration = this.m_hashDefaultActionMap.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            if (b) {
                map.put(key, (Action)this.m_hashDefaultActionMap.get(key));
                continue;
            }
            map.remove(key);
        }
    }

    protected void setUseDefaultCellEditor(boolean b) {
        if (b) {
            this.m_tree.setCellEditor(new NodeInfoTreeCellEditor(this.m_tree, (DefaultTreeCellRenderer)this.m_tree.getCellRenderer(), this));
        }
    }

    public void setNodeFactory(NodeFactory factory) {
        this.m_nodeFactory = factory;
    }

    public NodeFactory getNodeFactory() {
        return this.m_nodeFactory;
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        this.m_undoSupport.addUndoableEditListener(listener);
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.m_undoSupport.removeUndoableEditListener(listener);
    }

    public UndoManager getUndoManager() {
        return this.m_undoManager;
    }

    public void setUndoManager(UndoManager manager) {
        this.m_undoSupport.removeUndoableEditListener(this.m_undoManager);
        this.m_undoManager = manager;
        if (this.m_undoManager != null) {
            this.m_undoSupport.addUndoableEditListener(this.m_undoManager);
            if (this.m_undoManager instanceof InfoUndoManager) {
                ((InfoUndoManager)this.m_undoManager).addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent ev) {
                        Instrumenter.this.updateActionObjects();
                    }
                });
            }
        }
        this.updateActionObjects();
    }

    public void purgeUndoBuffer() {
        if (this.m_undoManager != null) {
            this.m_undoManager.discardAllEdits();
        }
    }

    protected void getFocusForTree() {
        this.m_tree.requestFocus();
    }

    public void moveNodesUp() {
        this.moveNodes(true);
    }

    public void moveNodesDown() {
        this.moveNodes(false);
    }

    public void addNodeAbove() throws VetoException {
        this.m_undoSupport.postEdit(this.addNode(true));
    }

    public void addNodeBelow() throws VetoException {
        this.m_undoSupport.postEdit(this.addNode(false));
    }

    public void addChildNode() throws VetoException {
        this.m_undoSupport.postEdit(this.addChildNode(false, null));
    }

    protected void setSelection(Vector nodes) {
        if (nodes.size() == 0) {
            return;
        }
        Enumeration en = nodes.elements();
        while (en.hasMoreElements()) {
            this.m_tree.addSelectionPath(new TreePath(((DefaultTreeModel)this.m_tree.getModel()).getPathToRoot((DefaultMutableTreeNode)en.nextElement())));
        }
        this.m_tree.scrollPathToVisible(new TreePath(((DefaultTreeModel)this.m_tree.getModel()).getPathToRoot((DefaultMutableTreeNode)nodes.firstElement())));
    }

    protected TreePath[] getSortedSelection(boolean ascending) {
        TreePath[] retval = this.m_tree.getSelectionPaths();
        if (retval == null) {
            return new TreePath[0];
        }
        final boolean asc = ascending;
        Arrays.sort(retval, new Comparator(){

            public int compare(Object a, Object b) {
                return (Instrumenter.this.m_tree.getRowForPath((TreePath)a) - Instrumenter.this.m_tree.getRowForPath((TreePath)b)) * (asc ? 1 : -1);
            }
        });
        return retval;
    }

    protected void startEdit() {
        this.m_tree.startEditingAtPath(this.m_tree.getLeadSelectionPath());
    }

    public void moveNode(DefaultMutableTreeNode node_to_move, DefaultMutableTreeNode dest_node, int dest_index) throws VetoException {
        this.m_undoSupport.postEdit(this.doMoveNode(node_to_move, dest_node, dest_index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveNodes(boolean up) {
        boolean veto = false;
        boolean added = false;
        Vector<DefaultMutableTreeNode> nodeV = new Vector<DefaultMutableTreeNode>(this.m_tree.getSelectionCount());
        TreePath[] selrange = this.getSortedSelection(up);
        this.m_undoSupport.beginUpdate();
        try {
            for (int i = 0; i < selrange.length; ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selrange[i].getLastPathComponent();
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                if (parent != null) {
                    int ndx = parent.getIndex(node);
                    if (up && ndx > 0 || !up && ndx < parent.getChildCount() - 1) {
                        this.m_undoSupport.postEdit(this.doMoveNode(node, parent, ndx + (up ? -1 : 1)));
                        added = true;
                    } else {
                        return;
                    }
                }
                nodeV.addElement(node);
            }
        }
        catch (VetoException ex) {
            veto = true;
        }
        finally {
            this.m_undoSupport.endUpdate();
        }
        if (veto && added) {
            this.m_undoManager.undo();
        } else {
            this.setSelection(nodeV);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeAncestor() {
        boolean veto = false;
        boolean added = false;
        Vector<DefaultMutableTreeNode> nodeV = new Vector<DefaultMutableTreeNode>(this.m_tree.getSelectionCount());
        TreePath[] lastsel = this.getSortedSelection(true);
        this.m_undoSupport.beginUpdate();
        try {
            for (int i = 0; i < lastsel.length; ++i) {
                DefaultMutableTreeNode newparent;
                DefaultMutableTreeNode sel = (DefaultMutableTreeNode)lastsel[i].getLastPathComponent();
                nodeV.addElement(sel);
                DefaultMutableTreeNode oldparent = (DefaultMutableTreeNode)sel.getParent();
                if (oldparent == null || (newparent = (DefaultMutableTreeNode)oldparent.getParent()) == null) continue;
                DefaultMutableTreeNode thisChild = (DefaultMutableTreeNode)oldparent.getChildAfter(sel);
                if (thisChild != null) {
                    DefaultMutableTreeNode nextChild;
                    do {
                        nextChild = (DefaultMutableTreeNode)oldparent.getChildAfter(thisChild);
                        this.m_undoSupport.postEdit(this.doMoveNode(thisChild, sel, sel.getChildCount()));
                        added = true;
                    } while ((thisChild = nextChild) != null);
                }
                this.m_undoSupport.postEdit(this.doMoveNode(sel, newparent, newparent.getIndex(oldparent) + 1));
                added = true;
                this.m_tree.makeVisible(new TreePath(((DefaultTreeModel)this.m_tree.getModel()).getPathToRoot(sel)));
                if (sel.getChildCount() <= 0) continue;
                this.m_tree.makeVisible(new TreePath(((DefaultTreeModel)this.m_tree.getModel()).getPathToRoot(sel.getFirstChild())));
            }
        }
        catch (VetoException ex) {
            veto = true;
        }
        finally {
            this.m_undoSupport.endUpdate();
        }
        if (veto && added) {
            this.m_undoManager.undo();
        } else {
            this.setSelection(nodeV);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeChild() {
        boolean veto = false;
        boolean added = false;
        Vector<DefaultMutableTreeNode> nodeV = new Vector<DefaultMutableTreeNode>(this.m_tree.getSelectionCount());
        TreePath[] lastsel = this.m_tree.getSelectionPaths();
        if (lastsel == null || lastsel.length == 0) {
            return;
        }
        this.m_undoSupport.beginUpdate();
        try {
            for (int i = 0; i < lastsel.length; ++i) {
                DefaultMutableTreeNode newparent;
                DefaultMutableTreeNode sel = (DefaultMutableTreeNode)lastsel[i].getLastPathComponent();
                nodeV.addElement(sel);
                DefaultMutableTreeNode oldparent = (DefaultMutableTreeNode)sel.getParent();
                if (oldparent == null || (newparent = (DefaultMutableTreeNode)oldparent.getChildBefore(sel)) == null) continue;
                this.m_undoSupport.postEdit(this.doMoveNode(sel, newparent, newparent.getChildCount()));
                added = true;
                this.m_tree.makeVisible(new TreePath(((DefaultTreeModel)this.m_tree.getModel()).getPathToRoot(sel)));
            }
        }
        catch (VetoException ex) {
            veto = true;
        }
        finally {
            this.m_undoSupport.endUpdate();
        }
        if (veto && added) {
            this.m_undoManager.undo();
        } else {
            this.setSelection(nodeV);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodes(DefaultMutableTreeNode parent, DefaultMutableTreeNode[] nodes, int parent_index) {
        boolean veto = false;
        boolean added = false;
        this.m_undoSupport.beginUpdate();
        try {
            for (int i = nodes.length - 1; i >= 0; --i) {
                this.m_undoSupport.postEdit(this.doAddNode(parent, nodes[i], parent_index));
                added = true;
            }
        }
        catch (VetoException ex) {
            veto = true;
        }
        finally {
            this.m_undoSupport.endUpdate();
        }
        if (veto && added) {
            this.m_undoManager.undo();
        }
    }

    protected UndoableEdit addChildNode(boolean top, Object newnodeinfo) throws VetoException {
        DefaultMutableTreeNode newnode;
        int placetoput = 0;
        DefaultMutableTreeNode parentnode = (DefaultMutableTreeNode)this.m_tree.getLeadSelectionPath().getLastPathComponent();
        if (parentnode == null) {
            return null;
        }
        if (!top) {
            placetoput = parentnode.getChildCount();
        }
        boolean initiate_edit = false;
        if (newnodeinfo == null) {
            initiate_edit = true;
            newnode = (DefaultMutableTreeNode)this.m_nodeFactory.createNode(parentnode);
        } else {
            newnode = newnodeinfo instanceof SubTreeNode ? ((SubTreeNode)newnodeinfo).createNode() : (DefaultMutableTreeNode)this.m_nodeFactory.createNode(newnodeinfo);
        }
        UndoableEdit retval = this.doAddNode(parentnode, newnode, placetoput);
        if (initiate_edit) {
            TreePath newpath = new TreePath(((DefaultTreeModel)this.m_tree.getModel()).getPathToRoot(newnode));
            this.m_tree.setSelectionPath(newpath);
            this.m_tree.scrollPathToVisible(newpath);
            this.m_tree.startEditingAtPath(newpath);
        }
        return retval;
    }

    protected UndoableEdit addNode(boolean above) throws VetoException {
        return this.addNode(above, null);
    }

    protected UndoableEdit addNode(boolean above, Object newnodeinfo) throws VetoException {
        DefaultMutableTreeNode newnode;
        int placetoput = 0;
        DefaultMutableTreeNode parentnode = null;
        int numsel = this.m_tree.getSelectionCount();
        if (numsel > 0) {
            int[] selrows = this.m_tree.getSelectionRows();
            int minsel = Integer.MAX_VALUE;
            int maxsel = Integer.MIN_VALUE;
            for (int i = 0; i < selrows.length; ++i) {
                if (selrows[i] > maxsel) {
                    maxsel = selrows[i];
                }
                if (selrows[i] >= minsel) continue;
                minsel = selrows[i];
            }
            DefaultMutableTreeNode actsel = (DefaultMutableTreeNode)this.m_tree.getPathForRow(above ? minsel : maxsel).getLastPathComponent();
            parentnode = (DefaultMutableTreeNode)actsel.getParent();
            placetoput = parentnode != null ? parentnode.getIndex(actsel) + (above ? 0 : 1) : 0;
        } else if (((DefaultMutableTreeNode)this.m_tree.getModel().getRoot()).getChildCount() == 0) {
            parentnode = (DefaultMutableTreeNode)this.m_tree.getModel().getRoot();
            placetoput = 0;
        } else {
            parentnode = (DefaultMutableTreeNode)this.m_tree.getModel().getRoot();
            placetoput = above ? 0 : parentnode.getChildCount();
        }
        if (parentnode == null) {
            return null;
        }
        boolean initiate_edit = false;
        if (newnodeinfo == null) {
            initiate_edit = true;
            newnode = (DefaultMutableTreeNode)this.m_nodeFactory.createNode(parentnode);
        } else {
            newnode = newnodeinfo instanceof SubTreeNode ? ((SubTreeNode)newnodeinfo).createNode() : (DefaultMutableTreeNode)this.m_nodeFactory.createNode(newnodeinfo);
        }
        UndoableEdit retval = this.doAddNode(parentnode, newnode, placetoput);
        if (initiate_edit) {
            TreePath newpath = new TreePath(((DefaultTreeModel)this.m_tree.getModel()).getPathToRoot(newnode));
            this.m_tree.setSelectionPath(newpath);
            this.m_tree.scrollPathToVisible(newpath);
            this.m_tree.startEditingAtPath(newpath);
        }
        return retval;
    }

    protected static boolean isNodeParentInHash(DefaultMutableTreeNode node, Hashtable hash) {
        boolean parent_in_selection = false;
        for (DefaultMutableTreeNode iter = (DefaultMutableTreeNode)node.getParent(); iter != null; iter = (DefaultMutableTreeNode)iter.getParent()) {
            if (hash.get(iter) == null) continue;
            parent_in_selection = true;
            break;
        }
        return parent_in_selection;
    }

    public void deleteSelectedNodes() {
        this.deleteSelection(true);
    }

    public static TreePath[] reduceSelection(TreePath[] original) {
        Object[] retarr;
        int i;
        if (original == null) {
            return new TreePath[0];
        }
        Vector<TreePath> retvect = new Vector<TreePath>(original.length / 2);
        Hashtable<Object, Boolean> hash = new Hashtable<Object, Boolean>(original.length);
        for (i = 0; i < original.length; ++i) {
            hash.put(original[i].getLastPathComponent(), Boolean.TRUE);
        }
        for (i = 0; i < original.length; ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)original[i].getLastPathComponent();
            if (Instrumenter.isNodeParentInHash(node, hash)) continue;
            retvect.addElement(original[i]);
        }
        if (retvect.size() == 1 && ((TreeNode)((TreePath)retvect.firstElement()).getLastPathComponent()).getParent() == null) {
            TreeNode root = (TreeNode)((TreePath)retvect.firstElement()).getLastPathComponent();
            retarr = new TreePath[root.getChildCount()];
            Enumeration<? extends TreeNode> enumeration = root.children();
            int i2 = 0;
            while (enumeration.hasMoreElements()) {
                TreePath path = new TreePath(new TreeNode[]{root, enumeration.nextElement()});
                retarr[i2++] = path;
            }
        } else {
            retarr = new TreePath[retvect.size()];
            retvect.copyInto(retarr);
        }
        return retarr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteSelection(boolean remain) {
        boolean veto = false;
        boolean added = false;
        TreePath[] lastsel = this.m_tree.getSelectionPaths();
        if ((lastsel = Instrumenter.reduceSelection(lastsel)) == null) {
            return;
        }
        int lead = this.m_tree.getLeadSelectionRow();
        if (remain) {
            ++lead;
        }
        this.m_undoSupport.beginUpdate();
        try {
            for (int i = 0; i < lastsel.length; ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)lastsel[i].getLastPathComponent();
                if (lead >= this.m_tree.getRowForPath(lastsel[i])) {
                    --lead;
                }
                if (node.getParent() == null) continue;
                this.m_undoSupport.postEdit(this.doDeleteNode(node));
                added = true;
            }
        }
        catch (VetoException ex) {
            veto = true;
        }
        finally {
            this.m_undoSupport.endUpdate();
        }
        if (veto && added) {
            this.m_undoManager.undo();
        }
        if (lead >= this.m_tree.getRowCount()) {
            lead = this.m_tree.getRowCount() - 1;
        }
        if (lead < 0) {
            lead = 0;
        }
        this.m_tree.setSelectionRow(lead);
    }

    protected UndoableEdit doMoveNode(DefaultMutableTreeNode node_to_move, DefaultMutableTreeNode dest_node, int dest_index) throws VetoException {
        this.fireNodeMove(new VetoableTreeStructureChangeEvent(this, node_to_move, node_to_move.getParent(), node_to_move.getParent().getIndex(node_to_move), dest_node, dest_index));
        UndoableInfoEdit unedit = new UndoableInfoEdit((DefaultTreeModel)this.m_tree.getModel(), 3, (DefaultMutableTreeNode)node_to_move.getParent(), node_to_move.getParent().getIndex(node_to_move), dest_node, dest_index, node_to_move, false);
        ((DefaultTreeModel)this.m_tree.getModel()).removeNodeFromParent(node_to_move);
        ((DefaultTreeModel)this.m_tree.getModel()).insertNodeInto(node_to_move, dest_node, dest_index);
        return unedit;
    }

    protected UndoableEdit doAddNode(DefaultMutableTreeNode parent, DefaultMutableTreeNode node, int index) throws VetoException {
        this.fireNodeCreation(new VetoableTreeStructureChangeEvent(this, node, null, 0, parent, index));
        UndoableInfoEdit unedit = new UndoableInfoEdit((DefaultTreeModel)this.m_tree.getModel(), 1, null, 0, parent, index, node, true);
        ((DefaultTreeModel)this.m_tree.getModel()).insertNodeInto(node, parent, index);
        return unedit;
    }

    protected UndoableEdit doDeleteNode(DefaultMutableTreeNode node) throws VetoException {
        this.fireNodeDeletion(new VetoableTreeStructureChangeEvent(this, node, node.getParent(), node.getParent().getIndex(node), null, 0));
        UndoableInfoEdit unedit = new UndoableInfoEdit((DefaultTreeModel)this.m_tree.getModel(), 2, (DefaultMutableTreeNode)node.getParent(), node.getParent().getIndex(node), null, 0, node, true);
        ((DefaultTreeModel)this.m_tree.getModel()).removeNodeFromParent(node);
        return unedit;
    }

    void infoTree_valueChanged(TreeSelectionEvent e) {
        this.updateActionObjects();
    }

    public void updateActionObjects() {
        boolean enable = this.m_tree.getSelectionCount() != 0;
        for (int i = 0; i < this.m_arrSelectionDependentActions.length; ++i) {
            if (enable == this.m_arrSelectionDependentActions[i].isEnabled()) continue;
            this.m_arrSelectionDependentActions[i].setEnabled(enable);
        }
        this.m_actUndo.setEnabled(this.m_undoManager != null && this.m_undoManager instanceof InfoUndoManager && this.m_undoManager.canUndo());
        this.m_actRedo.setEnabled(this.m_undoManager != null && this.m_undoManager instanceof InfoUndoManager && this.m_undoManager.canRedo());
        this.m_actPaste.setEnabled(this.m_arrCopiedNodes != null);
    }

    public synchronized DndId getNextDndId() {
        return new DndId(this.m_nMyInstrumentId, this.m_nDndOperationId++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishDndOperation(long op_id, boolean source) {
        Long op_id_ob = new Long(op_id);
        Hashtable hashtable = this.m_hashDndOperations;
        synchronized (hashtable) {
            DndOperations op = (DndOperations)this.m_hashDndOperations.get(op_id_ob);
            if (op != null) {
                if (source) {
                    op.m_bSourceDone = true;
                } else {
                    op.m_bTargetDone = true;
                }
                if (op.m_bSourceDone) {
                    this.m_undoSupport.beginUpdate();
                    for (int i = 0; i < op.m_ops.size(); ++i) {
                        this.m_undoSupport.postEdit((UndoableEdit)op.m_ops.elementAt(i));
                    }
                    this.m_undoSupport.endUpdate();
                    this.m_hashDndOperations.remove(op_id_ob);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDndCompoundAdd(long op_id, DefaultMutableTreeNode parent, DefaultMutableTreeNode node, int index) throws VetoException {
        UndoableEdit unedit = this.doAddNode(parent, node, index);
        Long op_id_ob = new Long(op_id);
        Hashtable hashtable = this.m_hashDndOperations;
        synchronized (hashtable) {
            DndOperations dndop = (DndOperations)this.m_hashDndOperations.get(op_id_ob);
            if (dndop == null) {
                dndop = new DndOperations();
                this.m_hashDndOperations.put(op_id_ob, dndop);
            }
            dndop.m_ops.addElement(unedit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDndCompoundDelete(long op_id, DefaultMutableTreeNode node) throws VetoException {
        if (node.getParent() != null) {
            UndoableEdit unedit = this.doDeleteNode(node);
            Long op_id_ob = new Long(op_id);
            Hashtable hashtable = this.m_hashDndOperations;
            synchronized (hashtable) {
                DndOperations dndop = (DndOperations)this.m_hashDndOperations.get(op_id_ob);
                if (dndop == null) {
                    dndop = new DndOperations();
                    this.m_hashDndOperations.put(op_id_ob, dndop);
                }
                dndop.m_ops.addElement(unedit);
            }
        }
    }

    public void cutNode() {
        this.copyNode();
        this.deleteSelectedNodes();
    }

    public void copyNode() {
        TreePath[] paths = this.getSortedSelection(true);
        if (paths == null || paths.length == 0) {
            return;
        }
        paths = Instrumenter.reduceSelection(paths);
        Vector<SubTreeNode> copiedNodes = new Vector<SubTreeNode>(paths.length);
        for (int i = 0; i < paths.length; ++i) {
            copiedNodes.addElement(new SubTreeNode((DefaultMutableTreeNode)paths[i].getLastPathComponent(), true));
        }
        this.m_arrCopiedNodes = new SubTreeNode[copiedNodes.size()];
        copiedNodes.copyInto(this.m_arrCopiedNodes);
        this.updateActionObjects();
    }

    public void pasteNode() {
        this.pasteNode(this.m_arrCopiedNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pasteNode(SubTreeNode[] nodes) {
        boolean veto = false;
        boolean added = false;
        if (nodes == null || nodes.length == 0) {
            return;
        }
        this.m_undoSupport.beginUpdate();
        try {
            for (int i = 0; i < nodes.length; ++i) {
                this.m_undoSupport.postEdit(this.addNode(true, nodes[i]));
                added = true;
            }
        }
        catch (VetoException ex) {
            veto = true;
        }
        finally {
            this.m_undoSupport.endUpdate();
        }
        if (veto && added) {
            this.m_undoManager.undo();
        }
        this.m_tree.scrollPathToVisible(this.m_tree.getLeadSelectionPath());
    }

    public Action getAddAboveAction() {
        return this.m_actAddAbove;
    }

    public Action getAddBelowAction() {
        return this.m_actAddBelow;
    }

    public Action getAddChildAction() {
        return this.m_actAddChild;
    }

    public Action getDeleteAction() {
        return this.m_actDelete;
    }

    public Action getMakeAncestorAction() {
        return this.m_actMakeAncestor;
    }

    public Action getMakeChildAction() {
        return this.m_actMakeChild;
    }

    public Action getMoveDownAction() {
        return this.m_actMoveDown;
    }

    public Action getMoveUpAction() {
        return this.m_actMoveUp;
    }

    public Action getUndoAction() {
        return this.m_actUndo;
    }

    public Action getRedoAction() {
        return this.m_actRedo;
    }

    public Action getCopyAction() {
        return this.m_actCopy;
    }

    public Action getCutAction() {
        return this.m_actCut;
    }

    public Action getPasteAction() {
        return this.m_actPaste;
    }

    public Action getStartEditAction() {
        return this.m_actStartEdit;
    }

    protected void createDefaultActionMap() {
        this.m_hashDefaultActionMap.put(ACTION_MOVE_UP, this.m_actMoveUp);
        this.m_hashDefaultActionMap.put(ACTION_MOVE_DOWN, this.m_actMoveDown);
        this.m_hashDefaultActionMap.put(ACTION_MAKE_CHILD, this.m_actMakeChild);
        this.m_hashDefaultActionMap.put(ACTION_MAKE_ANCESTOR, this.m_actMakeAncestor);
        this.m_hashDefaultActionMap.put(ACTION_ADD_ABOVE, this.m_actAddAbove);
        this.m_hashDefaultActionMap.put(ACTION_ADD_BELOW, this.m_actAddBelow);
        this.m_hashDefaultActionMap.put(ACTION_ADD_CHILD, this.m_actAddChild);
        this.m_hashDefaultActionMap.put(ACTION_COPY, this.m_actCopy);
        this.m_hashDefaultActionMap.put(ACTION_CUT, this.m_actCut);
        this.m_hashDefaultActionMap.put(ACTION_PASTE, this.m_actPaste);
        this.m_hashDefaultActionMap.put(ACTION_UNDO, this.m_actUndo);
        this.m_hashDefaultActionMap.put(ACTION_REDO, this.m_actRedo);
        this.m_hashDefaultActionMap.put(ACTION_DELETE, this.m_actDelete);
        this.m_hashDefaultActionMap.put(ACTION_START_EDIT, this.m_actStartEdit);
    }

    protected void createDefaultInputMap() {
        this.m_hashDefaultInputMap.put(KeyStroke.getKeyStroke(38, 2), ACTION_MOVE_UP);
        this.m_hashDefaultInputMap.put(KeyStroke.getKeyStroke(40, 2), ACTION_MOVE_DOWN);
        this.m_hashDefaultInputMap.put(KeyStroke.getKeyStroke(37, 2), ACTION_MAKE_ANCESTOR);
        this.m_hashDefaultInputMap.put(KeyStroke.getKeyStroke(39, 2), ACTION_MAKE_CHILD);
        this.m_hashDefaultInputMap.put(KeyStroke.getKeyStroke(155, 2), ACTION_ADD_BELOW);
        this.m_hashDefaultInputMap.put(KeyStroke.getKeyStroke(67, 2), ACTION_COPY);
        this.m_hashDefaultInputMap.put(KeyStroke.getKeyStroke(86, 2), ACTION_PASTE);
        this.m_hashDefaultInputMap.put(KeyStroke.getKeyStroke(88, 2), ACTION_CUT);
        this.m_hashDefaultInputMap.put(KeyStroke.getKeyStroke(90, 2), ACTION_UNDO);
        this.m_hashDefaultInputMap.put(KeyStroke.getKeyStroke(89, 2), ACTION_REDO);
        this.m_hashDefaultInputMap.put(KeyStroke.getKeyStroke(155, 1), ACTION_ADD_ABOVE);
        this.m_hashDefaultInputMap.put(KeyStroke.getKeyStroke(155, 0), ACTION_ADD_CHILD);
        this.m_hashDefaultInputMap.put(KeyStroke.getKeyStroke(127, 0), ACTION_DELETE);
        this.m_hashDefaultInputMap.put(KeyStroke.getKeyStroke(32, 0, true), ACTION_START_EDIT);
        this.m_hashDefaultInputMap.put(KeyStroke.getKeyStroke(32, 0, false), "none");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNextInstrumentId() {
        Object object = m_obNextInstrumentIdSemaphore;
        synchronized (object) {
            return m_nNextInstrumentId++;
        }
    }

    public long getMyInstrumentId() {
        return this.m_nMyInstrumentId;
    }

    public synchronized void removeVetoableTreeStructureChangeListener(VetoableTreeStructureChangeListener l) {
        if (this.vetoableTreeStructureChangeListeners != null && this.vetoableTreeStructureChangeListeners.contains(l)) {
            Vector v = (Vector)this.vetoableTreeStructureChangeListeners.clone();
            v.removeElement(l);
            this.vetoableTreeStructureChangeListeners = v;
        }
    }

    public synchronized void addVetoableTreeStructureChangeListener(VetoableTreeStructureChangeListener l) {
        Vector v;
        Vector vector = v = this.vetoableTreeStructureChangeListeners == null ? new Vector(2) : (Vector)this.vetoableTreeStructureChangeListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.vetoableTreeStructureChangeListeners = v;
        }
    }

    protected void fireNodeCreation(VetoableTreeStructureChangeEvent e) throws VetoException {
        if (this.vetoableTreeStructureChangeListeners != null) {
            Vector listeners = this.vetoableTreeStructureChangeListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((VetoableTreeStructureChangeListener)listeners.elementAt(i)).nodeCreation(e);
            }
        }
    }

    protected void fireNodeDeletion(VetoableTreeStructureChangeEvent e) throws VetoException {
        if (this.vetoableTreeStructureChangeListeners != null) {
            Vector listeners = this.vetoableTreeStructureChangeListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((VetoableTreeStructureChangeListener)listeners.elementAt(i)).nodeDeletion(e);
            }
        }
    }

    protected void fireNodeMove(VetoableTreeStructureChangeEvent e) throws VetoException {
        if (this.vetoableTreeStructureChangeListeners != null) {
            Vector listeners = this.vetoableTreeStructureChangeListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((VetoableTreeStructureChangeListener)listeners.elementAt(i)).nodeMove(e);
            }
        }
    }

    protected void fireNodeRename(VetoableTreeStructureChangeEvent e) throws VetoException {
        if (this.vetoableTreeStructureChangeListeners != null) {
            Vector listeners = this.vetoableTreeStructureChangeListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((VetoableTreeStructureChangeListener)listeners.elementAt(i)).nodeRename(e);
            }
        }
    }

    class DndOperations {
        public Vector m_ops = new Vector();
        public boolean m_bSourceDone;
        public boolean m_bTargetDone;
    }
}

