/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.dndtree;

import com.insightful.miner.dndtree.Instrumenter;
import com.insightful.miner.dndtree.UserObjectFactory;
import com.insightful.miner.dndtree.VetoException;
import com.insightful.miner.dndtree.VetoableTreeStructureChangeEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.TextComponent;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;

public class NodeInfoTreeCellEditor
extends DefaultTreeCellEditor {
    private Object m_object;
    private Instrumenter m_instr;

    public NodeInfoTreeCellEditor(JTree tree, DefaultTreeCellRenderer btcr, Instrumenter instrument) {
        super(tree, btcr);
        this.m_instr = instrument;
    }

    public Object getCellEditorValue() {
        boolean veto = false;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_object;
        Object userobject = node.getUserObject();
        String newname = (String)super.getCellEditorValue();
        try {
            this.m_instr.fireNodeRename(new VetoableTreeStructureChangeEvent(this, node, node.toString(), newname));
        }
        catch (VetoException ex) {
            veto = true;
        }
        if (!veto) {
            ((UserObjectFactory)((Object)this.m_instr.getNodeFactory())).setUserObjectTitle(userobject, newname);
        }
        return userobject;
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        this.m_object = value;
        Component c = super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
        Vector comps = new Vector();
        if (this.realEditor instanceof DefaultCellEditor) {
            this.getAllComps(((DefaultCellEditor)this.realEditor).getComponent(), comps);
        }
        for (int i = 0; i < comps.size(); ++i) {
            if (comps.elementAt(i) instanceof TextComponent) {
                ((TextComponent)comps.elementAt(i)).selectAll();
            }
            if (!(comps.elementAt(i) instanceof JTextComponent)) continue;
            ((JTextComponent)comps.elementAt(i)).selectAll();
        }
        return c;
    }

    protected void getAllComps(Component c, Vector v) {
        v.addElement(c);
        if (c instanceof Container) {
            for (int i = 0; i < ((Container)c).getComponentCount(); ++i) {
                this.getAllComps(((Container)c).getComponent(i), v);
            }
        }
    }
}

