/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.graphdlg.controls;

import com.insightful.gdevice.ColorScheme;
import com.insightful.gdevice.SCanvas;
import com.insightful.miner.graphdlg.controls.MinerComboBox;
import com.insightful.miner.graphdlg.controls.MinerControlMethods;
import com.insightful.miner.graphdlg.controls.MinerControlMetrics;
import com.insightful.splus.SplusCanvasHandler;
import com.insightful.splus.SplusOptionsManager;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.graph.GraphColorsDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.SystemColor;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class MinerColorControl
extends MinerComboBox
implements MinerControlMethods {
    private static final String[] styleList = new String[]{"Background", "Color 1", "Color 2", "Color 3", "Color 4", "Color 5", "Color 6", "Color 7", "Color 8", "Color 9", "Color 10", "Color 11", "Color 12", "Color 13", "Color 14", "Color 15", "Color 16"};
    private static final int iconHeight = System.getProperty("os.name", "").toLowerCase().indexOf("windows") > -1 ? MinerControlMetrics.getLabelDimension().height - 6 : MinerControlMetrics.getLabelDimension().height - 8;
    private ColorScheme colorScheme = new ColorScheme();
    private LocalIcon[] iconList = null;

    public MinerColorControl() {
        super("Color", 'C', new String[0]);
        boolean newGraph;
        super.setOptionList(styleList);
        this.setEditable(false);
        this.comboBox.setSelectedIndex(1);
        String newGraphOption = SplusOptionsManager.getOption((String)"new.graphsheet");
        boolean bl = newGraph = newGraphOption.equals("") || newGraphOption.equals("T") || newGraphOption.equals("TRUE");
        if (newGraph) {
            this.colorScheme = GraphColorsDialog.getDefaultColorScheme();
        } else {
            SplusCanvasHandler handler = SplusSystem.getCanvasHandler();
            if (handler != null) {
                SCanvas canvas = handler.getCurrentDeviceCanvas();
                this.colorScheme = canvas != null ? canvas.getColorScheme() : new ColorScheme();
            }
        }
        if (this.iconList == null) {
            this.iconList = new LocalIcon[styleList.length];
            for (int i = 0; i < this.iconList.length; ++i) {
                this.iconList[i] = new LocalIcon(i);
            }
        }
        this.comboBox.setRenderer(new LocalCellRenderer());
    }

    public synchronized String getValue() {
        int index = -1;
        try {
            index = this.comboBox.getSelectedIndex();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        String value = index == -1 ? "" : Integer.toString(index);
        return value;
    }

    public synchronized void setValue(String value) {
        int index = -1;
        try {
            index = Integer.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (index != -1) {
            this.comboBox.setSelectedIndex(index);
        }
    }

    public synchronized String[] getOptionList() {
        return new String[0];
    }

    public synchronized void setOptionList(String[] listData) {
    }

    private class LocalIcon
    implements Icon {
        private int colorNumber;

        public LocalIcon(int colorNumber) {
            this.colorNumber = colorNumber;
        }

        public int getIconHeight() {
            return iconHeight;
        }

        public int getIconWidth() {
            return iconHeight;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color col = this.colorNumber == 0 ? MinerColorControl.this.colorScheme.getBackgroundColor() : MinerColorControl.this.colorScheme.getPaletteColor(this.colorNumber);
            g.setColor(col);
            g.fillRect(3, 3, iconHeight - 6, iconHeight - 6);
            g.setColor(SystemColor.windowBorder);
            g.drawRect(2, 2, iconHeight - 5, iconHeight - 5);
        }
    }

    private class LocalCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public LocalCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            int whichIndex = index;
            if (whichIndex == -1) {
                whichIndex = Math.max(MinerColorControl.this.comboBox.getSelectedIndex(), 0);
            }
            if (whichIndex < styleList.length) {
                this.setText(styleList[whichIndex]);
                this.setIcon(MinerColorControl.this.iconList[whichIndex]);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }
}

